/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.parameters;

import iaik.pkcs.pkcs11.wrapper.CK_SALSA20_CHACHA20_POLY1305_PARAMS;
import iaik.pkcs.pkcs11.wrapper.Constants;
import iaik.pkcs.pkcs11.wrapper.Functions;

public class Salsa20Chacha20Poly1305Parameters {
    protected byte[] pNonce;
    protected byte[] pAAD;

    public Salsa20Chacha20Poly1305Parameters(byte[] pNonce, byte[] pAAD) {
        this.pNonce = pNonce;
        this.pAAD = pAAD;
    }

    public Object clone() {
        return new Salsa20Chacha20Poly1305Parameters((byte[])this.pNonce.clone(), (byte[])this.pAAD.clone());
    }

    public Object getPKCS11ParamsObject() {
        CK_SALSA20_CHACHA20_POLY1305_PARAMS params = new CK_SALSA20_CHACHA20_POLY1305_PARAMS();
        params.pNonce = this.pNonce;
        params.pAAD = this.pAAD;
        return params;
    }

    public void setValuesFromPKCS11Object(Object obj) {
        if (obj instanceof CK_SALSA20_CHACHA20_POLY1305_PARAMS) {
            this.pNonce = ((CK_SALSA20_CHACHA20_POLY1305_PARAMS)obj).pNonce;
            this.pAAD = ((CK_SALSA20_CHACHA20_POLY1305_PARAMS)obj).pAAD;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString());
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("pNonce: ");
        buffer.append(Functions.toHexString(this.pNonce));
        buffer.append(Constants.NEWLINE);
        buffer.append("pAAD: ");
        buffer.append(Functions.toHexString(this.pAAD));
        buffer.append(Constants.NEWLINE);
        return buffer.toString();
    }

    public boolean equals(Object otherObject) {
        boolean equal = false;
        if (otherObject instanceof Salsa20Chacha20Poly1305Parameters) {
            Salsa20Chacha20Poly1305Parameters other = (Salsa20Chacha20Poly1305Parameters)otherObject;
            equal = this == other || super.equals(other) && Functions.equals(this.pNonce, other.pNonce) && Functions.equals(this.pAAD, other.pAAD);
        }
        return equal;
    }

    public int hashCode() {
        return super.hashCode() ^ Functions.hashCode(this.pNonce) ^ Functions.hashCode(this.pAAD);
    }
}

