/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.parameters;

import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.wrapper.CK_GCM_PARAMS;
import iaik.pkcs.pkcs11.wrapper.Constants;
import iaik.pkcs.pkcs11.wrapper.Functions;

public class GcmParameters
implements Parameters {
    protected byte[] pIv;
    protected byte[] pAad;
    protected long ulTagBits;

    public GcmParameters(byte[] pIv, byte[] pAad, long ulTagBits) {
        if (ulTagBits < 0L || ulTagBits > 128L) {
            throw new IllegalArgumentException("Argument \"ulTagBits\" must must be '0 < ulTagBits < 128'.");
        }
        this.pIv = pIv;
        this.pAad = pAad;
        this.ulTagBits = ulTagBits;
    }

    public Object clone() {
        if (this.pAad != null) {
            return new GcmParameters((byte[])this.pIv.clone(), (byte[])this.pAad.clone(), this.ulTagBits);
        }
        return new GcmParameters((byte[])this.pIv.clone(), null, this.ulTagBits);
    }

    public Object getPKCS11ParamsObject() {
        CK_GCM_PARAMS params = new CK_GCM_PARAMS();
        params.pIv = this.pIv;
        params.pAAD = this.pAad;
        params.ulTagBits = this.ulTagBits;
        return params;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString());
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("pIV: ");
        buffer.append(Functions.toHexString(this.pIv));
        return buffer.toString();
    }

    public boolean equals(Object otherObject) {
        boolean equal = false;
        if (otherObject instanceof GcmParameters) {
            GcmParameters other = (GcmParameters)otherObject;
            equal = this == other || super.equals(other) && Functions.equals(this.pIv, other.pIv) && Functions.equals(this.pAad, other.pAad) && this.ulTagBits == other.ulTagBits;
        }
        return equal;
    }

    public int hashCode() {
        return super.hashCode() ^ Functions.hashCode(this.pIv) ^ Functions.hashCode(this.pAad) ^ new Long(this.ulTagBits).hashCode();
    }
}

