/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.GenericTemplate;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.OtherAttribute;
import iaik.pkcs.pkcs11.wrapper.CK_ATTRIBUTE;
import java.util.ArrayList;
import java.util.Enumeration;

public class AttributeArray
extends Attribute {
    protected Object template_;

    AttributeArray() {
    }

    public AttributeArray(Long type) {
        super(type);
    }

    public void setAttributeArrayValue(Object value) {
        this.template_ = value;
        ArrayList<CK_ATTRIBUTE> attributeList = new ArrayList<CK_ATTRIBUTE>();
        Enumeration attributeEnumeration = this.template_.attributeTable_.elements();
        while (attributeEnumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)attributeEnumeration.nextElement();
            if (!attribute.stateKnown_ || !attribute.present_) continue;
            attributeList.add(attribute.getCkAttribute());
        }
        this.ckAttribute_.pValue = attributeList.toArray(new CK_ATTRIBUTE[0]);
        this.present_ = true;
    }

    public Object getAttributeArrayValue() {
        if (this.template_ == null) {
            if (this.ckAttribute_.pValue != null && ((CK_ATTRIBUTE[])this.ckAttribute_.pValue).length > 0) {
                CK_ATTRIBUTE[] attributesArray = (CK_ATTRIBUTE[])this.ckAttribute_.pValue;
                GenericTemplate template = new GenericTemplate();
                for (int i = 0; i < attributesArray.length; ++i) {
                    Attribute attribute;
                    Long type = new Long(attributesArray[i].type);
                    Class implementation = Attribute.getAttributeClass(type);
                    if (implementation == null) {
                        attribute = new OtherAttribute();
                        attribute.setType(type);
                        attribute.setCkAttribute(attributesArray[i]);
                        continue;
                    }
                    try {
                        attribute = (Attribute)implementation.newInstance();
                        attribute.setCkAttribute(attributesArray[i]);
                        attribute.setPresent(true);
                        template.addAttribute(attribute);
                        continue;
                    }
                    catch (Exception ex) {
                        System.err.println("Error when trying to create a " + implementation + " instance for " + type + ": " + ex.getMessage());
                        System.err.flush();
                    }
                }
                return template;
            }
            return null;
        }
        return this.template_;
    }

    protected String getValueString() {
        String valueString = "";
        if (this.template_ == null) {
            this.template_ = this.getAttributeArrayValue();
        }
        if (this.template_ == null) {
            valueString = "<NULL_PTR>";
        } else {
            String indent = "      ";
            valueString = valueString + this.template_.toString(true, true, indent);
        }
        return valueString;
    }

    protected boolean equalsValue(java.lang.Object otherObject) {
        boolean equal = false;
        if (otherObject instanceof AttributeArray) {
            AttributeArray other = (AttributeArray)otherObject;
            if (this.template_ == null) {
                this.template_ = this.getAttributeArrayValue();
            }
            if (other.template_ == null) {
                other.template_ = other.getAttributeArrayValue();
            }
            equal = this.template_ == null && other.template_ == null || this.template_ != null && other.template_ != null && this.template_.equals(other.template_);
        }
        return equal;
    }

    public int hashCode() {
        if (this.template_ == null) {
            this.template_ = this.getAttributeArrayValue();
        }
        return this.template_ == null ? 0 : this.template_.hashCode();
    }

    public java.lang.Object clone() {
        AttributeArray clone = (AttributeArray)super.clone();
        if (this.template_ == null) {
            this.template_ = this.getAttributeArrayValue();
        }
        if (this.template_ != null) {
            clone.template_ = (GenericTemplate)this.template_.clone();
        }
        return clone;
    }

    public void setValue(java.lang.Object value) throws UnsupportedOperationException {
        this.setAttributeArrayValue((Object)value);
    }
}

