/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.spec;

import iaik.pkcs.pkcs11.provider.TokenManager;
import java.security.spec.KeySpec;

public abstract class PKCS11Spec
implements KeySpec {
    public static boolean USE_READ_ONLY_SESSION = true;
    public static boolean USE_READ_WRITE_SESSION = false;
    public static boolean USE_USER_SESSION = true;
    public static boolean USE_PUBLIC_SESSION = false;
    protected static final int USE_SO_ROLE = 0;
    protected static final int USE_USER_ROLE = 1;
    protected static final int USE_PUBLIC_ROLE = 2;
    protected TokenManager tokenManager_ = TokenManager.getDefaultTokenManager();
    protected boolean useROSession_;
    protected int useRole_ = 2;
    protected char[] usePin_ = null;

    /*
     * WARNING - void declaration
     */
    public PKCS11Spec(TokenManager tokenManager, boolean useROSession, boolean useUserSession) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (tokenManager == null) {
            throw new NullPointerException("Argument \"tokenManager\" must not be null.");
        }
        this.tokenManager_ = var1_1;
        this.useROSession_ = var2_2;
        if (var3_3 != false) {
            this.useRole_ = 1;
        }
    }

    public PKCS11Spec() {
    }

    /*
     * WARNING - void declaration
     */
    public PKCS11Spec setTokenManager(TokenManager tokenManager) {
        void var1_1;
        if (tokenManager == null) {
            throw new NullPointerException("Argument \"tokenManager\" must not be null.");
        }
        this.tokenManager_ = var1_1;
        return this;
    }

    public TokenManager getTokenManager() {
        return this.tokenManager_;
    }

    public boolean isUseROSession() {
        return this.useROSession_;
    }

    public boolean isUseUserSession() {
        return 1 == this.getRole();
    }

    /*
     * WARNING - void declaration
     */
    protected void setRole(int role) {
        void var1_1;
        this.useRole_ = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public PKCS11Spec setUseAnonymousRole(boolean rwAccess) {
        void var1_1;
        this.setRole(2);
        this.useROSession_ = var1_1 == false;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public PKCS11Spec setUseUserRole(boolean rwAccess) {
        void var1_1;
        this.setRole(1);
        this.useROSession_ = var1_1 == false;
        return this;
    }

    public PKCS11Spec setUseSORole() {
        this.setRole(0);
        this.useROSession_ = false;
        return this;
    }

    protected int getRole() {
        return this.useRole_;
    }

    public boolean isUseAnonymousRole() {
        return 2 == this.getRole();
    }

    public boolean isUseUserRole() {
        return 1 == this.getRole();
    }

    public boolean isUseSORole() {
        return 0 == this.getRole();
    }

    public boolean isUseRwSession() {
        return !this.useROSession_;
    }

    /*
     * WARNING - void declaration
     */
    public PKCS11Spec setPin(char[] pin) {
        void var1_1;
        this.usePin_ = var1_1;
        return this;
    }

    public char[] getPin() {
        return this.usePin_;
    }
}

