/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.signatures.ecdsa;

import iaik.pkcs.pkcs11.provider.signatures.SignatureUtil;
import iaik.pkcs.pkcs11.provider.signatures.ecdsa.UnwrappedEcdsaSignature;
import java.security.SignatureException;

public class EcdsaSignature
extends UnwrappedEcdsaSignature {
    protected static String SIGNATURE_ALGORITHM_NAME = "RawECDSA";

    protected String getAlgorithmName() {
        return SIGNATURE_ALGORITHM_NAME;
    }

    protected byte[] pkcs11Sign() throws SignatureException {
        byte[] byArray = super.pkcs11Sign();
        byArray = SignatureUtil.RStoASN1(byArray);
        return byArray;
    }

    protected boolean pkcs11Verify(byte[] signature) throws SignatureException {
        byte[] byArray = SignatureUtil.ASN1toRS(signature, 0);
        return super.pkcs11Verify(byArray);
    }
}

