/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.signatures;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import iaik.pkcs.pkcs11.Util;
import java.math.BigInteger;
import java.security.SignatureException;

public abstract class SignatureUtil {
    protected SignatureUtil() {
    }

    public static byte[] RStoASN1(byte[] rs) throws SignatureException {
        Object object;
        int n = rs.length / 2;
        Object object2 = new byte[n];
        byte[] byArray = new byte[n];
        System.arraycopy(rs, 0, object2, 0, n);
        System.arraycopy(object, n, byArray, 0, n);
        object = new BigInteger(1, (byte[])object2);
        BigInteger bigInteger = new BigInteger(1, byArray);
        SEQUENCE sEQUENCE = new SEQUENCE();
        object2 = sEQUENCE;
        sEQUENCE.addComponent((ASN1Object)new INTEGER((BigInteger)object));
        object2.addComponent((ASN1Object)new INTEGER(bigInteger));
        try {
            object = new ASN1((ASN1Object)object2).toByteArray();
        }
        catch (CodingException codingException) {
            throw new SignatureException("Error encoding r and s: " + codingException.toString());
        }
        return object;
    }

    public static byte[] ASN1toRS(byte[] sigBytes, int lengthRS) throws SignatureException {
        Object object;
        try {
            int n;
            ASN1 aSN1 = new ASN1(object);
            object = aSN1;
            if (aSN1.toASN1Object().isA(ASN.SEQUENCE)) {
                if (object.countComponents() != 2) {
                    throw new SignatureException("Error decoding r and s. The number of components is not 2.");
                }
            } else {
                throw new SignatureException("Error decoding r and s. The ASN.1 object is no SEQUENCE.");
            }
            Object object2 = object.getComponentAt(0);
            object = object.getComponentAt(1);
            object2 = (BigInteger)object2.getValue();
            object = (BigInteger)object.getValue();
            object2 = Util.unsignedBigIntergerToByteArray((BigInteger)object2);
            byte[] byArray = Util.unsignedBigIntergerToByteArray((BigInteger)object);
            n = lengthRS > 0 ? n : Math.max(((ASN1Object)object2).length, byArray.length);
            object = new byte[2 * n];
            System.arraycopy(object2, 0, object, (int)(n - ((ASN1Object)object2).length), ((ASN1Object)object2).length);
            System.arraycopy(byArray, 0, object, 2 * n - byArray.length, byArray.length);
        }
        catch (Exception exception) {
            throw new SignatureException("Error decoding r and s: " + exception.toString());
        }
        return object;
    }
}

