/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.signatures;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Signature;
import java.security.SignatureException;

public class SignatureOutputStream
extends FilterOutputStream {
    protected boolean on_ = true;
    protected Signature signatureEngine_;
    protected boolean isClosed_;
    protected int bytesProcessed_;
    protected boolean passThroughClose_;

    /*
     * WARNING - void declaration
     */
    public SignatureOutputStream(OutputStream data, Signature signatureEngine, boolean passThroughClose) {
        super(data);
        void var3_3;
        void var2_2;
        void var1_1;
        if (var1_1 == null) {
            throw new NullPointerException("Argument \"data\" must not be null.");
        }
        this.setSignature((Signature)var2_2);
        this.passThroughClose_ = var3_3;
    }

    public Signature getSignature() {
        return this.signatureEngine_;
    }

    /*
     * WARNING - void declaration
     */
    public void setSignature(Signature signatureEngine) {
        void var1_1;
        if (signatureEngine == null) {
            throw new NullPointerException("Argument \"signatureEngine\" must not be null.");
        }
        this.signatureEngine_ = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void write(int dataByte) throws IOException {
        this.out.write(dataByte);
        if (this.on_) {
            try {
                void var1_1;
                this.signatureEngine_.update((byte)var1_1);
                ++this.bytesProcessed_;
                return;
            }
            catch (SignatureException signatureException) {
                throw new IOException("Error updating signature engine: " + signatureException.toString());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void write(byte[] buffer, int offset, int length) throws IOException {
        this.out.write(buffer, offset, length);
        if (this.on_) {
            try {
                void var3_4;
                void var2_3;
                void var1_1;
                this.signatureEngine_.update((byte[])var1_1, (int)var2_3, length);
                this.bytesProcessed_ += var3_4;
                return;
            }
            catch (SignatureException signatureException) {
                throw new IOException("Error updating signature engine: " + signatureException.toString());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void write(byte[] buffer) throws IOException {
        void var1_1;
        this.write(buffer, 0, ((void)var1_1).length);
    }

    public boolean isOn() {
        return this.on_;
    }

    /*
     * WARNING - void declaration
     */
    public boolean setOn(boolean on) {
        void var1_1;
        boolean bl = this.on_;
        this.on_ = var1_1;
        return bl;
    }

    public int getBytesProcessed() {
        return this.bytesProcessed_;
    }

    public int clearBytesProcessed() {
        int n = this.bytesProcessed_;
        this.bytesProcessed_ = 0;
        return n;
    }

    public void close() throws IOException {
        if (this.passThroughClose_) {
            this.out.close();
        }
        this.isClosed_ = true;
    }

    public boolean isStreamClosed() {
        return this.isClosed_;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append(this.out.toString());
        stringBuffer.append('|');
        stringBuffer.append(this.signatureEngine_.toString());
        return stringBuffer.toString();
    }
}

