/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.signatures;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Signature;
import java.security.SignatureException;

public class SignatureInputStream
extends FilterInputStream {
    protected boolean on_ = true;
    protected Signature signatureEngine_;
    protected boolean isClosed_;
    protected boolean isAtEOF_;
    protected int bytesProcessed_;
    protected boolean passThroughClose_;

    /*
     * WARNING - void declaration
     */
    public SignatureInputStream(InputStream data, Signature signatureEngine, boolean passThroughClose) {
        super(data);
        void var3_3;
        void var2_2;
        void var1_1;
        if (var1_1 == null) {
            throw new NullPointerException("Argument \"data\" must not be null.");
        }
        this.setSignature((Signature)var2_2);
        this.passThroughClose_ = var3_3;
    }

    public Signature getSignature() {
        return this.signatureEngine_;
    }

    /*
     * WARNING - void declaration
     */
    public void setSignature(Signature signatureEngine) {
        void var1_1;
        if (signatureEngine == null) {
            throw new NullPointerException("Argument \"signatureEngine\" must not be null.");
        }
        this.signatureEngine_ = var1_1;
    }

    public int read() throws IOException {
        int n;
        try {
            n = this.in.read();
        }
        catch (EOFException eOFException) {
            this.isAtEOF_ = true;
            throw eOFException;
        }
        if (n < 0) {
            this.isAtEOF_ = true;
        } else if (this.on_) {
            try {
                this.signatureEngine_.update((byte)n);
                ++this.bytesProcessed_;
            }
            catch (SignatureException signatureException) {
                throw new IOException("Error updating signature engine: " + signatureException.toString());
            }
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int n;
        try {
            n = this.in.read(buffer, offset, n);
        }
        catch (EOFException eOFException) {
            this.isAtEOF_ = true;
            throw eOFException;
        }
        if (n < 0) {
            this.isAtEOF_ = true;
        } else if (this.on_) {
            try {
                void var2_4;
                void var1_1;
                this.signatureEngine_.update((byte[])var1_1, (int)var2_4, n);
                this.bytesProcessed_ += n;
            }
            catch (SignatureException signatureException) {
                throw new IOException("Error updating signature engine: " + signatureException.toString());
            }
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public int read(byte[] buffer) throws IOException {
        void var1_1;
        return this.read(buffer, 0, ((void)var1_1).length);
    }

    public boolean isOn() {
        return this.on_;
    }

    /*
     * WARNING - void declaration
     */
    public boolean setOn(boolean on) {
        void var1_1;
        boolean bl = this.on_;
        this.on_ = var1_1;
        return bl;
    }

    public boolean isStreamAtEOF() {
        return this.isAtEOF_;
    }

    public int getBytesProcessed() {
        return this.bytesProcessed_;
    }

    public int clearBytesProcessed() {
        int n = this.bytesProcessed_;
        this.bytesProcessed_ = 0;
        return n;
    }

    public void close() throws IOException {
        if (this.passThroughClose_) {
            this.in.close();
        }
        this.isClosed_ = true;
    }

    public boolean isStreamClosed() {
        return this.isClosed_;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append(this.in.toString());
        stringBuffer.append('|');
        stringBuffer.append(this.signatureEngine_.toString());
        return stringBuffer.toString();
    }
}

