/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.signatures;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.provider.DelegateProvider;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.PKCS11EngineClass;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11Key;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PrivateKey;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PublicKey;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;

public abstract class PKCS11Signature
extends SignatureSpi
implements PKCS11EngineClass {
    protected static final int SIGN = 1;
    protected static final int VERIFY = 2;
    protected Session session_;
    protected TokenManager tokenManager_;
    protected IAIKPKCS11PublicKey publicKey_;
    protected IAIKPKCS11PrivateKey privateKey_;
    protected int operationState_;
    protected boolean initialized_;
    protected boolean pkcs11OperationInitialized_;
    protected Boolean currentKeyIsSoftwareKey_;
    protected Signature softwareDelegate_;
    protected Mechanism[] usedMechanisms_;
    protected MechanismInfo[][] usedMechanismInfos_;
    private AlgorithmParameterSpec a;

    protected PKCS11Signature() {
    }

    protected Mechanism[] getUsedMechanisms() {
        if (this.usedMechanisms_ == null) {
            Mechanism mechanism = (Mechanism)this.getMechanism().clone();
            mechanism.setParameters(null);
            this.usedMechanisms_ = new Mechanism[]{mechanism};
        }
        return this.usedMechanisms_;
    }

    protected MechanismInfo[][] getUsedMechanismFeatures() {
        if (this.usedMechanismInfos_ == null) {
            MechanismInfo mechanismInfo = new MechanismInfo();
            mechanismInfo.setSign(true);
            MechanismInfo mechanismInfo2 = new MechanismInfo();
            mechanismInfo2.setVerify(true);
            this.usedMechanismInfos_ = new MechanismInfo[][]{{mechanismInfo, mechanismInfo2}};
        }
        return this.usedMechanismInfos_;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isSupportedBy(TokenManager tokenManager) {
        boolean bl;
        try {
            void var1_1;
            Mechanism[] mechanismArray = this.getUsedMechanisms();
            MechanismInfo[][] mechanismInfoArray = this.getUsedMechanismFeatures();
            bl = var1_1.isMechanismFeatureSupported(mechanismArray, mechanismInfoArray);
        }
        catch (TokenException tokenException) {
            bl = false;
        }
        return bl;
    }

    protected abstract Mechanism getMechanism();

    protected void initializeSoftwareDelegate() {
        DelegateProvider delegateProvider = this.tokenManager_ != null ? this.tokenManager_.getProvider().getDelegateProvider() : IAIKPkcs11.getGlobalDelegateProvider();
        String string = this.getAlgorithmName();
        this.softwareDelegate_ = delegateProvider.getSignature(string);
        if (this.softwareDelegate_ == null) {
            throw new IAIKPkcs11Exception("Could not get delegate signature engine for " + string);
        }
    }

    protected abstract String getAlgorithmName();

    /*
     * WARNING - void declaration
     */
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        void var1_1;
        publicKey = IAIKPkcs11.getGlobalKeyHandler().handleVerificationKey(this.getAlgorithmName(), publicKey);
        if (publicKey instanceof IAIKPKCS11Key) {
            this.currentKeyIsSoftwareKey_ = Boolean.FALSE;
            if (this.a != null) {
                try {
                    PKCS11Signature pKCS11Signature = this;
                    pKCS11Signature.engineSetParameter(pKCS11Signature.a);
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    throw new InvalidKeyException(invalidAlgorithmParameterException.toString(), invalidAlgorithmParameterException);
                }
            }
            this.pkcs11InitVerify((PublicKey)var1_1);
            return;
        }
        if (IAIKPkcs11.isEnableSoftwareDelegation()) {
            this.currentKeyIsSoftwareKey_ = Boolean.TRUE;
            if (this.softwareDelegate_ == null) {
                this.initializeSoftwareDelegate();
            }
            if (this.a != null) {
                try {
                    PKCS11Signature pKCS11Signature = this;
                    pKCS11Signature.engineSetParameter(pKCS11Signature.a);
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    throw new InvalidKeyException(invalidAlgorithmParameterException.toString(), invalidAlgorithmParameterException);
                }
            }
            this.softwareDelegate_.initVerify((PublicKey)var1_1);
            return;
        }
        throw new InvalidKeyException("The current key is not a key of this provider, but software delegation is disabled.");
    }

    /*
     * WARNING - void declaration
     */
    protected void pkcs11InitVerify(PublicKey publicKey) throws InvalidKeyException {
        void var1_1;
        if (!(publicKey instanceof IAIKPKCS11PublicKey)) {
            throw new InvalidKeyException("Public key must be of type iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PublicKey!");
        }
        this.publicKey_ = (IAIKPKCS11PublicKey)var1_1;
        this.tokenManager_ = this.publicKey_.getTokenManager();
        this.operationState_ = 2;
        this.initializePkcs11Operation();
        this.initialized_ = true;
    }

    /*
     * WARNING - void declaration
     */
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        void var1_1;
        privateKey = IAIKPkcs11.getGlobalKeyHandler().handleSignatureKey(this.getAlgorithmName(), privateKey);
        if (privateKey instanceof IAIKPKCS11Key) {
            this.currentKeyIsSoftwareKey_ = Boolean.FALSE;
            if (this.a != null) {
                try {
                    PKCS11Signature pKCS11Signature = this;
                    pKCS11Signature.engineSetParameter(pKCS11Signature.a);
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    throw new InvalidKeyException(invalidAlgorithmParameterException.toString(), invalidAlgorithmParameterException);
                }
            }
            this.pkcs11InitSign((PrivateKey)var1_1);
            return;
        }
        if (IAIKPkcs11.isEnableSoftwareDelegation()) {
            this.currentKeyIsSoftwareKey_ = Boolean.TRUE;
            if (this.softwareDelegate_ == null) {
                this.initializeSoftwareDelegate();
            }
            if (this.a != null) {
                try {
                    PKCS11Signature pKCS11Signature = this;
                    pKCS11Signature.engineSetParameter(pKCS11Signature.a);
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    throw new InvalidKeyException(invalidAlgorithmParameterException.toString(), invalidAlgorithmParameterException);
                }
            }
            this.softwareDelegate_.initSign((PrivateKey)var1_1);
            return;
        }
        throw new InvalidKeyException("The current key is not a key of this provider, but software delegation is disabled.");
    }

    protected void initializeSession() {
        try {
            if (this.session_ == null) {
                this.session_ = this.tokenManager_.getSession(false);
            }
            return;
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    protected void initializePkcs11Operation() throws InvalidKeyException {
        this.initializeSession();
        try {
            if (this.operationState_ == 1) {
                this.session_.signInit(this.getMechanism(), this.privateKey_.getKeyObject());
            } else {
                this.session_.verifyInit(this.getMechanism(), this.publicKey_.getKeyObject());
            }
        }
        catch (TokenException tokenException) {
            TokenException tokenException2 = tokenException;
            if (((PKCS11Exception)((Object)tokenException)).getErrorCode() == 257L) {
                try {
                    this.tokenManager_.makeAuthorizedSession(this.session_, null);
                    if (this.operationState_ == 1) {
                        this.session_.signInit(this.getMechanism(), this.privateKey_.getKeyObject());
                    } else {
                        this.session_.verifyInit(this.getMechanism(), this.publicKey_.getKeyObject());
                    }
                }
                catch (TokenException tokenException3) {
                    throw new InvalidKeyException(tokenException2.toString());
                }
            }
            throw new InvalidKeyException(tokenException2.toString());
        }
        this.pkcs11OperationInitialized_ = true;
    }

    protected void finalizePkcs11Operation() {
        if (this.pkcs11OperationInitialized_) {
            this.pkcs11OperationInitialized_ = false;
            this.tokenManager_.closeSession(this.session_);
            this.session_ = null;
            return;
        }
        this.tokenManager_.disposeSession(this.session_);
        this.session_ = null;
    }

    /*
     * WARNING - void declaration
     */
    protected void pkcs11InitSign(PrivateKey privateKey) throws InvalidKeyException {
        void var1_1;
        if (!(privateKey instanceof IAIKPKCS11PrivateKey)) {
            throw new InvalidKeyException("Private key must be of type iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PrivateKey!");
        }
        this.privateKey_ = (IAIKPKCS11PrivateKey)var1_1;
        this.tokenManager_ = this.privateKey_.getTokenManager();
        this.operationState_ = 1;
        this.initializePkcs11Operation();
        this.initialized_ = true;
    }

    /*
     * WARNING - void declaration
     */
    protected void engineUpdate(byte dataByte) throws SignatureException {
        void var1_1;
        if (this.currentKeyIsSoftwareKey_ == null) {
            throw new IllegalStateException();
        }
        if (this.currentKeyIsSoftwareKey_.booleanValue()) {
            if (IAIKPkcs11.isEnableSoftwareDelegation()) {
                this.softwareDelegate_.update(dataByte);
                return;
            }
            throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        }
        this.pkcs11Update((byte)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void pkcs11Update(byte dataByte) throws SignatureException {
        void var1_1;
        if (!this.initialized_) {
            throw new SignatureException("Signature object not initialzed");
        }
        byte[] byArray = new byte[]{var1_1};
        this.pkcs11Update(byArray, 0, 1);
    }

    /*
     * WARNING - void declaration
     */
    protected void engineUpdate(byte[] data, int offset, int length) throws SignatureException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.currentKeyIsSoftwareKey_ == null) {
            throw new IllegalStateException();
        }
        if (this.currentKeyIsSoftwareKey_.booleanValue()) {
            if (IAIKPkcs11.isEnableSoftwareDelegation()) {
                this.softwareDelegate_.update(data, offset, length);
                return;
            }
            throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        }
        this.pkcs11Update((byte[])var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected void pkcs11Update(byte[] data, int offset, int length) throws SignatureException {
        block9: {
            void var3_4;
            void var2_3;
            void var1_1;
            if (!this.initialized_) {
                throw new SignatureException("Signature object not initialzed");
            }
            if (offset + length > data.length) {
                throw new IllegalArgumentException("Arguments must satisfy ((offset + length) <= data.length).");
            }
            if (!this.pkcs11OperationInitialized_) {
                try {
                    this.initializePkcs11Operation();
                }
                catch (InvalidKeyException invalidKeyException) {
                    this.finalizePkcs11Operation();
                    throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 signature for next operation: " + invalidKeyException.toString());
                }
            }
            byte[] byArray = new byte[length];
            System.arraycopy(var1_1, (int)var2_3, byArray, 0, (int)var3_4);
            try {
                if (this.operationState_ == 1) {
                    this.session_.signUpdate(byArray);
                    break block9;
                }
                if (this.operationState_ == 2) {
                    this.session_.verifyUpdate(byArray);
                    break block9;
                }
                throw new SignatureException("Signature object in undefined state");
            }
            catch (TokenException tokenException) {
                this.finalizePkcs11Operation();
                throw new SignatureException(tokenException.toString());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] engineSign() throws SignatureException {
        if (this.currentKeyIsSoftwareKey_ == null) {
            throw new IllegalStateException();
        }
        if (this.currentKeyIsSoftwareKey_ != true) return this.pkcs11Sign();
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.softwareDelegate_.sign();
    }

    protected byte[] pkcs11Sign() throws SignatureException {
        byte[] byArray;
        if (this.operationState_ != 1) {
            throw new SignatureException("Signature object not in sign state");
        }
        if (!this.initialized_) {
            throw new SignatureException("Signature object not initialzed");
        }
        if (!this.pkcs11OperationInitialized_) {
            try {
                this.initializePkcs11Operation();
            }
            catch (InvalidKeyException invalidKeyException) {
                this.finalizePkcs11Operation();
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 signature for next operation: " + invalidKeyException.toString());
            }
        }
        try {
            byArray = this.session_.signFinal();
            this.pkcs11OperationInitialized_ = false;
        }
        catch (TokenException tokenException) {
            throw new SignatureException(tokenException.toString());
        }
        finally {
            this.finalizePkcs11Operation();
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean engineVerify(byte[] signature) throws SignatureException {
        if (this.currentKeyIsSoftwareKey_ == null) {
            throw new IllegalStateException();
        }
        if (this.currentKeyIsSoftwareKey_ != true) void var1_1;
        return this.pkcs11Verify((byte[])var1_1);
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.softwareDelegate_.verify(signature);
    }

    protected boolean pkcs11Verify(byte[] signature) throws SignatureException {
        boolean bl;
        PKCS11Exception pKCS11Exception;
        if (this.operationState_ != 2) {
            throw new SignatureException("Signature object not in verify state");
        }
        if (!this.initialized_) {
            throw new SignatureException("Signature object not initialzed");
        }
        if (!this.pkcs11OperationInitialized_) {
            try {
                this.initializePkcs11Operation();
            }
            catch (InvalidKeyException invalidKeyException) {
                this.finalizePkcs11Operation();
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 signature for next operation: " + invalidKeyException.toString());
            }
        }
        try {
            this.session_.verifyFinal((byte[])pKCS11Exception);
            bl = true;
            this.pkcs11OperationInitialized_ = false;
        }
        catch (PKCS11Exception pKCS11Exception2) {
            pKCS11Exception = pKCS11Exception2;
            long l2 = pKCS11Exception2.getErrorCode();
            if (l2 == 192L) {
                bl = false;
                this.pkcs11OperationInitialized_ = false;
            } else {
                bl = false;
            }
        }
        catch (TokenException tokenException) {
            bl = false;
        }
        finally {
            this.finalizePkcs11Operation();
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    protected void engineSetParameter(AlgorithmParameterSpec parametersSpec) throws InvalidAlgorithmParameterException {
        void var1_1;
        if (this.currentKeyIsSoftwareKey_ == null) {
            this.a = parametersSpec;
            return;
        }
        if (this.currentKeyIsSoftwareKey_.booleanValue()) {
            if (IAIKPkcs11.isEnableSoftwareDelegation()) {
                this.softwareDelegate_.setParameter(parametersSpec);
                return;
            }
            throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        }
        this.pkcs11SetParameter((AlgorithmParameterSpec)var1_1);
    }

    protected void pkcs11SetParameter(AlgorithmParameterSpec parametersSpec) throws InvalidAlgorithmParameterException {
        throw new UnsupportedOperationException("This method not supported by this class!");
    }

    /*
     * WARNING - void declaration
     */
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        void var2_2;
        void var1_1;
        if (this.currentKeyIsSoftwareKey_ != null && this.currentKeyIsSoftwareKey_.booleanValue()) {
            if (IAIKPkcs11.isEnableSoftwareDelegation()) {
                this.softwareDelegate_.setParameter(param, value);
                return;
            }
            throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        }
        this.pkcs11SetParameter((String)var1_1, var2_2);
    }

    protected void pkcs11SetParameter(String param, Object value) throws InvalidParameterException {
        throw new UnsupportedOperationException("Method not supported!");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        Object object;
        if (this.currentKeyIsSoftwareKey_ == null) return this.pkcs11GetParameter((String)object);
        if (this.currentKeyIsSoftwareKey_ != true) return this.pkcs11GetParameter((String)object);
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.softwareDelegate_.getParameter(param);
    }

    protected Object pkcs11GetParameter(String param) throws InvalidParameterException {
        throw new UnsupportedOperationException("Method not supported!");
    }

    protected void finalize() throws Throwable {
        if (this.session_ != null) {
            this.finalizePkcs11Operation();
        }
        super.finalize();
    }
}

