/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.signatures;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.signatures.PKCS11Signature;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;

public abstract class PKCS11BufferingSignature
extends PKCS11Signature {
    protected ByteArrayOutputStream buffer_ = new ByteArrayOutputStream(64);

    protected PKCS11BufferingSignature() {
    }

    protected abstract Mechanism getMechanism();

    /*
     * WARNING - void declaration
     */
    protected void pkcs11InitVerify(PublicKey publicKey) throws InvalidKeyException {
        void var1_1;
        super.pkcs11InitVerify((PublicKey)var1_1);
        this.buffer_.reset();
    }

    /*
     * WARNING - void declaration
     */
    protected void pkcs11InitSign(PrivateKey privateKey) throws InvalidKeyException {
        void var1_1;
        super.pkcs11InitSign((PrivateKey)var1_1);
        this.buffer_.reset();
    }

    /*
     * WARNING - void declaration
     */
    protected void pkcs11Update(byte[] data, int offset, int length) throws SignatureException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (!this.initialized_) {
            throw new SignatureException("Signature object not initialzed");
        }
        this.buffer_.write((byte[])var1_1, (int)var2_2, (int)var3_3);
    }

    protected byte[] pkcs11Sign() throws SignatureException {
        byte[] byArray;
        if (this.operationState_ != 1) {
            throw new SignatureException("Signature object not in sign state");
        }
        if (!this.initialized_) {
            throw new SignatureException("Signature object not initialzed");
        }
        if (!this.pkcs11OperationInitialized_) {
            try {
                this.initializePkcs11Operation();
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 signature for next operation: " + invalidKeyException.toString());
            }
        }
        try {
            byArray = this.session_.sign(this.buffer_.toByteArray());
            this.pkcs11OperationInitialized_ = false;
        }
        catch (TokenException tokenException) {
            throw new SignatureException(tokenException.toString());
        }
        finally {
            this.finalizePkcs11Operation();
            this.buffer_.reset();
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean pkcs11Verify(byte[] signature) throws SignatureException {
        boolean bl;
        if (this.operationState_ != 2) {
            throw new SignatureException("Signature object not in verify state");
        }
        if (!this.initialized_) {
            throw new SignatureException("Signature object not initialzed");
        }
        if (!this.pkcs11OperationInitialized_) {
            try {
                this.initializePkcs11Operation();
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 signature for next operation: " + invalidKeyException.toString());
            }
        }
        try {
            void var1_1;
            byte[] byArray = this.buffer_.toByteArray();
            this.session_.verify(byArray, (byte[])var1_1);
            bl = true;
            this.pkcs11OperationInitialized_ = false;
        }
        catch (PKCS11Exception pKCS11Exception) {
            PKCS11Exception pKCS11Exception2 = pKCS11Exception;
            long l2 = pKCS11Exception.getErrorCode();
            if (l2 == 192L) {
                bl = false;
                this.pkcs11OperationInitialized_ = false;
            } else {
                bl = false;
            }
        }
        catch (TokenException tokenException) {
            bl = false;
        }
        finally {
            this.finalizePkcs11Operation();
            this.buffer_.reset();
        }
        return bl;
    }
}

