/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.signatures;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.provider.DelegateProvider;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.signatures.PKCS11Signature;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;

public abstract class ExternalHashSignature
extends PKCS11Signature {
    protected MessageDigest messageDigest_;

    protected ExternalHashSignature() {
    }

    protected MessageDigest getMessageDigest() throws IAIKPkcs11Exception {
        Object object = this.tokenManager_ != null ? this.tokenManager_.getProvider().getDelegateProvider() : IAIKPkcs11.getGlobalDelegateProvider();
        String string = this.getMessageDigestName();
        if ((object = ((DelegateProvider)object).getMessageDigest(string)) == null) {
            throw new IAIKPkcs11Exception("Could not get delegate message digest engine for " + string);
        }
        return object;
    }

    protected abstract String getMessageDigestName();

    protected byte[] prepareHash(byte[] rawHash) throws IAIKPkcs11Exception {
        return rawHash;
    }

    protected abstract Mechanism getMechanism();

    /*
     * WARNING - void declaration
     */
    protected void pkcs11InitVerify(PublicKey publicKey) throws InvalidKeyException {
        void var1_1;
        super.pkcs11InitVerify((PublicKey)var1_1);
        if (this.messageDigest_ == null) {
            this.messageDigest_ = this.getMessageDigest();
            return;
        }
        this.messageDigest_.reset();
    }

    /*
     * WARNING - void declaration
     */
    protected void pkcs11InitSign(PrivateKey privateKey) throws InvalidKeyException {
        void var1_1;
        super.pkcs11InitSign((PrivateKey)var1_1);
        if (this.messageDigest_ == null) {
            this.messageDigest_ = this.getMessageDigest();
            return;
        }
        this.messageDigest_.reset();
    }

    /*
     * WARNING - void declaration
     */
    protected void pkcs11Update(byte dataByte) throws SignatureException {
        void var1_1;
        if (!this.initialized_) {
            throw new SignatureException("Signature object not initialzed");
        }
        this.messageDigest_.update((byte)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void pkcs11Update(byte[] data, int offset, int length) throws SignatureException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (!this.initialized_) {
            throw new SignatureException("Signature object not initialzed");
        }
        this.messageDigest_.update((byte[])var1_1, (int)var2_2, (int)var3_3);
    }

    protected byte[] pkcs11Sign() throws SignatureException {
        if (this.operationState_ != 1) {
            throw new SignatureException("Signature object not in sign state");
        }
        if (!this.initialized_) {
            throw new SignatureException("Signature object not initialzed");
        }
        if (!this.pkcs11OperationInitialized_) {
            try {
                this.initializePkcs11Operation();
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 signature for next operation: " + invalidKeyException.toString());
            }
        }
        byte[] byArray = this.messageDigest_.digest();
        byArray = this.prepareHash(byArray);
        try {
            byArray = this.session_.sign(byArray);
            this.pkcs11OperationInitialized_ = false;
        }
        catch (TokenException tokenException) {
            throw new SignatureException(tokenException.toString());
        }
        finally {
            this.finalizePkcs11Operation();
        }
        return byArray;
    }

    protected boolean pkcs11Verify(byte[] signature) throws SignatureException {
        boolean bl;
        PKCS11Exception pKCS11Exception;
        if (this.operationState_ != 2) {
            throw new SignatureException("Signature object not in verify state");
        }
        if (!this.initialized_) {
            throw new SignatureException("Signature object not initialzed");
        }
        if (!this.pkcs11OperationInitialized_) {
            try {
                this.initializePkcs11Operation();
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 signature for next operation: " + invalidKeyException.toString());
            }
        }
        ExternalHashSignature externalHashSignature = this;
        byte[] byArray = externalHashSignature.prepareHash(externalHashSignature.messageDigest_.digest());
        try {
            this.session_.verify(byArray, (byte[])pKCS11Exception);
            bl = true;
            this.pkcs11OperationInitialized_ = false;
        }
        catch (PKCS11Exception pKCS11Exception2) {
            pKCS11Exception = pKCS11Exception2;
            long l2 = pKCS11Exception2.getErrorCode();
            if (l2 == 192L) {
                bl = false;
                this.pkcs11OperationInitialized_ = false;
            } else {
                bl = false;
            }
        }
        catch (TokenException tokenException) {
            bl = false;
        }
        finally {
            this.finalizePkcs11Operation();
        }
        return bl;
    }
}

