/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.random;

import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.provider.random.PKCS11RandomSpi;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.security.GeneralSecurityException;

public class PKCS11SeededRandomSpi
extends PKCS11RandomSpi {
    protected static final int INITIAL_SEED_BYTES = 128;
    protected boolean isSeeded_;

    public PKCS11SeededRandomSpi() throws IAIKPkcs11Exception {
    }

    /*
     * WARNING - void declaration
     */
    public PKCS11SeededRandomSpi(TokenManager tokenManager) throws IAIKPkcs11Exception {
        super((TokenManager)var1_1);
        void var1_1;
    }

    protected int getInitialSeedByteNumber() {
        return 128;
    }

    protected void initializeSeed() {
        Object object;
        block15: {
            int n = this.getInitialSeedByteNumber();
            if (this.softwareDelegate_ == null) {
                try {
                    this.initializeSoftwareDelegate();
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new IAIKPkcs11Exception("Could not initialize software delegate secure random: " + generalSecurityException);
                }
            }
            if (this.useSoftwareDelegation_) {
                object = this.softwareDelegate_.generateSeed(n);
            } else {
                if (!this.pkcs11OperationInitialized_) {
                    this.initializePkcs11Operation();
                }
                try {
                    object = this.session_.generateRandom(n);
                }
                catch (TokenException tokenException) {
                    TokenException tokenException2 = tokenException;
                    if (tokenException instanceof PKCS11Exception) {
                        PKCS11Exception pKCS11Exception = (PKCS11Exception)tokenException2;
                        object = pKCS11Exception;
                        if (pKCS11Exception.getErrorCode() == 257L) {
                            try {
                                this.tokenManager_.makeAuthorizedSession(this.session_, null);
                                object = this.session_.generateRandom(n);
                                break block15;
                            }
                            catch (TokenException tokenException3) {
                                throw new IAIKPkcs11Exception(tokenException2.toString());
                            }
                        }
                        throw new IAIKPkcs11Exception(tokenException2.toString());
                    }
                    throw new IAIKPkcs11Exception(tokenException2.toString());
                }
                finally {
                    this.finalizePkcs11Operation();
                }
            }
        }
        this.softwareDelegate_.setSeed((byte[])object);
        this.isSeeded_ = true;
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized void engineNextBytes(byte[] arrayToFill) throws IAIKPkcs11Exception {
        void var1_1;
        if (arrayToFill == null) {
            throw new NullPointerException("Argument \"arrayToFill\" must not be null.");
        }
        if (!this.isSeeded_) {
            this.initializeSeed();
        }
        this.softwareDelegate_.nextBytes((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void engineSetSeed(byte[] seedBytes) throws IAIKPkcs11Exception {
        void var1_1;
        if (seedBytes == null) {
            throw new NullPointerException("Argument \"seedBytes\" must not be null.");
        }
        if (!this.isSeeded_) {
            this.initializeSeed();
        }
        this.softwareDelegate_.setSeed((byte[])var1_1);
    }
}

