/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.random;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.TokenInfo;
import iaik.pkcs.pkcs11.provider.DelegateProvider;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.PKCS11EngineClass;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;

public class PKCS11RandomSpi
extends SecureRandomSpi
implements PKCS11EngineClass {
    protected static final String SOFTWARE_SECURE_RANDOM_ALGORITHM = "SHA1PRNG";
    protected TokenManager tokenManager_;
    protected Session session_;
    protected boolean pkcs11OperationInitialized_;
    protected boolean useSoftwareDelegation_;
    protected SecureRandom softwareDelegate_;

    public PKCS11RandomSpi() throws IAIKPkcs11Exception {
        int n = IAIKPkcs11.getProviderInstanceCount();
        if (n <= 0) {
            throw new IAIKPkcs11Exception("No instance of IAIKPkcs11 available.");
        }
        this.tokenManager_ = IAIKPkcs11.getCurrentProviderInstance().getTokenManager();
        this.initialize();
    }

    /*
     * WARNING - void declaration
     */
    public PKCS11RandomSpi(TokenManager tokenManager) throws IAIKPkcs11Exception {
        void var1_1;
        if (tokenManager == null) {
            throw new NullPointerException("Argument \"tokenManager\" must not be null.");
        }
        this.tokenManager_ = var1_1;
        this.initialize();
    }

    public boolean isSupportedBy(TokenManager tokenManager) {
        boolean bl;
        try {
            Token token = this.tokenManager_.getToken();
            if (token != null) {
                token = token.getTokenInfo();
                bl = token.isRNG();
            } else {
                bl = false;
            }
        }
        catch (TokenException tokenException) {
            bl = false;
        }
        return bl;
    }

    protected void initialize() {
        try {
            boolean bl;
            Token token = this.tokenManager_.getToken();
            if (token != null) {
                token = token.getTokenInfo();
                bl = token.isRNG();
            } else {
                bl = false;
            }
            if (bl) {
                this.useSoftwareDelegation_ = false;
                return;
            }
            this.useSoftwareDelegation_ = true;
            this.initializeSoftwareDelegate();
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception("Could not get token info: " + (Object)((Object)tokenException));
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IAIKPkcs11Exception("Could not instantiate delegate secure random: " + generalSecurityException);
        }
    }

    protected void initializeSoftwareDelegate() throws GeneralSecurityException {
        DelegateProvider delegateProvider = this.tokenManager_ != null ? this.tokenManager_.getProvider().getDelegateProvider() : IAIKPkcs11.getGlobalDelegateProvider();
        String string = this.getSoftwareDelegateAlgorithm();
        this.softwareDelegate_ = delegateProvider.getSecureRandom(string);
        if (this.softwareDelegate_ == null) {
            throw new IAIKPkcs11Exception("Could not get delegate secure random engine for " + string);
        }
    }

    protected String getSoftwareDelegateAlgorithm() {
        return SOFTWARE_SECURE_RANDOM_ALGORITHM;
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized void engineNextBytes(byte[] arrayToFill) throws IAIKPkcs11Exception {
        int n;
        if (arrayToFill == null) {
            throw new NullPointerException("Argument \"arrayToFill\" must not be null.");
        }
        if (this.useSoftwareDelegation_) {
            this.softwareDelegate_.nextBytes(arrayToFill);
            return;
        }
        if (!this.pkcs11OperationInitialized_) {
            this.initializePkcs11Operation();
        }
        if ((n = arrayToFill.length) > 0) {
            void var1_1;
            Object object;
            block13: {
                try {
                    object = this.session_.generateRandom(n);
                }
                catch (TokenException tokenException) {
                    TokenException tokenException2 = tokenException;
                    if (tokenException instanceof PKCS11Exception) {
                        PKCS11Exception pKCS11Exception = (PKCS11Exception)tokenException2;
                        object = pKCS11Exception;
                        if (pKCS11Exception.getErrorCode() == 257L) {
                            try {
                                this.tokenManager_.makeAuthorizedSession(this.session_, null);
                                object = this.session_.generateRandom(n);
                                break block13;
                            }
                            catch (TokenException tokenException3) {
                                throw new IAIKPkcs11Exception(tokenException2.toString());
                            }
                        }
                        throw new IAIKPkcs11Exception(tokenException2.toString());
                    }
                    throw new IAIKPkcs11Exception(tokenException2.toString());
                }
                finally {
                    this.finalizePkcs11Operation();
                }
            }
            System.arraycopy(object, 0, var1_1, 0, n);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineSetSeed(byte[] seedBytes) throws IAIKPkcs11Exception {
        if (seedBytes == null) {
            throw new NullPointerException("Argument \"seedBytes\" must not be null.");
        }
        if (this.useSoftwareDelegation_) {
            this.softwareDelegate_.setSeed(seedBytes);
            return;
        }
        if (!this.pkcs11OperationInitialized_) {
            this.initializePkcs11Operation();
        }
        try {
            this.session_.seedRandom(seedBytes);
            return;
        }
        catch (TokenException tokenException) {
            TokenException tokenException2 = tokenException;
            if (!(tokenException instanceof PKCS11Exception)) throw new IAIKPkcs11Exception(tokenException2.toString());
            PKCS11Exception pKCS11Exception = (PKCS11Exception)tokenException2;
            if (pKCS11Exception.getErrorCode() != 257L) throw new IAIKPkcs11Exception(tokenException2.toString());
            try {
                void var1_1;
                this.tokenManager_.makeAuthorizedSession(this.session_, null);
                this.session_.seedRandom((byte[])var1_1);
                return;
            }
            catch (TokenException tokenException3) {
                throw new IAIKPkcs11Exception(tokenException2.toString());
            }
        }
        finally {
            this.finalizePkcs11Operation();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected byte[] engineGenerateSeed(int numBytes) {
        Object object;
        block13: {
            if (numBytes < 0) {
                throw new IllegalArgumentException("Argument \"numBytes\" must be greater than or equal to zero.");
            }
            if (this.useSoftwareDelegation_) {
                object = this.softwareDelegate_.generateSeed(numBytes);
            } else {
                if (!this.pkcs11OperationInitialized_) {
                    this.initializePkcs11Operation();
                }
                try {
                    object = this.session_.generateRandom(numBytes);
                }
                catch (TokenException tokenException) {
                    TokenException tokenException2 = tokenException;
                    if (tokenException instanceof PKCS11Exception) {
                        PKCS11Exception pKCS11Exception = (PKCS11Exception)tokenException2;
                        object = pKCS11Exception;
                        if (pKCS11Exception.getErrorCode() == 257L) {
                            try {
                                void var1_1;
                                this.tokenManager_.makeAuthorizedSession(this.session_, null);
                                object = this.session_.generateRandom((int)var1_1);
                                break block13;
                            }
                            catch (TokenException tokenException3) {
                                throw new IAIKPkcs11Exception(tokenException2.toString());
                            }
                        }
                        throw new IAIKPkcs11Exception(tokenException2.toString());
                    }
                    throw new IAIKPkcs11Exception(tokenException2.toString());
                }
                finally {
                    this.finalizePkcs11Operation();
                }
            }
        }
        return object;
    }

    protected void initializeSession() {
        try {
            if (this.session_ == null) {
                this.session_ = this.tokenManager_.getSession(false);
            }
            return;
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    protected void initializePkcs11Operation() {
        try {
            TokenInfo tokenInfo = this.tokenManager_.getToken().getTokenInfo();
            if (!tokenInfo.isRNG()) {
                throw new IAIKPkcs11Exception("The PKCS#11 token does not have a random number generator.");
            }
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
        this.initializeSession();
        this.pkcs11OperationInitialized_ = true;
    }

    protected void finalizePkcs11Operation() {
        this.pkcs11OperationInitialized_ = false;
        this.tokenManager_.disposeSession(this.session_);
        this.session_ = null;
    }

    protected void finalize() throws Throwable {
        if (this.session_ != null) {
            this.tokenManager_.disposeSession(this.session_);
        }
        super.finalize();
    }
}

