/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.macs;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.parameters.RC5MacGeneralParameters;
import iaik.pkcs.pkcs11.parameters.RC5Parameters;
import iaik.pkcs.pkcs11.provider.macs.PKCS11Mac;
import iaik.pkcs.pkcs11.provider.macs.PKCS11Rc5MacSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.RC5ParameterSpec;

public class Rc5Mac
extends PKCS11Mac {
    protected static String MAC_ALGORITHM_NAME = "MacRC5";
    protected Mechanism mechanism_;
    protected RC5ParameterSpec rc5ParameterSpec_;
    protected boolean rc5ParameterSpecChanged_;

    public Rc5Mac() {
        super(Mechanism.get((long)819L), Mechanism.get((long)820L), -1);
    }

    protected String getAlgorithmName() {
        return MAC_ALGORITHM_NAME;
    }

    protected int pkcs11GetMacLength() {
        if (this.rc5ParameterSpec_ != null) {
            return this.rc5ParameterSpec_.getWordSize();
        }
        if (this.params_ != null) {
            return this.params_.macLength_;
        }
        return this.defaultMacLength_;
    }

    /*
     * WARNING - void declaration
     */
    protected void pkcs11Init(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params instanceof RC5ParameterSpec) {
            this.rc5ParameterSpec_ = (RC5ParameterSpec)params;
        } else if (params instanceof PKCS11Rc5MacSpec) {
            this.rc5ParameterSpec_ = ((PKCS11Rc5MacSpec)params).getRC5ParameterSpec();
        } else {
            throw new InvalidAlgorithmParameterException("key must be of type javax.crypto.spec.RC5ParameterSpec or PKCS11Rc5MacSpec!");
        }
        this.rc5ParameterSpecChanged_ = true;
        try {
            void var2_2;
            void var1_1;
            super.pkcs11Init((Key)var1_1, (AlgorithmParameterSpec)var2_2);
            return;
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            return;
        }
    }

    protected Mechanism getMechanism() {
        if (this.rc5ParameterSpecChanged_) {
            RC5Parameters rC5Parameters;
            Mechanism mechanism;
            int n = this.rc5ParameterSpec_.getRounds();
            int n2 = this.rc5ParameterSpec_.getWordSize();
            if (this.defaultMacLength_ == this.pkcs11GetMacLength()) {
                mechanism = Mechanism.get((long)819L);
                rC5Parameters = new RC5Parameters((long)n2, (long)n);
            } else {
                mechanism = Mechanism.get((long)820L);
                rC5Parameters = new RC5MacGeneralParameters((long)n2, (long)n, (long)this.pkcs11GetMacLength());
            }
            this.rc5ParameterSpecChanged_ = false;
            mechanism.setParameters((Parameters)rC5Parameters);
            this.mechanism_ = mechanism;
        }
        return this.mechanism_;
    }
}

