/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.macs;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.parameters.RC2MacGeneralParameters;
import iaik.pkcs.pkcs11.parameters.RC2Parameters;
import iaik.pkcs.pkcs11.provider.macs.PKCS11Mac;
import iaik.pkcs.pkcs11.provider.macs.PKCS11Rc2MacSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;

public class Rc2Mac
extends PKCS11Mac {
    protected static String MAC_ALGORITHM_NAME = "MacRC2";
    protected RC2ParameterSpec rc2ParameterSpec_;
    protected boolean rc2ParameterSpecChanged_;
    protected Mechanism mechanism_;

    public Rc2Mac() {
        super(Mechanism.get((long)259L), Mechanism.get((long)260L), 4);
    }

    protected String getAlgorithmName() {
        return MAC_ALGORITHM_NAME;
    }

    /*
     * WARNING - void declaration
     */
    protected void pkcs11Init(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params instanceof RC2ParameterSpec) {
            this.rc2ParameterSpec_ = (RC2ParameterSpec)params;
        } else if (params instanceof PKCS11Rc2MacSpec) {
            this.rc2ParameterSpec_ = ((PKCS11Rc2MacSpec)params).getRC2ParameterSpec();
        } else {
            throw new InvalidAlgorithmParameterException("must be of type PKCS11Rc2MacSpec or javax.crypto.spec.RC2ParameterSpec!");
        }
        this.rc2ParameterSpecChanged_ = true;
        try {
            void var2_2;
            void var1_1;
            super.pkcs11Init((Key)var1_1, (AlgorithmParameterSpec)var2_2);
            return;
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            return;
        }
    }

    protected Mechanism getMechanism() {
        if (this.rc2ParameterSpecChanged_ && this.rc2ParameterSpec_ != null && this.params_ != null) {
            RC2Parameters rC2Parameters;
            Mechanism mechanism;
            if (this.defaultMacLength_ == this.pkcs11GetMacLength()) {
                mechanism = Mechanism.get((long)259L);
                rC2Parameters = new RC2Parameters((long)this.rc2ParameterSpec_.getEffectiveKeyBits());
            } else {
                mechanism = Mechanism.get((long)260L);
                rC2Parameters = new RC2MacGeneralParameters((long)this.rc2ParameterSpec_.getEffectiveKeyBits(), (long)this.pkcs11GetMacLength());
            }
            this.rc2ParameterSpecChanged_ = false;
            mechanism.setParameters((Parameters)rC2Parameters);
            this.mechanism_ = mechanism;
        }
        return this.mechanism_;
    }
}

