/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.macs;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.parameters.MacGeneralParameters;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.provider.DelegateProvider;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.PKCS11EngineClass;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11Key;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey;
import iaik.pkcs.pkcs11.provider.macs.PKCS11MacSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Mac;
import javax.crypto.MacSpi;

public abstract class PKCS11Mac
extends MacSpi
implements PKCS11EngineClass {
    protected Session session_;
    protected TokenManager tokenManager_;
    protected IAIKPKCS11SecretKey key_;
    protected SecretKey keyObject_;
    protected boolean initialized_;
    protected boolean pkcs11OperationInitialized_;
    protected boolean updateUsed_;
    protected byte[] buffer_;
    protected boolean currentKeyIsSoftwareKey_;
    protected Mac softwareDelegate_;
    protected Mechanism[] usedMechanisms_;
    protected MechanismInfo[][] usedMechanismInfos_;
    protected PKCS11MacSpec params_;
    protected int defaultMacLength_;

    /*
     * WARNING - void declaration
     */
    protected PKCS11Mac(Mechanism macMechanism, int defaultMacLength) {
        void var1_1;
        void var2_2;
        this.defaultMacLength_ = var2_2;
        this.usedMechanisms_ = new Mechanism[]{var1_1};
    }

    /*
     * WARNING - void declaration
     */
    protected PKCS11Mac(Mechanism macMechanism, Mechanism macGeneralMechanism, int defaultMacLength) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.defaultMacLength_ = var3_3;
        this.usedMechanisms_ = new Mechanism[]{var1_1, var2_2};
    }

    protected MechanismInfo[][] getUsedMechanismFeatures() {
        if (this.usedMechanismInfos_ == null) {
            MechanismInfo mechanismInfo = new MechanismInfo();
            mechanismInfo.setSign(true);
            MechanismInfo mechanismInfo2 = new MechanismInfo();
            mechanismInfo2.setVerify(true);
            PKCS11Mac pKCS11Mac = this;
            pKCS11Mac.usedMechanismInfos_ = new MechanismInfo[pKCS11Mac.usedMechanisms_.length][2];
            int n = 0;
            while (true) {
                pKCS11Mac = this;
                if (n >= pKCS11Mac.usedMechanisms_.length) break;
                this.usedMechanismInfos_[n][0] = mechanismInfo;
                this.usedMechanismInfos_[n][1] = mechanismInfo2;
                ++n;
            }
        }
        return this.usedMechanismInfos_;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isSupportedBy(TokenManager tokenManager) {
        boolean bl;
        try {
            void var1_1;
            Mechanism[] mechanismArray = this;
            mechanismArray = this.usedMechanisms_;
            MechanismInfo[][] mechanismInfoArray = this.getUsedMechanismFeatures();
            bl = var1_1.isMechanismFeatureSupported(mechanismArray, mechanismInfoArray);
        }
        catch (TokenException tokenException) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    protected void checkKeyObject(iaik.pkcs.pkcs11.objects.Key keyObject) throws InvalidKeyException {
        void var1_1;
        if (keyObject == null) {
            throw new NullPointerException("Argument \"keyObject\" must not be null.");
        }
        if (!(var1_1 instanceof SecretKey)) {
            throw new InvalidKeyException("PKCS#11 key object inside IAIKPKCS11SecretKey must be of type SecretKey");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] engineDoFinal() throws IllegalStateException {
        if (!this.currentKeyIsSoftwareKey_) return this.pkcs11DoFinal();
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.softwareDelegate_.doFinal();
    }

    protected byte[] pkcs11DoFinal() throws IllegalStateException {
        byte[] byArray;
        this.pkcs11Prepare();
        try {
            if (!this.updateUsed_ && this.buffer_ != null) {
                byArray = this.session_.sign(this.buffer_);
            } else {
                byArray = this.session_.signFinal();
                this.pkcs11OperationInitialized_ = false;
            }
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
        finally {
            this.finalizePkcs11Operation();
        }
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int engineGetMacLength() {
        if (!this.currentKeyIsSoftwareKey_) return this.pkcs11GetMacLength();
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.softwareDelegate_.getMacLength();
    }

    protected int pkcs11GetMacLength() {
        if (this.params_ != null && 0 <= this.params_.macLength_) {
            return this.params_.macLength_;
        }
        return this.defaultMacLength_;
    }

    /*
     * WARNING - void declaration
     */
    protected void engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        key = IAIKPkcs11.getGlobalKeyHandler().handleMacKey(this.getAlgorithmName(), key);
        if (params != null && !(params instanceof PKCS11MacSpec)) {
            throw new InvalidAlgorithmParameterException("Type PKCS11MacSpec is required.");
        }
        if (key instanceof IAIKPKCS11Key) {
            this.pkcs11Init(key, (PKCS11MacSpec)params);
            this.currentKeyIsSoftwareKey_ = false;
            return;
        }
        if (IAIKPkcs11.isEnableSoftwareDelegation()) {
            void var2_2;
            void var1_1;
            if (this.softwareDelegate_ == null) {
                this.initializeSoftwareDelegate();
            }
            this.softwareDelegate_.init((Key)var1_1, (AlgorithmParameterSpec)var2_2);
            this.currentKeyIsSoftwareKey_ = true;
            return;
        }
        throw new InvalidKeyException("The current key is not a key of this provider, but software delegation is disabled.");
    }

    protected void initializeSoftwareDelegate() {
        DelegateProvider delegateProvider = this.tokenManager_ != null ? this.tokenManager_.getProvider().getDelegateProvider() : IAIKPkcs11.getGlobalDelegateProvider();
        String string = this.getAlgorithmName();
        this.softwareDelegate_ = delegateProvider.getMac(string);
        if (this.softwareDelegate_ == null) {
            throw new IAIKPkcs11Exception("Could not get delegate MAC engine for " + string);
        }
    }

    protected abstract String getAlgorithmName();

    /*
     * WARNING - void declaration
     */
    protected void pkcs11Init(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        void var1_1;
        if (!(key instanceof IAIKPKCS11SecretKey)) {
            throw new InvalidKeyException("key must be of type iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey!");
        }
        this.key_ = (IAIKPKCS11SecretKey)var1_1;
        this.keyObject_ = (SecretKey)this.key_.getKeyObject();
        PKCS11Mac pKCS11Mac = this;
        pKCS11Mac.checkKeyObject((iaik.pkcs.pkcs11.objects.Key)pKCS11Mac.keyObject_);
        try {
            void var2_3;
            this.params_ = (PKCS11MacSpec)var2_3;
            return;
        }
        catch (ClassCastException classCastException) {
            throw new InvalidAlgorithmParameterException("must be of type PKCS11MacSpec");
        }
        finally {
            this.initialize();
        }
    }

    protected void engineReset() {
        if (this.currentKeyIsSoftwareKey_) {
            if (IAIKPkcs11.isEnableSoftwareDelegation()) {
                this.softwareDelegate_.reset();
                return;
            }
            throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        }
        this.pkcs11Reset();
    }

    protected void pkcs11Reset() {
        if (this.session_ != null) {
            this.finalizePkcs11Operation();
        }
        this.initialized_ = true;
        this.updateUsed_ = false;
        this.buffer_ = null;
    }

    protected void pkcs11Prepare() throws IllegalStateException, IAIKPkcs11Exception {
        if (!this.initialized_) {
            throw new IllegalStateException("MAC not initialized!");
        }
        if (!this.pkcs11OperationInitialized_) {
            try {
                this.initializePkcs11Operation();
                return;
            }
            catch (TokenException tokenException) {
                this.finalizePkcs11Operation();
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 signature for next operation: " + tokenException.toString());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void engineUpdate(byte input) throws IllegalStateException {
        void var1_1;
        if (this.currentKeyIsSoftwareKey_) {
            if (IAIKPkcs11.isEnableSoftwareDelegation()) {
                this.softwareDelegate_.update(input);
                return;
            }
            throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        }
        this.pkcs11Update((byte)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void pkcs11Update(byte input) throws IllegalStateException {
        void var1_1;
        this.pkcs11Prepare();
        byte[] byArray = new byte[1];
        byte[] byArray2 = byArray;
        byArray[0] = var1_1;
        if (!this.updateUsed_ && this.buffer_ == null) {
            this.buffer_ = byArray2;
            return;
        }
        try {
            if (this.buffer_ != null) {
                this.session_.signUpdate(this.buffer_);
                this.buffer_ = null;
            }
            this.session_.signUpdate(byArray2);
            this.updateUsed_ = true;
            return;
        }
        catch (TokenException tokenException) {
            this.finalizePkcs11Operation();
            throw new IAIKPkcs11Exception("Error updating digest: " + (Object)((Object)tokenException));
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void engineUpdate(byte[] data, int offset, int length) throws IllegalStateException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.currentKeyIsSoftwareKey_) {
            if (IAIKPkcs11.isEnableSoftwareDelegation()) {
                this.softwareDelegate_.update(data, offset, length);
                return;
            }
            throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        }
        this.pkcs11Update((byte[])var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected void pkcs11Update(byte[] data, int offset, int length) throws IllegalStateException {
        byte[] byArray;
        if (data == null) {
            throw new NullPointerException("Argument \"data\" must not be null.");
        }
        if (offset + length > data.length) {
            throw new IllegalArgumentException("Arguments must satisfy ((offset + length) <= data.length).");
        }
        this.pkcs11Prepare();
        if (offset == 0 && length == data.length) {
            byArray = data;
        } else {
            void var3_4;
            void var2_3;
            void var1_1;
            byArray = new byte[length];
            System.arraycopy(var1_1, (int)var2_3, byArray, 0, (int)var3_4);
        }
        if (!this.updateUsed_ && this.buffer_ == null) {
            this.buffer_ = byArray;
            return;
        }
        try {
            if (this.buffer_ != null) {
                this.session_.signUpdate(this.buffer_);
                this.buffer_ = null;
            }
            this.session_.signUpdate(byArray);
            this.updateUsed_ = true;
            return;
        }
        catch (TokenException tokenException) {
            this.finalizePkcs11Operation();
            throw new IAIKPkcs11Exception("Error updating MAC: " + (Object)((Object)tokenException));
        }
    }

    protected Mechanism getMechanism() {
        if (this.defaultMacLength_ == this.pkcs11GetMacLength()) {
            return (Mechanism)this.usedMechanisms_[0].clone();
        }
        Mechanism mechanism = (Mechanism)this.usedMechanisms_[1].clone();
        mechanism.setParameters((Parameters)new MacGeneralParameters((long)this.pkcs11GetMacLength()));
        return mechanism;
    }

    protected void initializeSession() {
        this.tokenManager_ = this.key_.getTokenManager();
        try {
            if (this.session_ == null) {
                this.session_ = this.tokenManager_.getSession(false);
            }
            this.tokenManager_.makeAuthorizedSession(this.session_, null);
            return;
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    protected void initializePkcs11Operation() throws TokenException {
        this.initializeSession();
        this.session_.signInit(this.getMechanism(), this.key_.getKeyObject());
        this.pkcs11OperationInitialized_ = true;
        this.updateUsed_ = false;
        this.buffer_ = null;
    }

    protected void finalizePkcs11Operation() {
        if (this.pkcs11OperationInitialized_) {
            this.pkcs11OperationInitialized_ = false;
            this.tokenManager_.closeSession(this.session_);
            this.session_ = null;
            return;
        }
        this.pkcs11OperationInitialized_ = false;
        this.tokenManager_.disposeSession(this.session_);
        this.session_ = null;
    }

    protected void initialize() throws InvalidAlgorithmParameterException, InvalidKeyException {
        try {
            this.initializePkcs11Operation();
        }
        catch (TokenException tokenException) {
            throw new InvalidKeyException(this.getClass().getName() + ": " + tokenException.toString());
        }
        this.initialized_ = true;
        this.updateUsed_ = false;
        this.buffer_ = null;
    }

    protected void finalize() throws Throwable {
        if (this.session_ != null) {
            this.finalizePkcs11Operation();
        }
        super.finalize();
    }
}

