/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keys;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.objects.PublicKey;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.provider.Constants;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11TokenUnavailableException;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PrivateKey;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PublicKey;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey;
import java.security.Key;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public abstract class IAIKPKCS11Key
implements Key {
    public static final String RSA = "RSA";
    public static final String DSA = "DSA";
    public static final String DH = "DH";
    public static final String ECDSA = "ECDSA";
    public static final String KEA = "KEA";
    public static final String GENERIC_SECRET = "GENERIC_SECRET";
    public static final String RC2 = "RC2";
    public static final String RC4 = "RC4";
    public static final String DES = "DES";
    public static final String DES2 = "DES2";
    public static final String DESede = "DESede";
    public static final String CAST = "CAST";
    public static final String CAST3 = "CAST3";
    public static final String CAST5 = "CAST5";
    public static final String CAST128 = "CAST128";
    public static final String RC5 = "RC5";
    public static final String IDEA = "IDEA";
    public static final String SKIPJACK = "SKIPJACK";
    public static final String BATON = "BATON";
    public static final String JUNIPER = "JUNIPER";
    public static final String CDMF = "CDMF";
    public static final String AES = "AES";
    public static final String BLOWFISH = "BLOWFISH";
    public static final String TWOFISH = "TWOFISH";
    public static final String VENDOR_DEFINED = "VENDOR_DEFINED";
    protected static final String KEY_TYPE_NAME_PROPERTIES = "iaik/pkcs/pkcs11/provider/keys/IAIKPKCS11Key.properties";
    protected static Map keyTypeNames_;
    protected static final Map keyTypeCodes_;
    private static boolean a;
    private static boolean b;
    protected TokenManager tokenManager_;
    protected iaik.pkcs.pkcs11.objects.Key keyObject_;
    protected String alias_;
    protected Session session_;
    protected boolean autoDestroy_;
    protected boolean destroyed_;
    private static Class c;

    protected static boolean jdk16AndEccelerate() {
        if (!b) {
            try {
                String string = System.getProperty("java.version");
                if (string != null && string.compareTo("1.6") < 0) {
                    a = false;
                } else {
                    Class.forName("iaik.security.ec.common.ECParameterSpec");
                    a = true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                a = false;
            }
            catch (SecurityException securityException) {
                a = false;
            }
            b = true;
            return a;
        }
        return a;
    }

    /*
     * WARNING - void declaration
     */
    public static IAIKPKCS11Key create(TokenManager tokenManager, iaik.pkcs.pkcs11.objects.Key keyObject) {
        Object object;
        if (keyObject instanceof PrivateKey) {
            object = IAIKPKCS11PrivateKey.create(tokenManager, (PrivateKey)keyObject);
        } else if (keyObject instanceof PublicKey) {
            object = IAIKPKCS11PublicKey.create((TokenManager)object, (PublicKey)keyObject);
        } else if (keyObject instanceof SecretKey) {
            object = IAIKPKCS11SecretKey.create((TokenManager)object, (SecretKey)keyObject);
        } else {
            void var1_1;
            throw new IAIKPkcs11Exception("Unrecognized PKCS#11 object type: " + var1_1.getClass().getName());
        }
        return object;
    }

    public static String getAlgorithmName(int keyTypeCode) {
        int n;
        return (String)keyTypeNames_.get(new Long(n));
    }

    public static Long getAlgorithmCode(String keyTypeName) {
        String string;
        return (Long)keyTypeCodes_.get(string);
    }

    /*
     * WARNING - void declaration
     */
    protected IAIKPKCS11Key(TokenManager tokenManager, iaik.pkcs.pkcs11.objects.Key keyObject) {
        void var2_2;
        void var1_1;
        if (tokenManager == null) {
            throw new NullPointerException("Argument \"tokenManager\" must not be null");
        }
        if (keyObject == null) {
            throw new NullPointerException("Argument \"keyObject\" must not be null");
        }
        this.tokenManager_ = var1_1;
        this.keyObject_ = var2_2;
    }

    public void destroy() {
        if (!this.destroyed_) {
            Session session = null;
            try {
                Token token = this.tokenManager_.getToken();
                if (token != null) {
                    boolean bl = this.keyObject_.getToken().getBooleanValue();
                    session = bl ? this.tokenManager_.getSession(true) : this.tokenManager_.getSession(false);
                    bl = this.keyObject_.getPrivate().getBooleanValue();
                    if (bl) {
                        this.tokenManager_.makeAuthorizedSession(session, null);
                    }
                } else {
                    throw new IAIKPkcs11TokenUnavailableException("The token is unavailable.");
                }
                session.destroyObject((iaik.pkcs.pkcs11.objects.Object)this.keyObject_);
                this.destroyed_ = true;
                this.setSession(null);
                if (session != null) {
                    this.tokenManager_.disposeSession(session);
                    return;
                }
            }
            catch (Exception exception) {
                try {
                    throw new IAIKPkcs11Exception(exception.toString());
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        this.tokenManager_.disposeSession(session);
                    }
                    throw throwable;
                }
            }
        }
    }

    public boolean isDestroyed() {
        return this.destroyed_;
    }

    public String getAlgorithm() {
        return IAIKPKCS11Key.getAlgorithmName(this.keyObject_.getKeyType().getLongValue().intValue());
    }

    public String getAlias() {
        if (this.alias_ == null) {
            char[] cArray = this.keyObject_.getLabel().getCharArrayValue();
            this.alias_ = cArray != null ? new String(cArray) : null;
        }
        return this.alias_;
    }

    public TokenManager getTokenManager() {
        return this.tokenManager_;
    }

    public iaik.pkcs.pkcs11.objects.Key getKeyObject() {
        return this.keyObject_;
    }

    public byte[] getKeyID() {
        return this.keyObject_.getId().getByteArrayValue();
    }

    public byte[] getEncoded() {
        return null;
    }

    public String getFormat() {
        return null;
    }

    public Session getSession() {
        return this.session_;
    }

    /*
     * WARNING - void declaration
     */
    public void setSession(Session session) {
        if (session != null) {
            void var1_1;
            this.session_ = session;
            this.tokenManager_.acquireSessionCloseLock((Session)var1_1);
            return;
        }
        if (this.session_ != null) {
            this.tokenManager_.releaseSessionCloseLock(this.session_);
            this.session_ = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setAutoDestroy(boolean autoDestroy) {
        void var1_1;
        this.autoDestroy_ = var1_1;
    }

    public boolean isAutoDestroy() {
        return this.autoDestroy_;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PKCS#11 key object: ");
        stringBuffer.append(Constants.LINE_SEPARATOR);
        stringBuffer.append(this.keyObject_.toString());
        stringBuffer.append(Constants.LINE_SEPARATOR);
        stringBuffer.append("on token: ");
        stringBuffer.append(Constants.LINE_SEPARATOR);
        try {
            stringBuffer.append(this.tokenManager_.getToken().getTokenInfo().toString());
        }
        catch (TokenException tokenException) {
            stringBuffer.append("Error getting token info: " + tokenException.toString());
        }
        return stringBuffer.toString();
    }

    public void finalize() throws Throwable {
        if (this.autoDestroy_) {
            try {
                this.destroy();
            }
            catch (Exception exception) {}
        } else {
            this.setSession(null);
        }
        super.finalize();
    }

    private static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Object object;
        Iterator<Object> iterator;
        keyTypeNames_ = new HashMap<Long, String>(32);
        keyTypeNames_.put(0L, RSA);
        keyTypeNames_.put(1L, DSA);
        keyTypeNames_.put(2L, DH);
        keyTypeNames_.put(3L, ECDSA);
        keyTypeNames_.put(5L, KEA);
        keyTypeNames_.put(16L, GENERIC_SECRET);
        keyTypeNames_.put(17L, RC2);
        keyTypeNames_.put(18L, RC4);
        keyTypeNames_.put(19L, DES);
        keyTypeNames_.put(20L, DES2);
        keyTypeNames_.put(21L, DESede);
        keyTypeNames_.put(22L, CAST);
        keyTypeNames_.put(23L, CAST3);
        keyTypeNames_.put(24L, CAST5);
        keyTypeNames_.put(24L, CAST128);
        keyTypeNames_.put(25L, RC5);
        keyTypeNames_.put(26L, IDEA);
        keyTypeNames_.put(27L, SKIPJACK);
        keyTypeNames_.put(28L, BATON);
        keyTypeNames_.put(29L, JUNIPER);
        keyTypeNames_.put(30L, CDMF);
        keyTypeNames_.put(31L, AES);
        keyTypeNames_.put(32L, BLOWFISH);
        keyTypeNames_.put(33L, TWOFISH);
        keyTypeNames_.put(0x80000000L, VENDOR_DEFINED);
        Properties properties = new Properties();
        try {
            properties.load((c == null ? (c = IAIKPKCS11Key.a("iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11Key")) : c).getClassLoader().getResourceAsStream(KEY_TYPE_NAME_PROPERTIES));
            iterator = properties.keySet().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                String string = properties.getProperty((String)object);
                try {
                    if (((String)object).startsWith("0x")) {
                        object = ((String)object).substring(2);
                    }
                    Long l2 = Long.valueOf((String)object, 16);
                    keyTypeNames_.put(l2, string);
                }
                catch (Exception exception) {
                    IAIKPkcs11.errorStream_.println("Error in properties file iaik/pkcs/pkcs11/provider/keys/IAIKPKCS11Key.properties in entry " + (String)object + ". Trying to continue.");
                }
            }
        }
        catch (Exception exception) {}
        keyTypeCodes_ = new HashMap(32);
        iterator = keyTypeNames_.entrySet().iterator();
        while (iterator.hasNext()) {
            object = (Map.Entry)iterator.next();
            keyTypeCodes_.put(object.getValue(), object.getKey());
        }
    }
}

