/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keypairgenerators;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.PublicKey;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.PKCS11EngineClass;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.provider.keypairgenerators.PKCS11KeyPairGenerationSpec;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11Key;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PrivateKey;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PublicKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public abstract class PKCS11KeyPairGenerator
extends KeyPairGeneratorSpi
implements PKCS11EngineClass {
    protected TokenManager tokenManager_;
    protected Session session_;
    protected PKCS11KeyPairGenerationSpec keyPairGenerationSpec_;
    protected boolean initialized_;
    protected boolean pkcs11OperationInitialized_;
    protected Mechanism[] usedMechanisms_;
    protected MechanismInfo[][] usedMechanismInfos_;

    protected PKCS11KeyPairGenerator() {
    }

    protected Mechanism[] getUsedMechanisms() {
        if (this.usedMechanisms_ == null) {
            Mechanism mechanism = (Mechanism)this.getMechanism().clone();
            mechanism.setParameters(null);
            this.usedMechanisms_ = new Mechanism[]{mechanism};
        }
        return this.usedMechanisms_;
    }

    protected MechanismInfo[][] getUsedMechanismFeatures() {
        if (this.usedMechanismInfos_ == null) {
            MechanismInfo mechanismInfo = new MechanismInfo();
            mechanismInfo.setGenerateKeyPair(true);
            this.usedMechanismInfos_ = new MechanismInfo[][]{{mechanismInfo}};
        }
        return this.usedMechanismInfos_;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isSupportedBy(TokenManager tokenManager) {
        boolean bl;
        try {
            void var1_1;
            Mechanism[] mechanismArray = this.getUsedMechanisms();
            MechanismInfo[][] mechanismInfoArray = this.getUsedMechanismFeatures();
            bl = var1_1.isMechanismFeatureSupported(mechanismArray, mechanismInfoArray);
        }
        catch (TokenException tokenException) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public void initialize(int keysize, SecureRandom random) throws InvalidParameterException {
        void var1_1;
        Object object = IAIKPkcs11.getGlobalKeyHandler().getKeyPairGeneratorTemplate(this.getAlgorithmName(), (int)var1_1);
        object = PKCS11KeyPairGenerator.a(object);
        try {
            this.initialize((AlgorithmParameterSpec)object, null);
            return;
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidParameterException(invalidAlgorithmParameterException.toString());
        }
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        iaik.pkcs.pkcs11.objects.KeyPair keyPair;
        if (params == null || !(params instanceof PKCS11KeyPairGenerationSpec)) {
            keyPair = IAIKPkcs11.getGlobalKeyHandler().getKeyPairGeneratorTemplate(this.getAlgorithmName(), params);
            this.keyPairGenerationSpec_ = PKCS11KeyPairGenerator.a(keyPair);
        } else {
            this.keyPairGenerationSpec_ = (PKCS11KeyPairGenerationSpec)keyPair;
            PKCS11KeyPairGenerator pKCS11KeyPairGenerator = this;
            pKCS11KeyPairGenerator.validateAlgorithmParameterSpec(pKCS11KeyPairGenerator.keyPairGenerationSpec_.getAlgorithmParameterSpec());
        }
        this.tokenManager_ = this.keyPairGenerationSpec_.getTokenManager();
        this.initializePkcs11Operation();
        this.initialized_ = true;
    }

    public KeyPair generateKeyPair() {
        if (!this.initialized_) {
            this.initialize(-1, null);
        }
        Mechanism mechanism = this.getMechanism();
        PKCS11KeyPairGenerator pKCS11KeyPairGenerator = this;
        Object object = pKCS11KeyPairGenerator.createPrivateKeyCreationTemplate(pKCS11KeyPairGenerator.keyPairGenerationSpec_);
        PKCS11KeyPairGenerator pKCS11KeyPairGenerator2 = this;
        Object object2 = pKCS11KeyPairGenerator2.createPublicKeyCreationTemplate(pKCS11KeyPairGenerator2.keyPairGenerationSpec_);
        if (!this.pkcs11OperationInitialized_) {
            this.initializePkcs11Operation();
        }
        try {
            mechanism = this.session_.generateKeyPair(mechanism, (iaik.pkcs.pkcs11.objects.Object)object2, (iaik.pkcs.pkcs11.objects.Object)object);
        }
        catch (TokenException tokenException) {
            this.finalizePkcs11Operation();
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
        object = mechanism.getPrivateKey();
        mechanism = mechanism.getPublicKey();
        PKCS11KeyPairGenerator pKCS11KeyPairGenerator3 = this;
        object2 = pKCS11KeyPairGenerator3.createPkcs11PrivateKey(pKCS11KeyPairGenerator3.tokenManager_, (iaik.pkcs.pkcs11.objects.PrivateKey)object);
        if (!object.getToken().getBooleanValue().booleanValue()) {
            ((IAIKPKCS11Key)object2).setSession(this.session_);
        }
        PKCS11KeyPairGenerator pKCS11KeyPairGenerator4 = this;
        object = pKCS11KeyPairGenerator4.createPkcs11PublicKey(pKCS11KeyPairGenerator4.tokenManager_, (PublicKey)mechanism);
        if (!mechanism.getToken().getBooleanValue().booleanValue()) {
            ((IAIKPKCS11Key)object).setSession(this.session_);
        }
        this.finalizePkcs11Operation();
        this.tokenManager_.notifyKeyStores();
        return new KeyPair((java.security.PublicKey)object, (PrivateKey)object2);
    }

    protected iaik.pkcs.pkcs11.objects.Object createPrivateKeyCreationTemplate(PKCS11KeyPairGenerationSpec keyPairGenerationSpec) {
        return keyPairGenerationSpec.getPrivateKeyTemplate();
    }

    protected iaik.pkcs.pkcs11.objects.Object createPublicKeyCreationTemplate(PKCS11KeyPairGenerationSpec keyPairGenerationSpec) {
        return keyPairGenerationSpec.getPublicKeyTemplate();
    }

    /*
     * WARNING - void declaration
     */
    protected IAIKPKCS11PrivateKey createPkcs11PrivateKey(TokenManager tokenManager, iaik.pkcs.pkcs11.objects.PrivateKey privateKeyObject) {
        void var2_2;
        return IAIKPKCS11PrivateKey.create(tokenManager, (iaik.pkcs.pkcs11.objects.PrivateKey)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected IAIKPKCS11PublicKey createPkcs11PublicKey(TokenManager tokenManager, PublicKey publicKeyObject) {
        void var2_2;
        return IAIKPKCS11PublicKey.create(tokenManager, (PublicKey)var2_2);
    }

    protected void initializeSession() {
        try {
            if (this.session_ == null) {
                this.session_ = this.tokenManager_.getSession(this.keyPairGenerationSpec_.isUseRwSession());
            }
            if (this.keyPairGenerationSpec_.isUseAnonymousRole()) {
                this.tokenManager_.makeAuthorizedSession(this.session_, null);
                return;
            }
            this.tokenManager_.login(this.session_, this.keyPairGenerationSpec_.isUseSORole(), this.keyPairGenerationSpec_.getPin());
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    protected void initializePkcs11Operation() {
        this.initializeSession();
        this.pkcs11OperationInitialized_ = true;
    }

    protected void finalizePkcs11Operation() {
        this.pkcs11OperationInitialized_ = false;
        this.tokenManager_.disposeSession(this.session_);
        this.session_ = null;
    }

    protected abstract Mechanism getMechanism();

    protected abstract String getAlgorithmName();

    private static PKCS11KeyPairGenerationSpec a(iaik.pkcs.pkcs11.objects.KeyPair keyPair) {
        IAIKPkcs11 iAIKPkcs11 = IAIKPkcs11.getCurrentProviderInstance();
        if (iAIKPkcs11 == null) {
            throw new IAIKPkcs11Exception("No IAIKPkcs11 provider available.");
        }
        return (PKCS11KeyPairGenerationSpec)new PKCS11KeyPairGenerationSpec(keyPair.getPublicKey(), keyPair.getPrivateKey()).setUseUserRole(true);
    }

    protected void validateAlgorithmParameterSpec(AlgorithmParameterSpec parameters) throws InvalidAlgorithmParameterException {
        if (parameters != null) {
            throw new InvalidAlgorithmParameterException("This key-pair generator does not accept parameters.");
        }
    }

    protected void finalize() throws Throwable {
        if (this.session_ != null) {
            this.tokenManager_.disposeSession(this.session_);
        }
        super.finalize();
    }
}

