/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keypairgenerators;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.DHPrivateKey;
import iaik.pkcs.pkcs11.objects.DHPublicKey;
import iaik.pkcs.pkcs11.objects.GenericTemplate;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.provider.keypairgenerators.PKCS11KeyPairGenerationSpec;
import iaik.pkcs.pkcs11.provider.keypairgenerators.PKCS11KeyPairGenerator;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.DHParameterSpec;

public class DhKeyPairGenerator
extends PKCS11KeyPairGenerator {
    protected Mechanism getMechanism() {
        return Mechanism.get((long)32L);
    }

    protected String getAlgorithmName() {
        return "DH";
    }

    protected iaik.pkcs.pkcs11.objects.Object createPrivateKeyCreationTemplate(PKCS11KeyPairGenerationSpec keyPairGenerationSpec) {
        PrivateKey privateKey;
        AlgorithmParameterSpec algorithmParameterSpec = keyPairGenerationSpec.getAlgorithmParameterSpec();
        if (algorithmParameterSpec != null && algorithmParameterSpec instanceof DHParameterSpec) {
            algorithmParameterSpec = (DHParameterSpec)algorithmParameterSpec;
            DHPrivateKey dHPrivateKey = new DHPrivateKey();
            int n = ((DHParameterSpec)algorithmParameterSpec).getL();
            if (n > 0) {
                dHPrivateKey.getValueBits().setLongValue(new Long(n));
                privateKey = keyPairGenerationSpec.getPrivateKeyTemplate();
                GenericTemplate genericTemplate = new GenericTemplate();
                genericTemplate.addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)dHPrivateKey);
                if (privateKey != null) {
                    genericTemplate.addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)privateKey);
                }
                privateKey = genericTemplate;
            } else {
                privateKey = privateKey.getPrivateKeyTemplate();
            }
        } else {
            privateKey = privateKey.getPrivateKeyTemplate();
        }
        return privateKey;
    }

    protected iaik.pkcs.pkcs11.objects.Object createPublicKeyCreationTemplate(PKCS11KeyPairGenerationSpec keyPairGenerationSpec) {
        Object object;
        Object object2 = keyPairGenerationSpec.getAlgorithmParameterSpec();
        if (object2 != null && object2 instanceof DHParameterSpec) {
            object2 = (DHParameterSpec)object2;
            DHPublicKey dHPublicKey = new DHPublicKey();
            Object object3 = ((DHParameterSpec)object2).getP();
            object3 = Util.unsignedBigIntergerToByteArray((BigInteger)object3);
            object2 = ((DHParameterSpec)object2).getG();
            object2 = Util.unsignedBigIntergerToByteArray((BigInteger)object2);
            dHPublicKey.getPrime().setByteArrayValue((byte[])object3);
            dHPublicKey.getBase().setByteArrayValue((byte[])object2);
            object = keyPairGenerationSpec.getPublicKeyTemplate();
            object2 = new GenericTemplate();
            object2.addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)dHPublicKey);
            if (object != null) {
                object2.addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)object);
            }
            object = object2;
        } else {
            object = object.getPublicKeyTemplate();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    protected void validateAlgorithmParameterSpec(AlgorithmParameterSpec parameters) throws InvalidAlgorithmParameterException {
        if (parameters != null && !(parameters instanceof DHParameterSpec)) {
            void var1_1;
            throw new InvalidAlgorithmParameterException("This key-pair generator does not accept the given parameters. They must be null or an isntance of DHParameterSpec, but they are " + var1_1);
        }
    }
}

