/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keygenerators;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.PKCS11EngineClass;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.provider.keygenerators.PKCS11KeyGenerationSpec;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11Key;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;

public abstract class PKCS11KeyGenerator
extends KeyGeneratorSpi
implements PKCS11EngineClass {
    protected TokenManager tokenManager_;
    protected Session session_;
    protected PKCS11KeyGenerationSpec keyGenerationSpec_;
    protected boolean initialized_;
    protected boolean pkcs11OperationInitialized_;
    protected Mechanism[] usedMechanisms_;
    protected MechanismInfo[][] usedMechanismInfos_;

    protected Mechanism[] getUsedMechanisms() {
        if (this.usedMechanisms_ == null) {
            Mechanism mechanism = (Mechanism)this.getMechanism().clone();
            mechanism.setParameters(null);
            this.usedMechanisms_ = new Mechanism[]{mechanism};
        }
        return this.usedMechanisms_;
    }

    protected MechanismInfo[][] getUsedMechanismFeatures() {
        if (this.usedMechanismInfos_ == null) {
            MechanismInfo mechanismInfo = new MechanismInfo();
            mechanismInfo.setGenerate(true);
            this.usedMechanismInfos_ = new MechanismInfo[][]{{mechanismInfo}};
        }
        return this.usedMechanismInfos_;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isSupportedBy(TokenManager tokenManager) {
        boolean bl;
        try {
            void var1_1;
            Mechanism[] mechanismArray = this.getUsedMechanisms();
            MechanismInfo[][] mechanismInfoArray = this.getUsedMechanismFeatures();
            bl = var1_1.isMechanismFeatureSupported(mechanismArray, mechanismInfoArray);
        }
        catch (TokenException tokenException) {
            bl = false;
        }
        return bl;
    }

    protected javax.crypto.SecretKey engineGenerateKey() {
        if (!this.initialized_) {
            this.engineInit(-1, null);
        }
        Object object = this.getMechanism();
        SecretKey secretKey = this.keyGenerationSpec_.getKeyTemplate();
        if (!this.pkcs11OperationInitialized_) {
            this.initializePkcs11Operation();
        }
        try {
            secretKey = (SecretKey)this.session_.generateKey((Mechanism)object, (iaik.pkcs.pkcs11.objects.Object)secretKey);
        }
        catch (TokenException tokenException) {
            this.finalizePkcs11Operation();
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
        object = IAIKPKCS11SecretKey.create(this.tokenManager_, secretKey);
        if (!secretKey.getToken().getBooleanValue().booleanValue()) {
            ((IAIKPKCS11Key)object).setSession(this.session_);
        }
        this.finalizePkcs11Operation();
        this.tokenManager_.notifyKeyStores();
        return object;
    }

    /*
     * WARNING - void declaration
     */
    protected void engineInit(SecureRandom random) {
        void var1_1;
        this.engineInit(-1, (SecureRandom)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void engineInit(int strength, SecureRandom random) throws InvalidParameterException {
        void var1_1;
        IAIKPkcs11 iAIKPkcs11 = IAIKPkcs11.getCurrentProviderInstance();
        if (iAIKPkcs11 == null) {
            throw new IAIKPkcs11Exception("No IAIKPkcs11 provider available.");
        }
        Object object = IAIKPkcs11.getGlobalKeyHandler().getKeyGeneratorTemplate(this.getAlgorithmName(), (int)var1_1);
        object = (AlgorithmParameterSpec)((Object)new PKCS11KeyGenerationSpec((SecretKey)object).setUseUserRole(false));
        try {
            this.engineInit((AlgorithmParameterSpec)object, null);
            return;
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new IAIKPkcs11Exception(invalidAlgorithmParameterException.toString());
        }
    }

    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        SecretKey secretKey;
        if (params == null || !(params instanceof PKCS11KeyGenerationSpec)) {
            IAIKPkcs11.getCurrentProviderInstance();
            secretKey = IAIKPkcs11.getGlobalKeyHandler().getKeyGeneratorTemplate(this.getAlgorithmName(), params);
            this.keyGenerationSpec_ = (PKCS11KeyGenerationSpec)new PKCS11KeyGenerationSpec(secretKey).setUseUserRole(false);
        } else {
            this.keyGenerationSpec_ = (PKCS11KeyGenerationSpec)secretKey;
        }
        this.tokenManager_ = this.keyGenerationSpec_.getTokenManager();
        this.initializePkcs11Operation();
        this.initialized_ = true;
    }

    protected void initializeSession() {
        try {
            if (this.session_ == null) {
                this.session_ = this.tokenManager_.getSession(this.keyGenerationSpec_.isUseRwSession());
            }
            if (this.keyGenerationSpec_.isUseAnonymousRole()) {
                this.tokenManager_.makeAuthorizedSession(this.session_, null);
                return;
            }
            this.tokenManager_.login(this.session_, this.keyGenerationSpec_.isUseSORole(), this.keyGenerationSpec_.getPin());
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    protected void initializePkcs11Operation() {
        this.initializeSession();
        this.pkcs11OperationInitialized_ = true;
    }

    protected void finalizePkcs11Operation() {
        this.pkcs11OperationInitialized_ = false;
        this.tokenManager_.disposeSession(this.session_);
        this.session_ = null;
    }

    protected abstract Mechanism getMechanism();

    protected abstract String getAlgorithmName();

    protected void finalize() throws Throwable {
        if (this.session_ != null) {
            this.tokenManager_.disposeSession(this.session_);
        }
        super.finalize();
    }
}

