/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keygenerators;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.keygenerators.PKCS11KeyDerivationSpec;
import iaik.pkcs.pkcs11.provider.keygenerators.PKCS11KeyGenerationSpec;
import iaik.pkcs.pkcs11.provider.keygenerators.PKCS11KeyGenerator;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11Key;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public abstract class PKCS11KeyDerivation
extends PKCS11KeyGenerator {
    protected Mechanism keyDerivationMechanism_;

    protected MechanismInfo[][] getUsedMechanismFeatures() {
        if (this.usedMechanismInfos_ == null) {
            MechanismInfo mechanismInfo = new MechanismInfo();
            mechanismInfo.setDerive(true);
            this.usedMechanismInfos_ = new MechanismInfo[][]{{mechanismInfo}};
        }
        return this.usedMechanismInfos_;
    }

    protected javax.crypto.SecretKey engineGenerateKey() {
        if (!this.initialized_) {
            throw new IllegalStateException("Key generator (derivator) not initialized!");
        }
        this.keyDerivationMechanism_.setParameters(this.getParameters());
        Object object = (PKCS11KeyDerivationSpec)this.keyGenerationSpec_;
        SecretKey secretKey = ((PKCS11KeyDerivationSpec)object).getBaseKey();
        object = ((PKCS11KeyGenerationSpec)object).getKeyTemplate();
        if (!this.pkcs11OperationInitialized_) {
            this.initializePkcs11Operation();
        }
        try {
            secretKey = (SecretKey)this.session_.deriveKey(this.keyDerivationMechanism_, (Key)secretKey, (Key)object);
        }
        catch (TokenException tokenException) {
            this.finalizePkcs11Operation();
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
        object = IAIKPKCS11SecretKey.create(this.tokenManager_, secretKey);
        if (!secretKey.getToken().getBooleanValue().booleanValue()) {
            ((IAIKPKCS11Key)object).setSession(this.session_);
        }
        this.finalizePkcs11Operation();
        this.tokenManager_.notifyKeyStores();
        return object;
    }

    protected void engineInit(SecureRandom random) {
        throw new UnsupportedOperationException("This method is not supported. Use engineInit(AlgorithmParameterSpec, SecureRandom) instead.");
    }

    protected void engineInit(int strength, SecureRandom random) {
        throw new UnsupportedOperationException("This method is not supported. Use engineInit(AlgorithmParameterSpec, SecureRandom) instead.");
    }

    /*
     * WARNING - void declaration
     */
    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        void var2_2;
        void var1_1;
        if (params == null || !(params instanceof PKCS11KeyDerivationSpec)) {
            throw new InvalidAlgorithmParameterException("params must be null or instance of PKCS11KeyDerivationSpec");
        }
        this.keyDerivationMechanism_ = this.getMechanism();
        super.engineInit((AlgorithmParameterSpec)var1_1, (SecureRandom)var2_2);
    }

    protected Parameters getParameters() {
        return null;
    }
}

