/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keyfactories;

import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.GenericTemplate;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.NonExtractableComponentException;
import iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec;
import iaik.pkcs.pkcs11.provider.keyfactories.PKCS11SecretKeyFactory;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11Key;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey;
import iaik.pkcs.pkcs11.provider.spec.PKCS11Spec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public abstract class SecretKeyFactory
extends PKCS11SecretKeyFactory {
    private static Class a;
    private static Class b;

    protected abstract iaik.pkcs.pkcs11.objects.Object createKeyCreationTemplate(KeySpec var1) throws InvalidKeySpecException;

    protected SecretKey pkcs11GenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        KeySpec keySpec2;
        if (keySpec == null) {
            throw new NullPointerException("Argument \"keySpec\" must not be null.");
        }
        if (!(keySpec instanceof PKCS11KeySpec)) {
            throw new IllegalArgumentException("Argument \"keySpec\" must be of instance iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec.");
        }
        this.pkcs11KeySpec_ = (PKCS11KeySpec)keySpec2;
        keySpec2 = this.pkcs11KeySpec_.getKeySpec();
        keySpec2 = this.createKeyCreationTemplate(keySpec2);
        GenericTemplate genericTemplate = new GenericTemplate();
        iaik.pkcs.pkcs11.objects.Object object = this.pkcs11KeySpec_.getKeyTemplate();
        if (object != null) {
            genericTemplate.addAllPresentAttributes(object);
        }
        genericTemplate.addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)keySpec2);
        return (SecretKey)this.createKey((iaik.pkcs.pkcs11.objects.Object)genericTemplate);
    }

    protected KeySpec pkcs11GetKeySpec(SecretKey key, Class keySpecClass) throws InvalidKeySpecException {
        KeySpec keySpec;
        Object object;
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        if (keySpecClass == null) {
            throw new NullPointerException("Argument \"keySpecClass\" must not be null.");
        }
        if (!(key instanceof IAIKPKCS11SecretKey)) {
            throw new InvalidKeySpecException("For this factory, the key must be a IAIKPKCS11SecretKey.");
        }
        object = (IAIKPKCS11SecretKey)object;
        object = ((IAIKPKCS11Key)object).getKeyObject();
        byte[] byArray = this.extractKeyMaterial((Key)object);
        if (keySpecClass.equals(a == null ? (a = SecretKeyFactory.a("javax.crypto.spec.SecretKeySpec")) : a)) {
            object = new SecretKeySpec(byArray, this.getAlgorithmName());
        } else if (keySpec.equals(b == null ? (b = SecretKeyFactory.a("iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec")) : b)) {
            keySpec = new SecretKeySpec(byArray, this.getAlgorithmName());
            boolean bl = object.getPrivate().getBooleanValue();
            keySpec = new PKCS11KeySpec(keySpec, null);
            if (bl) {
                ((PKCS11Spec)keySpec).setUseUserRole(true);
            }
            object = keySpec;
        } else {
            throw new InvalidKeySpecException("The given key spec class is invalid. It must be of SecretKeySpec.");
        }
        return object;
    }

    protected byte[] extractKeyMaterial(Key value) throws InvalidKeySpecException, NonExtractableComponentException, IAIKPkcs11Exception {
        Object object = value.getAttributeTable();
        if (!(object = (ByteArrayAttribute)object.get(Attribute.VALUE)).isStateKnown()) {
            throw new NonExtractableComponentException("The PKCS#11 key object's value attribute is either not present or sensitive.");
        }
        if (!object.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 key object does not possess a value attribute.");
        }
        if (object.isSensitive()) {
            throw new NonExtractableComponentException("The PKCS#11 key object's value attribute is sensitive.");
        }
        byte[] byArray = object.getByteArrayValue();
        object = byArray;
        return byArray;
    }

    protected String getSoftwareDelegateAlgorithm() {
        return this.getAlgorithmName();
    }

    protected abstract boolean isAlgorithmAccepted(String var1);

    protected boolean isFormatAccepted(String formatName) {
        return true;
    }

    protected void validateKeySpec(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec == null) {
            throw new NullPointerException("Argument \"keySpec\" must not be null.");
        }
        if (keySpec instanceof SecretKeySpec) {
            Object object;
            String string = ((SecretKeySpec)(object = (SecretKeySpec)object)).getAlgorithm();
            if (!this.isAlgorithmAccepted(string)) {
                throw new InvalidKeySpecException("The algorithm of the given spec is unsupported: " + string);
            }
            if (!this.isFormatAccepted((String)(object = ((SecretKeySpec)object).getAlgorithm()))) {
                throw new InvalidKeySpecException("The format of the key encoding of the given spec is unsupported: " + (String)object);
            }
            return;
        }
        throw new InvalidKeySpecException("The key spec must be of type javax.crypto.spec.SecretKeySpec.");
    }

    private static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

