/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keyfactories;

import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.GenericTemplate;
import iaik.pkcs.pkcs11.objects.RSAPrivateKey;
import iaik.pkcs.pkcs11.objects.RSAPublicKey;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.NonExtractableComponentException;
import iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeyFactory;
import iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PrivateKey;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PublicKey;
import java.math.BigInteger;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class RsaKeyFactory
extends PKCS11KeyFactory {
    public static final int PKCS1_VERSION = 0;
    protected static String KEY_FACTORY_ALGORITHM_NAME = "RSA";
    private static Class a;
    private static Class b;
    private static Class c;
    private static Class d;
    private static Class e;

    protected String getSoftwareDelegateAlgorithm() {
        return KEY_FACTORY_ALGORITHM_NAME;
    }

    protected String getAlgorithmName() {
        return KEY_FACTORY_ALGORITHM_NAME;
    }

    protected PublicKey pkcs11GeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        Object object;
        Object object2;
        Object object3;
        if (keySpec == null) {
            throw new NullPointerException("Argument \"keySpec\" must not be null.");
        }
        if (!(keySpec instanceof PKCS11KeySpec)) {
            throw new IllegalArgumentException("Argument \"keySpec\" must be of instance iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec.");
        }
        this.pkcs11KeySpec_ = (PKCS11KeySpec)object3;
        object3 = this.pkcs11KeySpec_.getKeySpec();
        if (object3 instanceof RSAPublicKeySpec) {
            object2 = (RSAPublicKeySpec)object3;
            object3 = Util.unsignedBigIntergerToByteArray((BigInteger)((RSAPublicKeySpec)object2).getModulus());
            object = Util.unsignedBigIntergerToByteArray((BigInteger)((RSAPublicKeySpec)object2).getPublicExponent());
        } else if (object3 instanceof X509EncodedKeySpec) {
            object2 = (X509EncodedKeySpec)object3;
            object3 = ((X509EncodedKeySpec)object2).getEncoded();
            try {
                object3 = new ASN1((byte[])object3);
                object3 = (byte[])object3.getComponentAt(1).getValue();
                object3 = new ASN1((byte[])object3);
                object = (BigInteger)object3.getComponentAt(0).getValue();
                object2 = (BigInteger)object3.getComponentAt(1).getValue();
            }
            catch (CodingException codingException) {
                throw new InvalidKeySpecException("The public key spec could not be parsed: " + codingException.toString());
            }
            object3 = Util.unsignedBigIntergerToByteArray((BigInteger)object);
            object = Util.unsignedBigIntergerToByteArray((BigInteger)object2);
        } else {
            throw new InvalidKeySpecException("The actual key spec inside the given PKCS11KeySpec must be of type java.security.spec.RSAPublicKeySpec.");
        }
        object2 = new RSAPublicKey();
        object2.getModulus().setByteArrayValue((byte[])object3);
        object2.getPublicExponent().setByteArrayValue(object);
        object3 = new GenericTemplate();
        object3.addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)object2);
        iaik.pkcs.pkcs11.objects.Object object4 = this.pkcs11KeySpec_.getKeyTemplate();
        object = object4;
        if (object4 != null) {
            object3.addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)object);
        }
        return (PublicKey)this.createKey((iaik.pkcs.pkcs11.objects.Object)object3);
    }

    protected PrivateKey pkcs11GeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        KeySpec keySpec2;
        Object object9;
        if (keySpec == null) {
            throw new NullPointerException("Argument \"keySpec\" must not be null.");
        }
        if (!(keySpec instanceof PKCS11KeySpec)) {
            throw new IllegalArgumentException("Argument \"keySpec\" must be of instance iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec.");
        }
        this.pkcs11KeySpec_ = (PKCS11KeySpec)object9;
        object9 = this.pkcs11KeySpec_.getKeySpec();
        if (object9 instanceof RSAPrivateKeySpec) {
            if (object9 instanceof RSAPrivateCrtKeySpec) {
                keySpec2 = (RSAPrivateCrtKeySpec)object9;
                object9 = Util.unsignedBigIntergerToByteArray((BigInteger)((RSAPrivateKeySpec)keySpec2).getModulus());
                object8 = Util.unsignedBigIntergerToByteArray((BigInteger)((RSAPrivateKeySpec)keySpec2).getPrivateExponent());
                object7 = Util.unsignedBigIntergerToByteArray((BigInteger)((RSAPrivateCrtKeySpec)keySpec2).getPublicExponent());
                object6 = Util.unsignedBigIntergerToByteArray((BigInteger)((RSAPrivateCrtKeySpec)keySpec2).getPrimeP());
                object5 = Util.unsignedBigIntergerToByteArray((BigInteger)((RSAPrivateCrtKeySpec)keySpec2).getPrimeQ());
                object4 = Util.unsignedBigIntergerToByteArray((BigInteger)((RSAPrivateCrtKeySpec)keySpec2).getPrimeExponentP());
                object3 = Util.unsignedBigIntergerToByteArray((BigInteger)((RSAPrivateCrtKeySpec)keySpec2).getPrimeExponentQ());
                object2 = Util.unsignedBigIntergerToByteArray((BigInteger)((RSAPrivateCrtKeySpec)keySpec2).getCrtCoefficient());
            } else {
                keySpec2 = (RSAPrivateKeySpec)object9;
                object9 = Util.unsignedBigIntergerToByteArray((BigInteger)((RSAPrivateKeySpec)keySpec2).getModulus());
                object8 = Util.unsignedBigIntergerToByteArray((BigInteger)((RSAPrivateKeySpec)keySpec2).getPrivateExponent());
                object7 = null;
                object6 = null;
                object5 = null;
                object4 = null;
                object3 = null;
                object2 = null;
            }
        } else if (object9 instanceof PKCS8EncodedKeySpec) {
            keySpec2 = (PKCS8EncodedKeySpec)object9;
            object = ((PKCS8EncodedKeySpec)keySpec2).getEncoded();
            try {
                object9 = new ASN1(object);
                object9 = (byte[])object9.getComponentAt(2).getValue();
                object2 = new ASN1((byte[])object9);
                object9 = (BigInteger)object2.getComponentAt(1).getValue();
                object7 = (BigInteger)object2.getComponentAt(2).getValue();
                object8 = (BigInteger)object2.getComponentAt(3).getValue();
                object6 = (BigInteger)object2.getComponentAt(4).getValue();
                object5 = (BigInteger)object2.getComponentAt(5).getValue();
                object4 = (BigInteger)object2.getComponentAt(6).getValue();
                object3 = (BigInteger)object2.getComponentAt(7).getValue();
                object2 = (BigInteger)object2.getComponentAt(8).getValue();
            }
            catch (CodingException codingException) {
                throw new InvalidKeySpecException("The private key spec could not be parsed: " + codingException.toString());
            }
            object9 = Util.unsignedBigIntergerToByteArray((BigInteger)object9);
            object8 = Util.unsignedBigIntergerToByteArray((BigInteger)object8);
            object7 = Util.unsignedBigIntergerToByteArray((BigInteger)object7);
            object6 = Util.unsignedBigIntergerToByteArray((BigInteger)object6);
            object5 = Util.unsignedBigIntergerToByteArray((BigInteger)object5);
            object4 = Util.unsignedBigIntergerToByteArray((BigInteger)object4);
            object3 = Util.unsignedBigIntergerToByteArray((BigInteger)object3);
            object2 = Util.unsignedBigIntergerToByteArray((BigInteger)object2);
        } else {
            throw new InvalidKeySpecException("The actual key spec inside the given PKCS11KeySpec must be of type java.security.spec.RSAPrivateKeySpec.");
        }
        keySpec2 = new GenericTemplate();
        RSAPrivateKey rSAPrivateKey = new RSAPrivateKey();
        object = rSAPrivateKey;
        rSAPrivateKey.getModulus().setByteArrayValue((byte[])object9);
        object.getPrivateExponent().setByteArrayValue(object8);
        if (object7 != null) {
            object.getPublicExponent().setByteArrayValue(object7);
        }
        if (object6 != null && object5 != null && object4 != null && object3 != null && object2 != null) {
            object.getPrime1().setByteArrayValue(object6);
            object.getPrime2().setByteArrayValue(object5);
            object.getExponent1().setByteArrayValue(object4);
            object.getExponent2().setByteArrayValue(object3);
            object.getCoefficient().setByteArrayValue((byte[])object2);
        }
        keySpec2.addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)object);
        object9 = this.pkcs11KeySpec_.getKeyTemplate();
        if (object9 != null) {
            keySpec2.addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)object9);
        }
        return (PrivateKey)this.createKey((iaik.pkcs.pkcs11.objects.Object)keySpec2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected KeySpec pkcs11GetKeySpec(Key key2, Class keySpecClass) throws InvalidKeySpecException {
        byte[] byArray;
        void var1_1;
        void var2_31;
        void var1_30;
        if (key2 == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        if (keySpecClass == null) {
            throw new NullPointerException("Argument \"keySpecClass\" must not be null.");
        }
        if (keySpecClass.equals(a == null ? (a = RsaKeyFactory.a("java.security.spec.RSAPublicKeySpec")) : a)) {
            if (!(key2 instanceof IAIKPKCS11PublicKey)) throw new InvalidKeySpecException("For this factory, the key must be a IAIKPKCS11PublicKey to get a RSAPublicKeySpec.");
            IAIKPKCS11PublicKey key2 = (IAIKPKCS11PublicKey)key2;
            iaik.pkcs.pkcs11.objects.Key key3 = key2.getKeyObject();
            if (!(key3 instanceof RSAPublicKey)) throw new InvalidKeySpecException("This factory does only accept RSA keys, but the PKCS#11 key object in the given key is: " + key3);
            RSAPublicKey rSAPublicKey = (RSAPublicKey)key3;
            this.verifyPublicKeyExtractable(rSAPublicKey);
            ByteArrayAttribute byteArrayAttribute = rSAPublicKey.getModulus();
            ByteArrayAttribute byteArrayAttribute2 = rSAPublicKey.getPublicExponent();
            byte[] byArray2 = byteArrayAttribute.getByteArrayValue();
            byte[] byArray3 = byteArrayAttribute2.getByteArrayValue();
            RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(new BigInteger(1, byArray2), new BigInteger(1, byArray3));
            return var1_30;
        }
        if (var2_31.equals(b == null ? (b = RsaKeyFactory.a("java.security.spec.RSAPrivateKeySpec")) : b)) {
            if (!(var1_1 instanceof IAIKPKCS11PrivateKey)) throw new InvalidKeySpecException("For this factory, the key must be a IAIKPKCS11PrivateKey to get a RSAPrivateKeySpec.");
            IAIKPKCS11PrivateKey iAIKPKCS11PrivateKey = (IAIKPKCS11PrivateKey)var1_1;
            iaik.pkcs.pkcs11.objects.Key key4 = iAIKPKCS11PrivateKey.getKeyObject();
            if (!(key4 instanceof RSAPrivateKey)) throw new InvalidKeySpecException("This factory does only accept RSA keys, but the PKCS#11 key object in the given key is: " + key4);
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)key4;
            this.verifyPrivateKeyExtractable(rSAPrivateKey);
            ByteArrayAttribute byteArrayAttribute = rSAPrivateKey.getModulus();
            ByteArrayAttribute byteArrayAttribute3 = rSAPrivateKey.getPrivateExponent();
            byte[] byArray4 = byteArrayAttribute.getByteArrayValue();
            byte[] byArray5 = byteArrayAttribute3.getByteArrayValue();
            RSAPrivateKeySpec rSAPrivateKeySpec = new RSAPrivateKeySpec(new BigInteger(1, byArray4), new BigInteger(1, byArray5));
            return var1_30;
        }
        if (var2_31.equals(c == null ? (c = RsaKeyFactory.a("java.security.spec.RSAPrivateCrtKeySpec")) : c)) {
            if (!(var1_1 instanceof IAIKPKCS11PrivateKey)) throw new InvalidKeySpecException("For this factory, the key must be a IAIKPKCS11PrivateKey to get a RSAPrivateCrtKeySpec.");
            IAIKPKCS11PrivateKey iAIKPKCS11PrivateKey = (IAIKPKCS11PrivateKey)var1_1;
            iaik.pkcs.pkcs11.objects.Key key5 = iAIKPKCS11PrivateKey.getKeyObject();
            if (!(key5 instanceof RSAPrivateKey)) throw new InvalidKeySpecException("This factory does only accept RSA keys, but the PKCS#11 key object in the given key is: " + key5);
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)key5;
            this.verifyPrivateCRTKeyExtractable(rSAPrivateKey);
            ByteArrayAttribute byteArrayAttribute = rSAPrivateKey.getModulus();
            ByteArrayAttribute byteArrayAttribute4 = rSAPrivateKey.getPrivateExponent();
            ByteArrayAttribute byteArrayAttribute5 = rSAPrivateKey.getPublicExponent();
            ByteArrayAttribute byteArrayAttribute6 = rSAPrivateKey.getPrime1();
            ByteArrayAttribute byteArrayAttribute7 = rSAPrivateKey.getPrime2();
            ByteArrayAttribute byteArrayAttribute8 = rSAPrivateKey.getExponent1();
            ByteArrayAttribute byteArrayAttribute9 = rSAPrivateKey.getExponent2();
            ByteArrayAttribute byteArrayAttribute10 = rSAPrivateKey.getCoefficient();
            byte[] byArray6 = byteArrayAttribute.getByteArrayValue();
            byte[] byArray7 = byteArrayAttribute4.getByteArrayValue();
            byte[] byArray8 = byteArrayAttribute5.getByteArrayValue();
            byte[] byArray9 = byteArrayAttribute6.getByteArrayValue();
            byte[] byArray10 = byteArrayAttribute7.getByteArrayValue();
            byte[] byArray11 = byteArrayAttribute8.getByteArrayValue();
            byte[] byArray12 = byteArrayAttribute9.getByteArrayValue();
            byte[] byArray13 = byteArrayAttribute10.getByteArrayValue();
            RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = new RSAPrivateCrtKeySpec(new BigInteger(1, byArray6), new BigInteger(1, byArray8), new BigInteger(1, byArray7), new BigInteger(1, byArray9), new BigInteger(1, byArray10), new BigInteger(1, byArray11), new BigInteger(1, byArray12), new BigInteger(1, byArray13));
            return var1_30;
        }
        if (var2_31.equals(d == null ? (d = RsaKeyFactory.a("java.security.spec.X509EncodedKeySpec")) : d)) {
            byte[] byArray14;
            if (!(var1_1 instanceof IAIKPKCS11PublicKey)) throw new InvalidKeySpecException("For this factory, the key must be a IAIKPKCS11PublicKey to get a X509EncodedKeySpec.");
            IAIKPKCS11PublicKey iAIKPKCS11PublicKey = (IAIKPKCS11PublicKey)var1_1;
            iaik.pkcs.pkcs11.objects.Key key6 = iAIKPKCS11PublicKey.getKeyObject();
            if (!(key6 instanceof RSAPublicKey)) throw new InvalidKeySpecException("This factory does only accept RSA keys, but the PKCS#11 key object in the given key is: " + key6);
            RSAPublicKey rSAPublicKey = (RSAPublicKey)key6;
            this.verifyPublicKeyExtractable(rSAPublicKey);
            ByteArrayAttribute byteArrayAttribute = rSAPublicKey.getModulus();
            ByteArrayAttribute byteArrayAttribute11 = rSAPublicKey.getPublicExponent();
            byte[] byArray15 = byteArrayAttribute.getByteArrayValue();
            byte[] byArray16 = byteArrayAttribute11.getByteArrayValue();
            try {
                AlgorithmID algorithmID = (AlgorithmID)AlgorithmID.rsaEncryption.clone();
                SEQUENCE sEQUENCE = new SEQUENCE();
                sEQUENCE.addComponent((ASN1Object)new INTEGER(new BigInteger(1, byArray15)));
                sEQUENCE.addComponent((ASN1Object)new INTEGER(new BigInteger(1, byArray16)));
                ASN1 aSN1 = new ASN1((ASN1Object)sEQUENCE);
                byte[] byArray17 = aSN1.toByteArray();
                SEQUENCE sEQUENCE2 = new SEQUENCE();
                sEQUENCE2.addComponent(algorithmID.toASN1Object());
                sEQUENCE2.addComponent((ASN1Object)new BIT_STRING(byArray17));
                byArray14 = DerCoder.encode((ASN1Object)sEQUENCE2);
            }
            catch (CodingException codingException) {
                throw new InvalidKeySpecException("Error during encoding of RSA public key: " + codingException.toString());
            }
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray14);
            return var1_30;
        }
        if (!var2_31.equals(e == null ? (e = RsaKeyFactory.a("java.security.spec.PKCS8EncodedKeySpec")) : e)) throw new InvalidKeySpecException("The given key spec class is invalid. It must be of either RSAPublicKeySpec, X509EncodedKeySpec, RSAPrivateKeySpec, RSAPrivateCrtKeySpec or PKCS8EncodedKeySpec.");
        if (!(var1_1 instanceof IAIKPKCS11PrivateKey)) throw new InvalidKeySpecException("For this factory, the key must be a IAIKPKCS11PrivateKey to get a PKCS8EncodedKeySpec.");
        IAIKPKCS11PrivateKey iAIKPKCS11PrivateKey = (IAIKPKCS11PrivateKey)var1_1;
        iaik.pkcs.pkcs11.objects.Key key7 = iAIKPKCS11PrivateKey.getKeyObject();
        if (!(key7 instanceof RSAPrivateKey)) throw new InvalidKeySpecException("This factory does only accept RSA keys, but the PKCS#11 key object in the given key is: " + key7);
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)key7;
        this.verifyPrivateCRTKeyExtractable(rSAPrivateKey);
        ByteArrayAttribute byteArrayAttribute = rSAPrivateKey.getModulus();
        ByteArrayAttribute byteArrayAttribute12 = rSAPrivateKey.getPrivateExponent();
        ByteArrayAttribute byteArrayAttribute13 = rSAPrivateKey.getPublicExponent();
        ByteArrayAttribute byteArrayAttribute14 = rSAPrivateKey.getPrime1();
        ByteArrayAttribute byteArrayAttribute15 = rSAPrivateKey.getPrime2();
        ByteArrayAttribute byteArrayAttribute16 = rSAPrivateKey.getExponent1();
        ByteArrayAttribute byteArrayAttribute17 = rSAPrivateKey.getExponent2();
        ByteArrayAttribute byteArrayAttribute18 = rSAPrivateKey.getCoefficient();
        byte[] byArray18 = byteArrayAttribute.getByteArrayValue();
        byte[] byArray19 = byteArrayAttribute12.getByteArrayValue();
        byte[] byArray20 = byteArrayAttribute13.getByteArrayValue();
        byte[] byArray21 = byteArrayAttribute14.getByteArrayValue();
        byte[] byArray22 = byteArrayAttribute15.getByteArrayValue();
        byte[] byArray23 = byteArrayAttribute16.getByteArrayValue();
        byte[] byArray24 = byteArrayAttribute17.getByteArrayValue();
        byte[] byArray25 = byteArrayAttribute18.getByteArrayValue();
        try {
            AlgorithmID algorithmID = (AlgorithmID)AlgorithmID.rsaEncryption.clone();
            SEQUENCE sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent((ASN1Object)new INTEGER(0));
            sEQUENCE.addComponent((ASN1Object)new INTEGER(new BigInteger(1, byArray18)));
            sEQUENCE.addComponent((ASN1Object)new INTEGER(new BigInteger(1, byArray20)));
            sEQUENCE.addComponent((ASN1Object)new INTEGER(new BigInteger(1, byArray19)));
            sEQUENCE.addComponent((ASN1Object)new INTEGER(new BigInteger(1, byArray21)));
            sEQUENCE.addComponent((ASN1Object)new INTEGER(new BigInteger(1, byArray22)));
            sEQUENCE.addComponent((ASN1Object)new INTEGER(new BigInteger(1, byArray23)));
            sEQUENCE.addComponent((ASN1Object)new INTEGER(new BigInteger(1, byArray24)));
            sEQUENCE.addComponent((ASN1Object)new INTEGER(new BigInteger(1, byArray25)));
            ASN1 aSN1 = new ASN1((ASN1Object)sEQUENCE);
            byte[] byArray26 = aSN1.toByteArray();
            SEQUENCE sEQUENCE3 = new SEQUENCE();
            sEQUENCE3.addComponent((ASN1Object)new INTEGER(0));
            sEQUENCE3.addComponent(algorithmID.toASN1Object());
            sEQUENCE3.addComponent((ASN1Object)new OCTET_STRING(byArray26));
            byArray = DerCoder.encode((ASN1Object)sEQUENCE3);
        }
        catch (CodingException codingException) {
            throw new InvalidKeySpecException("Error during encoding of RSA private key: " + codingException.toString());
        }
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
        return var1_30;
    }

    protected void verifyPublicKeyExtractable(RSAPublicKey key) throws NonExtractableComponentException, IAIKPkcs11Exception {
        ByteArrayAttribute byteArrayAttribute;
        ByteArrayAttribute byteArrayAttribute2 = key.getModulus();
        byteArrayAttribute = byteArrayAttribute.getPublicExponent();
        if (!byteArrayAttribute2.isStateKnown()) {
            throw new NonExtractableComponentException("The PKCS#11 RSA key object's modulus attribute is either not present or sensitive.");
        }
        if (!byteArrayAttribute.isStateKnown()) {
            throw new NonExtractableComponentException("The PKCS#11 RSA key object's public exponent attribute is either not present or sensitive.");
        }
        if (!byteArrayAttribute2.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 RSA key object does not possess a modulus attribute.");
        }
        if (!byteArrayAttribute.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 RSA key object does not possess a public exponent attribute.");
        }
        if (byteArrayAttribute2.isSensitive()) {
            throw new NonExtractableComponentException("The PKCS#11 RSA key object's modulus attribute is sensitive.");
        }
        if (byteArrayAttribute.isSensitive()) {
            throw new NonExtractableComponentException("The PKCS#11 RSA key object's public exponent attribute is sensitive.");
        }
    }

    protected void verifyPrivateKeyExtractable(RSAPrivateKey key) throws NonExtractableComponentException, IAIKPkcs11Exception {
        ByteArrayAttribute byteArrayAttribute;
        ByteArrayAttribute byteArrayAttribute2 = key.getModulus();
        byteArrayAttribute = byteArrayAttribute.getPrivateExponent();
        if (!byteArrayAttribute2.isStateKnown()) {
            throw new NonExtractableComponentException("The PKCS#11 RSA key object's modulus attribute is either not present or sensitive.");
        }
        if (!byteArrayAttribute.isStateKnown()) {
            throw new NonExtractableComponentException("The PKCS#11 RSA key object's private exponent attribute is either not present or sensitive.");
        }
        if (!byteArrayAttribute2.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 RSA key object does not possess a modulus attribute.");
        }
        if (!byteArrayAttribute.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 RSA key object does not possess a private exponent attribute.");
        }
        if (byteArrayAttribute2.isSensitive()) {
            throw new NonExtractableComponentException("The PKCS#11 RSA key object's modulus attribute is sensitive.");
        }
        if (byteArrayAttribute.isSensitive()) {
            throw new NonExtractableComponentException("The PKCS#11 RSA key object's private exponent attribute is sensitive.");
        }
    }

    protected void verifyPrivateCRTKeyExtractable(RSAPrivateKey key) throws NonExtractableComponentException, IAIKPkcs11Exception {
        ByteArrayAttribute byteArrayAttribute;
        ByteArrayAttribute byteArrayAttribute2 = key.getModulus();
        ByteArrayAttribute byteArrayAttribute3 = key.getPrivateExponent();
        ByteArrayAttribute byteArrayAttribute4 = key.getPublicExponent();
        ByteArrayAttribute byteArrayAttribute5 = key.getPrime1();
        ByteArrayAttribute byteArrayAttribute6 = key.getPrime2();
        ByteArrayAttribute byteArrayAttribute7 = key.getExponent1();
        ByteArrayAttribute byteArrayAttribute8 = key.getExponent2();
        byteArrayAttribute = byteArrayAttribute.getCoefficient();
        if (!byteArrayAttribute2.isStateKnown()) {
            throw new NonExtractableComponentException("The PKCS#11 RSA key object's modulus attribute is either not present or sensitive.");
        }
        if (!byteArrayAttribute3.isStateKnown()) {
            throw new NonExtractableComponentException("The PKCS#11 RSA key object's private exponent attribute is either not present or sensitive.");
        }
        if (!byteArrayAttribute4.isStateKnown()) {
            throw new NonExtractableComponentException("The PKCS#11 RSA key object's public exponent attribute is either not present or sensitive.");
        }
        if (!byteArrayAttribute5.isStateKnown()) {
            throw new NonExtractableComponentException("The PKCS#11 RSA key object's prime 1 attribute is either not present or sensitive.");
        }
        if (!byteArrayAttribute6.isStateKnown()) {
            throw new NonExtractableComponentException("The PKCS#11 RSA key object's prime 2 attribute is either not present or sensitive.");
        }
        if (!byteArrayAttribute7.isStateKnown()) {
            throw new NonExtractableComponentException("The PKCS#11 RSA key object's exponent 1 attribute is either not present or sensitive.");
        }
        if (!byteArrayAttribute7.isStateKnown()) {
            throw new NonExtractableComponentException("The PKCS#11 RSA key object's exponent 2 attribute is either not present or sensitive.");
        }
        if (!byteArrayAttribute.isStateKnown()) {
            throw new NonExtractableComponentException("The PKCS#11 RSA key object's CRT coefficent attribute is either not present or sensitive.");
        }
        if (!byteArrayAttribute2.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 RSA key object does not possess a modulus attribute.");
        }
        if (!byteArrayAttribute3.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 RSA key object does not possess a private exponent attribute.");
        }
        if (!byteArrayAttribute4.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 RSA key object does not possess a public exponent attribute.");
        }
        if (!byteArrayAttribute5.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 RSA key object does not possess a prime 1 attribute.");
        }
        if (!byteArrayAttribute6.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 RSA key object does not possess a prime 2 attribute.");
        }
        if (!byteArrayAttribute7.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 RSA key object does not possess a exponent 1 attribute.");
        }
        if (!byteArrayAttribute8.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 RSA key object does not possess a exponent 2 attribute.");
        }
        if (!byteArrayAttribute.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 RSA key object does not possess a CRT coefficent attribute.");
        }
        if (byteArrayAttribute2.isSensitive()) {
            throw new NonExtractableComponentException("The PKCS#11 RSA key object's modulus attribute is sensitive.");
        }
        if (byteArrayAttribute3.isSensitive()) {
            throw new NonExtractableComponentException("The PKCS#11 RSA key object's private exponent attribute is sensitive.");
        }
        if (byteArrayAttribute4.isSensitive()) {
            throw new NonExtractableComponentException("The PKCS#11 RSA key object's public exponent attribute is sensitive.");
        }
        if (byteArrayAttribute5.isSensitive()) {
            throw new NonExtractableComponentException("The PKCS#11 RSA key object's prime 1 attribute is sensitive.");
        }
        if (byteArrayAttribute6.isSensitive()) {
            throw new NonExtractableComponentException("The PKCS#11 RSA key object's prime 2 attribute is sensitive.");
        }
        if (byteArrayAttribute7.isSensitive()) {
            throw new NonExtractableComponentException("The PKCS#11 RSA key object's exponent 1 attribute is sensitive.");
        }
        if (byteArrayAttribute7.isSensitive()) {
            throw new NonExtractableComponentException("The PKCS#11 RSA key object's exponent 2 attribute is sensitive.");
        }
        if (byteArrayAttribute.isSensitive()) {
            throw new NonExtractableComponentException("The PKCS#11 RSA key object's CRT coefficent attribute is sensitive.");
        }
    }

    private static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

