/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keyfactories;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.SessionInfo;
import iaik.pkcs.pkcs11.State;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.provider.DelegateProvider;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.PKCS11EngineClass;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11Key;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;

public abstract class PKCS11KeyFactory
extends KeyFactorySpi
implements PKCS11EngineClass {
    public static final int PKCS8_VERSION = 0;
    protected TokenManager tokenManager_;
    protected Session session_;
    protected boolean pkcs11OperationInitialized_;
    protected PKCS11KeySpec pkcs11KeySpec_;
    protected KeyFactory softwareDelegate_;

    public boolean isSupportedBy(TokenManager tokenManager) {
        return true;
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        PublicKey publicKey;
        keySpec = IAIKPkcs11.getGlobalKeyHandler().handleKeyFactoryGeneratePublic(this.getAlgorithmName(), keySpec);
        if (keySpec instanceof PKCS11KeySpec) {
            publicKey = this.pkcs11GeneratePublic(keySpec);
        } else {
            if (this.softwareDelegate_ == null) {
                this.initializeSoftwareDelegate();
            }
            publicKey = this.softwareDelegate_.generatePublic((KeySpec)((Object)publicKey));
        }
        return publicKey;
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        PrivateKey privateKey;
        keySpec = IAIKPkcs11.getGlobalKeyHandler().handleKeyFactoryGeneratePrivate(this.getAlgorithmName(), keySpec);
        if (keySpec instanceof PKCS11KeySpec) {
            privateKey = this.pkcs11GeneratePrivate(keySpec);
        } else {
            if (this.softwareDelegate_ == null) {
                this.initializeSoftwareDelegate();
            }
            privateKey = this.softwareDelegate_.generatePrivate((KeySpec)((Object)privateKey));
        }
        return privateKey;
    }

    /*
     * WARNING - void declaration
     */
    protected KeySpec engineGetKeySpec(Key key, Class keySpecClass) throws InvalidKeySpecException {
        KeySpec keySpec;
        if (key instanceof IAIKPKCS11Key) {
            keySpec = this.pkcs11GetKeySpec(key, keySpecClass);
        } else {
            void var2_2;
            if (this.softwareDelegate_ == null) {
                this.initializeSoftwareDelegate();
            }
            keySpec = this.softwareDelegate_.getKeySpec((Key)((Object)keySpec), var2_2);
        }
        return keySpec;
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        Key key2;
        key = IAIKPkcs11.getGlobalKeyHandler().handleKeyFactoryTranslateKey(this.getAlgorithmName(), key);
        if (key instanceof IAIKPKCS11Key) {
            key2 = this.pkcs11TranslateKey(key);
        } else {
            if (this.softwareDelegate_ == null) {
                this.initializeSoftwareDelegate();
            }
            key2 = this.softwareDelegate_.translateKey(key2);
        }
        return key2;
    }

    protected abstract String getSoftwareDelegateAlgorithm();

    protected abstract String getAlgorithmName();

    protected void initializeSession() {
        block6: {
            if (this.pkcs11KeySpec_ == null) break block6;
            this.tokenManager_ = this.pkcs11KeySpec_.getTokenManager();
            try {
                block8: {
                    block7: {
                        PKCS11KeyFactory pKCS11KeyFactory = this;
                        if (pKCS11KeyFactory.isSessionAppropriate(pKCS11KeyFactory.session_, this.pkcs11KeySpec_)) break block7;
                        if (this.session_ == null) {
                            this.session_ = this.tokenManager_.getSession(this.pkcs11KeySpec_.isUseRwSession());
                        }
                        if (!this.pkcs11KeySpec_.isUseAnonymousRole()) break block8;
                        this.tokenManager_.makeAuthorizedSession(this.session_, null);
                    }
                    return;
                }
                this.tokenManager_.login(this.session_, this.pkcs11KeySpec_.isUseSORole(), this.pkcs11KeySpec_.getPin());
            }
            catch (TokenException tokenException) {
                throw new IAIKPkcs11Exception(tokenException.toString());
            }
        }
        throw new IAIKPkcs11Exception("Key factory is not initialized properly. The key spec is not set appropriately.");
    }

    protected void initializePkcs11Operation() {
        this.initializeSession();
        this.pkcs11OperationInitialized_ = true;
    }

    protected void finalizePkcs11Operation() {
        this.pkcs11OperationInitialized_ = false;
        this.tokenManager_.disposeSession(this.session_);
        this.session_ = null;
    }

    protected void initializeSoftwareDelegate() {
        DelegateProvider delegateProvider = this.tokenManager_ != null ? this.tokenManager_.getProvider().getDelegateProvider() : IAIKPkcs11.getGlobalDelegateProvider();
        String string = this.getSoftwareDelegateAlgorithm();
        this.softwareDelegate_ = delegateProvider.getKeyFactory(string);
        if (this.softwareDelegate_ == null) {
            throw new IAIKPkcs11Exception("Could not get delegate key factory engine for " + string);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isSessionAppropriate(Session session, PKCS11KeySpec pkcs11KeySpec) throws TokenException {
        boolean bl = false;
        if (session != null && pkcs11KeySpec != null) {
            void var2_2;
            Token token;
            SessionInfo sessionInfo = session.getSessionInfo();
            token = token.getToken();
            State state = sessionInfo.getState();
            boolean bl2 = state.equals((Object)State.RO_USER_FUNCTIONS) || state.equals((Object)State.RW_USER_FUNCTIONS);
            bl = token.equals((Object)this.tokenManager_.getToken()) && sessionInfo.isRwSession() != pkcs11KeySpec.isUseROSession() && bl2 == var2_2.isUseUserSession();
        }
        return bl;
    }

    protected Key createKey(iaik.pkcs.pkcs11.objects.Object keyCreationTemplate) throws InvalidKeySpecException {
        iaik.pkcs.pkcs11.objects.Key key;
        IAIKPKCS11Key iAIKPKCS11Key;
        this.initializePkcs11Operation();
        try {
            key = (iaik.pkcs.pkcs11.objects.Key)this.session_.createObject((iaik.pkcs.pkcs11.objects.Object)iAIKPKCS11Key);
        }
        catch (TokenException tokenException) {
            this.finalizePkcs11Operation();
            throw new InvalidKeySpecException("Key could not be generated using the given key spec: " + tokenException.toString());
        }
        iAIKPKCS11Key = IAIKPKCS11Key.create(this.tokenManager_, key);
        if (!key.getToken().getBooleanValue().booleanValue()) {
            iAIKPKCS11Key.setSession(this.session_);
        }
        this.finalizePkcs11Operation();
        this.tokenManager_.notifyKeyStores();
        return iAIKPKCS11Key;
    }

    protected abstract PublicKey pkcs11GeneratePublic(KeySpec var1) throws InvalidKeySpecException;

    protected abstract PrivateKey pkcs11GeneratePrivate(KeySpec var1) throws InvalidKeySpecException;

    protected abstract KeySpec pkcs11GetKeySpec(Key var1, Class var2) throws InvalidKeySpecException;

    protected Key pkcs11TranslateKey(Key key) throws InvalidKeyException {
        return key;
    }

    protected void finalize() throws Throwable {
        if (this.session_ != null) {
            this.tokenManager_.disposeSession(this.session_);
        }
        super.finalize();
    }
}

