/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keyfactories;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.ECDSAPrivateKey;
import iaik.pkcs.pkcs11.objects.ECDSAPublicKey;
import iaik.pkcs.pkcs11.objects.GenericTemplate;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.NonExtractableComponentException;
import iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeyFactory;
import iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PrivateKey;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PublicKey;
import iaik.pkcs.pkcs11.wrapper.Functions;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class EcDsaKeyFactory
extends PKCS11KeyFactory {
    protected static String KEY_FACTORY_ALGORITHM_NAME = "ECDSA";
    protected static final ObjectID OBJECT_ID_EC_KEY = new ObjectID("1.2.840.10045.2.1");
    protected static final AlgorithmID EC_ALGORITHM_ID = new AlgorithmID(OBJECT_ID_EC_KEY);
    public static final INTEGER EC_PRIVATE_KEY_VERSION = new INTEGER(1);
    private static boolean a;
    private static boolean b;
    private static Class c;
    private static Class d;

    protected static boolean checkJdk16AndEccelerate() {
        if (!b) {
            try {
                String string = System.getProperty("java.version");
                if (string != null && string.compareTo("1.6") < 0) {
                    a = false;
                } else {
                    Class.forName("iaik.security.ec.common.ECParameterSpec");
                    a = true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                a = false;
            }
            catch (SecurityException securityException) {
                a = false;
            }
            b = true;
        }
        return a;
    }

    protected String getSoftwareDelegateAlgorithm() {
        return KEY_FACTORY_ALGORITHM_NAME;
    }

    protected String getAlgorithmName() {
        return KEY_FACTORY_ALGORITHM_NAME;
    }

    protected PublicKey pkcs11GeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        byte[] byArray;
        if (keySpec == null) {
            throw new NullPointerException("Argument \"keySpec\" must not be null.");
        }
        if (!(keySpec instanceof PKCS11KeySpec)) {
            throw new IllegalArgumentException("Argument \"keySpec\" must be of instance iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec.");
        }
        this.pkcs11KeySpec_ = (PKCS11KeySpec)keySpec;
        Object object = this.pkcs11KeySpec_.getKeySpec();
        if (object instanceof X509EncodedKeySpec) {
            object = (X509EncodedKeySpec)object;
            object = ((X509EncodedKeySpec)object).getEncoded();
            try {
                object = new ASN1(object);
                keySpec = new AlgorithmID(object.getComponentAt(0));
                keySpec = keySpec.getParameter();
                byArray = DerCoder.encode((ASN1Object)keySpec);
                object = (BIT_STRING)object.getComponentAt(1);
                object = new OCTET_STRING((byte[])object.getValue());
                object = DerCoder.encode((ASN1Object)object);
            }
            catch (Exception exception) {
                throw new InvalidKeySpecException("The public key spec could not be parsed: " + exception.toString());
            }
        } else {
            if (EcDsaKeyFactory.checkJdk16AndEccelerate()) {
                try {
                    object = Class.forName("iaik.pkcs.pkcs11.provider.keyfactories.a");
                    object = (EcDsaKeyFactory)((Class)object).newInstance();
                    return ((EcDsaKeyFactory)object).pkcs11GeneratePublic((KeySpec)byArray);
                }
                catch (Throwable throwable) {
                    throw new InvalidKeySpecException("The actual key spec inside the given PKCS11KeySpec must be of type java.security.spec.X509EncodedKeySpec.");
                }
            }
            throw new InvalidKeySpecException("The actual key spec inside the given PKCS11KeySpec must be of type java.security.spec.X509EncodedKeySpec.");
        }
        return this.createECPublicKey(byArray, (byte[])object);
    }

    protected PublicKey createECPublicKey(byte[] encodedParameters, byte[] encodedPublicKeyValue) throws InvalidKeySpecException {
        iaik.pkcs.pkcs11.objects.Object object;
        GenericTemplate genericTemplate;
        ECDSAPublicKey eCDSAPublicKey = new ECDSAPublicKey();
        eCDSAPublicKey.getEcdsaParams().setByteArrayValue((byte[])genericTemplate);
        eCDSAPublicKey.getEcPoint().setByteArrayValue((byte[])object);
        genericTemplate = new GenericTemplate();
        object = this.pkcs11KeySpec_.getKeyTemplate();
        if (object != null) {
            genericTemplate.addAllPresentAttributes(object);
        }
        genericTemplate.addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)eCDSAPublicKey);
        return (PublicKey)this.createKey((iaik.pkcs.pkcs11.objects.Object)genericTemplate);
    }

    protected PrivateKey pkcs11GeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        byte[] byArray;
        if (keySpec == null) {
            throw new NullPointerException("Argument \"keySpec\" must not be null.");
        }
        if (!(keySpec instanceof PKCS11KeySpec)) {
            throw new IllegalArgumentException("Argument \"keySpec\" must be of instance iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec.");
        }
        this.pkcs11KeySpec_ = (PKCS11KeySpec)keySpec;
        Object object = this.pkcs11KeySpec_.getKeySpec();
        if (object instanceof PKCS8EncodedKeySpec) {
            object = (PKCS8EncodedKeySpec)object;
            object = ((PKCS8EncodedKeySpec)object).getEncoded();
            try {
                object = new ASN1(object);
                keySpec = new AlgorithmID(object.getComponentAt(1));
                keySpec = keySpec.getParameter();
                byArray = DerCoder.encode((ASN1Object)keySpec);
                object = (OCTET_STRING)object.getComponentAt(2);
                object = (SEQUENCE)DerCoder.decode((byte[])((byte[])object.getValue()));
                INTEGER iNTEGER = (INTEGER)object.getComponentAt(0);
                if (!iNTEGER.getValue().equals(EC_PRIVATE_KEY_VERSION.getValue())) {
                    throw new InvalidKeySpecException("The encoded private key has an invalid version field: " + iNTEGER.toString());
                }
                object = (OCTET_STRING)object.getComponentAt(1);
                object = (byte[])object.getValue();
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                object = invalidKeySpecException;
                throw invalidKeySpecException;
            }
            catch (Exception exception) {
                throw new InvalidKeySpecException("The private key spec could not be parsed: " + exception.toString());
            }
        } else {
            if (EcDsaKeyFactory.checkJdk16AndEccelerate()) {
                try {
                    object = Class.forName("iaik.pkcs.pkcs11.provider.keyfactories.a");
                    object = (EcDsaKeyFactory)((Class)object).newInstance();
                    return ((EcDsaKeyFactory)object).pkcs11GeneratePrivate((KeySpec)byArray);
                }
                catch (Throwable throwable) {
                    throw new InvalidKeySpecException("The actual key spec inside the given PKCS11KeySpec must be of type java.security.spec.X509EncodedKeySpec.");
                }
            }
            throw new InvalidKeySpecException("The actual key spec inside the given PKCS11KeySpec must be of type java.security.spec.PKCS8EncodedKeySpec.");
        }
        return this.createECPrivateKey(byArray, (byte[])object);
    }

    protected PrivateKey createECPrivateKey(byte[] encodedParameters, byte[] encodedPrivateKeyValue) throws InvalidKeySpecException {
        iaik.pkcs.pkcs11.objects.Object object;
        GenericTemplate genericTemplate;
        ECDSAPrivateKey eCDSAPrivateKey = new ECDSAPrivateKey();
        eCDSAPrivateKey.getEcdsaParams().setByteArrayValue((byte[])genericTemplate);
        eCDSAPrivateKey.getValue().setByteArrayValue((byte[])object);
        genericTemplate = new GenericTemplate();
        genericTemplate.addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)eCDSAPrivateKey);
        object = this.pkcs11KeySpec_.getKeyTemplate();
        if (object != null) {
            genericTemplate.addAllPresentAttributes(object);
        }
        return (PrivateKey)this.createKey((iaik.pkcs.pkcs11.objects.Object)genericTemplate);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected KeySpec pkcs11GetKeySpec(Key key, Class keySpecClass) throws InvalidKeySpecException {
        void var1_1;
        void var2_16;
        void var1_15;
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        if (keySpecClass == null) {
            throw new NullPointerException("Argument \"keySpecClass\" must not be null.");
        }
        if (keySpecClass.equals(c == null ? (c = EcDsaKeyFactory.a("java.security.spec.X509EncodedKeySpec")) : c)) {
            byte[] byArray;
            if (!(key instanceof IAIKPKCS11PublicKey)) throw new InvalidKeySpecException("For this factory, the key must be a IAIKPKCS11PublicKey to get an X509EncodedKeySpec.");
            IAIKPKCS11PublicKey iAIKPKCS11PublicKey = (IAIKPKCS11PublicKey)key;
            if (!((iAIKPKCS11PublicKey = iAIKPKCS11PublicKey.getKeyObject()) instanceof ECDSAPublicKey)) throw new InvalidKeySpecException("This factory does only accept ECDSA keys, but the PKCS#11 key object in the given key is: " + iAIKPKCS11PublicKey);
            ECDSAPublicKey eCDSAPublicKey = (ECDSAPublicKey)iAIKPKCS11PublicKey;
            this.verifyPublicKeyExtractable(eCDSAPublicKey);
            ByteArrayAttribute byteArrayAttribute = eCDSAPublicKey.getEcdsaParams();
            ByteArrayAttribute byteArrayAttribute2 = eCDSAPublicKey.getEcPoint();
            byte[] byArray2 = byteArrayAttribute.getByteArrayValue();
            byte[] byArray3 = byteArrayAttribute2.getByteArrayValue();
            try {
                iAIKPKCS11PublicKey = (AlgorithmID)EC_ALGORITHM_ID.clone();
                ASN1 aSN1 = new ASN1(byArray2);
                iAIKPKCS11PublicKey.setParameter(aSN1.toASN1Object());
                ASN1Object aSN1Object = DerCoder.decode((byte[])byArray3);
                if (!aSN1Object.isA(ASN.OCTET_STRING)) {
                    throw new InvalidKeySpecException("The encoded public key value of the PKCS#11 key is no OCTET STRING: " + Functions.toHexString((byte[])byArray3));
                }
                OCTET_STRING oCTET_STRING = (OCTET_STRING)aSN1Object;
                BIT_STRING bIT_STRING = new BIT_STRING((byte[])oCTET_STRING.getValue());
                SEQUENCE sEQUENCE = new SEQUENCE();
                sEQUENCE.addComponent(iAIKPKCS11PublicKey.toASN1Object());
                sEQUENCE.addComponent((ASN1Object)bIT_STRING);
                byArray = DerCoder.encode((ASN1Object)sEQUENCE);
            }
            catch (CodingException codingException) {
                throw new InvalidKeySpecException("Error during encoding of ECDSA public key: " + codingException.toString());
            }
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            return var1_15;
        }
        if (var2_16.equals(d == null ? (d = EcDsaKeyFactory.a("java.security.spec.PKCS8EncodedKeySpec")) : d)) {
            byte[] byArray;
            if (!(var1_1 instanceof IAIKPKCS11PrivateKey)) throw new InvalidKeySpecException("For this factory, the key must be a IAIKPKCS11PrivateKey to get a PKCS8EncodedKeySpec.");
            IAIKPKCS11PrivateKey iAIKPKCS11PrivateKey = (IAIKPKCS11PrivateKey)var1_1;
            if (!((iAIKPKCS11PrivateKey = iAIKPKCS11PrivateKey.getKeyObject()) instanceof ECDSAPrivateKey)) throw new InvalidKeySpecException("This factory does only accept ECDSA keys, but the PKCS#11 key object in the given key is: " + iAIKPKCS11PrivateKey);
            ECDSAPrivateKey eCDSAPrivateKey = (ECDSAPrivateKey)iAIKPKCS11PrivateKey;
            this.verifyPrivateKeyExtractable(eCDSAPrivateKey);
            ByteArrayAttribute byteArrayAttribute = eCDSAPrivateKey.getEcdsaParams();
            ByteArrayAttribute byteArrayAttribute3 = eCDSAPrivateKey.getValue();
            byte[] byArray4 = byteArrayAttribute.getByteArrayValue();
            byte[] byArray5 = byteArrayAttribute3.getByteArrayValue();
            try {
                iAIKPKCS11PrivateKey = (AlgorithmID)EC_ALGORITHM_ID.clone();
                ASN1 aSN1 = new ASN1(byArray4);
                iAIKPKCS11PrivateKey.setParameter(aSN1.toASN1Object());
                SEQUENCE sEQUENCE = new SEQUENCE();
                sEQUENCE.addComponent((ASN1Object)new INTEGER(0));
                sEQUENCE.addComponent(iAIKPKCS11PrivateKey.toASN1Object());
                SEQUENCE sEQUENCE2 = new SEQUENCE();
                sEQUENCE2.addComponent((ASN1Object)EC_PRIVATE_KEY_VERSION);
                sEQUENCE2.addComponent((ASN1Object)new OCTET_STRING(byArray5));
                OCTET_STRING oCTET_STRING = new OCTET_STRING(DerCoder.encode((ASN1Object)sEQUENCE2));
                sEQUENCE.addComponent((ASN1Object)oCTET_STRING);
                byArray = DerCoder.encode((ASN1Object)sEQUENCE);
            }
            catch (CodingException codingException) {
                throw new InvalidKeySpecException("Error during encoding of ECDSA private key: " + codingException.toString());
            }
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
            return var1_15;
        }
        if (!EcDsaKeyFactory.checkJdk16AndEccelerate()) throw new InvalidKeySpecException("The actual key spec inside the given PKCS11KeySpec must be of type java.security.spec.PKCS8EncodedKeySpec or java.security.spec.X509EncodedKeySpec.");
        try {
            Object object = Class.forName("iaik.pkcs.pkcs11.provider.keyfactories.a");
            object = (EcDsaKeyFactory)((Class)object).newInstance();
            return ((EcDsaKeyFactory)object).pkcs11GetKeySpec((Key)var1_1, (Class)var2_16);
        }
        catch (Throwable throwable) {
            throw new InvalidKeySpecException("The actual key spec inside the given PKCS11KeySpec must be of type java.security.spec.PKCS8EncodedKeySpec or java.security.spec.X509EncodedKeySpec.");
        }
    }

    protected void verifyPublicKeyExtractable(ECDSAPublicKey key) throws NonExtractableComponentException, IAIKPkcs11Exception {
        ByteArrayAttribute byteArrayAttribute;
        ByteArrayAttribute byteArrayAttribute2 = key.getEcdsaParams();
        byteArrayAttribute = byteArrayAttribute.getEcPoint();
        if (!byteArrayAttribute2.isStateKnown()) {
            throw new NonExtractableComponentException("The PKCS#11 EC key object's parameters attribute is either not present or sensitive.");
        }
        if (!byteArrayAttribute.isStateKnown()) {
            throw new NonExtractableComponentException("The PKCS#11 EC key object's point attribute is either not present or sensitive.");
        }
        if (!byteArrayAttribute2.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 EC key object does not possess a parameters attribute.");
        }
        if (!byteArrayAttribute.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 EC key object does not possess a point attribute.");
        }
        if (byteArrayAttribute2.isSensitive()) {
            throw new NonExtractableComponentException("The PKCS#11 EC key object's parameters attribute is sensitive.");
        }
        if (byteArrayAttribute.isSensitive()) {
            throw new NonExtractableComponentException("The PKCS#11 EC key object's point attribute is sensitive.");
        }
    }

    protected void verifyPrivateKeyExtractable(ECDSAPrivateKey key) throws NonExtractableComponentException, IAIKPkcs11Exception {
        ByteArrayAttribute byteArrayAttribute;
        ByteArrayAttribute byteArrayAttribute2 = key.getEcdsaParams();
        byteArrayAttribute = byteArrayAttribute.getValue();
        if (!byteArrayAttribute2.isStateKnown()) {
            throw new NonExtractableComponentException("The PKCS#11 EC key object's parameters attribute is either not present or sensitive.");
        }
        if (!byteArrayAttribute.isStateKnown()) {
            throw new NonExtractableComponentException("The PKCS#11 EC key object's private value attribute is either not present or sensitive.");
        }
        if (!byteArrayAttribute2.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 EC key object does not possess a parameters attribute.");
        }
        if (!byteArrayAttribute.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 EC key object does not possess a private value attribute.");
        }
        if (byteArrayAttribute2.isSensitive()) {
            throw new NonExtractableComponentException("The PKCS#11 EC key object's parameters attribute is sensitive.");
        }
        if (byteArrayAttribute.isSensitive()) {
            throw new NonExtractableComponentException("The PKCS#11 EC key object's private value attribute is sensitive.");
        }
    }

    private static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

