/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keyfactories;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.DSAPrivateKey;
import iaik.pkcs.pkcs11.objects.DSAPublicKey;
import iaik.pkcs.pkcs11.objects.GenericTemplate;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.NonExtractableComponentException;
import iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeyFactory;
import iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PrivateKey;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PublicKey;
import java.math.BigInteger;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class DsaKeyFactory
extends PKCS11KeyFactory {
    protected static String KEY_FACTORY_ALGORITHM_NAME = "DSA";
    private static Class a;
    private static Class b;
    private static Class c;
    private static Class d;

    protected String getSoftwareDelegateAlgorithm() {
        return KEY_FACTORY_ALGORITHM_NAME;
    }

    protected String getAlgorithmName() {
        return KEY_FACTORY_ALGORITHM_NAME;
    }

    protected PublicKey pkcs11GeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        Object object;
        Object object2;
        Object object3;
        KeySpec keySpec2;
        Object object4;
        if (keySpec == null) {
            throw new NullPointerException("Argument \"keySpec\" must not be null.");
        }
        if (!(keySpec instanceof PKCS11KeySpec)) {
            throw new IllegalArgumentException("Argument \"keySpec\" must be of instance iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec.");
        }
        this.pkcs11KeySpec_ = (PKCS11KeySpec)object4;
        object4 = this.pkcs11KeySpec_.getKeySpec();
        if (object4 instanceof DSAPublicKeySpec) {
            keySpec2 = (DSAPublicKeySpec)object4;
            object4 = Util.unsignedBigIntergerToByteArray((BigInteger)((DSAPublicKeySpec)keySpec2).getG());
            object3 = Util.unsignedBigIntergerToByteArray((BigInteger)((DSAPublicKeySpec)keySpec2).getP());
            object2 = Util.unsignedBigIntergerToByteArray((BigInteger)((DSAPublicKeySpec)keySpec2).getQ());
            object = Util.unsignedBigIntergerToByteArray((BigInteger)((DSAPublicKeySpec)keySpec2).getY());
        } else if (object4 instanceof X509EncodedKeySpec) {
            keySpec2 = (X509EncodedKeySpec)object4;
            object4 = ((X509EncodedKeySpec)keySpec2).getEncoded();
            try {
                object4 = new ASN1((byte[])object4);
                object3 = new AlgorithmID(object4.getComponentAt(0));
                object4 = (byte[])object4.getComponentAt(1).getValue();
                object4 = new ASN1((byte[])object4);
                object = (BigInteger)object4.toASN1Object().getValue();
                object4 = object3.getParameter();
                if (object4 != null && !object4.isA(ASN.NULL)) {
                    if (!object4.isA(ASN.SEQUENCE)) {
                        throw new InvalidKeySpecException("The public key spec could not be parsed. The key parameters are no ASN.1 SEQUENCE.");
                    }
                    if (object4.countComponents() < 3) {
                        throw new InvalidKeySpecException("The public key spec could not be parsed. The key parameters do not have 3 components.");
                    }
                } else {
                    throw new InvalidKeySpecException("The public key spec does not contain key parameters, which are required by this key factory.");
                }
                object3 = (BigInteger)object4.getComponentAt(0).getValue();
                object2 = (BigInteger)object4.getComponentAt(1).getValue();
                object4 = (BigInteger)object4.getComponentAt(2).getValue();
            }
            catch (CodingException codingException) {
                throw new InvalidKeySpecException("The public key spec could not be parsed: " + codingException.toString());
            }
            object4 = Util.unsignedBigIntergerToByteArray((BigInteger)object4);
            object3 = Util.unsignedBigIntergerToByteArray((BigInteger)object3);
            object2 = Util.unsignedBigIntergerToByteArray((BigInteger)object2);
            object = Util.unsignedBigIntergerToByteArray((BigInteger)object);
        } else {
            throw new InvalidKeySpecException("The actual key spec inside the given PKCS11KeySpec must be of type java.security.spec.DSAPublicKeySpec.");
        }
        keySpec2 = new DSAPublicKey();
        keySpec2.getBase().setByteArrayValue((byte[])object4);
        keySpec2.getPrime().setByteArrayValue(object3);
        keySpec2.getSubprime().setByteArrayValue(object2);
        keySpec2.getValue().setByteArrayValue(object);
        object4 = new GenericTemplate();
        object4.addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)keySpec2);
        iaik.pkcs.pkcs11.objects.Object object5 = this.pkcs11KeySpec_.getKeyTemplate();
        object = object5;
        if (object5 != null) {
            object4.addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)object);
        }
        return (PublicKey)this.createKey((iaik.pkcs.pkcs11.objects.Object)object4);
    }

    protected PrivateKey pkcs11GeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        Object object;
        Object object2;
        Object object3;
        KeySpec keySpec2;
        Object object4;
        if (keySpec == null) {
            throw new NullPointerException("Argument \"keySpec\" must not be null.");
        }
        if (!(keySpec instanceof PKCS11KeySpec)) {
            throw new IllegalArgumentException("Argument \"keySpec\" must be of instance iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec.");
        }
        this.pkcs11KeySpec_ = (PKCS11KeySpec)object4;
        object4 = this.pkcs11KeySpec_.getKeySpec();
        if (object4 instanceof DSAPrivateKeySpec) {
            keySpec2 = (DSAPrivateKeySpec)object4;
            object4 = Util.unsignedBigIntergerToByteArray((BigInteger)((DSAPrivateKeySpec)keySpec2).getG());
            object3 = Util.unsignedBigIntergerToByteArray((BigInteger)((DSAPrivateKeySpec)keySpec2).getP());
            object2 = Util.unsignedBigIntergerToByteArray((BigInteger)((DSAPrivateKeySpec)keySpec2).getQ());
            object = Util.unsignedBigIntergerToByteArray((BigInteger)((DSAPrivateKeySpec)keySpec2).getX());
        } else if (object4 instanceof PKCS8EncodedKeySpec) {
            keySpec2 = (PKCS8EncodedKeySpec)object4;
            object4 = ((PKCS8EncodedKeySpec)keySpec2).getEncoded();
            try {
                object4 = new ASN1((byte[])object4);
                object3 = new AlgorithmID(object4.getComponentAt(1));
                object4 = (byte[])object4.getComponentAt(2).getValue();
                object4 = new ASN1((byte[])object4);
                object = (BigInteger)object4.toASN1Object().getValue();
                object4 = object3.getParameter();
                if (object4 != null && !object4.isA(ASN.NULL)) {
                    if (!object4.isA(ASN.SEQUENCE)) {
                        throw new InvalidKeySpecException("The private key spec could not be parsed. The key parameters are no ASN.1 SEQUENCE.");
                    }
                    if (object4.countComponents() < 3) {
                        throw new InvalidKeySpecException("The private key spec could not be parsed. The key parameters do not have 3 components.");
                    }
                } else {
                    throw new InvalidKeySpecException("The private key spec does not contain key parameters, which are required by this key factory.");
                }
                object3 = (BigInteger)object4.getComponentAt(0).getValue();
                object2 = (BigInteger)object4.getComponentAt(1).getValue();
                object4 = (BigInteger)object4.getComponentAt(2).getValue();
            }
            catch (CodingException codingException) {
                throw new InvalidKeySpecException("The private key spec could not be parsed: " + codingException.toString());
            }
            object4 = Util.unsignedBigIntergerToByteArray((BigInteger)object4);
            object3 = Util.unsignedBigIntergerToByteArray((BigInteger)object3);
            object2 = Util.unsignedBigIntergerToByteArray((BigInteger)object2);
            object = Util.unsignedBigIntergerToByteArray((BigInteger)object);
        } else {
            throw new InvalidKeySpecException("The actual key spec inside the given PKCS11KeySpec must be of type java.security.spec.DSAPrivateKeySpec.");
        }
        keySpec2 = new DSAPrivateKey();
        keySpec2.getBase().setByteArrayValue((byte[])object4);
        keySpec2.getPrime().setByteArrayValue(object3);
        keySpec2.getSubprime().setByteArrayValue(object2);
        keySpec2.getValue().setByteArrayValue(object);
        object4 = new GenericTemplate();
        object4.addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)keySpec2);
        iaik.pkcs.pkcs11.objects.Object object5 = this.pkcs11KeySpec_.getKeyTemplate();
        object = object5;
        if (object5 != null) {
            object4.addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)object);
        }
        return (PrivateKey)this.createKey((iaik.pkcs.pkcs11.objects.Object)object4);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected KeySpec pkcs11GetKeySpec(Key key2, Class keySpecClass) throws InvalidKeySpecException {
        byte[] byArray;
        void var1_1;
        void var2_33;
        void var1_32;
        if (key2 == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        if (keySpecClass == null) {
            throw new NullPointerException("Argument \"keySpecClass\" must not be null.");
        }
        if (keySpecClass.equals(a == null ? (a = DsaKeyFactory.a("java.security.spec.DSAPublicKeySpec")) : a)) {
            if (!(key2 instanceof IAIKPKCS11PublicKey)) throw new InvalidKeySpecException("For this factory, the key must be a IAIKPKCS11PublicKeyto get a DSAPublicKeySpec.");
            IAIKPKCS11PublicKey key2 = (IAIKPKCS11PublicKey)key2;
            iaik.pkcs.pkcs11.objects.Key key3 = key2.getKeyObject();
            if (!(key3 instanceof DSAPublicKey)) throw new InvalidKeySpecException("This factory does only accept DSA keys, but the PKCS#11 key objectin the given key is: " + key3);
            DSAPublicKey dSAPublicKey = (DSAPublicKey)key3;
            this.verifyPublicKeyExtractable(dSAPublicKey);
            ByteArrayAttribute byteArrayAttribute = dSAPublicKey.getBase();
            ByteArrayAttribute byteArrayAttribute2 = dSAPublicKey.getPrime();
            ByteArrayAttribute byteArrayAttribute3 = dSAPublicKey.getSubprime();
            ByteArrayAttribute byteArrayAttribute4 = dSAPublicKey.getValue();
            byte[] byArray2 = byteArrayAttribute.getByteArrayValue();
            byte[] byArray3 = byteArrayAttribute2.getByteArrayValue();
            byte[] byArray4 = byteArrayAttribute3.getByteArrayValue();
            byte[] byArray5 = byteArrayAttribute4.getByteArrayValue();
            DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(new BigInteger(1, byArray5), new BigInteger(1, byArray3), new BigInteger(1, byArray4), new BigInteger(1, byArray2));
            return var1_32;
        }
        if (var2_33.equals(b == null ? (b = DsaKeyFactory.a("java.security.spec.DSAPrivateKeySpec")) : b)) {
            if (!(var1_1 instanceof IAIKPKCS11PrivateKey)) throw new InvalidKeySpecException("For this factory, the key must be a IAIKPKCS11PrivateKey to get a DSAPrivateKeySpec.");
            IAIKPKCS11PrivateKey iAIKPKCS11PrivateKey = (IAIKPKCS11PrivateKey)var1_1;
            iaik.pkcs.pkcs11.objects.Key key4 = iAIKPKCS11PrivateKey.getKeyObject();
            if (!(key4 instanceof DSAPrivateKey)) throw new InvalidKeySpecException("This factory does only accept DSA keys, but the PKCS#11 key object in the given key is: " + key4);
            DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)key4;
            this.verifyPrivateKeyExtractable(dSAPrivateKey);
            ByteArrayAttribute byteArrayAttribute = dSAPrivateKey.getBase();
            ByteArrayAttribute byteArrayAttribute5 = dSAPrivateKey.getPrime();
            ByteArrayAttribute byteArrayAttribute6 = dSAPrivateKey.getSubprime();
            ByteArrayAttribute byteArrayAttribute7 = dSAPrivateKey.getValue();
            byte[] byArray6 = byteArrayAttribute.getByteArrayValue();
            byte[] byArray7 = byteArrayAttribute5.getByteArrayValue();
            byte[] byArray8 = byteArrayAttribute6.getByteArrayValue();
            byte[] byArray9 = byteArrayAttribute7.getByteArrayValue();
            DSAPrivateKeySpec dSAPrivateKeySpec = new DSAPrivateKeySpec(new BigInteger(1, byArray9), new BigInteger(1, byArray7), new BigInteger(1, byArray8), new BigInteger(1, byArray6));
            return var1_32;
        }
        if (var2_33.equals(c == null ? (c = DsaKeyFactory.a("java.security.spec.X509EncodedKeySpec")) : c)) {
            byte[] byArray10;
            if (!(var1_1 instanceof IAIKPKCS11PublicKey)) throw new InvalidKeySpecException("For this factory, the key must be a IAIKPKCS11PublicKey to get a X509EncodedKeySpec.");
            IAIKPKCS11PublicKey iAIKPKCS11PublicKey = (IAIKPKCS11PublicKey)var1_1;
            iaik.pkcs.pkcs11.objects.Key key5 = iAIKPKCS11PublicKey.getKeyObject();
            if (!(key5 instanceof DSAPublicKey)) throw new InvalidKeySpecException("This factory does only accept RSA keys, but the PKCS#11 key object in the given key is: " + key5);
            DSAPublicKey dSAPublicKey = (DSAPublicKey)key5;
            this.verifyPublicKeyExtractable(dSAPublicKey);
            ByteArrayAttribute byteArrayAttribute = dSAPublicKey.getBase();
            ByteArrayAttribute byteArrayAttribute8 = dSAPublicKey.getPrime();
            ByteArrayAttribute byteArrayAttribute9 = dSAPublicKey.getSubprime();
            ByteArrayAttribute byteArrayAttribute10 = dSAPublicKey.getValue();
            byte[] byArray11 = byteArrayAttribute.getByteArrayValue();
            byte[] byArray12 = byteArrayAttribute8.getByteArrayValue();
            byte[] byArray13 = byteArrayAttribute9.getByteArrayValue();
            byte[] byArray14 = byteArrayAttribute10.getByteArrayValue();
            try {
                AlgorithmID algorithmID = (AlgorithmID)AlgorithmID.dsa.clone();
                ASN1 aSN1 = new ASN1((ASN1Object)new INTEGER(new BigInteger(1, byArray14)));
                byte[] byArray15 = aSN1.toByteArray();
                SEQUENCE sEQUENCE = new SEQUENCE();
                sEQUENCE.addComponent((ASN1Object)new INTEGER(new BigInteger(1, byArray12)));
                sEQUENCE.addComponent((ASN1Object)new INTEGER(new BigInteger(1, byArray13)));
                sEQUENCE.addComponent((ASN1Object)new INTEGER(new BigInteger(1, byArray11)));
                algorithmID.setParameter((ASN1Object)sEQUENCE);
                SEQUENCE sEQUENCE2 = new SEQUENCE();
                sEQUENCE2.addComponent(algorithmID.toASN1Object());
                sEQUENCE2.addComponent((ASN1Object)new BIT_STRING(byArray15));
                byArray10 = DerCoder.encode((ASN1Object)sEQUENCE2);
            }
            catch (CodingException codingException) {
                throw new InvalidKeySpecException("Error during encoding of RSA public key: " + codingException.toString());
            }
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray10);
            return var1_32;
        }
        if (!var2_33.equals(d == null ? (d = DsaKeyFactory.a("java.security.spec.PKCS8EncodedKeySpec")) : d)) throw new InvalidKeySpecException("The given key spec class is invalid. It must be of either DSAPublicKeySpec, X509EncodedKeySpec, DSAPrivateKeySpec or PKCS8EncodedKeySpec.");
        if (!(var1_1 instanceof IAIKPKCS11PrivateKey)) throw new InvalidKeySpecException("For this factory, the key must be a IAIKPKCS11PrivateKey to get a PKCS8EncodedKeySpec.");
        IAIKPKCS11PrivateKey iAIKPKCS11PrivateKey = (IAIKPKCS11PrivateKey)var1_1;
        iaik.pkcs.pkcs11.objects.Key key6 = iAIKPKCS11PrivateKey.getKeyObject();
        if (!(key6 instanceof DSAPrivateKey)) throw new InvalidKeySpecException("This factory does only accept RSA keys, but the PKCS#11 key object in the given key is: " + key6);
        DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)key6;
        this.verifyPrivateKeyExtractable(dSAPrivateKey);
        ByteArrayAttribute byteArrayAttribute = dSAPrivateKey.getBase();
        ByteArrayAttribute byteArrayAttribute11 = dSAPrivateKey.getPrime();
        ByteArrayAttribute byteArrayAttribute12 = dSAPrivateKey.getSubprime();
        ByteArrayAttribute byteArrayAttribute13 = dSAPrivateKey.getValue();
        byte[] byArray16 = byteArrayAttribute.getByteArrayValue();
        byte[] byArray17 = byteArrayAttribute11.getByteArrayValue();
        byte[] byArray18 = byteArrayAttribute12.getByteArrayValue();
        byte[] byArray19 = byteArrayAttribute13.getByteArrayValue();
        try {
            AlgorithmID algorithmID = (AlgorithmID)AlgorithmID.rsaEncryption.clone();
            ASN1 aSN1 = new ASN1((ASN1Object)new INTEGER(new BigInteger(1, byArray19)));
            byte[] byArray20 = aSN1.toByteArray();
            SEQUENCE sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent((ASN1Object)new INTEGER(new BigInteger(1, byArray17)));
            sEQUENCE.addComponent((ASN1Object)new INTEGER(new BigInteger(1, byArray18)));
            sEQUENCE.addComponent((ASN1Object)new INTEGER(new BigInteger(1, byArray16)));
            algorithmID.setParameter((ASN1Object)sEQUENCE);
            SEQUENCE sEQUENCE3 = new SEQUENCE();
            sEQUENCE3.addComponent((ASN1Object)new INTEGER(0));
            sEQUENCE3.addComponent(algorithmID.toASN1Object());
            sEQUENCE3.addComponent((ASN1Object)new OCTET_STRING(byArray20));
            byArray = DerCoder.encode((ASN1Object)sEQUENCE3);
        }
        catch (CodingException codingException) {
            throw new InvalidKeySpecException("Error during encoding of RSA private key: " + codingException.toString());
        }
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
        return var1_32;
    }

    protected void verifyPublicKeyExtractable(DSAPublicKey key) throws NonExtractableComponentException, IAIKPkcs11Exception {
        ByteArrayAttribute byteArrayAttribute;
        ByteArrayAttribute byteArrayAttribute2 = key.getBase();
        ByteArrayAttribute byteArrayAttribute3 = key.getPrime();
        ByteArrayAttribute byteArrayAttribute4 = key.getSubprime();
        byteArrayAttribute = byteArrayAttribute.getValue();
        if (!byteArrayAttribute2.isStateKnown()) {
            throw new NonExtractableComponentException("The PKCS#11 DSA key object's base attribute is either not present or sensitive.");
        }
        if (!byteArrayAttribute3.isStateKnown()) {
            throw new NonExtractableComponentException("The PKCS#11 DSA key object's prime attribute is either not present or sensitive.");
        }
        if (!byteArrayAttribute4.isStateKnown()) {
            throw new NonExtractableComponentException("The PKCS#11 DSA key object's subprime attribute is either not present or sensitive.");
        }
        if (!byteArrayAttribute.isStateKnown()) {
            throw new NonExtractableComponentException("The PKCS#11 DSA key object's value attribute is either not present or sensitive.");
        }
        if (!byteArrayAttribute2.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DSA key object does not possess a base attribute.");
        }
        if (!byteArrayAttribute3.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DSA key object does not possess a prime attribute.");
        }
        if (!byteArrayAttribute4.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DSA key object does not possess a subprime attribute.");
        }
        if (!byteArrayAttribute.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DSA key object does not possess a value attribute.");
        }
        if (byteArrayAttribute2.isSensitive()) {
            throw new NonExtractableComponentException("The PKCS#11 DSA key object's base attribute is sensitive.");
        }
        if (byteArrayAttribute3.isSensitive()) {
            throw new NonExtractableComponentException("The PKCS#11 DSA key object's prime attribute is sensitive.");
        }
        if (byteArrayAttribute4.isSensitive()) {
            throw new NonExtractableComponentException("The PKCS#11 DSA key object's subprime attribute is sensitive.");
        }
        if (byteArrayAttribute.isSensitive()) {
            throw new NonExtractableComponentException("The PKCS#11 DSA key object's value attribute is sensitive.");
        }
    }

    protected void verifyPrivateKeyExtractable(DSAPrivateKey key) throws NonExtractableComponentException, IAIKPkcs11Exception {
        ByteArrayAttribute byteArrayAttribute;
        ByteArrayAttribute byteArrayAttribute2 = key.getBase();
        ByteArrayAttribute byteArrayAttribute3 = key.getPrime();
        ByteArrayAttribute byteArrayAttribute4 = key.getSubprime();
        byteArrayAttribute = byteArrayAttribute.getValue();
        if (!byteArrayAttribute2.isStateKnown()) {
            throw new NonExtractableComponentException("The PKCS#11 DSA key object's base attribute is either not present or sensitive.");
        }
        if (!byteArrayAttribute3.isStateKnown()) {
            throw new NonExtractableComponentException("The PKCS#11 DSA key object's prime attribute is either not present or sensitive.");
        }
        if (!byteArrayAttribute4.isStateKnown()) {
            throw new NonExtractableComponentException("The PKCS#11 DSA key object's subprime attribute is either not present or sensitive.");
        }
        if (!byteArrayAttribute.isStateKnown()) {
            throw new NonExtractableComponentException("The PKCS#11 DSA key object's value attribute is either not present or sensitive.");
        }
        if (!byteArrayAttribute2.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DSA key object does not possess a base attribute.");
        }
        if (!byteArrayAttribute3.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DSA key object does not possess a prime attribute.");
        }
        if (!byteArrayAttribute4.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DSA key object does not possess a subprime attribute.");
        }
        if (!byteArrayAttribute.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DSA key object does not possess a value attribute.");
        }
        if (byteArrayAttribute2.isSensitive()) {
            throw new NonExtractableComponentException("The PKCS#11 DSA key object's base attribute is sensitive.");
        }
        if (byteArrayAttribute3.isSensitive()) {
            throw new NonExtractableComponentException("The PKCS#11 DSA key object's prime attribute is sensitive.");
        }
        if (byteArrayAttribute4.isSensitive()) {
            throw new NonExtractableComponentException("The PKCS#11 DSA key object's subprime attribute is sensitive.");
        }
        if (byteArrayAttribute.isSensitive()) {
            throw new NonExtractableComponentException("The PKCS#11 DSA key object's value attribute is sensitive.");
        }
    }

    private static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

