/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keyfactories;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.DHPrivateKey;
import iaik.pkcs.pkcs11.objects.DHPublicKey;
import iaik.pkcs.pkcs11.objects.GenericTemplate;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.NonExtractableComponentException;
import iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeyFactory;
import iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PrivateKey;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PublicKey;
import java.math.BigInteger;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;

public class DhKeyFactory
extends PKCS11KeyFactory {
    protected static String KEY_FACTORY_ALGORITHM_NAME = "DH";
    private static Class a;
    private static Class b;
    private static Class c;
    private static Class d;

    protected String getSoftwareDelegateAlgorithm() {
        return KEY_FACTORY_ALGORITHM_NAME;
    }

    protected String getAlgorithmName() {
        return KEY_FACTORY_ALGORITHM_NAME;
    }

    protected PublicKey pkcs11GeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        Object object;
        Object object2;
        KeySpec keySpec2;
        Object object3;
        if (keySpec == null) {
            throw new NullPointerException("Argument \"keySpec\" must not be null.");
        }
        if (!(keySpec instanceof PKCS11KeySpec)) {
            throw new IllegalArgumentException("Argument \"keySpec\" must be of instance iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec.");
        }
        this.pkcs11KeySpec_ = (PKCS11KeySpec)object3;
        object3 = this.pkcs11KeySpec_.getKeySpec();
        if (object3 instanceof DHPublicKeySpec) {
            keySpec2 = (DHPublicKeySpec)object3;
            object3 = Util.unsignedBigIntergerToByteArray((BigInteger)((DHPublicKeySpec)keySpec2).getG());
            object2 = Util.unsignedBigIntergerToByteArray((BigInteger)((DHPublicKeySpec)keySpec2).getP());
            object = Util.unsignedBigIntergerToByteArray((BigInteger)((DHPublicKeySpec)keySpec2).getY());
        } else if (object3 instanceof X509EncodedKeySpec) {
            keySpec2 = (X509EncodedKeySpec)object3;
            object3 = ((X509EncodedKeySpec)keySpec2).getEncoded();
            try {
                object3 = new ASN1((byte[])object3);
                object2 = new AlgorithmID(object3.getComponentAt(0));
                object3 = (byte[])object3.getComponentAt(1).getValue();
                object3 = new ASN1((byte[])object3);
                object = (BigInteger)object3.toASN1Object().getValue();
                object3 = object2.getParameter();
                if (object3 != null && !object3.isA(ASN.NULL)) {
                    if (!object3.isA(ASN.SEQUENCE)) {
                        throw new InvalidKeySpecException("The public key spec could not be parsed. The key parameters are no ASN.1 SEQUENCE.");
                    }
                    if (object3.countComponents() < 2) {
                        throw new InvalidKeySpecException("The public key spec could not be parsed. The key parameters do not have 2 components.");
                    }
                } else {
                    throw new InvalidKeySpecException("The public key spec does not contain key parameters, which are required by this key factory.");
                }
                object2 = (BigInteger)object3.getComponentAt(0).getValue();
                object3 = (BigInteger)object3.getComponentAt(1).getValue();
            }
            catch (CodingException codingException) {
                throw new InvalidKeySpecException("The public key spec could not be parsed: " + codingException.toString());
            }
            object3 = Util.unsignedBigIntergerToByteArray((BigInteger)object3);
            object2 = Util.unsignedBigIntergerToByteArray((BigInteger)object2);
            object = Util.unsignedBigIntergerToByteArray((BigInteger)object);
        } else {
            throw new InvalidKeySpecException("The actual key spec inside the given PKCS11KeySpec must be of type java.security.spec.DHPublicKeySpec.");
        }
        keySpec2 = new DHPublicKey();
        keySpec2.getBase().setByteArrayValue((byte[])object3);
        keySpec2.getPrime().setByteArrayValue(object2);
        keySpec2.getValue().setByteArrayValue(object);
        object3 = new GenericTemplate();
        iaik.pkcs.pkcs11.objects.Object object4 = this.pkcs11KeySpec_.getKeyTemplate();
        object = object4;
        if (object4 != null) {
            object3.addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)object);
        }
        object3.addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)keySpec2);
        return (PublicKey)this.createKey((iaik.pkcs.pkcs11.objects.Object)object3);
    }

    protected PrivateKey pkcs11GeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        Object object;
        Object object2;
        KeySpec keySpec2;
        Object object3;
        if (keySpec == null) {
            throw new NullPointerException("Argument \"keySpec\" must not be null.");
        }
        if (!(keySpec instanceof PKCS11KeySpec)) {
            throw new IllegalArgumentException("Argument \"keySpec\" must be of instance iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec.");
        }
        this.pkcs11KeySpec_ = (PKCS11KeySpec)object3;
        object3 = this.pkcs11KeySpec_.getKeySpec();
        if (object3 instanceof DHPrivateKeySpec) {
            keySpec2 = (DHPrivateKeySpec)object3;
            object3 = Util.unsignedBigIntergerToByteArray((BigInteger)((DHPrivateKeySpec)keySpec2).getG());
            object2 = Util.unsignedBigIntergerToByteArray((BigInteger)((DHPrivateKeySpec)keySpec2).getP());
            object = Util.unsignedBigIntergerToByteArray((BigInteger)((DHPrivateKeySpec)keySpec2).getX());
        } else if (object3 instanceof PKCS8EncodedKeySpec) {
            keySpec2 = (PKCS8EncodedKeySpec)object3;
            object3 = ((PKCS8EncodedKeySpec)keySpec2).getEncoded();
            try {
                object3 = new ASN1((byte[])object3);
                object2 = new AlgorithmID(object3.getComponentAt(1));
                object3 = (byte[])object3.getComponentAt(2).getValue();
                object3 = new ASN1((byte[])object3);
                object = (BigInteger)object3.toASN1Object().getValue();
                object3 = object2.getParameter();
                if (object3 != null && !object3.isA(ASN.NULL)) {
                    if (!object3.isA(ASN.SEQUENCE)) {
                        throw new InvalidKeySpecException("The private key spec could not be parsed. The key parameters are no ASN.1 SEQUENCE.");
                    }
                    if (object3.countComponents() < 2) {
                        throw new InvalidKeySpecException("The private key spec could not be parsed. The key parameters do not have 2 components.");
                    }
                } else {
                    throw new InvalidKeySpecException("The private key spec does not contain key parameters, which are required by this key factory.");
                }
                object2 = (BigInteger)object3.getComponentAt(0).getValue();
                object3 = (BigInteger)object3.getComponentAt(1).getValue();
            }
            catch (CodingException codingException) {
                throw new InvalidKeySpecException("The private key spec could not be parsed: " + codingException.toString());
            }
            object3 = Util.unsignedBigIntergerToByteArray((BigInteger)object3);
            object2 = Util.unsignedBigIntergerToByteArray((BigInteger)object2);
            object = Util.unsignedBigIntergerToByteArray((BigInteger)object);
        } else {
            throw new InvalidKeySpecException("The actual key spec inside the given PKCS11KeySpec must be of type java.security.spec.DHPrivateKeySpec.");
        }
        keySpec2 = new DHPrivateKey();
        keySpec2.getBase().setByteArrayValue((byte[])object3);
        keySpec2.getPrime().setByteArrayValue(object2);
        keySpec2.getValue().setByteArrayValue(object);
        object3 = new GenericTemplate();
        object3.addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)keySpec2);
        iaik.pkcs.pkcs11.objects.Object object4 = this.pkcs11KeySpec_.getKeyTemplate();
        object = object4;
        if (object4 != null) {
            object3.addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)object);
        }
        return (PrivateKey)this.createKey((iaik.pkcs.pkcs11.objects.Object)object3);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected KeySpec pkcs11GetKeySpec(Key key2, Class keySpecClass) throws InvalidKeySpecException {
        byte[] byArray;
        void var1_1;
        void var2_33;
        void var1_32;
        if (key2 == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        if (keySpecClass == null) {
            throw new NullPointerException("Argument \"keySpecClass\" must not be null.");
        }
        if (keySpecClass.equals(a == null ? (a = DhKeyFactory.a("javax.crypto.spec.DHPublicKeySpec")) : a)) {
            if (!(key2 instanceof IAIKPKCS11PublicKey)) throw new InvalidKeySpecException("For this factory, the key must be a IAIKPKCS11PublicKey to get a DHPublicKeySpec.");
            IAIKPKCS11PublicKey key2 = (IAIKPKCS11PublicKey)key2;
            iaik.pkcs.pkcs11.objects.Key key3 = key2.getKeyObject();
            if (!(key3 instanceof DHPublicKey)) throw new InvalidKeySpecException("This factory does only accept DH keys, but the PKCS#11 key object in the given key is: " + key3);
            DHPublicKey dHPublicKey = (DHPublicKey)key3;
            this.verifyPublicKeyExtractable(dHPublicKey);
            ByteArrayAttribute byteArrayAttribute = dHPublicKey.getBase();
            ByteArrayAttribute byteArrayAttribute2 = dHPublicKey.getPrime();
            ByteArrayAttribute byteArrayAttribute3 = dHPublicKey.getValue();
            byte[] byArray2 = byteArrayAttribute.getByteArrayValue();
            byte[] byArray3 = byteArrayAttribute2.getByteArrayValue();
            byte[] byArray4 = byteArrayAttribute3.getByteArrayValue();
            DHPublicKeySpec dHPublicKeySpec = new DHPublicKeySpec(new BigInteger(1, byArray4), new BigInteger(1, byArray3), new BigInteger(1, byArray2));
            return var1_32;
        }
        if (var2_33.equals(b == null ? (b = DhKeyFactory.a("javax.crypto.spec.DHPrivateKeySpec")) : b)) {
            if (!(var1_1 instanceof IAIKPKCS11PrivateKey)) throw new InvalidKeySpecException("For this factory, the key must be a IAIKPKCS11PrivateKey to get a DHPrivateKeySpec.");
            IAIKPKCS11PrivateKey iAIKPKCS11PrivateKey = (IAIKPKCS11PrivateKey)var1_1;
            iaik.pkcs.pkcs11.objects.Key key4 = iAIKPKCS11PrivateKey.getKeyObject();
            if (!(key4 instanceof DHPrivateKey)) throw new InvalidKeySpecException("This factory does only accept DH keys, but the PKCS#11 key object in the given key is: " + key4);
            DHPrivateKey dHPrivateKey = (DHPrivateKey)key4;
            this.verifyPrivateKeyExtractable(dHPrivateKey);
            ByteArrayAttribute byteArrayAttribute = dHPrivateKey.getBase();
            ByteArrayAttribute byteArrayAttribute4 = dHPrivateKey.getPrime();
            ByteArrayAttribute byteArrayAttribute5 = dHPrivateKey.getValue();
            byte[] byArray5 = byteArrayAttribute.getByteArrayValue();
            byte[] byArray6 = byteArrayAttribute4.getByteArrayValue();
            byte[] byArray7 = byteArrayAttribute5.getByteArrayValue();
            DHPrivateKeySpec dHPrivateKeySpec = new DHPrivateKeySpec(new BigInteger(1, byArray7), new BigInteger(1, byArray6), new BigInteger(1, byArray5));
            return var1_32;
        }
        if (var2_33.equals(c == null ? (c = DhKeyFactory.a("java.security.spec.X509EncodedKeySpec")) : c)) {
            byte[] byArray8;
            if (!(var1_1 instanceof IAIKPKCS11PublicKey)) throw new InvalidKeySpecException("For this factory, the key must be a IAIKPKCS11PublicKey to get a X509EncodedKeySpec.");
            IAIKPKCS11PublicKey iAIKPKCS11PublicKey = (IAIKPKCS11PublicKey)var1_1;
            iaik.pkcs.pkcs11.objects.Key key5 = iAIKPKCS11PublicKey.getKeyObject();
            if (!(key5 instanceof DHPublicKey)) throw new InvalidKeySpecException("This factory does only accept DH keys, but the PKCS#11 key object in the given key is: " + key5);
            DHPublicKey dHPublicKey = (DHPublicKey)key5;
            this.verifyPublicKeyExtractable(dHPublicKey);
            ByteArrayAttribute byteArrayAttribute = dHPublicKey.getBase();
            ByteArrayAttribute byteArrayAttribute6 = dHPublicKey.getPrime();
            ByteArrayAttribute byteArrayAttribute7 = dHPublicKey.getValue();
            byte[] byArray9 = byteArrayAttribute.getByteArrayValue();
            byte[] byArray10 = byteArrayAttribute6.getByteArrayValue();
            byte[] byArray11 = byteArrayAttribute7.getByteArrayValue();
            try {
                AlgorithmID algorithmID = (AlgorithmID)AlgorithmID.dhKeyAgreement.clone();
                ASN1 aSN1 = new ASN1((ASN1Object)new INTEGER(new BigInteger(1, byArray11)));
                byte[] byArray12 = aSN1.toByteArray();
                SEQUENCE sEQUENCE = new SEQUENCE();
                sEQUENCE.addComponent((ASN1Object)new INTEGER(new BigInteger(1, byArray10)));
                sEQUENCE.addComponent((ASN1Object)new INTEGER(new BigInteger(1, byArray9)));
                algorithmID.setParameter((ASN1Object)sEQUENCE);
                SEQUENCE sEQUENCE2 = new SEQUENCE();
                sEQUENCE2.addComponent(algorithmID.toASN1Object());
                sEQUENCE2.addComponent((ASN1Object)new BIT_STRING(byArray12));
                byArray8 = DerCoder.encode((ASN1Object)sEQUENCE2);
            }
            catch (CodingException codingException) {
                throw new InvalidKeySpecException("Error during encoding of DH public key: " + codingException.toString());
            }
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray8);
            return var1_32;
        }
        if (!var2_33.equals(d == null ? (d = DhKeyFactory.a("java.security.spec.PKCS8EncodedKeySpec")) : d)) throw new InvalidKeySpecException("The given key spec class is invalid. It must be of either DHPublicKeySpec, DHPrivateKeySpec, X509EncodedKeySpec or PKCS8EncodedKeySpec.");
        if (!(var1_1 instanceof IAIKPKCS11PrivateKey)) throw new InvalidKeySpecException("For this factory, the key must be a IAIKPKCS11PrivateKey to get a PKCS8EncodedKeySpec.");
        IAIKPKCS11PrivateKey iAIKPKCS11PrivateKey = (IAIKPKCS11PrivateKey)var1_1;
        iaik.pkcs.pkcs11.objects.Key key6 = iAIKPKCS11PrivateKey.getKeyObject();
        if (!(key6 instanceof DHPrivateKey)) throw new InvalidKeySpecException("This factory does only accept DH keys, but the PKCS#11 key object in the given key is: " + key6);
        DHPrivateKey dHPrivateKey = (DHPrivateKey)key6;
        this.verifyPrivateKeyExtractable(dHPrivateKey);
        ByteArrayAttribute byteArrayAttribute = dHPrivateKey.getBase();
        ByteArrayAttribute byteArrayAttribute8 = dHPrivateKey.getPrime();
        ByteArrayAttribute byteArrayAttribute9 = dHPrivateKey.getValue();
        byte[] byArray13 = byteArrayAttribute.getByteArrayValue();
        byte[] byArray14 = byteArrayAttribute8.getByteArrayValue();
        byte[] byArray15 = byteArrayAttribute9.getByteArrayValue();
        try {
            AlgorithmID algorithmID = (AlgorithmID)AlgorithmID.rsaEncryption.clone();
            ASN1 aSN1 = new ASN1((ASN1Object)new INTEGER(new BigInteger(1, byArray15)));
            byte[] byArray16 = aSN1.toByteArray();
            SEQUENCE sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent((ASN1Object)new INTEGER(new BigInteger(1, byArray14)));
            sEQUENCE.addComponent((ASN1Object)new INTEGER(new BigInteger(1, byArray13)));
            algorithmID.setParameter((ASN1Object)sEQUENCE);
            SEQUENCE sEQUENCE3 = new SEQUENCE();
            sEQUENCE3.addComponent((ASN1Object)new INTEGER(0));
            sEQUENCE3.addComponent(algorithmID.toASN1Object());
            sEQUENCE3.addComponent((ASN1Object)new OCTET_STRING(byArray16));
            byArray = DerCoder.encode((ASN1Object)sEQUENCE3);
        }
        catch (CodingException codingException) {
            throw new InvalidKeySpecException("Error during encoding of DH private key: " + codingException.toString());
        }
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
        return var1_32;
    }

    protected void verifyPublicKeyExtractable(DHPublicKey key) throws NonExtractableComponentException, IAIKPkcs11Exception {
        ByteArrayAttribute byteArrayAttribute;
        ByteArrayAttribute byteArrayAttribute2 = key.getBase();
        ByteArrayAttribute byteArrayAttribute3 = key.getPrime();
        byteArrayAttribute = byteArrayAttribute.getValue();
        if (!byteArrayAttribute2.isStateKnown()) {
            throw new NonExtractableComponentException("The PKCS#11 DH key object's base attribute is either not present or sensitive.");
        }
        if (!byteArrayAttribute3.isStateKnown()) {
            throw new NonExtractableComponentException("The PKCS#11 DH key object's prime attribute is either not present or sensitive.");
        }
        if (!byteArrayAttribute.isStateKnown()) {
            throw new NonExtractableComponentException("The PKCS#11 DH key object's value attribute is either not present or sensitive.");
        }
        if (!byteArrayAttribute2.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DH key object does not possess a base attribute.");
        }
        if (!byteArrayAttribute3.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DH key object does not possess a prime attribute.");
        }
        if (!byteArrayAttribute.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DH key object does not possess a value attribute.");
        }
        if (byteArrayAttribute2.isSensitive()) {
            throw new NonExtractableComponentException("The PKCS#11 DH key object's base attribute is sensitive.");
        }
        if (byteArrayAttribute3.isSensitive()) {
            throw new NonExtractableComponentException("The PKCS#11 DH key object's prime attribute is sensitive.");
        }
        if (byteArrayAttribute.isSensitive()) {
            throw new NonExtractableComponentException("The PKCS#11 DH key object's value attribute is sensitive.");
        }
    }

    protected void verifyPrivateKeyExtractable(DHPrivateKey key) throws NonExtractableComponentException, IAIKPkcs11Exception {
        ByteArrayAttribute byteArrayAttribute;
        ByteArrayAttribute byteArrayAttribute2 = key.getBase();
        ByteArrayAttribute byteArrayAttribute3 = key.getPrime();
        byteArrayAttribute = byteArrayAttribute.getValue();
        if (!byteArrayAttribute2.isStateKnown()) {
            throw new NonExtractableComponentException("The PKCS#11 DH key object's base attribute is either not present or sensitive.");
        }
        if (!byteArrayAttribute3.isStateKnown()) {
            throw new NonExtractableComponentException("The PKCS#11 DH key object's prime attribute is either not present or sensitive.");
        }
        if (!byteArrayAttribute.isStateKnown()) {
            throw new NonExtractableComponentException("The PKCS#11 DH key object's value attribute is either not present or sensitive.");
        }
        if (!byteArrayAttribute2.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DH key object does not possess a base attribute.");
        }
        if (!byteArrayAttribute3.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DH key object does not possess a prime attribute.");
        }
        if (!byteArrayAttribute.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 DH key object does not possess a value attribute.");
        }
        if (byteArrayAttribute2.isSensitive()) {
            throw new NonExtractableComponentException("The PKCS#11 DH key object's base attribute is sensitive.");
        }
        if (byteArrayAttribute3.isSensitive()) {
            throw new NonExtractableComponentException("The PKCS#11 DH key object's prime attribute is sensitive.");
        }
        if (byteArrayAttribute.isSensitive()) {
            throw new NonExtractableComponentException("The PKCS#11 DH key object's value attribute is sensitive.");
        }
    }

    private static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

