/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keyfactories;

import iaik.pkcs.pkcs11.objects.DES2SecretKey;
import iaik.pkcs.pkcs11.objects.DES3SecretKey;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec;
import iaik.pkcs.pkcs11.provider.keyfactories.SecretKeyFactory;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11Key;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey;
import iaik.pkcs.pkcs11.provider.spec.PKCS11Spec;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class DesEdeKeyFactory
extends SecretKeyFactory {
    protected static final String ALGORITHM_NAME = "DESede";
    private static Class a;
    private static Class b;
    private static Class c;

    protected iaik.pkcs.pkcs11.objects.Object createKeyCreationTemplate(KeySpec keySpec) throws InvalidKeySpecException {
        Object object;
        this.validateKeySpec(keySpec);
        if (keySpec instanceof SecretKeySpec) {
            object = ((SecretKeySpec)keySpec).getEncoded();
        } else if (object instanceof DESedeKeySpec) {
            object = ((DESedeKeySpec)object).getKey();
        } else {
            throw new InvalidKeySpecException("The given key spec is invalid. It must be either aSecretKeySpec or a DESedeKeySpec.");
        }
        if (((byte[])object).length == 16) {
            DES2SecretKey dES2SecretKey = new DES2SecretKey();
            dES2SecretKey.getValue().setByteArrayValue(object);
            object = dES2SecretKey;
        } else {
            DES3SecretKey dES3SecretKey = new DES3SecretKey();
            dES3SecretKey.getValue().setByteArrayValue(object);
            object = dES3SecretKey;
        }
        return object;
    }

    protected KeySpec pkcs11GetKeySpec(SecretKey key, Class keySpecClass) throws InvalidKeySpecException {
        KeySpec keySpec;
        Object object;
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        if (keySpecClass == null) {
            throw new NullPointerException("Argument \"keySpecClass\" must not be null.");
        }
        if (!(key instanceof IAIKPKCS11SecretKey)) {
            throw new InvalidKeySpecException("For this factory, the key must be a IAIKPKCS11SecretKey.");
        }
        object = (IAIKPKCS11SecretKey)object;
        object = ((IAIKPKCS11Key)object).getKeyObject();
        byte[] byArray = this.extractKeyMaterial((Key)object);
        if (keySpecClass.equals(a == null ? (a = DesEdeKeyFactory.a("javax.crypto.spec.SecretKeySpec")) : a)) {
            object = new SecretKeySpec(byArray, this.getAlgorithmName());
        } else if (keySpecClass.equals(b == null ? (b = DesEdeKeyFactory.a("javax.crypto.spec.DESedeKeySpec")) : b)) {
            try {
                object = new DESedeKeySpec(byArray);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new InvalidKeySpecException("The key value of the given spec is invalid: " + invalidKeyException.toString());
            }
        } else if (keySpec.equals(c == null ? (c = DesEdeKeyFactory.a("iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec")) : c)) {
            keySpec = new SecretKeySpec(byArray, this.getAlgorithmName());
            boolean bl = object.getPrivate().getBooleanValue();
            keySpec = new PKCS11KeySpec(keySpec, null);
            if (bl) {
                ((PKCS11Spec)keySpec).setUseUserRole(true);
            }
            object = keySpec;
        } else {
            throw new InvalidKeySpecException("The given key spec class is invalid. It must be of eitherSecretKeySpec or DESedeKeySpec.");
        }
        return object;
    }

    protected String getAlgorithmName() {
        return ALGORITHM_NAME;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isAlgorithmAccepted(String algorithmName) {
        void var1_1;
        return algorithmName != null && var1_1.equalsIgnoreCase(ALGORITHM_NAME);
    }

    protected void validateKeySpec(KeySpec keySpec) throws InvalidKeySpecException {
        Object object;
        if (keySpec == null) {
            throw new NullPointerException("Argument \"keySpec\" must not be null.");
        }
        if (keySpec instanceof SecretKeySpec) {
            object = (SecretKeySpec)keySpec;
            String string = ((SecretKeySpec)object).getAlgorithm();
            if (!this.isAlgorithmAccepted(string)) {
                throw new InvalidKeySpecException("The algorithm of the given spec is unsupported: " + string);
            }
            if (!this.isFormatAccepted((String)(object = ((SecretKeySpec)object).getAlgorithm()))) {
                throw new InvalidKeySpecException("The format of the key encoding of the given spec is unsupported: " + (String)object);
            }
            return;
        }
        if (!(object instanceof DESedeKeySpec)) {
            throw new InvalidKeySpecException("The key spec must be of type javax.crypto.spec.SecretKeySpec.");
        }
    }

    private static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

