/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keyagreements;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.objects.DHPublicKey;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.X942DHPrivateKey;
import iaik.pkcs.pkcs11.objects.X942DHPublicKey;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.parameters.X942DH1KeyDerivationParameters;
import iaik.pkcs.pkcs11.provider.keyagreements.PKCS11KeyAgreement;
import iaik.pkcs.pkcs11.provider.keyagreements.PKCS11X942DhKeyAgreementParameterSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class X942DhKeyAgreement
extends PKCS11KeyAgreement {
    protected static String KEY_AGREEMENT_ALGORITHM_NAME = "DH/X9.42";
    protected Mechanism mechanism_;

    /*
     * WARNING - void declaration
     */
    protected void pkcs11Init(java.security.Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (params == null || !(params instanceof PKCS11X942DhKeyAgreementParameterSpec)) {
            throw new InvalidAlgorithmParameterException("params must be null or instance of X942DhKeyAgreementParameterSpec");
        }
        super.pkcs11Init((java.security.Key)var1_1, (AlgorithmParameterSpec)var2_2, (SecureRandom)var3_3);
    }

    protected Mechanism[] getUsedMechanisms() {
        if (this.usedMechanisms_ == null) {
            this.usedMechanisms_ = new Mechanism[]{Mechanism.get((long)49L)};
        }
        return this.usedMechanisms_;
    }

    protected String getAlgorithmName() {
        return KEY_AGREEMENT_ALGORITHM_NAME;
    }

    /*
     * WARNING - void declaration
     */
    protected void checkInitKeyObject(Key key) throws InvalidKeyException {
        void var1_1;
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        if (!(var1_1 instanceof X942DHPrivateKey)) {
            throw new InvalidKeyException("key must be of instance X942DHPrivateKey.");
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void checkPhaseKeyObject(Key key) throws InvalidKeyException {
        void var1_1;
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        if (!(var1_1 instanceof X942DHPublicKey)) {
            throw new InvalidKeyException("key must be of instance X942DHPublicKey.");
        }
    }

    protected int getMaxSecretLength(Key phaseKey) {
        return ((DHPublicKey)phaseKey).getPrime().getByteArrayValue().length;
    }

    protected Mechanism getMechanism() {
        if (this.keyAgreementSpecChanged_) {
            Mechanism mechanism = Mechanism.get((long)49L);
            Object object = this.phaseKey_.getKeyObject();
            if (object != null) {
                object = (DHPublicKey)object;
                object = object.getValue().getByteArrayValue();
                PKCS11X942DhKeyAgreementParameterSpec pKCS11X942DhKeyAgreementParameterSpec = (PKCS11X942DhKeyAgreementParameterSpec)this.keyAgreementSpec_;
                object = new X942DH1KeyDerivationParameters(pKCS11X942DhKeyAgreementParameterSpec.getKeyDerivationFunctionType(), pKCS11X942DhKeyAgreementParameterSpec.getOtherInfo(), (byte[])object);
                mechanism.setParameters((Parameters)object);
            }
            this.mechanism_ = mechanism;
            this.keyAgreementSpecChanged_ = false;
        }
        return this.mechanism_;
    }
}

