/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keyagreements;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.AESSecretKey;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.BlowfishSecretKey;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.CAST128SecretKey;
import iaik.pkcs.pkcs11.objects.CAST3SecretKey;
import iaik.pkcs.pkcs11.objects.CASTSecretKey;
import iaik.pkcs.pkcs11.objects.DES3SecretKey;
import iaik.pkcs.pkcs11.objects.DESSecretKey;
import iaik.pkcs.pkcs11.objects.GenericSecretKey;
import iaik.pkcs.pkcs11.objects.IDEASecretKey;
import iaik.pkcs.pkcs11.objects.RC2SecretKey;
import iaik.pkcs.pkcs11.objects.RC4SecretKey;
import iaik.pkcs.pkcs11.objects.RC5SecretKey;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.objects.TwofishSecretKey;
import iaik.pkcs.pkcs11.provider.DelegateProvider;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.PKCS11EngineClass;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.provider.keyagreements.PKCS11KeyAgreementSpec;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11Key;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Hashtable;
import javax.crypto.KeyAgreement;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.ShortBufferException;

public abstract class PKCS11KeyAgreement
extends KeyAgreementSpi
implements PKCS11EngineClass {
    protected TokenManager tokenManager_;
    protected Session session_;
    protected PKCS11KeyAgreementSpec keyAgreementSpec_;
    protected boolean keyAgreementSpecChanged_;
    protected boolean initialized_;
    protected boolean pkcs11OperationInitialized_;
    protected IAIKPKCS11Key initKey_;
    protected iaik.pkcs.pkcs11.objects.Key initKeyObject_;
    protected IAIKPKCS11Key phaseKey_;
    protected boolean currentKeyIsSoftwareKey_;
    protected KeyAgreement softwareDelegate_;
    protected Mechanism[] usedMechanisms_;
    protected MechanismInfo[][] usedMechanismInfos_;

    protected Mechanism[] getUsedMechanisms() {
        if (this.usedMechanisms_ == null) {
            Mechanism mechanism = (Mechanism)this.getMechanism().clone();
            mechanism.setParameters(null);
            this.usedMechanisms_ = new Mechanism[]{mechanism};
        }
        return this.usedMechanisms_;
    }

    protected MechanismInfo[][] getUsedMechanismFeatures() {
        if (this.usedMechanismInfos_ == null) {
            MechanismInfo mechanismInfo = new MechanismInfo();
            mechanismInfo.setDerive(true);
            this.usedMechanismInfos_ = new MechanismInfo[][]{{mechanismInfo}};
        }
        return this.usedMechanismInfos_;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isSupportedBy(TokenManager tokenManager) {
        boolean bl;
        try {
            void var1_1;
            Mechanism[] mechanismArray = this.getUsedMechanisms();
            MechanismInfo[][] mechanismInfoArray = this.getUsedMechanismFeatures();
            bl = var1_1.isMechanismFeatureSupported(mechanismArray, mechanismInfoArray);
        }
        catch (TokenException tokenException) {
            bl = false;
        }
        return bl;
    }

    protected abstract void checkInitKeyObject(iaik.pkcs.pkcs11.objects.Key var1) throws InvalidKeyException;

    protected abstract void checkPhaseKeyObject(iaik.pkcs.pkcs11.objects.Key var1) throws InvalidKeyException;

    /*
     * WARNING - void declaration
     */
    protected void engineInit(Key key, SecureRandom random) throws InvalidKeyException {
        key = IAIKPkcs11.getGlobalKeyHandler().handleKeyAgreementKey(this.getAlgorithmName(), key, null);
        if (key instanceof IAIKPKCS11Key) {
            this.pkcs11Init(key, random);
            this.currentKeyIsSoftwareKey_ = false;
            return;
        }
        if (IAIKPkcs11.isEnableSoftwareDelegation()) {
            void var2_2;
            void var1_1;
            if (this.softwareDelegate_ == null) {
                this.initializeSoftwareDelegate();
            }
            this.softwareDelegate_.init((Key)var1_1, (SecureRandom)var2_2);
            this.currentKeyIsSoftwareKey_ = true;
            return;
        }
        throw new InvalidKeyException("The current key is not a key of this provider, but software delegation is disabled.");
    }

    protected void initializeSession() {
        try {
            if (this.session_ == null) {
                Session session = this.session_ = this.keyAgreementSpec_.isUseROSession() ? this.tokenManager_.getSession(false) : this.tokenManager_.getSession(true);
            }
            if (this.keyAgreementSpec_.isUseUserSession()) {
                this.tokenManager_.makeAuthorizedSession(this.session_, null);
            }
            return;
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    protected void initializePkcs11Operation() {
        this.initializeSession();
        this.pkcs11OperationInitialized_ = true;
    }

    protected void finalizePkcs11Operation() {
        this.pkcs11OperationInitialized_ = false;
        this.tokenManager_.disposeSession(this.session_);
        this.session_ = null;
    }

    protected void initializeSoftwareDelegate() {
        DelegateProvider delegateProvider = this.tokenManager_ != null ? this.tokenManager_.getProvider().getDelegateProvider() : IAIKPkcs11.getGlobalDelegateProvider();
        String string = this.getAlgorithmName();
        this.softwareDelegate_ = delegateProvider.getKeyAgreement(string);
        if (this.softwareDelegate_ == null) {
            throw new IAIKPkcs11Exception("Could not get delegate key agreement engine for " + string);
        }
    }

    protected abstract String getAlgorithmName();

    protected void pkcs11Init(Key key, SecureRandom random) throws InvalidKeyException {
        iaik.pkcs.pkcs11.objects.Key key2;
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        if (!(key instanceof IAIKPKCS11Key)) {
            throw new InvalidKeyException("Argument \"key\" must be of type IAIKPKCS11Key.");
        }
        IAIKPkcs11 iAIKPkcs11 = IAIKPkcs11.getCurrentProviderInstance();
        if (iAIKPkcs11 == null) {
            throw new IAIKPkcs11Exception("No IAIKPkcs11 provider available.");
        }
        this.initKey_ = (IAIKPKCS11Key)key2;
        key2 = this.initKey_.getKeyObject();
        this.checkInitKeyObject(key2);
        this.initKeyObject_ = key2;
        this.tokenManager_ = iAIKPkcs11.getTokenManager();
        this.keyAgreementSpec_ = (PKCS11KeyAgreementSpec)new PKCS11KeyAgreementSpec(null).setUseUserRole(false);
        this.initializePkcs11Operation();
        this.initialized_ = true;
    }

    /*
     * WARNING - void declaration
     */
    protected void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        key = IAIKPkcs11.getGlobalKeyHandler().handleKeyAgreementKey(this.getAlgorithmName(), key, params);
        if (key instanceof IAIKPKCS11Key) {
            this.pkcs11Init(key, params, random);
            this.currentKeyIsSoftwareKey_ = false;
            return;
        }
        if (IAIKPkcs11.isEnableSoftwareDelegation()) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (this.softwareDelegate_ == null) {
                this.initializeSoftwareDelegate();
            }
            this.softwareDelegate_.init((Key)var1_1, (AlgorithmParameterSpec)var2_2, (SecureRandom)var3_3);
            this.currentKeyIsSoftwareKey_ = true;
            return;
        }
        throw new InvalidKeyException("The current key is not a key of this provider, but software delegation is disabled.");
    }

    /*
     * WARNING - void declaration
     */
    protected void pkcs11Init(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        void var2_2;
        iaik.pkcs.pkcs11.objects.Key key2;
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        if (!(key instanceof IAIKPKCS11Key)) {
            throw new InvalidKeyException("Argument \"key\" must be of type IAIKPKCS11Key.");
        }
        if (params == null || !(params instanceof PKCS11KeyAgreementSpec)) {
            throw new InvalidAlgorithmParameterException("params must be null or instance of PKCS11KeyAgreementSpec");
        }
        this.initKey_ = (IAIKPKCS11Key)key2;
        key2 = this.initKey_.getKeyObject();
        this.checkInitKeyObject(key2);
        this.initKeyObject_ = key2;
        this.keyAgreementSpec_ = (PKCS11KeyAgreementSpec)var2_2;
        this.tokenManager_ = this.keyAgreementSpec_.getTokenManager();
        this.initializePkcs11Operation();
        this.initialized_ = true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Key engineDoPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        key = IAIKPkcs11.getGlobalKeyHandler().handleKeyAgreementPhaseKey(this.getAlgorithmName(), key);
        if (!this.currentKeyIsSoftwareKey_) void var2_2;
        Key key2;
        return this.pkcs11DoPhase(key2, (boolean)var2_2);
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new InvalidKeyException("The current key is not a key of this provider, but software delegation is disabled.");
        return this.softwareDelegate_.doPhase(key, lastPhase);
    }

    /*
     * WARNING - void declaration
     */
    protected Key pkcs11DoPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        void var1_1;
        void var2_2;
        if (!this.initialized_) {
            throw new IllegalStateException("Key agreement not initialized!");
        }
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        if (!(key instanceof IAIKPKCS11Key)) {
            throw new InvalidKeyException("Argument \"key\" must be of type IAIKPKCS11Key.");
        }
        if (var2_2 == false) {
            throw new IllegalStateException("Multiple phases are unsupported");
        }
        this.phaseKey_ = (IAIKPKCS11Key)var1_1;
        PKCS11KeyAgreement pKCS11KeyAgreement = this;
        pKCS11KeyAgreement.checkPhaseKeyObject(pKCS11KeyAgreement.phaseKey_.getKeyObject());
        this.keyAgreementSpecChanged_ = true;
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        if (!this.currentKeyIsSoftwareKey_) return this.pkcs11GenerateSecret();
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.softwareDelegate_.generateSecret();
    }

    protected byte[] pkcs11GenerateSecret() throws IllegalStateException {
        if (!this.initialized_) {
            throw new IllegalStateException("Key agreement not initialized!");
        }
        Object object = this.a(null, false);
        object = object.getAttributeTable();
        object = (object = (ByteArrayAttribute)object.get(Attribute.VALUE)) != null && object.isStateKnown() && object.isPresent() && !object.isSensitive() ? (Object)object.getByteArrayValue() : null;
        return object;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int engineGenerateSecret(byte[] sharedSecret, int offset) throws IllegalStateException, ShortBufferException {
        if (!this.currentKeyIsSoftwareKey_) void var2_3;
        void var1_1;
        return this.pkcs11GenerateSecret((byte[])var1_1, (int)var2_3);
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.softwareDelegate_.generateSecret(sharedSecret, offset);
    }

    /*
     * WARNING - void declaration
     */
    protected int pkcs11GenerateSecret(byte[] sharedSecret, int offset) throws IllegalStateException, ShortBufferException {
        byte[] byArray = this.engineGenerateSecret();
        int n = -1;
        if (byArray != null) {
            void var2_2;
            void var1_1;
            n = byArray.length;
            if (sharedSecret == null) {
                throw new NullPointerException("Argument \"sharedSecret\" must not be null.");
            }
            if (n > sharedSecret.length - offset) {
                throw new ShortBufferException("Buffer too small. Bytes available: " + (sharedSecret.length - offset) + ", bytes needed: " + n);
            }
            System.arraycopy(byArray, 0, var1_1, (int)var2_2, n);
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected javax.crypto.SecretKey engineGenerateSecret(String algorithm) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        if (!this.currentKeyIsSoftwareKey_) javax.crypto.SecretKey secretKey;
        return this.pkcs11GenerateSecret((String)((Object)secretKey));
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new InvalidKeyException("The current key is not a key of this provider, but software delegation is disabled.");
        return this.softwareDelegate_.generateSecret(algorithm);
    }

    protected javax.crypto.SecretKey pkcs11GenerateSecret(String algorithm) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        IAIKPKCS11SecretKey iAIKPKCS11SecretKey;
        iaik.pkcs.pkcs11.objects.Key key;
        if (!this.initialized_) {
            throw new IllegalStateException("Key agreement not initialized!");
        }
        if ((key = this.a((String)key, true)) instanceof SecretKey) {
            iAIKPKCS11SecretKey = IAIKPKCS11SecretKey.create(this.tokenManager_, (SecretKey)key);
            if (!key.getToken().getBooleanValue().booleanValue()) {
                iAIKPKCS11SecretKey.setSession(this.session_);
                this.session_ = null;
                this.pkcs11OperationInitialized_ = false;
            }
        } else {
            this.finalizePkcs11Operation();
            throw new IAIKPkcs11Exception("Expected a secret key, key derivation returned key: " + key);
        }
        this.tokenManager_.notifyKeyStores();
        return iAIKPKCS11SecretKey;
    }

    private iaik.pkcs.pkcs11.objects.Key a(String object, boolean bl) {
        Mechanism mechanism = this.getMechanism();
        Object object2 = null;
        if (this.keyAgreementSpec_ != null) {
            object2 = this.keyAgreementSpec_.getKeyTemplate();
        }
        if (object2 == null) {
            Object object3;
            object2 = object;
            object = this;
            if (object2 == null || ((String)object2).equals("")) {
                object2 = new GenericSecretKey();
                Object object4 = object;
                object2.getValueLen().setLongValue(new Long(((PKCS11KeyAgreement)object4).getMaxSecretLength(((PKCS11KeyAgreement)object4).phaseKey_.getKeyObject())));
                object3 = object2;
            } else if (((String)object2).equalsIgnoreCase("AES")) {
                object2 = new AESSecretKey();
                object2.getValueLen().setLongValue(Long.valueOf(16L));
                object3 = object2;
            } else if (((String)object2).equalsIgnoreCase("DESede")) {
                object2 = new DES3SecretKey();
                object3 = object2;
            } else if (((String)object2).equalsIgnoreCase("RC4")) {
                object2 = new RC4SecretKey();
                object2.getValueLen().setLongValue(Long.valueOf(16L));
                object3 = object2;
            } else if (((String)object2).equalsIgnoreCase("DES")) {
                object2 = new DESSecretKey();
                object3 = object2;
            } else if (((String)object2).equalsIgnoreCase("IDEA")) {
                object2 = new IDEASecretKey();
                object3 = object2;
            } else if (((String)object2).equalsIgnoreCase("RC2")) {
                object2 = new RC2SecretKey();
                object2.getValueLen().setLongValue(Long.valueOf(16L));
                object3 = object2;
            } else if (((String)object2).equalsIgnoreCase("RC5")) {
                object2 = new RC5SecretKey();
                object2.getValueLen().setLongValue(Long.valueOf(16L));
                object3 = object2;
            } else if (((String)object2).equalsIgnoreCase("BLOWFISH")) {
                object2 = new BlowfishSecretKey();
                object2.getValueLen().setLongValue(Long.valueOf(16L));
                object3 = object2;
            } else if (((String)object2).equalsIgnoreCase("TWOFISH")) {
                object2 = new TwofishSecretKey();
                object2.getValueLen().setLongValue(Long.valueOf(16L));
                object3 = object2;
            } else if (((String)object2).equalsIgnoreCase("CAST128") || ((String)object2).equalsIgnoreCase("CAST5")) {
                object2 = new CAST128SecretKey();
                object2.getValueLen().setLongValue(Long.valueOf(16L));
                object3 = object2;
            } else if (((String)object2).equalsIgnoreCase("CAST3")) {
                object2 = new CAST3SecretKey();
                object2.getValueLen().setLongValue(Long.valueOf(8L));
                object3 = object2;
            } else if (((String)object2).equalsIgnoreCase("CAST")) {
                object2 = new CASTSecretKey();
                object2.getValueLen().setLongValue(Long.valueOf(8L));
                object3 = object2;
            } else {
                object2 = new GenericSecretKey();
                Object object5 = object;
                object2.getValueLen().setLongValue(new Long(((PKCS11KeyAgreement)object5).getMaxSecretLength(((PKCS11KeyAgreement)object5).phaseKey_.getKeyObject())));
                object3 = object2;
            }
            object = object3;
            object3.getSensitive().setBooleanValue(Boolean.valueOf(bl));
            object.getToken().setBooleanValue(Boolean.FALSE);
            object.getPrivate().setBooleanValue(Boolean.TRUE);
            object2 = object;
        }
        try {
            return this.session_.deriveKey(mechanism, this.initKeyObject_, (iaik.pkcs.pkcs11.objects.Key)object2);
        }
        catch (TokenException tokenException) {
            this.finalizePkcs11Operation();
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    protected byte[] extractValue(SecretKey secretKeyObject) {
        Object object;
        if (secretKeyObject == null) {
            throw new NullPointerException("Argument \"secretKeyObject\" must not be null.");
        }
        object = object.getAttributeTable();
        object = (object = (ByteArrayAttribute)((Hashtable)object).get(Attribute.VALUE)) != null && object.isStateKnown() && object.isPresent() && !object.isSensitive() ? (Object)object.getByteArrayValue() : null;
        return object;
    }

    protected abstract Mechanism getMechanism();

    protected abstract int getMaxSecretLength(iaik.pkcs.pkcs11.objects.Key var1);

    protected void finalize() throws Throwable {
        if (this.session_ != null) {
            this.finalizePkcs11Operation();
        }
        super.finalize();
    }
}

