/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.hashes;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.provider.DelegateProvider;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.PKCS11EngineClass;
import iaik.pkcs.pkcs11.provider.TokenManager;
import java.security.MessageDigest;

public abstract class PKCS11Hash
extends MessageDigest
implements PKCS11EngineClass {
    protected TokenManager tokenManager_;
    protected Session session_;
    protected int hashValueLength_;
    protected Mechanism mechanism_;
    protected Mechanism[] usedMechanisms_;
    protected MechanismInfo[][] usedMechanismInfos_;
    protected boolean initialized_;
    protected boolean pkcs11OperationInitialized_;
    protected boolean useSoftwareDelegate_;
    protected MessageDigest softwareDelegate_;

    /*
     * WARNING - void declaration
     */
    protected PKCS11Hash(String algorithmName, int hashValueLength, Mechanism mechanism) {
        super((String)var1_1);
        void var3_3;
        void var2_2;
        void var1_1;
        if (hashValueLength < 0) {
            throw new NullPointerException("Argument \"hashValueLength\" must be >= 0.");
        }
        if (mechanism == null) {
            throw new NullPointerException("Argument \"mechanism\" must not be null.");
        }
        this.hashValueLength_ = var2_2;
        this.mechanism_ = var3_3;
    }

    protected int engineGetDigestLength() {
        int n = this.useSoftwareDelegate_ ? this.softwareDelegate_.getDigestLength() : this.hashValueLength_;
        return n;
    }

    /*
     * WARNING - void declaration
     */
    protected void engineUpdate(byte input) {
        void var1_1;
        if (!this.initialized_) {
            this.initialize();
        }
        if (this.useSoftwareDelegate_) {
            this.softwareDelegate_.update(input);
            return;
        }
        if (!this.pkcs11OperationInitialized_) {
            try {
                this.initializePkcs11Operation();
            }
            catch (TokenException tokenException) {
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 hash for next operation: " + tokenException.toString());
            }
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = byArray;
        byArray[0] = var1_1;
        try {
            this.session_.digestUpdate(byArray2);
            return;
        }
        catch (TokenException tokenException) {
            this.finalizePkcs11Operation();
            throw new IAIKPkcs11Exception("Error updating digest: " + (Object)((Object)tokenException));
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void engineUpdate(byte[] data, int offset, int length) {
        byte[] byArray;
        if (data == null) {
            throw new NullPointerException("Argument \"data\" must not be null.");
        }
        if (offset + length > data.length) {
            throw new IllegalArgumentException("Arguments must satisfy ((offset + length) <= data.length).");
        }
        if (!this.initialized_) {
            this.initialize();
        }
        if (this.useSoftwareDelegate_) {
            this.softwareDelegate_.update(data, offset, length);
            return;
        }
        if (!this.pkcs11OperationInitialized_) {
            try {
                this.initializePkcs11Operation();
            }
            catch (TokenException tokenException) {
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 hash for next operation: " + tokenException.toString());
            }
        }
        if (offset == 0 && length == data.length) {
            byArray = data;
        } else {
            void var3_4;
            void var2_3;
            void var1_1;
            byArray = new byte[length];
            System.arraycopy(var1_1, (int)var2_3, byArray, 0, (int)var3_4);
        }
        try {
            this.session_.digestUpdate(byArray);
            return;
        }
        catch (TokenException tokenException) {
            this.finalizePkcs11Operation();
            throw new IAIKPkcs11Exception("Error updating digest: " + (Object)((Object)tokenException));
        }
    }

    protected byte[] engineDigest() {
        byte[] byArray;
        if (!this.initialized_) {
            this.initialize();
        }
        if (this.useSoftwareDelegate_) {
            byArray = this.softwareDelegate_.digest();
        } else {
            try {
                byArray = this.session_.digestFinal();
                this.pkcs11OperationInitialized_ = false;
            }
            catch (TokenException tokenException) {
                throw new IAIKPkcs11Exception("Error updating digest: " + (Object)((Object)tokenException));
            }
            finally {
                this.finalizePkcs11Operation();
            }
        }
        return byArray;
    }

    protected void engineReset() {
        if (this.useSoftwareDelegate_) {
            if (!this.initialized_) {
                this.initialize();
            }
            this.softwareDelegate_.reset();
            return;
        }
        if (!this.initialized_) {
            this.initialize();
            return;
        }
        this.finalizePkcs11Operation();
        try {
            this.initializePkcs11Operation();
            return;
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception("Error initializing the PKCS#11 digest: " + tokenException.toString());
        }
    }

    protected Mechanism[] getUsedMechanisms() {
        if (this.usedMechanisms_ == null) {
            Mechanism mechanism = (Mechanism)this.mechanism_.clone();
            mechanism.setParameters(null);
            this.usedMechanisms_ = new Mechanism[]{mechanism};
        }
        return this.usedMechanisms_;
    }

    public Mechanism getUsedMechanism() {
        return this.mechanism_;
    }

    protected MechanismInfo[][] getUsedMechanismFeatures() {
        if (this.usedMechanismInfos_ == null) {
            MechanismInfo mechanismInfo = new MechanismInfo();
            mechanismInfo.setDigest(true);
            this.usedMechanismInfos_ = new MechanismInfo[][]{{mechanismInfo}};
        }
        return this.usedMechanismInfos_;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isSupportedBy(TokenManager tokenManager) {
        boolean bl;
        try {
            void var1_1;
            Mechanism[] mechanismArray = this.getUsedMechanisms();
            MechanismInfo[][] mechanismInfoArray = this.getUsedMechanismFeatures();
            bl = var1_1.isMechanismFeatureSupported(mechanismArray, mechanismInfoArray);
        }
        catch (TokenException tokenException) {
            bl = false;
        }
        return bl;
    }

    public TokenManager getTokenManager() {
        return this.tokenManager_;
    }

    protected void initialize() {
        block4: {
            IAIKPkcs11 iAIKPkcs11 = (IAIKPkcs11)this.getProvider();
            this.tokenManager_ = iAIKPkcs11.getTokenManager();
            try {
                PKCS11Hash pKCS11Hash = this;
                if (pKCS11Hash.isSupportedBy(pKCS11Hash.tokenManager_)) {
                    this.initializePkcs11Operation();
                    this.useSoftwareDelegate_ = false;
                    break block4;
                }
                if (IAIKPkcs11.isEnableSoftwareDelegation()) {
                    this.initializeSoftwareDelegate();
                    this.useSoftwareDelegate_ = true;
                    break block4;
                }
                throw new IAIKPkcs11Exception("Software delegation is disabled and the current token does not support: " + this.mechanism_.toString());
            }
            catch (TokenException tokenException) {
                throw new IAIKPkcs11Exception("Error initializing the PKCS#11 digest: " + tokenException.toString());
            }
        }
        this.initialized_ = true;
    }

    protected void initializeSession() throws TokenException {
        if (this.session_ == null) {
            this.session_ = this.tokenManager_.getSession(false);
        }
        this.tokenManager_.makeAuthorizedSession(this.session_, null);
    }

    protected void initializePkcs11Operation() throws TokenException {
        this.initializeSession();
        this.session_.digestInit(this.mechanism_);
        this.pkcs11OperationInitialized_ = true;
    }

    protected void finalizePkcs11Operation() {
        if (this.pkcs11OperationInitialized_) {
            try {
                this.session_.digestFinal();
            }
            catch (TokenException tokenException) {}
        }
        this.pkcs11OperationInitialized_ = false;
        this.tokenManager_.disposeSession(this.session_);
        this.session_ = null;
    }

    protected void initializeSoftwareDelegate() {
        DelegateProvider delegateProvider = this.tokenManager_ != null ? this.tokenManager_.getProvider().getDelegateProvider() : IAIKPkcs11.getGlobalDelegateProvider();
        String string = this.getAlgorithm();
        this.softwareDelegate_ = delegateProvider.getMessageDigest(string);
        if (this.softwareDelegate_ == null) {
            throw new IAIKPkcs11Exception("Could not get delegate message digest engine for " + string);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setTokenManager(TokenManager tokenManager) {
        void var1_1;
        if (tokenManager == null) {
            throw new NullPointerException("Argument \"tokenManager\" must not be null.");
        }
        this.tokenManager_ = var1_1;
        if (!this.initialized_) {
            this.initialize();
        }
    }

    protected void finalize() throws Throwable {
        if (this.session_ != null) {
            this.finalizePkcs11Operation();
        }
        super.finalize();
    }
}

