/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.cms;

import iaik.asn1.structures.AlgorithmID;
import iaik.cms.CMSAlgorithmID;
import iaik.cms.DigestInfo;
import iaik.cms.ecc.IaikEccProvider;
import iaik.pkcs.pkcs1.RSAPssParameterSpec;
import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.parameters.RSAPkcsPssParameters;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11Key;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PrivateKey;
import iaik.pkcs.pkcs11.provider.signatures.PKCS11SignatureParameterSpec;
import iaik.security.cipher.SecretKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class IaikPkcs11CmsSecurityProvider
extends IaikEccProvider {
    protected IAIKPkcs11 iaikPkcs11Provider_;

    /*
     * WARNING - void declaration
     */
    public IaikPkcs11CmsSecurityProvider(IAIKPkcs11 iaikPkcs11Provider) {
        void var1_1;
        this.iaikPkcs11Provider_ = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] calculateSignatureFromHash(AlgorithmID signatureAlgorithm, AlgorithmID digestAlgorithm, PrivateKey privateKey, byte[] digest) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature signature;
        Object object;
        if (privateKey instanceof IAIKPKCS11PrivateKey) {
            byte[] byArray;
            block10: {
                IAIKPkcs11 iAIKPkcs11 = ((IAIKPKCS11PrivateKey)privateKey).getTokenManager().getProvider();
                String string = signatureAlgorithm.getImplementationName();
                byArray = digest;
                try {
                    if (string.startsWith("RSA")) {
                        if (signatureAlgorithm.equals((Object)CMSAlgorithmID.rsassaPss)) {
                            digest = Signature.getInstance("RawRSA/PSS", iAIKPkcs11.getName());
                            object = IaikPkcs11CmsSecurityProvider.a(digestAlgorithm, signatureAlgorithm);
                            try {
                                signature.setParameter((AlgorithmParameterSpec)object);
                                break block10;
                            }
                            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                                throw new SignatureException("Error setting RSA-PSS algorithm parameters: " + invalidAlgorithmParameterException.toString());
                            }
                        }
                        DigestInfo digestInfo = new DigestInfo(digestAlgorithm, (byte[])signature);
                        object = digestInfo;
                        byArray = digestInfo.toByteArray();
                        signature = Signature.getInstance("RawRSA/PKCS1", iAIKPkcs11.getName());
                        break block10;
                    }
                    if (string.equals("DSA")) {
                        signature = Signature.getInstance("RawDSA", iAIKPkcs11.getName());
                        break block10;
                    }
                    if (string.indexOf("ECDSA") != -1) {
                        signature = Signature.getInstance("RawECDSA", iAIKPkcs11.getName());
                        break block10;
                    }
                    throw new NoSuchAlgorithmException("Unable to calculate signature with signature algorithm: " + string);
                }
                catch (NoSuchProviderException noSuchProviderException) {
                    throw new NoSuchAlgorithmException("The PKCS#11 provider has not been installed corerctly: " + noSuchProviderException);
                }
            }
            signature.initSign(privateKey);
            signature.update(byArray);
            object = signature.sign();
        } else {
            void var3_5;
            void var2_4;
            object = super.calculateSignatureFromHash((AlgorithmID)object, (AlgorithmID)var2_4, (PrivateKey)var3_5, (byte[])signature);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] calculateSignatureFromSignedAttributes(AlgorithmID signatureAlgorithm, AlgorithmID digestAlgorithm, PrivateKey privateKey, byte[] signedAttributes) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        void var3_3;
        void var2_2;
        void var1_1;
        byte[] byArray = this.getHash(digestAlgorithm, signedAttributes);
        return this.calculateSignatureFromHash((AlgorithmID)var1_1, (AlgorithmID)var2_2, (PrivateKey)var3_3, byArray);
    }

    /*
     * WARNING - void declaration
     */
    public Signature getSignature(String algorithm, int mode, Key key) throws InvalidKeyException, NoSuchAlgorithmException {
        Signature signature;
        if (key instanceof IAIKPKCS11Key) {
            try {
                signature = Signature.getInstance(algorithm, this.iaikPkcs11Provider_.getName());
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new NoSuchAlgorithmException("PKCS#11 Provider has not been installed correctly " + noSuchProviderException.toString());
            }
            if (mode == 1) {
                signature.initSign((PrivateKey)key);
            } else if (mode == 2) {
                signature.initVerify((PublicKey)key);
            }
        } else {
            void var3_4;
            void var2_3;
            signature = super.getSignature((String)((Object)signature), (int)var2_3, (Key)var3_4);
        }
        return signature;
    }

    /*
     * WARNING - void declaration
     */
    public javax.crypto.SecretKey decryptKey(byte[] encryptedKey, AlgorithmID kea, PrivateKey recipientKey, String cekAlgorithmName) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException, BadPaddingException {
        Object object;
        Object object2;
        if (recipientKey instanceof IAIKPKCS11PrivateKey) {
            IAIKPkcs11 iAIKPkcs11 = ((IAIKPKCS11PrivateKey)recipientKey).getTokenManager().getProvider();
            object2 = kea.getImplementationName();
            try {
                object2 = Cipher.getInstance((String)object2, iAIKPkcs11.getName());
                ((Cipher)object2).init(2, (Key)recipientKey, (AlgorithmParameterSpec)null, (SecureRandom)null);
                object = ((Cipher)object2).doFinal(encryptedKey);
                object = new SecretKey((byte[])object, cekAlgorithmName);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new NoSuchAlgorithmException("The PKCS#11 provider has not been installed corerctly: " + noSuchProviderException);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new NoSuchAlgorithmException("Error initializing the cipher: " + invalidAlgorithmParameterException);
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                throw new NoSuchAlgorithmException("Error during cipher operation: " + illegalBlockSizeException);
            }
        } else {
            void var3_6;
            object = super.decryptKey((byte[])object, (AlgorithmID)object2, (PrivateKey)var3_6, cekAlgorithmName);
        }
        return object;
    }

    private static PKCS11SignatureParameterSpec a(AlgorithmID algorithmID, AlgorithmID algorithmID2) throws NoSuchAlgorithmException {
        int n;
        long l2;
        Object object;
        if (algorithmID.equals((Object)AlgorithmID.sha1)) {
            object = Mechanism.get((long)544L);
            l2 = 1L;
            n = 20;
        } else if (algorithmID.equals((Object)AlgorithmID.sha224)) {
            object = Mechanism.get((long)597L);
            l2 = 5L;
            n = 28;
        } else if (algorithmID.equals((Object)AlgorithmID.sha256)) {
            object = Mechanism.get((long)592L);
            l2 = 2L;
            n = 32;
        } else if (algorithmID.equals((Object)AlgorithmID.sha384)) {
            object = Mechanism.get((long)608L);
            l2 = 3L;
            n = 48;
        } else if (algorithmID.equals((Object)AlgorithmID.sha512)) {
            object = Mechanism.get((long)624L);
            l2 = 4L;
            n = 64;
        } else if (algorithmID.equals((Object)AlgorithmID.sha3_224)) {
            object = Mechanism.get((long)693L);
            l2 = 6L;
            n = 28;
        } else if (algorithmID.equals((Object)AlgorithmID.sha3_256)) {
            object = Mechanism.get((long)592L);
            l2 = 7L;
            n = 32;
        } else if (algorithmID.equals((Object)AlgorithmID.sha3_384)) {
            object = Mechanism.get((long)704L);
            l2 = 8L;
            n = 48;
        } else if (algorithmID.equals((Object)AlgorithmID.sha3_512)) {
            object = Mechanism.get((long)720L);
            l2 = 9L;
            n = 64;
        } else {
            throw new NoSuchAlgorithmException("Cannot create RSA-PSS parameters for " + algorithmID.getName() + " digest algorithm!");
        }
        object = new RSAPkcsPssParameters(object, l2, (long)n);
        object = new PKCS11SignatureParameterSpec((Parameters)object);
        AlgorithmID algorithmID3 = (AlgorithmID)AlgorithmID.mgf1.clone();
        algorithmID3.setParameter(algorithmID.toASN1Object());
        algorithmID = new RSAPssParameterSpec(algorithmID, algorithmID3, n);
        try {
            algorithmID2.setAlgorithmParameterSpec((AlgorithmParameterSpec)algorithmID);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new NoSuchAlgorithmException(invalidAlgorithmParameterException.toString());
        }
        return object;
    }
}

