/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.ciphers;

import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.objects.PublicKey;
import iaik.pkcs.pkcs11.objects.RSAPrivateKey;
import iaik.pkcs.pkcs11.objects.RSAPublicKey;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.parameters.RSAPkcsOaepParameters;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.ciphers.PKCS11Cipher;
import iaik.pkcs.pkcs11.provider.ciphers.PKCS11OAEPParameterSpec;
import iaik.pkcs.pkcs11.provider.ciphers.PKCS11UnwrapKeySpec;
import iaik.pkcs.pkcs11.provider.hashes.PKCS11Hash;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11Key;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PrivateKey;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PublicKey;
import iaik.pkcs.pkcs11.provider.spec.PKCS11Spec;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

public class RsaCipher
extends PKCS11Cipher {
    protected static final String CIPHER_NAME = "RSA";
    protected static final String DEFAULT_MODE = "ECB";
    protected static final String DEFAULT_PADDING = "PKCS1Padding";
    protected static final Mechanism DEFAULT_MECHANISM = Mechanism.get((long)1L);
    protected static final int PKCS11_OPERATION_SIGN_VERIFY = 1;
    protected static final int PKCS11_OPERATION_ENCRYPT_DECRYPT = 2;
    private static final String[] a = new String[]{"none", "ecb"};
    private static final String[] b = new String[]{"nopadding", "pkcs1padding", "oaeppadding", "oaep", "oaepwith", "iso9796padding", "iso9796", "rawx509"};
    private static final Long[] c = new Long[]{3L, 1L, 9L, 9L, 9L, 2L, 2L, 3L};
    private static HashMap d = new HashMap<String, Mechanism>();
    protected static Vector supportedModes_;
    protected static Vector supportedPaddings_;
    protected static Hashtable cipherModePaddingMechansims_;
    protected Hashtable modePaddingMechanisms_;
    protected int pkcs11Operation_;
    protected ByteArrayOutputStream buffer_;
    private HashMap e;
    private static Class f;

    public RsaCipher() {
        this.mode_ = this.getDefaultMode();
        this.padding_ = this.getDefaultPadding();
        this.buffer_ = new ByteArrayOutputStream(128);
        this.e = null;
    }

    protected Mechanism[] getUsedMechanisms() {
        if (this.usedMechanisms_ == null) {
            Object object = new HashSet<Long>();
            ((AbstractCollection)object).addAll(Arrays.asList(c));
            this.usedMechanisms_ = new Mechanism[((HashSet)object).size()];
            int n = 0;
            object = ((HashSet)object).iterator();
            while (object.hasNext()) {
                Long l2 = (Long)object.next();
                this.usedMechanisms_[n++] = Mechanism.get((long)l2);
            }
        }
        return this.usedMechanisms_;
    }

    protected MechanismInfo[][] getUsedMechanismFeatures() {
        if (this.usedMechanismInfos_ == null) {
            MechanismInfo mechanismInfo = new MechanismInfo();
            mechanismInfo.setEncrypt(true);
            MechanismInfo mechanismInfo2 = new MechanismInfo();
            mechanismInfo2.setDecrypt(true);
            MechanismInfo mechanismInfo3 = new MechanismInfo();
            mechanismInfo3.setSign(true);
            MechanismInfo mechanismInfo4 = new MechanismInfo();
            mechanismInfo4.setVerifyRecover(true);
            MechanismInfo mechanismInfo5 = new MechanismInfo();
            mechanismInfo5.setWrap(true);
            MechanismInfo mechanismInfo6 = new MechanismInfo();
            mechanismInfo6.setUnwrap(true);
            this.usedMechanismInfos_ = new MechanismInfo[][]{{mechanismInfo, mechanismInfo2, mechanismInfo3, mechanismInfo4, mechanismInfo5, mechanismInfo6}, {mechanismInfo, mechanismInfo2, mechanismInfo3, mechanismInfo4, mechanismInfo5, mechanismInfo6}, {mechanismInfo, mechanismInfo2, mechanismInfo5, mechanismInfo6}, {mechanismInfo3, mechanismInfo4}};
        }
        return this.usedMechanismInfos_;
    }

    /*
     * WARNING - void declaration
     */
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        void var1_1;
        int n;
        if (key instanceof IAIKPKCS11Key) {
            n = this.pkcs11GetKeySize(key);
        } else if (var1_1 instanceof java.security.interfaces.RSAPrivateKey) {
            n = ((java.security.interfaces.RSAPrivateKey)var1_1).getModulus().bitLength();
        } else if (var1_1 instanceof java.security.interfaces.RSAPublicKey) {
            n = ((java.security.interfaces.RSAPublicKey)var1_1).getModulus().bitLength();
        } else {
            throw new UnsupportedOperationException("Cannot determine size of software key. Key is not a RSA key. Key is of class: " + (var1_1 != null ? var1_1.getClass().toString() : "null"));
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    protected void checkKeyObject(iaik.pkcs.pkcs11.objects.Key keyObject) throws InvalidKeyException {
        void var1_1;
        if (keyObject == null) {
            throw new NullPointerException("Argument \"keyObject\" must not be null.");
        }
        if (!(keyObject instanceof RSAPrivateKey) && !(var1_1 instanceof RSAPublicKey)) {
            throw new InvalidKeyException("PKCS#11 key object inside IAIKPKCS11Key must be of type RSA");
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void pkcs11Init(int operationMode, Key key, AlgorithmParameterSpec parameterSpecs, SecureRandom randomSource) throws InvalidAlgorithmParameterException, InvalidKeyException {
        PKCS11OAEPParameterSpec pKCS11OAEPParameterSpec;
        void var1_1;
        this.currentKeyIsSoftwareKey_ = false;
        if (operationMode != 1 && operationMode != 2 && operationMode != 4 && operationMode != 3) {
            throw new IAIKPkcs11Exception("Unknown operation mode: " + operationMode);
        }
        this.operationMode_ = var1_1;
        if (parameterSpecs != null && !(parameterSpecs instanceof PKCS11UnwrapKeySpec) && !(parameterSpecs instanceof PKCS11OAEPParameterSpec)) {
            throw new InvalidAlgorithmParameterException("AlgorithmParameterSpec not supported: " + parameterSpecs);
        }
        if (parameterSpecs instanceof PKCS11UnwrapKeySpec) {
            this.parameterSpecs_ = (PKCS11Spec)((Object)parameterSpecs);
            this.unwrapTemplate_ = ((PKCS11UnwrapKeySpec)parameterSpecs).getKeyTemplate();
        } else if (parameterSpecs instanceof PKCS11OAEPParameterSpec) {
            if (this.padding_.toLowerCase().indexOf("oaep") == -1) {
                throw new InvalidAlgorithmParameterException("OAEP parameters not allowed for non-oaep padding.");
            }
            this.parameterSpecs_ = (PKCS11Spec)((Object)parameterSpecs);
            this.paddingChanged_ = true;
        }
        this.key_ = (IAIKPKCS11Key)((Object)pKCS11OAEPParameterSpec);
        this.keyObject_ = this.key_.getKeyObject();
        RsaCipher rsaCipher = this;
        rsaCipher.checkKeyObject(rsaCipher.keyObject_);
        this.mechanism_ = this.getMechanism();
        if (parameterSpecs != null && parameterSpecs instanceof PKCS11OAEPParameterSpec) {
            void var3_4;
            RSAPkcsOaepParameters rSAPkcsOaepParameters = (RSAPkcsOaepParameters)this.mechanism_.getParameters();
            pKCS11OAEPParameterSpec = (PKCS11OAEPParameterSpec)var3_4;
            if (rSAPkcsOaepParameters.getHashAlgorithm().getMechanismCode() != pKCS11OAEPParameterSpec.getHashAlgorithm().getMechanismCode()) {
                throw new InvalidAlgorithmParameterException("OAEP parameters differ from given oaep padding.");
            }
        }
        if (this.mechanism_ == null) {
            throw new IAIKPkcs11Exception("The currently selected combination of mode and padding is not supported: " + this.mode_ + "/" + this.padding_);
        }
        this.initialize();
    }

    protected void initializePkcs11Operation() throws InvalidAlgorithmParameterException, InvalidKeyException {
        this.initializeSession();
        try {
            iaik.pkcs.pkcs11.objects.Key key = this.key_.getKeyObject();
            if (this.operationMode_ == 2) {
                if (key instanceof PublicKey) {
                    this.session_.verifyRecoverInit(this.mechanism_, key);
                    this.pkcs11Operation_ = 1;
                } else {
                    this.session_.decryptInit(this.mechanism_, this.key_.getKeyObject());
                    this.pkcs11Operation_ = 2;
                }
            } else if (this.operationMode_ == 1) {
                if (key instanceof PrivateKey) {
                    this.session_.signInit(this.mechanism_, key);
                    this.pkcs11Operation_ = 1;
                } else {
                    this.session_.encryptInit(this.mechanism_, key);
                    this.pkcs11Operation_ = 2;
                }
            }
        }
        catch (TokenException tokenException) {
            throw new InvalidKeyException("Error initializing the PKCS#11 RSA cipher: " + tokenException.toString());
        }
        this.updateUsed_ = false;
        this.pkcs11OperationInitialized_ = true;
    }

    /*
     * WARNING - void declaration
     */
    protected byte[] pkcs11Update(byte[] data, int offset, int length) {
        void var3_5;
        void var2_4;
        void var1_1;
        if (!this.initialized_ || this.key_ == null) {
            throw new IllegalStateException("Cipher not initialized.");
        }
        if (data == null) {
            throw new NullPointerException("Argument \"data\" must not be null.");
        }
        if (offset + length > data.length) {
            throw new NullPointerException("Arguments must satisfy ((offset + length) <= data.length).");
        }
        if (!this.pkcs11OperationInitialized_) {
            try {
                this.initializePkcs11Operation();
            }
            catch (InvalidKeyException invalidKeyException) {
                this.finalizePkcs11Operation();
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidKeyException.toString());
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                this.finalizePkcs11Operation();
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidAlgorithmParameterException.toString());
            }
        }
        this.buffer_.write((byte[])var1_1, (int)var2_4, (int)var3_5);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected byte[] pkcs11DoFinal(byte[] input, int inputOffset, int inputLength) throws BadPaddingException, IllegalBlockSizeException {
        byte[] byArray;
        if (!this.initialized_ || this.key_ == null) {
            throw new IllegalStateException("Cipher not initialized.");
        }
        if (input != null && inputOffset + inputLength > input.length) {
            throw new NullPointerException("Arguments must satisfy ((inputOffset + inputLength) <= input.length).");
        }
        if (!this.pkcs11OperationInitialized_) {
            try {
                this.initializePkcs11Operation();
            }
            catch (InvalidKeyException invalidKeyException) {
                this.finalizePkcs11Operation();
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidKeyException.toString());
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                this.finalizePkcs11Operation();
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidAlgorithmParameterException.toString());
            }
        }
        if (byArray != null) {
            void var3_7;
            void var2_6;
            this.buffer_.write(byArray, (int)var2_6, (int)var3_7);
        }
        byArray = this.buffer_.toByteArray();
        this.buffer_.reset();
        try {
            if (this.operationMode_ == 1) {
                byArray = this.pkcs11Operation_ == 1 ? this.session_.sign(byArray) : this.session_.encrypt(byArray);
            } else if (this.operationMode_ == 2) {
                byArray = this.pkcs11Operation_ == 1 ? this.session_.verifyRecover(byArray) : this.session_.decrypt(byArray);
            } else {
                throw new UnsupportedOperationException("Method only supported in state encrypt or decrypt.");
            }
            this.pkcs11OperationInitialized_ = false;
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception("Error finishing cipher operation: " + (Object)((Object)tokenException));
        }
        finally {
            this.finalizePkcs11Operation();
        }
        return byArray;
    }

    protected String getAlgorithmName() {
        return CIPHER_NAME;
    }

    protected int pkcs11GetOutputSize(int inputLen) {
        int n;
        if (this.initialized_) {
            try {
                RsaCipher rsaCipher = this;
                n = rsaCipher.pkcs11GetKeySize(rsaCipher.key_) + 7 >> 3;
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IAIKPkcs11Exception(invalidKeyException.toString());
            }
        } else {
            throw new IAIKPkcs11Exception("Cipher object not initialized.");
        }
        return n;
    }

    protected int pkcs11GetKeySize(Key key) throws InvalidKeyException {
        RSAPublicKey rSAPublicKey;
        int n;
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        if (key instanceof IAIKPKCS11PrivateKey) {
            key = (RSAPrivateKey)((IAIKPKCS11PrivateKey)key).getKeyObject();
            n = key.getModulus().getByteArrayValue().length << 3;
        } else if (rSAPublicKey instanceof IAIKPKCS11PublicKey) {
            rSAPublicKey = (RSAPublicKey)((IAIKPKCS11PublicKey)rSAPublicKey).getKeyObject();
            n = rSAPublicKey.getModulusBits().getLongValue().intValue();
        } else if (rSAPublicKey instanceof java.security.interfaces.RSAPrivateKey) {
            n = ((java.security.interfaces.RSAPrivateKey)rSAPublicKey).getModulus().bitLength();
        } else if (rSAPublicKey instanceof java.security.interfaces.RSAPublicKey) {
            n = ((java.security.interfaces.RSAPublicKey)rSAPublicKey).getModulus().bitLength();
        } else {
            throw new InvalidKeyException("The provided key must be an IAIKPKCS11PrivateKey or an IAIKPKCS11PublicKey but it is : " + rSAPublicKey.toString());
        }
        return n;
    }

    protected int pkcs11GetBlockSize() {
        return this.pkcs11GetOutputSize(1);
    }

    protected Mechanism getDefaultMechanism() {
        return DEFAULT_MECHANISM;
    }

    protected String getDefaultMode() {
        return DEFAULT_MODE;
    }

    protected String getDefaultPadding() {
        return DEFAULT_PADDING;
    }

    protected Mechanism getMechanism() {
        if (this.modeChanged_ || this.paddingChanged_) {
            try {
                this.mechanism_ = this.getMechanismForModeAndPadding();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.mechanism_ = null;
            }
            this.modeChanged_ = false;
            this.paddingChanged_ = false;
        }
        return this.mechanism_;
    }

    private HashMap b() {
        try {
            Vector vector;
            String string;
            Object object;
            Object object2;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            HashMap<Object, Vector> hashMap2 = new HashMap<Object, Vector>();
            Enumeration<?> enumeration = (f == null ? (f = RsaCipher.a("iaik.pkcs.pkcs11.provider.IAIKPkcs11")) : f).getClassLoader().getResource("iaik/pkcs/pkcs11/provider/default/IAIKPkcs11Algorithm.properties");
            enumeration = ((URL)((Object)enumeration)).openStream();
            Properties properties = new Properties();
            properties.load((InputStream)((Object)enumeration));
            enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                int n;
                object2 = (String)enumeration.nextElement();
                if (!(object2 instanceof String) || (n = ((String)(object = object2)).indexOf("MessageDigest")) < 0 || (string = ((String)object).substring(n + 14)).indexOf(".") != -1) continue;
                string = string.toLowerCase();
                object2 = properties.getProperty((String)object2);
                try {
                    Class<?> clazz = Class.forName((String)object2);
                    vector = (PKCS11Hash)clazz.newInstance();
                    object = ((PKCS11Hash)((Object)vector)).getUsedMechanism();
                    hashMap.put(string, object);
                }
                catch (Exception exception) {
                    object2 = ((String)object2).toLowerCase();
                    if (hashMap2.containsKey(object2)) {
                        vector = (Vector)hashMap2.get(object2);
                    } else {
                        vector = new Vector();
                        hashMap2.put(object2, vector);
                    }
                    vector.add(string);
                }
            }
            object2 = hashMap2.keySet();
            object = object2.iterator();
            while (object.hasNext()) {
                Object object3 = (String)object.next();
                if (!hashMap.containsKey(object3)) continue;
                string = (Mechanism)hashMap.get(object3);
                object2 = (Vector)hashMap2.get(object3);
                object3 = ((Vector)object2).iterator();
                while (object3.hasNext()) {
                    vector = (String)object3.next();
                    hashMap.put((String)((Object)vector), string);
                }
            }
            return hashMap;
        }
        catch (Exception exception) {
            return d;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected Mechanism getMechanismForModeAndPadding() throws NoSuchAlgorithmException {
        block14: {
            block12: {
                block13: {
                    block16: {
                        block15: {
                            var1_1 = new StringBuffer(16);
                            var1_1.append(this.mode_);
                            var1_1.append('/');
                            var1_1.append(this.padding_);
                            var2_2 = var1_1.toString().toLowerCase();
                            this.modePaddingMechanisms_ = this.getModePaddingMechanisms();
                            if (!this.modePaddingMechanisms_.containsKey(var2_2)) break block12;
                            var1_1 = (Mechanism)this.modePaddingMechanisms_.get(var2_2);
                            if (var1_1 == null) break block13;
                            if (!(var1_1 = (Mechanism)var1_1.clone()).equals(Mechanism.get((long)9L))) break block14;
                            var4_3 = null;
                            if (this.parameterSpecs_ != null && this.parameterSpecs_ instanceof PKCS11OAEPParameterSpec) {
                                var4_3 = (PKCS11OAEPParameterSpec)this.parameterSpecs_;
                            }
                            if ((var3_4 = this.padding_.toLowerCase()).startsWith((String)(var5_5 = "oaepwith"))) {
                                var9_6 = var3_4.substring(var5_5.length());
                                var10_8 = var9_6.indexOf("andmgf1padding");
                                if (!var9_6.endsWith("andmgf1padding") || var10_8 == -1) {
                                    throw new NoSuchAlgorithmException("Unknown message generation function (MGF) in requested padding: " + var2_2);
                                }
                                var9_6 = var9_6.substring(0, var10_8);
                                AlgorithmID.getAlgorithmID((String)var9_6.toLowerCase());
                                var11_9 = this.b();
                                var12_11 = var11_9.keySet();
                                var5_5 = var12_11.iterator();
                                var3_4 = null;
                                var6_12 = false;
                                while (var5_5.hasNext() && !var6_12) {
                                    var7_13 = (String)var5_5.next();
                                    if (!var9_6.equalsIgnoreCase(var7_13)) continue;
                                    var3_4 = (Mechanism)((Mechanism)var11_9.get(var7_13)).clone();
                                    var6_12 = true;
                                }
                                if (var3_4 == null) {
                                    throw new NoSuchAlgorithmException("Requested hash algorithm for padding not supported: " + var2_2);
                                }
                            } else {
                                var3_4 = var4_3 != null ? var4_3.getHashAlgorithm() : Mechanism.get((long)544L);
                            }
                            if (var4_3 == null) break block15;
                            var9_7 = var4_3.getMgfHashAlgorithm();
                            var11_10 = var4_3.getOaepSourceType();
                            var5_5 = (Iterator<K>)var4_3.getOaepSourceData();
                            break block16;
                        }
                        if (var3_4.getMechanismCode() == 544L) ** GOTO lbl-1000
                        if (var3_4.getMechanismCode() == 592L) {
                            var9_7 = 2L;
                        } else if (var3_4.getMechanismCode() == 608L) {
                            var9_7 = 3L;
                        } else if (var3_4.getMechanismCode() == 624L) {
                            var9_7 = 4L;
                        } else lbl-1000:
                        // 2 sources

                        {
                            var9_7 = 1L;
                        }
                        var11_10 = 1L;
                        var5_5 = null;
                    }
                    var2_2 = new RSAPkcsOaepParameters((Mechanism)var3_4, var9_7, var11_10, (byte[])var5_5);
                    var1_1.setParameters((Parameters)var2_2);
                    break block14;
                }
                throw new NoSuchAlgorithmException("Combination of mode and padding not supported: " + var2_2);
            }
            throw new NoSuchAlgorithmException("Combination of mode and padding not supported: " + var2_2);
        }
        return var1_1;
    }

    protected Hashtable getModePaddingMechanisms() {
        if (cipherModePaddingMechansims_ == null) {
            HashMap hashMap = this.b();
            Hashtable<String, Mechanism> hashtable = new Hashtable<String, Mechanism>(2 * (8 + hashMap.size()));
            hashtable.put("ssl/pkcs1padding", Mechanism.get((long)1L));
            for (int i2 = 0; i2 < 8; ++i2) {
                String string = b[i2];
                if (string.equals("oaepwith")) {
                    Object object = hashMap.keySet();
                    object = object.iterator();
                    while (object.hasNext()) {
                        String string2 = (String)object.next();
                        string2 = string + string2 + "andmgf1padding";
                        for (int i3 = 0; i3 < 2; ++i3) {
                            hashtable.put(a[i3] + "/" + string2, Mechanism.get((long)c[i2]));
                        }
                    }
                    continue;
                }
                for (int i4 = 0; i4 < 2; ++i4) {
                    hashtable.put(a[i4] + "/" + string, Mechanism.get((long)c[i2]));
                }
            }
            cipherModePaddingMechansims_ = hashtable;
        }
        return cipherModePaddingMechansims_;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isModeSupported(String mode) {
        boolean bl = false;
        if (mode != null) {
            void var1_1;
            if (supportedModes_ == null) {
                Vector<String> vector = new Vector<String>(1);
                vector.add("ecb");
                vector.add("none");
                vector.add("ssl");
                supportedModes_ = vector;
            }
            bl = supportedModes_.contains(var1_1.toLowerCase());
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        void var1_1;
        if (mode.toUpperCase(Locale.US).equalsIgnoreCase("SSL")) {
            mode = this.getDefaultMode();
        }
        if (this.isModeSupported(mode)) {
            this.mode_ = mode;
            this.modeChanged_ = true;
            return;
        }
        throw new NoSuchAlgorithmException("Mode not supported: " + (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isPaddingSupported(String padding) {
        boolean bl = false;
        if (padding != null) {
            void var1_1;
            if (supportedPaddings_ == null) {
                HashMap hashMap = this.b();
                Vector<String> vector = new Vector<String>(15);
                for (int i2 = 0; i2 < 8; ++i2) {
                    String string = b[i2];
                    if (string.equals("oaepwith")) {
                        Object object = hashMap.keySet();
                        object = object.iterator();
                        while (object.hasNext()) {
                            String string2 = (String)object.next();
                            string2 = string + string2 + "andmgf1padding";
                            vector.add(string2);
                        }
                        continue;
                    }
                    vector.add(string);
                }
                supportedPaddings_ = vector;
            }
            bl = supportedPaddings_.contains(var1_1.toLowerCase());
        }
        return bl;
    }

    private static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        d.put("SHA-1", Mechanism.get((long)544L));
        d.put("SHA", Mechanism.get((long)544L));
        d.put("SHA1", Mechanism.get((long)544L));
        d.put("SHA-256", Mechanism.get((long)592L));
        d.put("SHA256", Mechanism.get((long)592L));
        d.put("SHA-384", Mechanism.get((long)608L));
        d.put("SHA384", Mechanism.get((long)608L));
        d.put("SHA-512", Mechanism.get((long)624L));
        d.put("SHA512", Mechanism.get((long)624L));
        d.put("MD2", Mechanism.get((long)512L));
        d.put("MD5", Mechanism.get((long)528L));
        d.put("RipeMd128", Mechanism.get((long)560L));
        d.put("RipeMd-128", Mechanism.get((long)560L));
        d.put("RipeMd160", Mechanism.get((long)576L));
        d.put("RipeMd-160", Mechanism.get((long)576L));
        d.put("FastHash", Mechanism.get((long)4208L));
    }
}

