/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.ciphers;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.RC5SecretKey;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.parameters.RC5CbcParameters;
import iaik.pkcs.pkcs11.parameters.RC5Parameters;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.ciphers.BlockCipher;
import iaik.pkcs.pkcs11.provider.ciphers.b;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Hashtable;
import javax.crypto.spec.RC5ParameterSpec;

public class Rc5Cipher
extends BlockCipher {
    protected static final String CIPHER_NAME = "RC5";
    protected static final Mechanism DEFAULT_MECHANISM = Mechanism.get((long)817L);
    protected static Hashtable cipherModePaddingMechansims_;
    protected RC5ParameterSpec rc5ParameterSpec_;
    protected boolean rc5ParameterSpecChanged_;

    protected Mechanism[] getUsedMechanisms() {
        if (this.usedMechanisms_ == null) {
            this.usedMechanisms_ = new Mechanism[]{Mechanism.get((long)821L), Mechanism.get((long)817L), Mechanism.get((long)818L)};
        }
        return this.usedMechanisms_;
    }

    /*
     * WARNING - void declaration
     */
    protected void checkKeyObject(Key keyObject) throws InvalidKeyException {
        void var1_1;
        if (keyObject == null) {
            throw new NullPointerException("Argument \"keyObject\" must not be null.");
        }
        if (!(var1_1 instanceof RC5SecretKey)) {
            throw new InvalidKeyException("PKCS#11 key object inside IAIKPKCS11SecretKey must be of type RC5SecretKey");
        }
    }

    protected String getAlgorithmName() {
        return CIPHER_NAME;
    }

    protected Hashtable getModePaddingMechanisms() {
        if (cipherModePaddingMechansims_ == null) {
            Hashtable<String, Mechanism> hashtable = new Hashtable<String, Mechanism>(3);
            hashtable.put("ecb/nopadding", Mechanism.get((long)817L));
            hashtable.put("cbc/nopadding", Mechanism.get((long)818L));
            hashtable.put("cbc/pkcs5padding", Mechanism.get((long)821L));
            cipherModePaddingMechansims_ = hashtable;
        }
        return cipherModePaddingMechansims_;
    }

    protected Mechanism getDefaultMechanism() {
        return DEFAULT_MECHANISM;
    }

    protected Mechanism getMechanism() {
        if (this.modeChanged_ || this.paddingChanged_ || this.rc5ParameterSpecChanged_) {
            Mechanism mechanism = null;
            try {
                mechanism = this.getMechanismForModeAndPadding();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
            if (mechanism != null && this.mode_.equalsIgnoreCase("ecb") && this.rc5ParameterSpec_ != null) {
                int n = this.rc5ParameterSpec_.getWordSize();
                int n2 = this.rc5ParameterSpec_.getRounds();
                RC5Parameters rC5Parameters = new RC5Parameters((long)n, (long)n2);
                mechanism.setParameters((Parameters)rC5Parameters);
            } else if (mechanism != null && this.mode_.equalsIgnoreCase("cbc") && this.rc5ParameterSpec_ != null) {
                int n = this.rc5ParameterSpec_.getWordSize();
                int n3 = this.rc5ParameterSpec_.getRounds();
                byte[] byArray = this.rc5ParameterSpec_.getIV();
                RC5CbcParameters rC5CbcParameters = new RC5CbcParameters((long)n, (long)n3, byArray);
                mechanism.setParameters((Parameters)rC5CbcParameters);
            }
            this.mechanism_ = mechanism;
            this.modeChanged_ = false;
            this.paddingChanged_ = false;
            this.rc5ParameterSpecChanged_ = false;
        }
        return this.mechanism_;
    }

    /*
     * WARNING - void declaration
     */
    protected int pkcs11GetOutputSize(int inputLen) {
        int n = -1;
        if (inputLen >= 0) {
            void var1_1;
            n = var1_1 + (this.engineGetBlockSize() << 1) - true;
        }
        return n;
    }

    protected int pkcs11GetKeySize(java.security.Key key) throws InvalidKeyException {
        SecretKey secretKey;
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        if (key instanceof IAIKPKCS11SecretKey) {
            secretKey = (SecretKey)((IAIKPKCS11SecretKey)key).getKeyObject();
            if (!(secretKey instanceof RC5SecretKey)) {
                throw new InvalidKeyException("The provided IAIKPKCS11SecretKey must contain a RC5 secret key but contains: " + secretKey.toString());
            }
        } else {
            throw new InvalidKeyException("The provided key must be an IAIKPKCS11SecretKey but it is: " + secretKey.toString());
        }
        secretKey = (RC5SecretKey)secretKey;
        int n = secretKey.getValueLen().getLongValue().intValue() << 3;
        return n;
    }

    protected int pkcs11GetBlockSize() {
        int n = -1;
        if (this.rc5ParameterSpec_ != null) {
            n = this.rc5ParameterSpec_.getWordSize() << 1;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    protected void pkcs11Init(int operationMode, java.security.Key key, AlgorithmParameterSpec parameterSpecs, SecureRandom randomSource) throws InvalidAlgorithmParameterException, InvalidKeyException {
        void var1_1;
        void var2_2;
        if (operationMode != 1 && operationMode != 2 && operationMode != 4 && operationMode != 3) {
            throw new IAIKPkcs11Exception("Unknown operation mode: " + operationMode);
        }
        this.operationMode_ = operationMode;
        if (!(key instanceof IAIKPKCS11SecretKey)) {
            throw new InvalidKeyException("key must be of type iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey!");
        }
        this.key_ = (IAIKPKCS11SecretKey)var2_2;
        if (!(operationMode != 4 && var1_1 != 3 || this.externalPadding_ instanceof b)) {
            throw new InvalidKeyException("Wrap or unwrap mode not supported for padding " + this.padding_);
        }
        this.keyObject_ = this.key_.getKeyObject();
        Rc5Cipher rc5Cipher = this;
        rc5Cipher.checkKeyObject(rc5Cipher.keyObject_);
        if (this.mode_.equalsIgnoreCase("ecb")) {
            if (parameterSpecs == null || !(parameterSpecs instanceof RC5ParameterSpec)) {
                throw new InvalidAlgorithmParameterException("RC5ParameterSpec required, but parameterSpecs is: " + parameterSpecs);
            }
            this.rc5ParameterSpec_ = (RC5ParameterSpec)parameterSpecs;
            this.rc5ParameterSpecChanged_ = true;
        } else if (this.mode_.equalsIgnoreCase("cbc")) {
            void var3_3;
            if (parameterSpecs == null || !(parameterSpecs instanceof RC5ParameterSpec)) {
                throw new InvalidAlgorithmParameterException("RC5ParameterSpec required, but parameterSpecs is: " + parameterSpecs);
            }
            this.rc5ParameterSpec_ = (RC5ParameterSpec)var3_3;
            this.rc5ParameterSpecChanged_ = true;
            if (this.rc5ParameterSpec_.getIV() == null) {
                throw new InvalidAlgorithmParameterException("Initialization vector required in RC5ParameterSpec in CBC mode, in the given RC5ParameterSpec it is null.");
            }
        }
        this.mechanism_ = this.getMechanism();
        if (this.mechanism_ == null) {
            throw new IAIKPkcs11Exception("The currently selected combination of mode and padding is not supported: " + this.mode_ + "/" + this.padding_);
        }
        this.initialize();
    }
}

