/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.ciphers;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.RC4SecretKey;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.ciphers.PKCS11Cipher;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class Rc4Cipher
extends PKCS11Cipher {
    protected static final String CIPHER_NAME = "RC4";
    protected static final Mechanism DEFAULT_MECHANISM = Mechanism.get((long)273L);

    /*
     * WARNING - void declaration
     */
    protected void checkKeyObject(Key keyObject) throws InvalidKeyException {
        void var1_1;
        if (keyObject == null) {
            throw new NullPointerException("Argument \"keyObject\" must not be null.");
        }
        if (!(var1_1 instanceof RC4SecretKey)) {
            throw new InvalidKeyException("PKCS#11 key object inside IAIKPKCS11SecretKey must be of type RC4SecretKey");
        }
    }

    protected String getAlgorithmName() {
        return CIPHER_NAME;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isModeSupported(String mode) {
        void var1_1;
        return mode == null || var1_1.equalsIgnoreCase("NONE");
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isPaddingSupported(String padding) {
        void var1_1;
        return padding == null || var1_1.equalsIgnoreCase("NoPadding");
    }

    /*
     * WARNING - void declaration
     */
    protected int pkcs11GetOutputSize(int inputLen) {
        int n = -1;
        if (inputLen >= 0) {
            void var1_1;
            n = var1_1;
        }
        return n;
    }

    protected int pkcs11GetKeySize(java.security.Key key) throws InvalidKeyException {
        SecretKey secretKey;
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        if (key instanceof IAIKPKCS11SecretKey) {
            secretKey = (SecretKey)((IAIKPKCS11SecretKey)key).getKeyObject();
            if (!(secretKey instanceof RC4SecretKey)) {
                throw new InvalidKeyException("The provided IAIKPKCS11SecretKey must contain a RC4 secret key but contains: " + secretKey.toString());
            }
        } else {
            throw new InvalidKeyException("The provided key must be an IAIKPKCS11SecretKey but it is: " + secretKey.toString());
        }
        secretKey = (RC4SecretKey)secretKey;
        int n = secretKey.getValueLen().getLongValue().intValue() << 3;
        return n;
    }

    protected int pkcs11GetBlockSize() {
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    protected void pkcs11Init(int operationMode, java.security.Key key, AlgorithmParameterSpec parameterSpecs, SecureRandom randomSource) throws InvalidAlgorithmParameterException, InvalidKeyException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (operationMode != 1 && operationMode != 2 && operationMode != 4 && operationMode != 3) {
            throw new IAIKPkcs11Exception("Unknown operation mode: " + operationMode);
        }
        this.operationMode_ = var1_1;
        if (!(key instanceof IAIKPKCS11SecretKey)) {
            throw new InvalidKeyException("key must be of type iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey!");
        }
        this.key_ = (IAIKPKCS11SecretKey)var2_2;
        this.keyObject_ = this.key_.getKeyObject();
        Rc4Cipher rc4Cipher = this;
        rc4Cipher.checkKeyObject(rc4Cipher.keyObject_);
        if (var3_3 != null) {
            throw new InvalidAlgorithmParameterException("This cipher does not support AlgorithmParameterSpec.");
        }
        this.mechanism_ = this.getMechanism();
        if (this.mechanism_ == null) {
            throw new IAIKPkcs11Exception("This cipher object is not corretly initialized.");
        }
        this.initialize();
    }

    protected Mechanism getDefaultMechanism() {
        return DEFAULT_MECHANISM;
    }

    protected Mechanism getMechanism() {
        return DEFAULT_MECHANISM;
    }
}

