/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.ciphers;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.RC2SecretKey;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.parameters.RC2CbcParameters;
import iaik.pkcs.pkcs11.parameters.RC2Parameters;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.ciphers.BlockCipher;
import iaik.pkcs.pkcs11.provider.ciphers.b;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Hashtable;
import javax.crypto.spec.RC2ParameterSpec;

public class Rc2Cipher
extends BlockCipher {
    protected static final String CIPHER_NAME = "RC2";
    protected static final Mechanism DEFAULT_MECHANISM = Mechanism.get((long)257L);
    protected static Hashtable cipherModePaddingMechansims_;
    protected RC2ParameterSpec rc2ParameterSpec_;
    protected boolean rc2ParameterSpecChanged_;

    protected Mechanism[] getUsedMechanisms() {
        if (this.usedMechanisms_ == null) {
            this.usedMechanisms_ = new Mechanism[]{Mechanism.get((long)261L), Mechanism.get((long)257L), Mechanism.get((long)258L)};
        }
        return this.usedMechanisms_;
    }

    /*
     * WARNING - void declaration
     */
    protected void checkKeyObject(Key keyObject) throws InvalidKeyException {
        void var1_1;
        if (keyObject == null) {
            throw new NullPointerException("Argument \"keyObject\" must not be null.");
        }
        if (!(var1_1 instanceof RC2SecretKey)) {
            throw new InvalidKeyException("PKCS#11 key object inside IAIKPKCS11SecretKey must be of type RC2SecretKey");
        }
    }

    protected String getAlgorithmName() {
        return CIPHER_NAME;
    }

    protected Hashtable getModePaddingMechanisms() {
        if (cipherModePaddingMechansims_ == null) {
            Hashtable<String, Mechanism> hashtable = new Hashtable<String, Mechanism>(3);
            hashtable.put("ecb/nopadding", Mechanism.get((long)257L));
            hashtable.put("cbc/nopadding", Mechanism.get((long)258L));
            hashtable.put("cbc/pkcs5padding", Mechanism.get((long)261L));
            cipherModePaddingMechansims_ = hashtable;
        }
        return cipherModePaddingMechansims_;
    }

    protected Mechanism getDefaultMechanism() {
        return DEFAULT_MECHANISM;
    }

    protected Mechanism getMechanism() {
        if (this.modeChanged_ || this.paddingChanged_ || this.rc2ParameterSpecChanged_) {
            Mechanism mechanism = null;
            try {
                mechanism = this.getMechanismForModeAndPadding();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
            if (mechanism != null && this.mode_.equalsIgnoreCase("ecb") && this.rc2ParameterSpec_ != null) {
                int n = this.rc2ParameterSpec_.getEffectiveKeyBits();
                RC2Parameters rC2Parameters = new RC2Parameters((long)n);
                mechanism.setParameters((Parameters)rC2Parameters);
            } else if (mechanism != null && this.mode_.equalsIgnoreCase("cbc") && this.rc2ParameterSpec_ != null) {
                int n = this.rc2ParameterSpec_.getEffectiveKeyBits();
                byte[] byArray = this.rc2ParameterSpec_.getIV();
                RC2CbcParameters rC2CbcParameters = new RC2CbcParameters((long)n, byArray);
                mechanism.setParameters((Parameters)rC2CbcParameters);
            }
            this.mechanism_ = mechanism;
            this.modeChanged_ = false;
            this.paddingChanged_ = false;
            this.rc2ParameterSpecChanged_ = false;
        }
        return this.mechanism_;
    }

    /*
     * WARNING - void declaration
     */
    protected int pkcs11GetOutputSize(int inputLen) {
        int n = -1;
        if (inputLen >= 0) {
            void var1_1;
            n = var1_1 + 15;
        }
        return n;
    }

    protected int pkcs11GetKeySize(java.security.Key key) throws InvalidKeyException {
        SecretKey secretKey;
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        if (key instanceof IAIKPKCS11SecretKey) {
            secretKey = (SecretKey)((IAIKPKCS11SecretKey)key).getKeyObject();
            if (!(secretKey instanceof RC2SecretKey)) {
                throw new InvalidKeyException("The provided IAIKPKCS11SecretKey must contain a RC2 secret key but contains: " + secretKey.toString());
            }
        } else {
            throw new InvalidKeyException("The provided key must be an IAIKPKCS11SecretKey but it is: " + secretKey.toString());
        }
        secretKey = (RC2SecretKey)secretKey;
        int n = secretKey.getValueLen().getLongValue().intValue() << 3;
        return n;
    }

    protected int pkcs11GetBlockSize() {
        return 8;
    }

    /*
     * WARNING - void declaration
     */
    protected void pkcs11Init(int operationMode, java.security.Key key, AlgorithmParameterSpec parameterSpecs, SecureRandom randomSource) throws InvalidAlgorithmParameterException, InvalidKeyException {
        void var1_1;
        void var2_2;
        if (operationMode != 1 && operationMode != 2 && operationMode != 4 && operationMode != 3) {
            throw new IAIKPkcs11Exception("Unknown operation mode: " + operationMode);
        }
        this.operationMode_ = operationMode;
        if (!(key instanceof IAIKPKCS11SecretKey)) {
            throw new InvalidKeyException("key must be of type iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey!");
        }
        this.key_ = (IAIKPKCS11SecretKey)var2_2;
        if (!(operationMode != 4 && var1_1 != 3 || this.externalPadding_ instanceof b)) {
            throw new InvalidKeyException("Wrap or unwrap mode not supported for padding " + this.padding_);
        }
        this.keyObject_ = this.key_.getKeyObject();
        Rc2Cipher rc2Cipher = this;
        rc2Cipher.checkKeyObject(rc2Cipher.keyObject_);
        if (this.mode_.equalsIgnoreCase("ecb")) {
            if (parameterSpecs == null || !(parameterSpecs instanceof RC2ParameterSpec)) {
                throw new InvalidAlgorithmParameterException("RC2ParameterSpec required, but parameterSpecs is: " + parameterSpecs);
            }
            this.rc2ParameterSpec_ = (RC2ParameterSpec)parameterSpecs;
            this.rc2ParameterSpecChanged_ = true;
        } else if (this.mode_.equalsIgnoreCase("cbc")) {
            void var3_3;
            if (parameterSpecs == null || !(parameterSpecs instanceof RC2ParameterSpec)) {
                throw new InvalidAlgorithmParameterException("RC2ParameterSpec required, but parameterSpecs is: " + parameterSpecs);
            }
            this.rc2ParameterSpec_ = (RC2ParameterSpec)var3_3;
            this.rc2ParameterSpecChanged_ = true;
            if (this.rc2ParameterSpec_.getIV() == null) {
                throw new InvalidAlgorithmParameterException("Initialization vector required in RC2ParameterSpec in CBC mode, in the given RC2ParameterSpec it is null.");
            }
        }
        this.mechanism_ = this.getMechanism();
        if (this.mechanism_ == null) {
            throw new IAIKPkcs11Exception("The currently selected combination of mode and padding is not supported: " + this.mode_ + "/" + this.padding_);
        }
        this.initialize();
    }
}

