/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.ciphers;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.GenericTemplate;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.objects.PublicKey;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.provider.DelegateProvider;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.PKCS11EngineClass;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11Key;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PublicKey;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey;
import iaik.pkcs.pkcs11.provider.spec.PKCS11Spec;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public abstract class PKCS11Cipher
extends CipherSpi
implements PKCS11EngineClass {
    protected static final byte[] DUMMY_DATA = new byte[]{0};
    protected Session session_;
    protected TokenManager tokenManager_;
    protected IAIKPKCS11Key key_;
    protected iaik.pkcs.pkcs11.objects.Key keyObject_;
    protected int operationMode_;
    protected Mechanism mechanism_ = this.getDefaultMechanism();
    protected boolean initialized_;
    protected boolean pkcs11OperationInitialized_;
    protected boolean updateUsed_;
    protected boolean currentKeyIsSoftwareKey_;
    protected Cipher softwareDelegate_;
    protected String mode_;
    protected String padding_;
    protected AlgorithmParameters parameters_;
    protected boolean modeChanged_;
    protected boolean paddingChanged_;
    protected Mechanism[] usedMechanisms_;
    protected MechanismInfo[][] usedMechanismInfos_;
    protected iaik.pkcs.pkcs11.objects.Key unwrapTemplate_;
    protected PKCS11Spec parameterSpecs_;
    private static Class a;

    protected PKCS11Cipher() {
    }

    protected Mechanism[] getUsedMechanisms() {
        if (this.usedMechanisms_ == null) {
            Mechanism mechanism = (Mechanism)this.getMechanism().clone();
            mechanism.setParameters(null);
            this.usedMechanisms_ = new Mechanism[]{mechanism};
        }
        return this.usedMechanisms_;
    }

    protected MechanismInfo[][] getUsedMechanismFeatures() {
        if (this.usedMechanismInfos_ == null) {
            MechanismInfo mechanismInfo = new MechanismInfo();
            mechanismInfo.setEncrypt(true);
            MechanismInfo mechanismInfo2 = new MechanismInfo();
            mechanismInfo2.setDecrypt(true);
            MechanismInfo mechanismInfo3 = new MechanismInfo();
            mechanismInfo3.setWrap(true);
            MechanismInfo mechanismInfo4 = new MechanismInfo();
            mechanismInfo4.setUnwrap(true);
            this.usedMechanismInfos_ = new MechanismInfo[][]{{mechanismInfo, mechanismInfo2, mechanismInfo3, mechanismInfo4}};
        }
        return this.usedMechanismInfos_;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isSupportedBy(TokenManager tokenManager) {
        boolean bl;
        try {
            void var1_1;
            Mechanism[] mechanismArray = this.getUsedMechanisms();
            MechanismInfo[][] mechanismInfoArray = this.getUsedMechanismFeatures();
            bl = var1_1.isMechanismFeatureSupported(mechanismArray, mechanismInfoArray);
        }
        catch (TokenException tokenException) {
            bl = false;
        }
        return bl;
    }

    protected abstract void checkKeyObject(iaik.pkcs.pkcs11.objects.Key var1) throws InvalidKeyException;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws BadPaddingException, IllegalBlockSizeException, ShortBufferException {
        if (!this.currentKeyIsSoftwareKey_) void var3_4;
        void var2_3;
        void var1_1;
        return this.pkcs11DoFinal((byte[])var1_1, (int)var2_3, (int)var3_4, output, outputOffset);
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.softwareDelegate_.doFinal(input, inputOffset, inputLen, output, outputOffset);
    }

    /*
     * WARNING - void declaration
     */
    protected int pkcs11DoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws BadPaddingException, IllegalBlockSizeException, ShortBufferException {
        void var3_5;
        void var2_4;
        byte[] byArray;
        if (!this.initialized_ || this.key_ == null) {
            throw new IllegalStateException("Cipher not initialized.");
        }
        if (!this.pkcs11OperationInitialized_) {
            try {
                this.initializePkcs11Operation();
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidKeyException.toString());
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidAlgorithmParameterException.toString());
            }
        }
        if ((byArray = this.pkcs11DoFinal(byArray, (int)var2_4, (int)var3_5)) != null && output != null) {
            if (output.length - outputOffset < byArray.length) {
                throw new ShortBufferException("Output is " + byArray.length + "bytes long.The given buffer has only place for " + (output.length - outputOffset) + "bytes.");
            }
            System.arraycopy(byArray, 0, output, outputOffset, byArray.length);
        }
        if (byArray != null) {
            return byArray.length;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLength) throws BadPaddingException, IllegalBlockSizeException {
        if (!this.currentKeyIsSoftwareKey_) void var3_3;
        void var2_2;
        byte[] byArray;
        return this.pkcs11DoFinal(byArray, (int)var2_2, (int)var3_3);
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        if (input == null) return this.softwareDelegate_.doFinal();
        return this.softwareDelegate_.doFinal(input, inputOffset, inputLength);
    }

    /*
     * WARNING - void declaration
     */
    protected byte[] pkcs11DoFinal(byte[] input, int inputOffset, int inputLength) throws BadPaddingException, IllegalBlockSizeException {
        byte[] byArray;
        if (!this.initialized_ || this.key_ == null) {
            throw new IllegalStateException("Cipher not initialized.");
        }
        if (input != null && inputOffset + inputLength > input.length) {
            throw new IllegalArgumentException("Arguments must satisfy ((inputOffset + inputLength) <= input.length).");
        }
        if (!this.pkcs11OperationInitialized_) {
            try {
                this.initializePkcs11Operation();
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidKeyException.toString());
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidAlgorithmParameterException.toString());
            }
        }
        if (!this.updateUsed_ && input != null) {
            byte[] byArray2;
            if (inputOffset == 0 && inputLength == input.length) {
                byArray2 = input;
            } else {
                byArray2 = new byte[inputLength];
                System.arraycopy(input, inputOffset, byArray2, 0, inputLength);
            }
            try {
                if (this.operationMode_ == 1) {
                    byArray = this.session_.encrypt(byArray2);
                } else if (this.operationMode_ == 2) {
                    byArray = this.session_.decrypt(byArray2);
                } else {
                    throw new UnsupportedOperationException("Method only supported in state encrypt or decrypt.");
                }
                this.pkcs11OperationInitialized_ = false;
            }
            catch (TokenException tokenException) {
                throw new IAIKPkcs11Exception("Error calculating cipher: " + (java.lang.Object)((java.lang.Object)tokenException));
            }
            finally {
                this.finalizePkcs11Operation();
            }
        }
        try {
            byte[] byArray3;
            byte[] byArray4 = null;
            if (byArray != null) {
                void var3_7;
                void var2_4;
                byArray4 = this.pkcs11Update(byArray, (int)var2_4, (int)var3_7);
            }
            if (this.operationMode_ == 1) {
                byArray3 = this.session_.encryptFinal();
            } else if (this.operationMode_ == 2) {
                byArray3 = this.session_.decryptFinal();
            } else {
                throw new UnsupportedOperationException("Method only supported in state encrypt or decrypt.");
            }
            if (byArray != null && byArray4 != null) {
                if (byArray3 != null) {
                    byArray = new byte[byArray4.length + byArray3.length];
                    System.arraycopy(byArray4, 0, byArray, 0, byArray4.length);
                    System.arraycopy(byArray3, 0, byArray, byArray4.length, byArray3.length);
                } else {
                    byArray = byArray4;
                }
            } else {
                byArray = byArray3;
            }
            this.pkcs11OperationInitialized_ = false;
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception("Error finalizing cipher: " + (java.lang.Object)((java.lang.Object)tokenException));
        }
        finally {
            this.finalizePkcs11Operation();
        }
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int engineGetBlockSize() {
        if (!this.currentKeyIsSoftwareKey_) return this.pkcs11GetBlockSize();
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.softwareDelegate_.getBlockSize();
    }

    protected int pkcs11GetBlockSize() {
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] engineGetIV() {
        if (!this.currentKeyIsSoftwareKey_) return this.pkcs11GetIV();
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.softwareDelegate_.getIV();
    }

    protected byte[] pkcs11GetIV() {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        byte[] byArray;
        if (key instanceof IAIKPKCS11Key) {
            return this.pkcs11GetKeySize(key);
        }
        if (!(byArray instanceof javax.crypto.SecretKey)) throw new InvalidKeyException("Cannot determine size of software key.");
        if ((byArray = byArray.getEncoded()) == null) throw new InvalidKeyException("Cannot determine size of software secret key. Key encoding is null.");
        return byArray.length << 3;
    }

    protected int pkcs11GetKeySize(Key key) throws InvalidKeyException {
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int engineGetOutputSize(int inputLength) {
        if (!this.currentKeyIsSoftwareKey_) int n;
        return this.pkcs11GetOutputSize(n);
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.softwareDelegate_.getOutputSize(inputLength);
    }

    protected int pkcs11GetOutputSize(int inputLength) {
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AlgorithmParameters engineGetParameters() {
        if (!this.currentKeyIsSoftwareKey_) return this.pkcs11GetParameters();
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.softwareDelegate_.getParameters();
    }

    protected AlgorithmParameters pkcs11GetParameters() {
        return this.parameters_;
    }

    /*
     * WARNING - void declaration
     */
    protected void engineInit(int operationMode, Key key, SecureRandom randomSource) throws InvalidKeyException {
        key = IAIKPkcs11.getGlobalKeyHandler().handleCipherKey(this.getAlgorithmName(), operationMode, key);
        if (key instanceof IAIKPKCS11Key) {
            this.pkcs11Init(operationMode, key, randomSource);
            this.currentKeyIsSoftwareKey_ = false;
            return;
        }
        if (IAIKPkcs11.isEnableSoftwareDelegation()) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (this.softwareDelegate_ == null) {
                this.initializeSoftwareDelegate();
            }
            this.softwareDelegate_.init((int)var1_1, (Key)var2_2, (SecureRandom)var3_3);
            this.currentKeyIsSoftwareKey_ = true;
            return;
        }
        throw new InvalidKeyException("The current key is not a key of this provider, but software delegation is disabled.");
    }

    /*
     * WARNING - void declaration
     */
    protected void pkcs11Init(int operationMode, Key key, SecureRandom randomSource) throws InvalidKeyException {
        try {
            void var3_4;
            void var2_3;
            void var1_1;
            this.pkcs11Init((int)var1_1, (Key)var2_3, (AlgorithmParameterSpec)null, (SecureRandom)var3_4);
            return;
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new IAIKPkcs11Exception(invalidAlgorithmParameterException.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void engineInit(int operationMode, Key key, AlgorithmParameters parameters, SecureRandom random) throws InvalidAlgorithmParameterException, InvalidKeyException {
        key = IAIKPkcs11.getGlobalKeyHandler().handleCipherKey(this.getAlgorithmName(), operationMode, key);
        if (key instanceof IAIKPKCS11Key) {
            this.pkcs11Init(operationMode, key, parameters, random);
            this.currentKeyIsSoftwareKey_ = false;
            return;
        }
        if (IAIKPkcs11.isEnableSoftwareDelegation()) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (this.softwareDelegate_ == null) {
                this.initializeSoftwareDelegate();
            }
            this.softwareDelegate_.init((int)var1_1, (Key)var2_2, (AlgorithmParameters)var3_3, random);
            this.currentKeyIsSoftwareKey_ = true;
            return;
        }
        throw new InvalidKeyException("The current key is not a key of this provider, but software delegation is disabled.");
    }

    /*
     * WARNING - void declaration
     */
    protected void pkcs11Init(int operationMode, Key key, AlgorithmParameters parameters, SecureRandom random) throws InvalidAlgorithmParameterException, InvalidKeyException {
        void var2_2;
        void var1_1;
        this.pkcs11Init((int)var1_1, (Key)var2_2, (AlgorithmParameterSpec)null, random);
    }

    /*
     * WARNING - void declaration
     */
    protected void engineInit(int operationMode, Key key, AlgorithmParameterSpec parameterSpecs, SecureRandom randomSource) throws InvalidAlgorithmParameterException, InvalidKeyException {
        key = IAIKPkcs11.getGlobalKeyHandler().handleCipherKey(this.getAlgorithmName(), operationMode, key);
        if (key instanceof IAIKPKCS11Key) {
            this.pkcs11Init(operationMode, key, parameterSpecs, randomSource);
            this.currentKeyIsSoftwareKey_ = false;
            return;
        }
        if (IAIKPkcs11.isEnableSoftwareDelegation()) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.currentKeyIsSoftwareKey_ = true;
            if (this.softwareDelegate_ == null) {
                this.initializeSoftwareDelegate();
            }
            this.softwareDelegate_.init((int)var1_1, (Key)var2_2, (AlgorithmParameterSpec)var3_3, randomSource);
            return;
        }
        throw new InvalidKeyException("The current key is not a key of this provider, but software delegation is disabled.");
    }

    /*
     * WARNING - void declaration
     */
    protected void pkcs11Init(int operationMode, Key key, AlgorithmParameterSpec parameterSpecs, SecureRandom randomSource) throws InvalidAlgorithmParameterException, InvalidKeyException {
        void var2_3;
        void var1_1;
        if (operationMode != 1 && operationMode != 2 && operationMode != 4 && operationMode != 3) {
            throw new IAIKPkcs11Exception("Unknown operation mode: " + operationMode);
        }
        this.mechanism_ = this.getMechanism();
        if (this.mechanism_ == null) {
            throw new IAIKPkcs11Exception("This cipher object has not been initialized correctly.");
        }
        this.operationMode_ = var1_1;
        this.key_ = (IAIKPKCS11Key)var2_3;
        iaik.pkcs.pkcs11.objects.Key key2 = this.key_.getKeyObject();
        this.checkKeyObject(key2);
        this.keyObject_ = key2;
        this.initialize();
    }

    protected void initializeSoftwareDelegate() {
        DelegateProvider delegateProvider = this.a();
        String string = this.getFullAlgorithmName();
        this.softwareDelegate_ = delegateProvider.getCipher(string);
        if (this.softwareDelegate_ == null) {
            throw new IAIKPkcs11Exception("Could not get delegate cipher engine for " + string);
        }
    }

    protected abstract String getAlgorithmName();

    protected String getFullAlgorithmName() {
        String string;
        block0: {
            string = this.getAlgorithmName();
            if (this.mode_ == null || this.padding_ == null) break block0;
            StringBuffer stringBuffer = new StringBuffer(string.length() + this.mode_.length() + this.padding_.length() + 2);
            stringBuffer.append(string);
            stringBuffer.append('/');
            stringBuffer.append(this.mode_);
            stringBuffer.append('/');
            stringBuffer.append(this.padding_);
            string = stringBuffer.toString();
        }
        return string;
    }

    protected void initializeSession() {
        try {
            this.tokenManager_ = this.key_.getTokenManager();
            if (this.session_ == null) {
                this.session_ = this.tokenManager_.getSession(this.operationMode_ == 4);
            }
            this.tokenManager_.makeAuthorizedSession(this.session_, null);
            return;
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    protected void initializePkcs11Operation() throws InvalidAlgorithmParameterException, InvalidKeyException {
        this.initializeSession();
        try {
            if (this.operationMode_ == 2) {
                this.session_.decryptInit(this.mechanism_, this.key_.getKeyObject());
            } else if (this.operationMode_ == 1) {
                this.session_.encryptInit(this.mechanism_, this.key_.getKeyObject());
            } else if (this.operationMode_ == 4 && this.parameterSpecs_ != null && this.parameterSpecs_.isUseUserRole()) {
                this.tokenManager_.loginUser(this.parameterSpecs_.getPin());
            }
        }
        catch (TokenException tokenException) {
            throw new InvalidKeyException("Error initializing the PKCS#11 cipher: " + tokenException.toString());
        }
        this.updateUsed_ = false;
        this.pkcs11OperationInitialized_ = true;
    }

    protected void finalizePkcs11Operation() {
        if (this.pkcs11OperationInitialized_) {
            this.pkcs11OperationInitialized_ = false;
            this.tokenManager_.closeSession(this.session_);
            this.session_ = null;
            return;
        }
        this.pkcs11OperationInitialized_ = false;
        this.tokenManager_.disposeSession(this.session_);
        this.session_ = null;
    }

    protected void initialize() throws InvalidAlgorithmParameterException, InvalidKeyException {
        this.initializePkcs11Operation();
        this.initialized_ = true;
    }

    /*
     * WARNING - void declaration
     */
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        void var1_1;
        if (this.isModeSupported(mode)) {
            this.mode_ = mode;
            this.modeChanged_ = true;
            return;
        }
        throw new NoSuchAlgorithmException("Mode not supported: " + (String)var1_1);
    }

    protected abstract boolean isModeSupported(String var1);

    /*
     * WARNING - void declaration
     */
    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        if (this.isPaddingSupported(padding)) {
            this.padding_ = padding;
            this.paddingChanged_ = true;
            if (this.getMechanism() == null) {
                throw new NoSuchPaddingException("Padding not supported with this mode: " + this.mode_ + "/" + padding);
            }
        } else {
            void var1_1;
            throw new NoSuchPaddingException("Padding not supported: " + (String)var1_1);
        }
    }

    protected abstract boolean isPaddingSupported(String var1);

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] engineUpdate(byte[] data, int offset, int length) {
        if (!this.currentKeyIsSoftwareKey_) void var3_3;
        void var2_2;
        byte[] byArray;
        return this.pkcs11Update(byArray, (int)var2_2, (int)var3_3);
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.softwareDelegate_.update(data, offset, length);
    }

    /*
     * WARNING - void declaration
     */
    protected byte[] pkcs11Update(byte[] data, int offset, int length) {
        byte[] byArray;
        block13: {
            byte[] byArray2;
            if (!this.initialized_ || this.key_ == null) {
                throw new IllegalStateException("Cipher not initialized.");
            }
            if (!this.pkcs11OperationInitialized_) {
                try {
                    this.initializePkcs11Operation();
                }
                catch (InvalidKeyException invalidKeyException) {
                    this.finalizePkcs11Operation();
                    throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidKeyException.toString());
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    this.finalizePkcs11Operation();
                    throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidAlgorithmParameterException.toString());
                }
            }
            if (data == null) {
                throw new NullPointerException("Argument \"data\" must not be null.");
            }
            if (offset + length > data.length) {
                throw new IllegalArgumentException("Arguments must satisfy ((offset + length) <= data.length).");
            }
            if (offset == 0 && length == data.length) {
                byArray2 = data;
            } else {
                void var3_4;
                void var2_3;
                byArray2 = new byte[length];
                System.arraycopy(byArray, (int)var2_3, byArray2, 0, (int)var3_4);
            }
            try {
                if (this.operationMode_ == 1) {
                    byArray = this.session_.encryptUpdate(byArray2);
                    break block13;
                }
                if (this.operationMode_ == 2) {
                    byArray = this.session_.decryptUpdate(byArray2);
                    break block13;
                }
                throw new UnsupportedOperationException("Method only supported in state encrypt or decrypt.");
            }
            catch (TokenException tokenException) {
                this.finalizePkcs11Operation();
                throw new IAIKPkcs11Exception("Error updating cipher: " + (java.lang.Object)((java.lang.Object)tokenException));
            }
        }
        this.updateUsed_ = true;
        return byArray;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int engineUpdate(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws ShortBufferException {
        if (!this.currentKeyIsSoftwareKey_) void var3_4;
        void var2_3;
        void var1_1;
        return this.pkcs11Update((byte[])var1_1, (int)var2_3, (int)var3_4, output, outputOffset);
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.softwareDelegate_.update(input, inputOffset, inputLength, output, outputOffset);
    }

    /*
     * WARNING - void declaration
     */
    protected void engineUpdateAAD(byte[] src, int offset, int len) {
        if (this.currentKeyIsSoftwareKey_) {
            if (IAIKPkcs11.isEnableSoftwareDelegation()) {
                try {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    Method method = this.softwareDelegate_.getClass().getDeclaredMethod("updateAAD", a == null ? (a = PKCS11Cipher.a("[B")) : a, Integer.TYPE, Integer.TYPE);
                    method.invoke((java.lang.Object)this.softwareDelegate_, var1_1, (int)var2_2, (int)var3_3);
                    return;
                }
                catch (Exception exception) {
                    throw new IAIKPkcs11Exception(exception.toString());
                }
            }
            throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        }
        throw new IAIKPkcs11Exception("updateAAD() currently not supported. Use PKCS11GCMParameterSpec to specify additional authenticated data!");
    }

    /*
     * WARNING - void declaration
     */
    protected int pkcs11Update(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws ShortBufferException {
        void var3_3;
        void var2_2;
        byte[] byArray;
        if (!this.initialized_ || this.key_ == null) {
            throw new IllegalStateException("Cipher not initialized.");
        }
        if (input == null) {
            throw new NullPointerException("Argument \"data\" must not be null.");
        }
        if ((byArray = this.pkcs11Update(byArray, (int)var2_2, (int)var3_3)) != null && output != null) {
            if (output.length - outputOffset < byArray.length) {
                throw new ShortBufferException("Output is " + byArray.length + "bytes long.The given buffer has only place for " + (output.length - outputOffset) + "bytes.");
            }
            System.arraycopy(byArray, 0, output, outputOffset, byArray.length);
        }
        this.updateUsed_ = true;
        if (byArray != null) {
            return byArray.length;
        }
        return 0;
    }

    protected void updateAAD(byte[] src) {
    }

    protected void updateAAD(byte[] src, int offset, int len) {
    }

    protected void updateAAD(ByteBuffer src) {
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws NoSuchAlgorithmException, InvalidKeyException {
        if (!this.currentKeyIsSoftwareKey_) void var3_3;
        void var2_2;
        Key key;
        return this.pkcs11Unwrap((byte[])key, (String)var2_2, (int)var3_3);
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new IAIKPkcs11Exception("The current key is not a key of this provider, but software delegation is disabled.");
        return this.softwareDelegate_.unwrap(wrappedKey, wrappedKeyAlgorithm, wrappedKeyType);
    }

    /*
     * WARNING - void declaration
     */
    protected Key pkcs11Unwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws NoSuchAlgorithmException, InvalidKeyException {
        IAIKPKCS11Key iAIKPKCS11Key;
        java.lang.Object object;
        iaik.pkcs.pkcs11.objects.Key key;
        if (!this.initialized_ || this.key_ == null) {
            throw new IllegalStateException("Cipher not initialized.");
        }
        if (wrappedKey == null) {
            throw new NullPointerException("Argument \"wrappedKey\" must not be null.");
        }
        if (this.operationMode_ != 4) {
            throw new UnsupportedOperationException("Method only supported in state unwrap.");
        }
        if (!this.pkcs11OperationInitialized_) {
            try {
                this.initializePkcs11Operation();
            }
            catch (InvalidKeyException invalidKeyException) {
                this.finalizePkcs11Operation();
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidKeyException.toString());
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                this.finalizePkcs11Operation();
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidAlgorithmParameterException.toString());
            }
        }
        if (this.unwrapTemplate_ == null) {
            void var3_5;
            switch (var3_5) {
                case 3: {
                    key = new GenericTemplate();
                    object = new LongAttribute(Attribute.CLASS);
                    object.setLongValue(Object.ObjectClass.SECRET_KEY);
                    ((GenericTemplate)key).addAttribute((Attribute)object);
                    break;
                }
                case 2: {
                    key = new GenericTemplate();
                    object = new LongAttribute(Attribute.CLASS);
                    object.setLongValue(Object.ObjectClass.PRIVATE_KEY);
                    ((GenericTemplate)key).addAttribute((Attribute)object);
                    break;
                }
                case 1: {
                    key = new GenericTemplate();
                    object = new LongAttribute(Attribute.CLASS);
                    object.setLongValue(Object.ObjectClass.PUBLIC_KEY);
                    ((GenericTemplate)key).addAttribute((Attribute)object);
                    break;
                }
                default: {
                    key = null;
                }
            }
            if (key != null) {
                object = IAIKPKCS11Key.getAlgorithmCode(wrappedKeyAlgorithm);
                LongAttribute longAttribute = new LongAttribute(Attribute.KEY_TYPE);
                longAttribute.setLongValue((Long)object);
                ((GenericTemplate)key).addAttribute((Attribute)longAttribute);
            }
        } else {
            key = this.unwrapTemplate_;
        }
        try {
            if (key != null && wrappedKeyAlgorithm.equalsIgnoreCase("TlsRsaPremasterSecret")) {
                void var2_4;
                this.session_.decryptInit(this.mechanism_, this.key_.getKeyObject());
                object = this.session_.decrypt((byte[])iAIKPKCS11Key);
                return new SecretKeySpec((byte[])object, (String)var2_4);
            }
            object = this.session_.unwrapKey(this.mechanism_, this.key_.getKeyObject(), (byte[])iAIKPKCS11Key, (Object)key);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.finalizePkcs11Operation();
            if (pKCS11Exception.getErrorCode() == 112L) {
                throw new NoSuchAlgorithmException("Token does not support this algorithm: " + (java.lang.Object)((java.lang.Object)pKCS11Exception));
            }
            if (pKCS11Exception.getErrorCode() == 272L) {
                throw new InvalidKeyException("Token does not support the algorithm of the wrapped key: " + (java.lang.Object)((java.lang.Object)pKCS11Exception));
            }
            throw new IAIKPkcs11Exception("Error unwrapping key: " + (java.lang.Object)((java.lang.Object)pKCS11Exception));
        }
        catch (TokenException tokenException) {
            this.finalizePkcs11Operation();
            throw new IAIKPkcs11Exception("Error unwrapping key: " + (java.lang.Object)((java.lang.Object)tokenException));
        }
        if (object instanceof PrivateKey) {
            iAIKPKCS11Key = IAIKPKCS11Key.create(this.tokenManager_, (iaik.pkcs.pkcs11.objects.Key)object);
        } else if (object instanceof PublicKey) {
            iAIKPKCS11Key = IAIKPKCS11PublicKey.create(this.tokenManager_, (PublicKey)object);
        } else if (object instanceof SecretKey) {
            iAIKPKCS11Key = IAIKPKCS11SecretKey.create(this.tokenManager_, (SecretKey)object);
        } else {
            this.finalizePkcs11Operation();
            throw new InvalidKeyException("This type of PKCS#11 key cannot be handled: " + object);
        }
        if (!object.getToken().getBooleanValue().booleanValue()) {
            iAIKPKCS11Key.setSession(this.session_);
            this.pkcs11OperationInitialized_ = false;
        }
        this.finalizePkcs11Operation();
        this.tokenManager_.notifyKeyStores();
        return iAIKPKCS11Key;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] engineWrap(Key key) throws InvalidKeyException, IllegalBlockSizeException {
        if (!this.currentKeyIsSoftwareKey_) byte[] byArray;
        return this.pkcs11Wrap((Key)byArray);
        if (!IAIKPkcs11.isEnableSoftwareDelegation()) throw new InvalidKeyException("The current key is not a key of this provider, but software delegation is disabled.");
        return this.softwareDelegate_.wrap(key);
    }

    protected byte[] pkcs11Wrap(Key key) throws InvalidKeyException, IllegalBlockSizeException {
        java.lang.Object object;
        block13: {
            if (!this.initialized_ || this.key_ == null) {
                throw new IllegalStateException("Cipher not initialized.");
            }
            if (key == null) {
                throw new NullPointerException("Argument \"key\" must not be null.");
            }
            if (!(key instanceof IAIKPKCS11Key)) {
                throw new InvalidKeyException("Argument key must be of instance iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11Key.");
            }
            if (!this.pkcs11OperationInitialized_) {
                try {
                    this.initializePkcs11Operation();
                }
                catch (InvalidKeyException invalidKeyException) {
                    this.finalizePkcs11Operation();
                    throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidKeyException.toString());
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    this.finalizePkcs11Operation();
                    throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidAlgorithmParameterException.toString());
                }
            }
            object = ((IAIKPKCS11Key)object).getKeyObject();
            try {
                if (this.operationMode_ == 3) {
                    object = this.session_.wrapKey(this.mechanism_, this.key_.getKeyObject(), object);
                    break block13;
                }
                throw new UnsupportedOperationException("Method only supported in state wrap.");
            }
            catch (TokenException tokenException) {
                throw new IAIKPkcs11Exception("Error wrapping key: " + (java.lang.Object)((java.lang.Object)tokenException));
            }
            finally {
                this.finalizePkcs11Operation();
            }
        }
        return object;
    }

    protected abstract Mechanism getDefaultMechanism();

    protected abstract Mechanism getMechanism();

    protected void finalize() throws Throwable {
        if (this.session_ != null) {
            this.finalizePkcs11Operation();
        }
        super.finalize();
    }

    final DelegateProvider a() {
        if (this.tokenManager_ != null) {
            return this.tokenManager_.getProvider().getDelegateProvider();
        }
        return IAIKPkcs11.getGlobalDelegateProvider();
    }

    private static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

