/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.ciphers;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.ECDSAPrivateKey;
import iaik.pkcs.pkcs11.objects.ECDSAPublicKey;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.objects.PublicKey;
import iaik.pkcs.pkcs11.parameters.EcdsaEciesParams;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.ciphers.ECIESParameterSpec;
import iaik.pkcs.pkcs11.provider.ciphers.PKCS11Cipher;
import iaik.pkcs.pkcs11.provider.ciphers.PKCS5Padding;
import iaik.pkcs.pkcs11.provider.ciphers.Padding;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11Key;
import java.io.ByteArrayOutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

public class EciesCipher
extends PKCS11Cipher {
    protected static final String CIPHER_NAME = "ECIES";
    protected static final String DEFAULT_MODE = "ECB";
    protected static final String DEFAULT_PADDING = "NoPadding";
    protected static final String PKCS5_PADDING = "Pkcs5Padding";
    protected static final Mechanism DEFAULT_MECHANISM = Mechanism.get((long)2147488257L);
    protected static final int PKCS11_OPERATION_SIGN_VERIFY = 1;
    protected static final int PKCS11_OPERATION_ENCRYPT_DECRYPT = 2;
    protected int pkcs11Operation_;
    protected ByteArrayOutputStream buffer_;
    protected int blockSize_ = 16;

    public EciesCipher() {
        this.mode_ = this.getDefaultMode();
        this.padding_ = this.getDefaultPadding();
        this.buffer_ = new ByteArrayOutputStream(128);
    }

    protected Mechanism[] getUsedMechanisms() {
        if (this.usedMechanisms_ == null) {
            this.usedMechanisms_ = new Mechanism[]{Mechanism.get((long)2147488257L)};
        }
        return this.usedMechanisms_;
    }

    protected MechanismInfo[][] getUsedMechanismFeatures() {
        if (this.usedMechanismInfos_ == null) {
            MechanismInfo mechanismInfo = new MechanismInfo();
            mechanismInfo.setEncrypt(true);
            MechanismInfo mechanismInfo2 = new MechanismInfo();
            mechanismInfo2.setDecrypt(true);
            this.usedMechanismInfos_ = new MechanismInfo[][]{{mechanismInfo, mechanismInfo2}};
        }
        return this.usedMechanismInfos_;
    }

    /*
     * WARNING - void declaration
     */
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        int n = -1;
        if (key instanceof IAIKPKCS11Key) {
            void var1_1;
            n = this.pkcs11GetKeySize((Key)var1_1);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    protected void checkKeyObject(iaik.pkcs.pkcs11.objects.Key keyObject) throws InvalidKeyException {
        void var1_1;
        if (keyObject == null) {
            throw new NullPointerException("Argument \"keyObject\" must not be null.");
        }
        if (!(keyObject instanceof ECDSAPrivateKey) && !(var1_1 instanceof ECDSAPublicKey)) {
            throw new InvalidKeyException("PKCS#11 key object inside IAIKPKCS11Key must be of type EC");
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void pkcs11Init(int operationMode, Key key, AlgorithmParameterSpec parameterSpecs, SecureRandom randomSource) throws InvalidAlgorithmParameterException, InvalidKeyException {
        Object object;
        ECIESParameterSpec eCIESParameterSpec;
        void var1_1;
        this.currentKeyIsSoftwareKey_ = false;
        if (operationMode != 1 && operationMode != 2) {
            throw new IAIKPkcs11Exception("Unknown operation mode: " + operationMode);
        }
        this.operationMode_ = var1_1;
        this.key_ = (IAIKPKCS11Key)((Object)eCIESParameterSpec);
        this.keyObject_ = this.key_.getKeyObject();
        EciesCipher eciesCipher = this;
        eciesCipher.checkKeyObject(eciesCipher.keyObject_);
        this.mechanism_ = Mechanism.get((long)2147488257L);
        if (parameterSpecs instanceof ECIESParameterSpec) {
            void var3_5;
            eCIESParameterSpec = (ECIESParameterSpec)var3_5;
            object = this;
            int n = eCIESParameterSpec.getCryptOpt();
            Object object2 = eCIESParameterSpec.getHashAlgorithm();
            String string = eCIESParameterSpec.getSymmetricCipher();
            String string2 = eCIESParameterSpec.getMacAlgorithm();
            long l2 = EciesCipher.a((String)object2);
            long l3 = ((EciesCipher)object).c(string);
            long l4 = EciesCipher.b(string2);
            object = eCIESParameterSpec.getSharedSecret1();
            object2 = eCIESParameterSpec.getSharedSecret2();
            int n2 = eCIESParameterSpec.getMacOpt();
            object = new EcdsaEciesParams(l2, l3, (long)n, l4, (long)n2, (byte[])object, (byte[])object2);
        } else {
            object = new EcdsaEciesParams(592L, 2147488258L, 0L, 593L, 0L);
        }
        this.mechanism_.setParameters((Parameters)object);
        this.initialize();
    }

    private static long a(String string) throws InvalidParameterException, InvalidAlgorithmParameterException {
        long l2;
        String string2 = string.toLowerCase();
        if (string2.equals("sha1") || string2.equals("sha-1") || string2.equals("sha") || string2.equals("1.3.14.3.2.26") || string2.equals("1.3.14.3.2.18")) {
            l2 = 544L;
        } else if (string2.equals("sha224") || string2.equals("sha-224") || string2.equals("2.16.840.1.101.3.4.2.4")) {
            l2 = 597L;
        } else if (string2.equals("sha256") || string2.equals("sha-256") || string2.equals("2.16.840.1.101.3.4.2.1")) {
            l2 = 592L;
        } else if (string2.equals("sha384") || string2.equals("sha-384") || string2.equals("2.16.840.1.101.3.4.2.2")) {
            l2 = 608L;
        } else if (string2.equals("sha512") || string2.equals("sha-512") || string2.equals("2.16.840.1.101.3.4.2.3")) {
            l2 = 624L;
        } else if (string2.equals("md5") || string2.equals("md-5") || string2.equals("1.2.840.113549.2.5")) {
            l2 = 528L;
        } else if (string2.equals("ripemd160") || string2.equals("ripemd-160") || string2.equals("1.3.36.3.2.1") || string2.equals("1.0.10118.3.0.49")) {
            l2 = 576L;
        } else if (string2.equals("sha3-224") || string2.equals("sha3224") || string2.equals("2.16.840.1.101.3.4.2.7")) {
            l2 = 693L;
        } else if (string2.equals("sha3-256") || string2.equals("sha3256") || string2.equals("2.16.840.1.101.3.4.2.8")) {
            l2 = 688L;
        } else if (string2.equals("sha3-384") || string2.equals("sha3384") || string2.equals("2.16.840.1.101.3.4.2.9")) {
            l2 = 704L;
        } else if (string2.equals("sha3-512") || string2.equals("sha3512") || string2.equals("2.16.840.1.101.3.4.2.10")) {
            l2 = 720L;
        } else {
            try {
                return Long.parseLong(string2);
            }
            catch (Exception exception) {
                throw new InvalidAlgorithmParameterException("Invalid HASH algorithm for ECIES: " + string);
            }
        }
        return l2;
    }

    private static long b(String string) throws InvalidAlgorithmParameterException {
        String string2 = string.toLowerCase();
        if (string2.equals("hmacsha1") || string2.equals("hmac/sha1") || string2.equals("hmac/sha-1") || string2.equals("hmac/sha") || string2.equals("1.3.6.1.5.5.8.1.2") || string2.equals("1.2.840.113549.2.7")) {
            return 545L;
        }
        if (string2.equals("hmacsha224") || string2.equals("hmac/sha224") || string2.equals("hmac/sha-224") || string2.equals("1.2.840.113549.2.8")) {
            return 598L;
        }
        if (string2.equals("hmacsha256") || string2.equals("hmac/sha-256") || string2.equals("hmac/sha256") || string2.equals("1.2.840.113549.2.9")) {
            return 593L;
        }
        if (string2.equals("hmacsha384") || string2.equals("hmac/sha-384") || string2.equals("hmac/sha384") || string2.equals("1.2.840.113549.2.10")) {
            return 609L;
        }
        if (string2.equals("hmacsha512") || string2.equals("hmac/sha-512") || string2.equals("hmac/sha512") || string2.equals("1.2.840.113549.2.11")) {
            return 625L;
        }
        if (string2.equals("hmacsha512/224") || string2.equals("hmac/sha512-224") || string2.equals("hmac/sha-512-224")) {
            return 73L;
        }
        if (string2.equals("hmacsha3-224") || string2.equals("hmac/sha3-224") || string2.equals("2.16.840.1.101.3.4.2.13")) {
            return 694L;
        }
        if (string2.equals("hmacsha3-256") || string2.equals("hmac/sha3-256") || string2.equals("2.16.840.1.101.3.4.2.14")) {
            return 689L;
        }
        if (string2.equals("hmacsha3-384") || string2.equals("hmac/sha3-384") || string2.equals("2.16.840.1.101.3.4.2.15")) {
            return 705L;
        }
        if (string2.equals("hmacsha3-512") || string2.equals("hmac/sha3-512") || string2.equals("2.16.840.1.101.3.4.2.16")) {
            return 721L;
        }
        if (string2.equals("hmacmd5") || string2.equals("hmac/md5") || string2.equals("1.3.6.1.5.5.8.1.1")) {
            return 529L;
        }
        if (string2.equals("hmacripemd160") || string2.equals("hmac/ripemd160") || string2.equals("hmac/ripemd-160") || string2.equals("1.3.6.1.5.5.8.1.4")) {
            return 577L;
        }
        if (string2.equals("cmacaes") || string2.equals("cmac/aes")) {
            return 4234L;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (Exception exception) {
            throw new InvalidAlgorithmParameterException("Invalid mac algorithm: " + string);
        }
    }

    private long c(String string) throws InvalidAlgorithmParameterException {
        long l2 = 0L;
        String string2 = string.toLowerCase();
        if (string2.equals("xor")) {
            l2 = 2147488258L;
            this.blockSize_ = 0;
        } else if (string2.startsWith("aes")) {
            this.blockSize_ = 16;
            int n = string2.indexOf(47) + 1;
            if (n == 0) {
                return 4226L;
            }
            if ((string2 = string2.substring(n)).startsWith("cbc")) {
                l2 = 4226L;
            } else if (string2.startsWith("ecb")) {
                l2 = 4225L;
            }
            if (string2.toLowerCase().endsWith("pkcs5padding")) {
                this.padding_ = PKCS5_PADDING;
            }
            try {
                l2 = Long.parseLong(string);
            }
            catch (Exception exception) {}
        }
        if (l2 == 0L) {
            throw new InvalidAlgorithmParameterException("Invalid symmectric cipher: " + string);
        }
        return l2;
    }

    protected void initializePkcs11Operation() throws InvalidAlgorithmParameterException, InvalidKeyException {
        this.initializeSession();
        try {
            iaik.pkcs.pkcs11.objects.Key key = this.key_.getKeyObject();
            if (this.operationMode_ == 2) {
                if (key instanceof PublicKey) {
                    this.session_.verifyRecoverInit(this.mechanism_, key);
                    this.pkcs11Operation_ = 1;
                } else {
                    this.session_.decryptInit(this.mechanism_, this.key_.getKeyObject());
                    this.pkcs11Operation_ = 2;
                }
            } else if (this.operationMode_ == 1) {
                if (key instanceof PrivateKey) {
                    this.session_.signInit(this.mechanism_, key);
                    this.pkcs11Operation_ = 1;
                } else {
                    this.session_.encryptInit(this.mechanism_, key);
                    this.pkcs11Operation_ = 2;
                }
            }
        }
        catch (TokenException tokenException) {
            throw new InvalidKeyException("Error initializing the PKCS#11 ECIES cipher: " + (Object)((Object)tokenException));
        }
        this.updateUsed_ = false;
        this.pkcs11OperationInitialized_ = true;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isModeSupported(String mode) {
        void var1_1;
        return mode != null && (mode.equals("CBC") || var1_1.equals(DEFAULT_MODE));
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isPaddingSupported(String padding) {
        void var1_1;
        return padding != null && (padding.equals(PKCS5_PADDING) || var1_1.equals(DEFAULT_PADDING));
    }

    /*
     * WARNING - void declaration
     */
    protected byte[] pkcs11Update(byte[] data, int offset, int length) {
        void var3_5;
        void var2_4;
        void var1_1;
        if (!this.initialized_ || this.key_ == null) {
            throw new IllegalStateException("Cipher not initialized.");
        }
        if (data == null) {
            throw new NullPointerException("Argument \"data\" must not be null.");
        }
        if (offset + length > data.length) {
            throw new NullPointerException("Arguments must satisfy ((offset + length) <= data.length).");
        }
        if (!this.pkcs11OperationInitialized_) {
            try {
                this.initializePkcs11Operation();
            }
            catch (InvalidKeyException invalidKeyException) {
                this.finalizePkcs11Operation();
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidKeyException);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                this.finalizePkcs11Operation();
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidAlgorithmParameterException);
            }
        }
        this.buffer_.write((byte[])var1_1, (int)var2_4, (int)var3_5);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected byte[] pkcs11DoFinal(byte[] input, int inputOffset, int inputLength) throws BadPaddingException, IllegalBlockSizeException {
        byte[] byArray;
        if (!this.initialized_ || this.key_ == null) {
            throw new IllegalStateException("Cipher not initialized.");
        }
        if (input != null && inputOffset + inputLength > input.length) {
            throw new NullPointerException("Arguments must satisfy ((inputOffset + inputLength) <= input.length).");
        }
        if (!this.pkcs11OperationInitialized_) {
            try {
                this.initializePkcs11Operation();
            }
            catch (InvalidKeyException invalidKeyException) {
                this.finalizePkcs11Operation();
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidKeyException);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                this.finalizePkcs11Operation();
                throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 cipher for next cipher operation: " + invalidAlgorithmParameterException);
            }
        }
        if (byArray != null) {
            void var3_9;
            void var2_5;
            this.buffer_.write(byArray, (int)var2_5, (int)var3_9);
        }
        if (this.padding_.equals(PKCS5_PADDING) && this.operationMode_ == 1) {
            PKCS5Padding pKCS5Padding = new PKCS5Padding();
            new PKCS5Padding().blockSize_ = this.blockSize_;
            byArray = this.buffer_.toByteArray();
            byArray = ((Padding)pKCS5Padding).pad(byArray, 0, byArray.length);
        } else {
            byArray = this.buffer_.toByteArray();
        }
        this.buffer_.reset();
        try {
            if (this.operationMode_ == 1) {
                byArray = this.pkcs11Operation_ == 1 ? this.session_.sign(byArray) : this.session_.encrypt(byArray);
            } else if (this.operationMode_ == 2) {
                byArray = this.pkcs11Operation_ == 1 ? this.session_.verifyRecover(byArray) : this.session_.decrypt(byArray);
            } else {
                throw new UnsupportedOperationException("Method only supported in state encrypt or decrypt.");
            }
            this.pkcs11OperationInitialized_ = false;
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception("Error finishing cipher operation: " + (Object)((Object)tokenException));
        }
        finally {
            this.finalizePkcs11Operation();
        }
        if (this.padding_.endsWith(PKCS5_PADDING) && this.operationMode_ == 2) {
            PKCS5Padding pKCS5Padding = new PKCS5Padding();
            new PKCS5Padding().blockSize_ = this.blockSize_;
            return ((Padding)pKCS5Padding).unpad(byArray, 0, byArray.length);
        }
        return byArray;
    }

    protected String getAlgorithmName() {
        return CIPHER_NAME;
    }

    protected int pkcs11GetBlockSize() {
        return this.blockSize_;
    }

    protected Mechanism getDefaultMechanism() {
        return DEFAULT_MECHANISM;
    }

    protected String getDefaultMode() {
        return DEFAULT_MODE;
    }

    protected String getDefaultPadding() {
        return DEFAULT_PADDING;
    }

    protected Mechanism getMechanism() {
        if (this.modeChanged_ || this.paddingChanged_) {
            try {
                this.mechanism_ = this.getMechanismForModeAndPadding();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.mechanism_ = null;
            }
            this.modeChanged_ = false;
            this.paddingChanged_ = false;
        }
        return this.mechanism_;
    }

    protected Mechanism getMechanismForModeAndPadding() throws NoSuchAlgorithmException {
        return null;
    }
}

