/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.ciphers;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.objects.DESSecretKey;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.provider.ciphers.BlockCipher;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey;
import java.security.InvalidKeyException;
import java.util.Hashtable;

public class DesCipher
extends BlockCipher {
    protected static final String CIPHER_NAME = "DES";
    protected static final Mechanism DEFAULT_MECHANISM = Mechanism.get((long)289L);
    protected static Hashtable cipherModePaddingMechansims_;

    protected Mechanism[] getUsedMechanisms() {
        if (this.usedMechanisms_ == null) {
            this.usedMechanisms_ = new Mechanism[]{Mechanism.get((long)293L), Mechanism.get((long)289L), Mechanism.get((long)290L)};
        }
        return this.usedMechanisms_;
    }

    /*
     * WARNING - void declaration
     */
    protected void checkKeyObject(Key keyObject) throws InvalidKeyException {
        void var1_1;
        if (keyObject == null) {
            throw new NullPointerException("Argument \"keyObject\" must not be null.");
        }
        if (!(var1_1 instanceof DESSecretKey)) {
            throw new InvalidKeyException("PKCS#11 key object inside IAIKPKCS11SecretKey must be of type DESSecretKey");
        }
    }

    protected String getAlgorithmName() {
        return CIPHER_NAME;
    }

    protected Hashtable getModePaddingMechanisms() {
        if (cipherModePaddingMechansims_ == null) {
            Hashtable<String, Mechanism> hashtable = new Hashtable<String, Mechanism>(3);
            hashtable.put("ecb/nopadding", Mechanism.get((long)289L));
            hashtable.put("cbc/nopadding", Mechanism.get((long)290L));
            hashtable.put("cbc/pkcs5padding", Mechanism.get((long)293L));
            cipherModePaddingMechansims_ = hashtable;
        }
        return cipherModePaddingMechansims_;
    }

    protected Mechanism getDefaultMechanism() {
        return DEFAULT_MECHANISM;
    }

    /*
     * WARNING - void declaration
     */
    protected int pkcs11GetOutputSize(int inputLen) {
        int n = -1;
        if (inputLen >= 0) {
            void var1_1;
            n = var1_1 + 15;
        }
        return n;
    }

    protected int pkcs11GetKeySize(java.security.Key key) throws InvalidKeyException {
        SecretKey secretKey;
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        if (key instanceof IAIKPKCS11SecretKey) {
            secretKey = (SecretKey)((IAIKPKCS11SecretKey)key).getKeyObject();
            if (!(secretKey instanceof DESSecretKey)) {
                throw new InvalidKeyException("The provided IAIKPKCS11SecretKey must contain a DES secret key but contains: " + secretKey.toString());
            }
        } else {
            throw new InvalidKeyException("The provided key must be an IAIKPKCS11SecretKey but it is: " + secretKey.toString());
        }
        return 56;
    }

    protected int pkcs11GetBlockSize() {
        return 8;
    }
}

