/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.ciphers;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.parameters.CcmParameters;
import iaik.pkcs.pkcs11.parameters.GcmParameters;
import iaik.pkcs.pkcs11.parameters.InitializationVectorParameters;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.provider.DelegateProvider;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.ciphers.PKCS11CCMParameterSpec;
import iaik.pkcs.pkcs11.provider.ciphers.PKCS11Cipher;
import iaik.pkcs.pkcs11.provider.ciphers.PKCS11GCMParameterSpec;
import iaik.pkcs.pkcs11.provider.ciphers.PKCS11UnwrapKeySpec;
import iaik.pkcs.pkcs11.provider.ciphers.Padding;
import iaik.pkcs.pkcs11.provider.ciphers.a;
import iaik.pkcs.pkcs11.provider.ciphers.b;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey;
import iaik.pkcs.pkcs11.provider.spec.PKCS11Spec;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Hashtable;
import java.util.Vector;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public abstract class BlockCipher
extends PKCS11Cipher {
    protected static final String DEFAULT_MODE = "ECB";
    protected static final String DEFAULT_PADDING = "NoPadding";
    protected static Vector supportedModes_;
    protected static Vector supportedPaddings_;
    protected static Vector externalPaddings_;
    protected Hashtable modePaddingMechanisms_ = this.getModePaddingMechanisms();
    protected AlgorithmParameterSpec ivParameterSpec_;
    protected boolean ivParameterSpecChanged_;
    protected Padding externalPadding_;
    private static Class a;
    private static Class b;
    private static Class c;

    public BlockCipher() {
        this.mode_ = this.getDefaultMode();
        this.padding_ = this.getDefaultPadding();
        this.externalPadding_ = new b();
        int n = this.pkcs11GetBlockSize();
        if (n > 0) {
            this.externalPadding_.setBlockSize(n);
        }
    }

    protected MechanismInfo[][] getUsedMechanismFeatures() {
        if (this.usedMechanismInfos_ == null) {
            MechanismInfo mechanismInfo = new MechanismInfo();
            mechanismInfo.setEncrypt(true);
            MechanismInfo mechanismInfo2 = new MechanismInfo();
            mechanismInfo2.setDecrypt(true);
            this.usedMechanismInfos_ = new MechanismInfo[][]{{mechanismInfo, mechanismInfo2}, {mechanismInfo, mechanismInfo2}, {mechanismInfo, mechanismInfo2}};
        }
        return this.usedMechanismInfos_;
    }

    /*
     * WARNING - void declaration
     */
    protected void checkKeyObject(iaik.pkcs.pkcs11.objects.Key keyObject) throws InvalidKeyException {
        void var1_1;
        if (keyObject == null) {
            throw new NullPointerException("Argument \"keyObject\" must not be null.");
        }
        if (!(var1_1 instanceof SecretKey)) {
            throw new InvalidKeyException("PKCS#11 key object inside IAIKPKCS11SecretKey must be of type SecretKey");
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void pkcs11Init(int operationMode, Key key, AlgorithmParameters parameters, SecureRandom random) throws InvalidAlgorithmParameterException, InvalidKeyException {
        try {
            void var2_2;
            void var1_1;
            void var3_3;
            AlgorithmParameterSpec algorithmParameterSpec = parameters != null ? (AlgorithmParameterSpec)parameters.getParameterSpec(a == null ? (a = BlockCipher.a("javax.crypto.spec.IvParameterSpec")) : a) : null;
            this.parameters_ = var3_3;
            this.pkcs11Init((int)var1_1, (Key)var2_2, algorithmParameterSpec, random);
            return;
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidAlgorithmParameterException(invalidParameterSpecException.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void pkcs11Init(int operationMode, Key key, AlgorithmParameterSpec parameterSpecs, SecureRandom randomSource) throws InvalidAlgorithmParameterException, InvalidKeyException {
        void var3_3;
        void var1_1;
        IAIKPKCS11SecretKey iAIKPKCS11SecretKey;
        if (operationMode != 1 && operationMode != 2 && operationMode != 4 && operationMode != 3) {
            throw new IAIKPkcs11Exception("Unknown operation mode: " + operationMode);
        }
        if (!(key instanceof IAIKPKCS11SecretKey)) {
            throw new InvalidKeyException("key must be of type iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey!");
        }
        if (!(operationMode != 4 && operationMode != 3 || this.externalPadding_ instanceof b)) {
            throw new InvalidKeyException("Wrap or unwrap mode not supported for padding " + this.padding_);
        }
        iAIKPKCS11SecretKey = iAIKPKCS11SecretKey;
        iaik.pkcs.pkcs11.objects.Key key2 = iAIKPKCS11SecretKey.getKeyObject();
        this.checkKeyObject(key2);
        if (parameterSpecs instanceof PKCS11UnwrapKeySpec) {
            this.parameterSpecs_ = (PKCS11Spec)((Object)parameterSpecs);
            this.unwrapTemplate_ = ((PKCS11UnwrapKeySpec)parameterSpecs).getKeyTemplate();
            parameterSpecs = ((PKCS11UnwrapKeySpec)parameterSpecs).getIV();
        }
        if (this.mode_.equalsIgnoreCase("ecb") && parameterSpecs != null) {
            throw new InvalidAlgorithmParameterException("AlgorithmParameterSpec not supported in ECB mode, but parameterSpecs is: " + parameterSpecs);
        }
        if (this.mode_.equalsIgnoreCase("cbc")) {
            if (operationMode == 1 && parameterSpecs == null) {
                Object object = this.a();
                object = ((DelegateProvider)object).getSecureRandom(null);
                int n = this.pkcs11GetBlockSize();
                if (n < 0) {
                    throw new InvalidAlgorithmParameterException("No IV specified and unknown block size of cipher");
                }
                byte[] byArray = new byte[n];
                ((SecureRandom)object).nextBytes(byArray);
                parameterSpecs = new IvParameterSpec(byArray);
            }
            if (parameterSpecs == null || !(parameterSpecs instanceof IvParameterSpec)) {
                throw new InvalidAlgorithmParameterException("AlgorithmParameterSpec IvParameterSpec required in CBC mode, but parameterSpecs is: " + parameterSpecs);
            }
        } else if (this.mode_.equalsIgnoreCase("ccm")) {
            Object object;
            if (operationMode == 1 && parameterSpecs instanceof PKCS11CCMParameterSpec && (object = ((PKCS11CCMParameterSpec)parameterSpecs).getIV()) == null) {
                DelegateProvider delegateProvider = this.a();
                object = delegateProvider;
                Object object2 = delegateProvider.getSecureRandom(null);
                int n = this.pkcs11GetBlockSize();
                if (n < 0) {
                    throw new InvalidAlgorithmParameterException("No IV specified and unknown block size of cipher");
                }
                object = new byte[n];
                ((SecureRandom)object2).nextBytes((byte[])object);
                object2 = ((PKCS11CCMParameterSpec)parameterSpecs).getAdditionalData();
                long l2 = ((PKCS11CCMParameterSpec)parameterSpecs).getDataLen();
                long l3 = ((PKCS11CCMParameterSpec)parameterSpecs).getMacLen();
                parameterSpecs = new PKCS11CCMParameterSpec((byte[])object, (byte[])object2, l2, l3);
            }
            if (parameterSpecs == null || !(parameterSpecs instanceof PKCS11CCMParameterSpec)) {
                throw new InvalidAlgorithmParameterException("AlgorithmParameterSpec " + (b == null ? (b = BlockCipher.a("iaik.pkcs.pkcs11.provider.ciphers.PKCS11CCMParameterSpec")) : b).getName() + " required in CCM mode, but parameterSpecs is: " + parameterSpecs);
            }
        } else if (this.mode_.equalsIgnoreCase("gcm")) {
            if (operationMode == 1 && parameterSpecs == null) {
                Object object = this.a();
                object = ((DelegateProvider)object).getSecureRandom(null);
                int n = this.pkcs11GetBlockSize();
                if (n < 0) {
                    throw new InvalidAlgorithmParameterException("No IV specified and unknown block size of cipher");
                }
                byte[] byArray = new byte[n];
                ((SecureRandom)object).nextBytes(byArray);
                parameterSpecs = new PKCS11GCMParameterSpec(byArray, null, 12L);
            }
            if (parameterSpecs == null || !(parameterSpecs instanceof PKCS11GCMParameterSpec)) {
                throw new InvalidAlgorithmParameterException("AlgorithmParameterSpec " + (c == null ? (c = BlockCipher.a("iaik.pkcs.pkcs11.provider.ciphers.PKCS11GCMParameterSpec")) : c).getName() + " required in GCM mode, but parameterSpecs is: " + parameterSpecs);
            }
        }
        this.key_ = iAIKPKCS11SecretKey;
        this.keyObject_ = key2;
        this.operationMode_ = var1_1;
        this.ivParameterSpec_ = var3_3;
        this.ivParameterSpecChanged_ = true;
        this.mechanism_ = this.getMechanism();
        this.externalPadding_.setBlockSize(this.pkcs11GetBlockSize());
        if (this.mechanism_ == null) {
            throw new IAIKPkcs11Exception("The currently selected combination of mode and padding is not supported: " + this.mode_ + "/" + this.padding_);
        }
        this.initialize();
    }

    protected AlgorithmParameters pkcs11GetParameters() {
        if (this.ivParameterSpec_ != null) {
            if (this.parameters_ == null) {
                Object object = this.a();
                if ((object = ((DelegateProvider)object).getParameters(this.getAlgorithmName())) == null) {
                    throw new IAIKPkcs11Exception("No algorithm parameters implementation available from software delegate");
                }
                this.parameters_ = object;
            }
            try {
                this.parameters_.init(this.ivParameterSpec_);
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new IAIKPkcs11Exception("Could not convert IV parameter spec to parameters: " + invalidParameterSpecException);
            }
        }
        return this.parameters_;
    }

    protected abstract int pkcs11GetKeySize(Key var1) throws InvalidKeyException;

    protected abstract int pkcs11GetBlockSize();

    protected byte[] pkcs11GetIV() {
        byte[] byArray = this.ivParameterSpec_ != null ? ((IvParameterSpec)this.ivParameterSpec_).getIV() : null;
        return byArray;
    }

    protected String getDefaultMode() {
        return DEFAULT_MODE;
    }

    protected String getDefaultPadding() {
        return DEFAULT_PADDING;
    }

    protected abstract Mechanism getDefaultMechanism();

    protected Mechanism getMechanism() {
        Mechanism mechanism = null;
        if (this.modeChanged_ || this.paddingChanged_ || this.ivParameterSpecChanged_) {
            long l2;
            byte[] byArray;
            Object object;
            Object object2;
            try {
                mechanism = this.getMechanismForModeAndPadding();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
            if (mechanism != null && this.mode_.equalsIgnoreCase("cbc") && this.ivParameterSpec_ != null) {
                object2 = ((IvParameterSpec)this.ivParameterSpec_).getIV();
                object = new InitializationVectorParameters((byte[])object2);
                mechanism.setParameters((Parameters)object);
            }
            if (mechanism != null && this.mode_.equalsIgnoreCase("gcm") && this.ivParameterSpec_ != null) {
                if (!(this.ivParameterSpec_ instanceof PKCS11GCMParameterSpec)) {
                    throw new IllegalArgumentException("Illegal ParameterSpec! Use GCMParameterSpec for AES in GCM mode");
                }
                PKCS11GCMParameterSpec pKCS11GCMParameterSpec = (PKCS11GCMParameterSpec)this.ivParameterSpec_;
                object2 = pKCS11GCMParameterSpec;
                object = pKCS11GCMParameterSpec.getIV();
                byArray = ((PKCS11GCMParameterSpec)object2).getAdditionalData();
                l2 = ((PKCS11GCMParameterSpec)object2).getTagBits();
                GcmParameters gcmParameters = new GcmParameters((byte[])object, byArray, l2);
                mechanism.setParameters((Parameters)gcmParameters);
            }
            if (mechanism != null && this.mode_.equalsIgnoreCase("ccm") && this.ivParameterSpec_ != null) {
                if (!(this.ivParameterSpec_ instanceof PKCS11CCMParameterSpec)) {
                    throw new IllegalArgumentException("Illegal ParameterSpec! Use CCMParameterSpec for AES in CCM mode");
                }
                PKCS11CCMParameterSpec pKCS11CCMParameterSpec = (PKCS11CCMParameterSpec)this.ivParameterSpec_;
                object2 = pKCS11CCMParameterSpec;
                object = pKCS11CCMParameterSpec.getIV();
                byArray = ((PKCS11CCMParameterSpec)object2).getAdditionalData();
                l2 = ((PKCS11CCMParameterSpec)object2).getDataLen();
                long l3 = ((PKCS11CCMParameterSpec)object2).getMacLen();
                object2 = new CcmParameters(l2, (byte[])object, byArray, l3);
                mechanism.setParameters((Parameters)object2);
            }
            this.mechanism_ = mechanism;
            this.modeChanged_ = false;
            this.paddingChanged_ = false;
            this.ivParameterSpecChanged_ = false;
        }
        return this.mechanism_;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Mechanism getMechanismForModeAndPadding() throws NoSuchAlgorithmException {
        void var1_8;
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append(this.mode_);
        stringBuffer.append('/');
        stringBuffer.append(this.padding_);
        String string = stringBuffer.toString().toLowerCase();
        StringBuffer stringBuffer2 = new StringBuffer(16);
        stringBuffer2.append(this.mode_);
        stringBuffer2.append('/');
        stringBuffer2.append("nopadding");
        String string2 = stringBuffer2.toString().toLowerCase();
        if (this.modePaddingMechanisms_.containsKey(string)) {
            Mechanism mechanism = (Mechanism)this.modePaddingMechanisms_.get(string);
            if (mechanism == null) throw new NoSuchAlgorithmException("Combination of mode and padding not supported: " + string);
            Mechanism mechanism2 = (Mechanism)mechanism.clone();
            return var1_8;
        } else {
            if (!this.modePaddingMechanisms_.containsKey(string2)) throw new NoSuchAlgorithmException("Combination of mode and padding not supported: " + string);
            Mechanism mechanism = (Mechanism)this.modePaddingMechanisms_.get(string2);
            if (mechanism == null) {
                throw new NoSuchAlgorithmException("Combination of mode and padding not supported: " + string);
            }
            Mechanism mechanism3 = (Mechanism)mechanism.clone();
            if (!this.padding_.toLowerCase().equals("iso10126padding")) throw new NoSuchAlgorithmException("Combination of mode and padding not supported: " + string);
            this.externalPadding_ = new a();
            int n = this.pkcs11GetBlockSize();
            if (n <= 0) return var1_8;
            this.externalPadding_.setBlockSize(n);
        }
        return var1_8;
    }

    protected abstract Hashtable getModePaddingMechanisms();

    /*
     * WARNING - void declaration
     */
    protected boolean isModeSupported(String mode) {
        boolean bl = false;
        if (mode != null) {
            void var1_1;
            if (supportedModes_ == null) {
                Vector<String> vector = new Vector<String>(2);
                vector.add("ecb");
                vector.add("cbc");
                supportedModes_ = vector;
            }
            bl = supportedModes_.contains(var1_1.toLowerCase());
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isPaddingSupported(String padding) {
        boolean bl = false;
        if (padding != null) {
            if (supportedPaddings_ == null) {
                Vector<String> vector = new Vector<String>(2);
                vector.add("nopadding");
                vector.add("pkcs5padding");
                supportedPaddings_ = vector;
            }
            bl = supportedPaddings_.contains(padding.toLowerCase());
        }
        if (!bl) {
            void var1_1;
            bl = BlockCipher.isExternalPaddingSupported((String)var1_1);
        }
        return bl;
    }

    protected static boolean isExternalPaddingSupported(String padding) {
        boolean bl = false;
        if (padding != null) {
            String string;
            if (externalPaddings_ == null) {
                Vector<String> vector = new Vector<String>(2);
                vector.add(iaik.pkcs.pkcs11.provider.ciphers.b.a);
                String[] stringArray = iaik.pkcs.pkcs11.provider.ciphers.a.a;
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    vector.add(stringArray[i2]);
                }
                externalPaddings_ = vector;
            }
            bl = externalPaddings_.contains(string.toLowerCase());
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    protected byte[] pkcs11Update(byte[] data, int offset, int length) {
        void var3_3;
        void var2_2;
        byte[] byArray;
        if (data == null) {
            throw new NullPointerException("Argument \"data\" must not be null.");
        }
        if (offset + length > data.length) {
            throw new IllegalArgumentException("Arguments must satisfy ((offset + length) <= data.length).");
        }
        if (this.operationMode_ == 1 || this.operationMode_ == 3) {
            byArray = this.externalPadding_.pad(data, offset, length);
            return super.pkcs11Update(byArray, 0, byArray.length);
        }
        byArray = super.pkcs11Update(byArray, (int)var2_2, (int)var3_3);
        return this.externalPadding_.unpad(byArray, 0, byArray.length);
    }

    /*
     * WARNING - void declaration
     */
    protected byte[] pkcs11DoFinal(byte[] input, int inputOffset, int inputLength) throws BadPaddingException, IllegalBlockSizeException {
        void var3_3;
        void var2_2;
        byte[] byArray;
        if (input != null && inputOffset + inputLength > input.length) {
            throw new IllegalArgumentException("Arguments must satisfy ((inputOffset + inputLength) <= input.length).");
        }
        if (this.operationMode_ == 1 || this.operationMode_ == 3) {
            byArray = this.externalPadding_.padFinal(input, inputOffset, inputLength);
            if (byArray != null) {
                return super.pkcs11DoFinal(byArray, 0, byArray.length);
            }
            return super.pkcs11DoFinal(null, 0, 0);
        }
        if ((byArray = super.pkcs11DoFinal(byArray, (int)var2_2, (int)var3_3)) != null) {
            return this.externalPadding_.unpadFinal(byArray, 0, byArray.length);
        }
        return this.externalPadding_.unpadFinal(null, 0, 0);
    }

    private static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

