/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.ciphers;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.objects.AESSecretKey;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.provider.ciphers.BlockCipher;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey;
import java.security.InvalidKeyException;
import java.util.Hashtable;
import java.util.Vector;

public class AesCipher
extends BlockCipher {
    protected static final String CIPHER_NAME = "AES";
    protected static final Mechanism DEFAULT_MECHANISM = Mechanism.get((long)4225L);
    protected static Vector supportedModes_;
    protected static Hashtable cipherModePaddingMechansims_;

    protected Mechanism[] getUsedMechanisms() {
        if (this.usedMechanisms_ == null) {
            this.usedMechanisms_ = new Mechanism[]{Mechanism.get((long)4229L), Mechanism.get((long)4225L), Mechanism.get((long)4226L), Mechanism.get((long)4231L), Mechanism.get((long)4232L)};
        }
        return this.usedMechanisms_;
    }

    protected MechanismInfo[][] getUsedMechanismFeatures() {
        if (this.usedMechanismInfos_ == null) {
            MechanismInfo mechanismInfo = new MechanismInfo();
            mechanismInfo.setEncrypt(true);
            MechanismInfo mechanismInfo2 = new MechanismInfo();
            mechanismInfo2.setDecrypt(true);
            this.usedMechanismInfos_ = new MechanismInfo[][]{{mechanismInfo, mechanismInfo2}, {mechanismInfo, mechanismInfo2}, {mechanismInfo, mechanismInfo2}, {mechanismInfo, mechanismInfo2}, {mechanismInfo, mechanismInfo2}};
        }
        return this.usedMechanismInfos_;
    }

    /*
     * WARNING - void declaration
     */
    protected void checkKeyObject(Key keyObject) throws InvalidKeyException {
        void var1_1;
        if (keyObject == null) {
            throw new NullPointerException("Argument \"keyObject\" must not be null.");
        }
        if (!(var1_1 instanceof AESSecretKey)) {
            throw new InvalidKeyException("PKCS#11 key object inside IAIKPKCS11SecretKey must be of type AESSecretKey");
        }
    }

    protected String getAlgorithmName() {
        return CIPHER_NAME;
    }

    protected Hashtable getModePaddingMechanisms() {
        if (cipherModePaddingMechansims_ == null) {
            Hashtable<String, Mechanism> hashtable = new Hashtable<String, Mechanism>(5);
            hashtable.put("ecb/nopadding", Mechanism.get((long)4225L));
            hashtable.put("cbc/nopadding", Mechanism.get((long)4226L));
            hashtable.put("cbc/pkcs5padding", Mechanism.get((long)4229L));
            hashtable.put("gcm/nopadding", Mechanism.get((long)4231L));
            hashtable.put("ccm/nopadding", Mechanism.get((long)4232L));
            cipherModePaddingMechansims_ = hashtable;
        }
        return cipherModePaddingMechansims_;
    }

    protected Mechanism getDefaultMechanism() {
        return DEFAULT_MECHANISM;
    }

    /*
     * WARNING - void declaration
     */
    protected int getOutputSize(int inputLen) {
        int n = -1;
        if (inputLen >= 0) {
            void var1_1;
            n = var1_1 + 15;
        }
        return n;
    }

    protected int pkcs11GetKeySize(java.security.Key key) throws InvalidKeyException {
        SecretKey secretKey;
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        if (key instanceof IAIKPKCS11SecretKey) {
            secretKey = (SecretKey)((IAIKPKCS11SecretKey)key).getKeyObject();
            if (!(secretKey instanceof AESSecretKey)) {
                throw new InvalidKeyException("The provided IAIKPKCS11SecretKey must contain a AES secret key but contains: " + secretKey.toString());
            }
        } else {
            throw new InvalidKeyException("The provided key must be an IAIKPKCS11SecretKey but it is: " + secretKey.toString());
        }
        secretKey = (AESSecretKey)secretKey;
        int n = secretKey.getValueLen().getLongValue().intValue() << 3;
        return n;
    }

    protected int pkcs11GetBlockSize() {
        return 16;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isModeSupported(String mode) {
        boolean bl = false;
        if (mode != null) {
            void var1_1;
            if (supportedModes_ == null) {
                Vector<String> vector = new Vector<String>(4);
                vector.add("ecb");
                vector.add("cbc");
                vector.add("gcm");
                vector.add("ccm");
                supportedModes_ = vector;
            }
            bl = supportedModes_.contains(var1_1.toLowerCase());
        }
        return bl;
    }
}

