/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider;

import iaik.pkcs.pkcs11.DefaultInitializeArgs;
import iaik.pkcs.pkcs11.InitializeArgs;
import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Slot;
import iaik.pkcs.pkcs11.State;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.provider.Constants;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11AuthenticationCanceledException;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11AuthenticationException;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11TokenUnavailableException;
import iaik.pkcs.pkcs11.provider.LoginManager;
import iaik.pkcs.pkcs11.provider.SessionContainer;
import iaik.pkcs.pkcs11.provider.TokenKeyStore;
import iaik.pkcs.pkcs11.provider.TokenKeyStoreFastSpi;
import iaik.pkcs.pkcs11.provider.TokenKeyStoreSpi;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class TokenManager {
    protected static final Object moduleMapsLock_ = new Object();
    protected static final HashMap usedModulesMap_ = new HashMap(4);
    protected static final HashMap modulesUsageCounterMap_ = new HashMap(4);
    protected static final HashMap usedSlotsMap_ = new HashMap(4);
    protected IAIKPkcs11 myProvider_;
    protected String pkcs11ModulePath_;
    protected Module pkcs11module_;
    protected Slot slot_;
    protected Set activeSessions_ = new HashSet(4);
    protected LinkedList sessionROPool_;
    protected LinkedList lockedSessionROPool_;
    protected LinkedList sessionRWPool_;
    protected int sessionPoolMaxSize_;
    protected int openSessions_;
    protected int sessionsInPool_;
    protected int openedSessionsTotal_;
    protected Map sessionCloseLockCounts_ = new HashMap(4);
    protected Set sessionsToBeClosed_ = new HashSet(4);
    protected Set keyStores_ = new HashSet(4);
    private boolean a;
    private Map b;
    private boolean c;
    private boolean d = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Module a(Properties properties) throws TokenException, IOException, IAIKPkcs11Exception {
        String string = properties.getProperty("PKCS11_NATIVE_MODULE");
        if (string == null) {
            throw new IAIKPkcs11Exception("Required PKCS11_NATIVE_MODULE property has not been configured; e.g. check if properties files are in the CLASSPATH.");
        }
        String string2 = properties.getProperty("PKCS11_WRAPPER_PATH");
        if (string2 == null) {
            boolean bl = new Boolean(properties.getProperty("PKCS11_WRAPPER_NATIVE_DEBUG", "false"));
            string = Module.getInstance((String)string, (boolean)bl);
        } else {
            string = Module.getInstance((String)string, (String)string2);
        }
        Object object = moduleMapsLock_;
        synchronized (object) {
            Object object2 = (Module)usedModulesMap_.get(string);
            if (object2 != null) {
                string = object2;
            } else {
                String string3 = string;
                usedModulesMap_.put(string3, string3);
            }
            object2 = (Integer)modulesUsageCounterMap_.get(string);
            if (object2 == null) {
                block16: {
                    object2 = properties.getProperty("MODULE_INITIALIZATION_PARAMETERS", null);
                    if (object2 == null) {
                        object2 = Boolean.valueOf(properties.getProperty("MULTI_THREAD_INIT", "true")).booleanValue() ? new DefaultInitializeArgs(null, false, true) : null;
                    } else {
                        DefaultInitializeArgs defaultInitializeArgs = new DefaultInitializeArgs();
                        byte[] byArray = object2.getBytes("UTF-8");
                        object2 = byArray;
                        byte[] byArray2 = new byte[byArray.length + 9];
                        System.arraycopy(object2, 0, byArray2, 0, ((Module)object2).length);
                        defaultInitializeArgs.setReserved((Object)byArray2);
                        object2 = defaultInitializeArgs;
                    }
                    try {
                        string.initialize((InitializeArgs)object2);
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        boolean bl = false;
                        if (pKCS11Exception.getErrorCode() != 401L || properties.getProperty("MODULE_ALREADY_INITIALIZED", "ignore").equals("exception")) {
                            bl = true;
                        }
                        if (!bl) break block16;
                        try {
                            string.finalize(null);
                        }
                        catch (TokenException tokenException) {}
                        throw pKCS11Exception;
                    }
                }
                Integer n = 0;
                modulesUsageCounterMap_.put(string, n);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenManager(IAIKPkcs11 myProvider) throws IOException, TokenException, IAIKPkcs11Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Properties properties;
        new Boolean(true);
        if (myProvider == null) {
            throw new NullPointerException("Argument \"myProvider\" must not be null");
        }
        this.myProvider_ = myProvider;
        String string = (properties = ((IAIKPkcs11)properties).getProperties()).getProperty("PKCS11_NATIVE_MODULE");
        if (string == null) {
            throw new IAIKPkcs11Exception("Required PKCS11_NATIVE_MODULE property has not been configured; e.g. check if properties files are in the CLASSPATH.");
        }
        String string2 = properties.getProperty("SLOT_ID");
        boolean bl = new Boolean(properties.getProperty("USE_UTF8_ENCODING", "true"));
        String string3 = properties.getProperty("PKCS11_WRAPPER_PATH");
        if (string3 == null) {
            boolean bl2 = new Boolean(properties.getProperty("PKCS11_WRAPPER_NATIVE_DEBUG", "false"));
            properties = Module.getInstance((String)string, (boolean)bl2);
        } else {
            properties = Module.getInstance((String)string, (String)string3);
        }
        Object object5 = moduleMapsLock_;
        synchronized (object5) {
            object4 = (Module)usedModulesMap_.get(properties);
            if (object4 != null) {
                properties = object4;
            } else {
                Properties properties2 = properties;
                usedModulesMap_.put(properties2, properties2);
            }
            object3 = (Slot[])modulesUsageCounterMap_.get(properties);
            if (object3 == null) {
                block40: {
                    DefaultInitializeArgs defaultInitializeArgs;
                    String string4 = this.myProvider_.getModuleInitializationParameters();
                    if (string4 == null) {
                        defaultInitializeArgs = this.myProvider_.isMultiThreadInit() ? new DefaultInitializeArgs(null, false, true) : null;
                    } else {
                        object2 = new DefaultInitializeArgs();
                        byte[] byArray = string4.getBytes("UTF-8");
                        object = new byte[byArray.length + 9];
                        System.arraycopy(byArray, 0, object, 0, byArray.length);
                        object2.setReserved(object);
                        defaultInitializeArgs = object2;
                    }
                    try {
                        properties.initialize((InitializeArgs)defaultInitializeArgs);
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        boolean bl3 = false;
                        if (pKCS11Exception.getErrorCode() != 401L || this.myProvider_.getModuleAlreadyInitialized().equals("exception")) {
                            bl3 = true;
                        }
                        if (!bl3) break block40;
                        try {
                            properties.finalize(null);
                        }
                        catch (TokenException tokenException) {}
                        throw pKCS11Exception;
                    }
                }
                object3 = 1;
                modulesUsageCounterMap_.put(properties, object3);
            } else {
                object3 = new Integer((Integer)object3 + 1);
                modulesUsageCounterMap_.put(properties, object3);
            }
        }
        try {
            object5 = usedSlotsMap_;
            synchronized (object5) {
                object4 = (Map)usedSlotsMap_.get(properties);
                if (object4 == null) {
                    object4 = new HashMap();
                    usedSlotsMap_.put(properties, object4);
                }
                if (string2 != null && !string2.equals("")) {
                    long l2;
                    object3 = properties.getSlotList(false);
                    if (string2.startsWith("[") && string2.endsWith("]")) {
                        object2 = string2.substring(1, string2.length() - 1);
                        int n = Integer.parseInt((String)object2);
                        if (n < 0 || n >= ((Object)object3).length) {
                            throw new IAIKPkcs11Exception("The specified slot index is invalid.");
                        }
                        Object object6 = object3[n];
                        object = object6;
                        l2 = object6.getSlotID();
                    } else {
                        l2 = Long.parseLong(string2);
                    }
                    object2 = object4.keySet().iterator();
                    while (object2.hasNext()) {
                        Slot slot = (Slot)object2.next();
                        if (slot.getSlotID() != l2) continue;
                        if (slot.isSetUtf8Encoding() != bl) {
                            throw new IAIKPkcs11Exception("Slot with the configured ID " + l2 + " already in use " + (slot.isSetUtf8Encoding() ? "with" : "without") + " UTF8 encoding.");
                        }
                        this.slot_ = slot;
                        break;
                    }
                    if (this.slot_ == null) {
                        for (int i2 = 0; i2 < ((Object)object3).length; ++i2) {
                            if (object3[i2].getSlotID() != l2) continue;
                            this.slot_ = object3[i2];
                            break;
                        }
                    }
                    if (this.slot_ == null) {
                        throw new IAIKPkcs11Exception("Slot with the configured ID " + l2 + " not found.");
                    }
                } else {
                    object3 = properties.getSlotList(true);
                    if (((Slot[])object3).length > 0) {
                        for (int i3 = 0; i3 < ((Slot[])object3).length; ++i3) {
                            if (object4.containsKey(object3[i3])) continue;
                            this.slot_ = object3[i3];
                            break;
                        }
                    }
                    if (this.slot_ == null && ((Slot[])(object3 = properties.getSlotList(false))).length > 0) {
                        for (int i4 = 0; i4 < ((Slot[])object3).length; ++i4) {
                            if (object4.containsKey(object3[i4])) continue;
                            this.slot_ = object3[i4];
                            break;
                        }
                    }
                    if (this.slot_ == null) {
                        throw new IAIKPkcs11Exception("No unused slot found for this module: " + properties);
                    }
                }
                this.slot_.setUtf8Encoding(bl);
                object3 = (Integer)object4.get(this.slot_);
                object3 = object3 == null ? Integer.valueOf(1) : new Integer((Integer)object3 + 1);
                object4.put(this.slot_, object3);
            }
        }
        catch (IAIKPkcs11Exception iAIKPkcs11Exception) {
            TokenManager.a((Module)properties);
            throw iAIKPkcs11Exception;
        }
        catch (TokenException tokenException) {
            TokenManager.a((Module)properties);
            throw tokenException;
        }
        this.a = this.slot_.getSlotInfo().isRemovableDevice();
        this.pkcs11ModulePath_ = string;
        this.pkcs11module_ = properties;
        this.sessionROPool_ = new LinkedList();
        this.lockedSessionROPool_ = new LinkedList();
        this.sessionRWPool_ = new LinkedList();
        this.sessionPoolMaxSize_ = this.myProvider_.getSessionPoolMaxSize();
        this.d = this.myProvider_.isCheckSessionIntegrity();
    }

    private static void a(Module module) {
        Integer n = (Integer)modulesUsageCounterMap_.get(module);
        int n2 = n;
        if (n2 > 1) {
            modulesUsageCounterMap_.put(module, --n2);
            return;
        }
        modulesUsageCounterMap_.remove(module);
        usedModulesMap_.remove(module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void clearSessionPool(boolean tryToCloseSessions) {
        LinkedList linkedList = this.sessionROPool_;
        synchronized (linkedList) {
            LinkedList linkedList2 = this.lockedSessionROPool_;
            synchronized (linkedList2) {
                LinkedList linkedList3 = this.sessionRWPool_;
                synchronized (linkedList3) {
                    Set set = this.sessionsToBeClosed_;
                    synchronized (set) {
                        void var1_1;
                        if (var1_1 != false) {
                            Session session;
                            Iterator iterator = this.sessionROPool_.iterator();
                            while (iterator.hasNext()) {
                                session = (Session)iterator.next();
                                this.closeSession(session);
                            }
                            iterator = this.lockedSessionROPool_.iterator();
                            while (iterator.hasNext()) {
                                session = (Session)iterator.next();
                                this.closeSession(session);
                            }
                            iterator = this.sessionRWPool_.iterator();
                            while (iterator.hasNext()) {
                                session = (Session)iterator.next();
                                this.closeSession(session);
                            }
                            iterator = this.sessionsToBeClosed_.iterator();
                            while (iterator.hasNext()) {
                                session = (Session)iterator.next();
                                this.closeSession(session);
                            }
                        }
                        this.sessionROPool_.clear();
                        this.lockedSessionROPool_.clear();
                        this.sessionRWPool_.clear();
                        this.sessionsInPool_ = 0;
                    }
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void disposeSession(Session session) {
        if (session != null) {
            try {
                LinkedList linkedList = this.sessionROPool_;
                synchronized (linkedList) {
                    LinkedList linkedList2 = this.lockedSessionROPool_;
                    synchronized (linkedList2) {
                        LinkedList linkedList3 = this.sessionRWPool_;
                        synchronized (linkedList3) {
                            int n = this.sessionROPool_.size() + this.sessionRWPool_.size();
                            if (n < this.sessionPoolMaxSize_) {
                                Set set = this.activeSessions_;
                                synchronized (set) {
                                    this.activeSessions_.remove(session);
                                }
                                if (session.isRwSession()) {
                                    this.sessionRWPool_.addLast(session);
                                    ++this.sessionsInPool_;
                                } else {
                                    if (this.isSessionCloseLocked(session)) {
                                        this.lockedSessionROPool_.addLast(session);
                                    } else {
                                        this.sessionROPool_.addLast(session);
                                    }
                                    ++this.sessionsInPool_;
                                }
                            } else {
                                this.closeSession(session);
                            }
                        }
                    }
                }
            }
            catch (TokenException tokenException) {
                void var1_1;
                this.closeSession((Session)var1_1);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void closeSession(Session session) {
        if (session != null) {
            void var1_1;
            if (this.isSessionCloseLocked(session)) {
                this.setToBeClosed(session);
                return;
            }
            this.closeSessionNow((Session)var1_1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void closeSessionNow(Session session) {
        if (session != null) {
            try {
                void var1_1;
                Set set = this.activeSessions_;
                synchronized (set) {
                    this.activeSessions_.remove(session);
                }
                set = this.sessionsToBeClosed_;
                synchronized (set) {
                    this.sessionsToBeClosed_.remove(session);
                }
                var1_1.closeSession();
                --this.openSessions_;
                return;
            }
            catch (TokenException tokenException) {}
        }
    }

    public TokenKeyStore getKeyStore() {
        Object object = new TokenKeyStoreSpi(this);
        object = new TokenKeyStore((TokenKeyStoreSpi)object, this.myProvider_, "TokenKeyStoreSpi");
        return object;
    }

    public TokenKeyStore getKeyStore(String keyStoreName) {
        Object object;
        if (keyStoreName.startsWith("FastPKCS11") || keyStoreName.startsWith("FastPKCS11KeyStore")) {
            object = new TokenKeyStoreFastSpi(this);
            object = new TokenKeyStore((TokenKeyStoreSpi)object, this.myProvider_, "TokenKeyStoreSpi");
        } else if (((String)object).startsWith("PKCS11") || ((String)object).startsWith("PKCS11KeyStore") || ((String)object).startsWith("PKCS11SingleTokenKeyStore")) {
            object = this.getKeyStore();
        } else {
            throw new IllegalArgumentException("Unknown keystore type");
        }
        return object;
    }

    public Module getModule() {
        return this.pkcs11module_;
    }

    public String getModulePath() {
        return this.pkcs11ModulePath_;
    }

    public IAIKPkcs11 getProvider() {
        return this.myProvider_;
    }

    /*
     * WARNING - void declaration
     */
    public Session getSession(boolean rwBahavior) throws TokenException, IAIKPkcs11TokenUnavailableException {
        void var1_1;
        return this.getSession((boolean)var1_1, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Session getSession(boolean rwBahavior, boolean forSessionKey) throws TokenException, IAIKPkcs11TokenUnavailableException {
        Token token = this.slot_.getToken();
        if (token != null) {
            Session session;
            if (!rwBahavior) {
                LinkedList linkedList = this.sessionROPool_;
                synchronized (linkedList) {
                    LinkedList linkedList2 = this.lockedSessionROPool_;
                    synchronized (linkedList2) {
                        Set set = this.activeSessions_;
                        synchronized (set) {
                            void var2_7;
                            if (var2_7 != false && this.lockedSessionROPool_.size() > 0) {
                                session = (Session)this.lockedSessionROPool_.removeFirst();
                                --this.sessionsInPool_;
                            } else if (this.sessionROPool_.size() > 0) {
                                session = (Session)this.sessionROPool_.removeFirst();
                                --this.sessionsInPool_;
                            } else if (this.lockedSessionROPool_.size() > 0) {
                                session = (Session)this.lockedSessionROPool_.removeFirst();
                                --this.sessionsInPool_;
                            } else {
                                session = token.openSession(true, rwBahavior, null, null);
                                ++this.openSessions_;
                                ++this.openedSessionsTotal_;
                            }
                            this.activeSessions_.add(session);
                        }
                    }
                }
            }
            LinkedList linkedList = this.sessionRWPool_;
            synchronized (linkedList) {
                Set set = this.activeSessions_;
                synchronized (set) {
                    if (this.sessionRWPool_.size() > 0) {
                        session = (Session)this.sessionRWPool_.removeFirst();
                        --this.sessionsInPool_;
                    } else {
                        session = token.openSession(true, rwBahavior, null, null);
                        ++this.openSessions_;
                        ++this.openedSessionsTotal_;
                    }
                    this.activeSessions_.add(session);
                }
            }
            try {
                if (!this.d) return session;
                session.getSessionInfo();
                return session;
            }
            catch (TokenException tokenException) {
                this.clearSessionPool(true);
                this.activeSessions_.remove(session);
                try {
                    void var1_1;
                    session = token.openSession(true, (boolean)var1_1, null, null);
                    session.getSessionInfo();
                    this.activeSessions_.add(session);
                    return session;
                }
                catch (TokenException tokenException2) {
                    throw new IAIKPkcs11TokenUnavailableException("Token unavailable.");
                }
            }
        }
        this.clearSessionPool(false);
        throw new IAIKPkcs11TokenUnavailableException("Token unavailable.");
    }

    public Slot getSlot() {
        return this.slot_;
    }

    public Token getToken() throws TokenException {
        return this.slot_.getToken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void acquireSessionCloseLock(Session session) {
        Map map = this.sessionCloseLockCounts_;
        synchronized (map) {
            void var1_1;
            Integer n = (Integer)this.sessionCloseLockCounts_.get(session);
            int n2 = n == null ? 1 : n + 1;
            Integer n3 = n2;
            this.sessionCloseLockCounts_.put(var1_1, n3);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(Session session, boolean bl) {
        Map map = this.sessionCloseLockCounts_;
        synchronized (map) {
            Integer n = (Integer)this.sessionCloseLockCounts_.get(session);
            if (n != null) {
                int n2 = n;
                if (n2 <= 1 || bl) {
                    this.sessionCloseLockCounts_.remove(session);
                    if (this.isToBeClosed(session)) {
                        this.closeSessionNow(session);
                    }
                } else {
                    Integer n3 = --n2;
                    this.sessionCloseLockCounts_.put(session, n3);
                }
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void releaseSessionCloseLock(Session session) {
        void var1_1;
        this.a((Session)var1_1, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void setToBeClosed(Session session) {
        if (session != null) {
            Set set = this.activeSessions_;
            synchronized (set) {
                this.activeSessions_.remove(session);
            }
            set = this.sessionsToBeClosed_;
            synchronized (set) {
                void var1_1;
                this.sessionsToBeClosed_.add(var1_1);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected boolean isToBeClosed(Session session) {
        boolean bl;
        if (session != null) {
            Set set = this.sessionsToBeClosed_;
            synchronized (set) {
                void var1_1;
                bl = this.sessionsToBeClosed_.contains(var1_1);
            }
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSessionCloseLocked(Session session) {
        boolean bl;
        Map map = this.sessionCloseLockCounts_;
        synchronized (map) {
            Integer n;
            n = (Integer)this.sessionCloseLockCounts_.get(n);
            bl = n != null;
        }
        return bl;
    }

    private Map a() throws TokenException {
        if (this.b == null) {
            HashMap<Mechanism, MechanismInfo> hashMap = new HashMap<Mechanism, MechanismInfo>();
            Token token = this.getToken();
            Mechanism[] mechanismArray = token.getMechanismList();
            for (int i2 = 0; i2 < mechanismArray.length; ++i2) {
                Mechanism mechanism = mechanismArray[i2];
                MechanismInfo mechanismInfo = token.getMechanismInfo(mechanism);
                if (mechanismInfo.isDigest() || mechanism.isDigestMechanism()) {
                    mechanismInfo.setMaxKeySize(0L);
                    mechanismInfo.setMinKeySize(0L);
                }
                hashMap.put(mechanism, mechanismInfo);
            }
            this.b = hashMap;
        }
        return this.b;
    }

    private MechanismInfo a(Mechanism mechanism) throws TokenException {
        if (this.a) {
            Token token = this.getToken();
            if (token != null) {
                Mechanism[] mechanismArray = token.getMechanismList();
                for (int i2 = 0; i2 < mechanismArray.length; ++i2) {
                    if (!mechanism.equals((Object)mechanismArray[i2])) continue;
                    return token.getMechanismInfo(mechanism);
                }
            }
            return null;
        }
        return (MechanismInfo)this.a().get(mechanism);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isMechanismFeatureSupported(Mechanism mechanism, MechanismInfo mechanismFeatures) throws TokenException {
        if (mechanism == null) {
            throw new NullPointerException("Argument \"mechanism\" must not be null.");
        }
        Token token = this.getToken();
        if (token != null) {
            void var2_2;
            MechanismInfo mechanismInfo;
            return (mechanismInfo = this.a((Mechanism)mechanismInfo)) != null && (mechanismFeatures == null || mechanismInfo.supports((MechanismInfo)var2_2));
        }
        return false;
    }

    public boolean isMechanismFeatureSupported(Mechanism[] mechanisms, MechanismInfo[][] mechanismFeatures) throws TokenException {
        if (mechanisms == null) {
            throw new NullPointerException("Argument \"mechanisms\" must not be null.");
        }
        if (mechanismFeatures == null) {
            throw new NullPointerException("Argument \"mechanismFeatures\" must not be null.");
        }
        if (mechanisms.length != mechanismFeatures.length) {
            throw new NullPointerException("The lengths of  \"mechanisms\" and \"mechanismFeatures\" must match.");
        }
        Token token = this.getToken();
        if (token != null) {
            if (mechanisms.length == 0) {
                return true;
            }
            if (this.a) {
                Mechanism[] mechanismArray = token.getMechanismList();
                HashSet<Mechanism> hashSet = new HashSet<Mechanism>(mechanismArray.length);
                hashSet.addAll(Arrays.asList(mechanismArray));
                for (int i2 = 0; i2 < mechanisms.length; ++i2) {
                    if (!hashSet.contains(mechanisms[i2])) continue;
                    for (int i3 = 0; i3 < mechanismFeatures[i2].length; ++i3) {
                        MechanismInfo mechanismInfo = token.getMechanismInfo(mechanisms[i2]);
                        if (mechanismInfo.isDigest() || mechanisms[i2].isDigestMechanism()) {
                            mechanismInfo.setMaxKeySize(0L);
                            mechanismInfo.setMinKeySize(0L);
                        }
                        if (mechanismFeatures[i2][i3] != null && !mechanismInfo.supports(mechanismFeatures[i2][i3])) continue;
                        return true;
                    }
                }
                return false;
            }
            Map map = this.a();
            for (int i4 = 0; i4 < mechanisms.length; ++i4) {
                Mechanism mechanism = mechanisms[i4];
                MechanismInfo mechanismInfo = (MechanismInfo)map.get(mechanism);
                if (mechanismInfo == null) continue;
                for (int i5 = 0; i5 < mechanismFeatures[i4].length; ++i5) {
                    token = mechanismFeatures[i4][i5];
                    if (token != null && !mechanismInfo.supports((MechanismInfo)token)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isRemovable() {
        return this.a;
    }

    public boolean isTokenPresent() throws TokenException {
        return this.slot_.getSlotInfo().isTokenPresent();
    }

    /*
     * WARNING - void declaration
     */
    public boolean loginUser(char[] PIN) throws TokenException, IAIKPkcs11AuthenticationCanceledException, IAIKPkcs11AuthenticationException {
        void var1_1;
        return this.login(null, false, (char[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean loginSO(char[] PIN) throws TokenException, IAIKPkcs11AuthenticationCanceledException, IAIKPkcs11AuthenticationException {
        void var1_1;
        return this.login(null, true, (char[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean login(boolean SORole, char[] PIN) throws TokenException, IAIKPkcs11AuthenticationCanceledException, IAIKPkcs11AuthenticationException {
        void var2_2;
        void var1_1;
        return this.a(null, (boolean)var1_1, (char[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public boolean login(Session session, boolean SORole, char[] PIN) throws TokenException, IAIKPkcs11AuthenticationCanceledException, IAIKPkcs11AuthenticationException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.a((Session)var1_1, (boolean)var2_2, (char[])var3_3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean a(Session session, boolean bl, char[] cArray) throws IAIKPkcs11TokenUnavailableException, TokenException {
        SessionContainer sessionContainer = new SessionContainer(this, session);
        session = sessionContainer.getSession();
        try {
            boolean bl2;
            Slot slot = this.slot_;
            synchronized (slot) {
                boolean bl3;
                boolean bl4 = bl;
                Session session2 = session;
                if (session2 != null) {
                    session2 = session2.getSessionInfo().getState();
                    bl3 = bl4 ? !session2.equals((Object)State.RW_SO_FUNCTIONS) : !(session2.equals((Object)State.RO_USER_FUNCTIONS) | session2.equals((Object)State.RW_USER_FUNCTIONS));
                } else {
                    bl3 = bl2 = true;
                }
                if (bl3) {
                    if (cArray == null && !bl) {
                        cArray = this.getProvider().getUserPIN();
                    }
                    LoginManager loginManager = this.getProvider().getLoginManager();
                    loginManager.login(this, session, bl, cArray);
                    this.notifyKeyStores();
                }
            }
            boolean bl5 = bl2;
            return bl5;
        }
        finally {
            sessionContainer.disposeSessionIfDummy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout() throws TokenException {
        Slot slot = this.slot_;
        synchronized (slot) {
            LoginManager loginManager = this.getProvider().getLoginManager();
            loginManager.logout(this, null);
            this.notifyKeyStores();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void logout(Session session) throws TokenException {
        Slot slot = this.slot_;
        synchronized (slot) {
            void var1_1;
            LoginManager loginManager = this.getProvider().getLoginManager();
            loginManager.logout(this, (Session)var1_1);
            this.notifyKeyStores();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setUserPIN(Session session, char[] oldUserPIN, char[] newUserPIN) throws TokenException, IAIKPkcs11AuthenticationCanceledException, IAIKPkcs11AuthenticationException {
        Slot slot = this.slot_;
        synchronized (slot) {
            void var3_4;
            void var2_3;
            void var1_1;
            if (oldUserPIN == null) {
                oldUserPIN = this.getProvider().getUserPIN();
            }
            this.getProvider().getLoginManager().setUserPIN(this, (Session)var1_1, (char[])var2_3, (char[])var3_4);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean makeAuthorizedSession(Session session, char[] PIN) throws TokenException, IAIKPkcs11TokenUnavailableException, IAIKPkcs11AuthenticationException {
        void var2_2;
        void var1_1;
        return this.makeAuthorizedSession((Session)var1_1, false, (char[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public boolean makeAuthorizedSession(Session session, boolean SORole, char[] PIN) throws TokenException, IAIKPkcs11TokenUnavailableException, IAIKPkcs11AuthenticationException {
        boolean bl;
        if (session == null) {
            throw new NullPointerException("Argument \"session\" must not be null.");
        }
        Token token = this.slot_.getToken();
        if (token != null) {
            void var3_4;
            void var2_3;
            void var1_1;
            bl = token.isLoginRequired() ? this.login((Session)var1_1, (boolean)var2_3, (char[])var3_4) : false;
        } else {
            throw new IAIKPkcs11TokenUnavailableException("Token unavailable.");
        }
        return bl;
    }

    public void waitForSlotEvent() throws TokenException {
        try {
            while (true) {
                this.pkcs11module_.waitForSlotEvent(true, null);
            }
        }
        catch (TokenException tokenException) {
            Slot slot;
            while (!(slot = this.pkcs11module_.waitForSlotEvent(false, null)).equals((Object)this.slot_)) {
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void addKeyStoreReference(TokenKeyStoreSpi keyStore) {
        Set set = this.keyStores_;
        synchronized (set) {
            void var1_1;
            this.keyStores_.add(new SoftReference<void>(var1_1));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyKeyStores() {
        Set set = this.keyStores_;
        synchronized (set) {
            Iterator iterator = this.keyStores_.iterator();
            while (iterator.hasNext()) {
                Object object = (SoftReference)iterator.next();
                if ((object = (TokenKeyStoreSpi)((SoftReference)object).get()) == null) {
                    iterator.remove();
                    continue;
                }
                ((TokenKeyStoreSpi)object).setUpToDate(false);
            }
            return;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(this.slot_);
        stringBuffer.append(Constants.LINE_SEPARATOR);
        stringBuffer.append("open sessions in session pool: ");
        stringBuffer.append(this.openSessions_);
        stringBuffer.append(Constants.LINE_SEPARATOR);
        stringBuffer.append("sessions opened in total: ");
        stringBuffer.append(this.openedSessionsTotal_);
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void finalize() throws Throwable {
        if (!this.c) {
            this.c = true;
            this.closeSessions();
            Object object = moduleMapsLock_;
            synchronized (object) {
                HashMap hashMap = usedSlotsMap_;
                synchronized (hashMap) {
                    Integer n = (Integer)modulesUsageCounterMap_.get(this.pkcs11module_);
                    if (n != null) {
                        int n2 = n;
                        if (n2 > 1) {
                            modulesUsageCounterMap_.put(this.pkcs11module_, --n2);
                            Map map = (Map)usedSlotsMap_.get(this.pkcs11module_);
                            Integer n3 = (Integer)map.get(this.slot_);
                            if (n3 != null) {
                                if (n3 <= 1) {
                                    map.remove(this.slot_);
                                } else {
                                    n3 = new Integer(n3 - 1);
                                    map.put(this.slot_, n3);
                                }
                            }
                        } else {
                            modulesUsageCounterMap_.remove(this.pkcs11module_);
                            usedModulesMap_.remove(this.pkcs11module_);
                            usedSlotsMap_.remove(this.pkcs11module_);
                            this.pkcs11module_.finalize(null);
                        }
                    } else {
                        usedModulesMap_.remove(this.pkcs11module_);
                        try {
                            this.pkcs11module_.finalize(null);
                        }
                        catch (PKCS11Exception pKCS11Exception) {}
                    }
                }
            }
            super.finalize();
        }
    }

    public void closeSessions() {
        int n;
        this.clearSessionPool(true);
        Object[] objectArray = this.activeSessions_.toArray();
        for (n = 0; n < objectArray.length; ++n) {
            this.closeSession((Session)objectArray[n]);
        }
        objectArray = this.sessionsToBeClosed_.toArray();
        for (n = 0; n < objectArray.length; ++n) {
            this.a((Session)objectArray[n], true);
        }
    }

    public static TokenManager getDefaultTokenManager() {
        Provider[] providerArray = Security.getProviders();
        for (int i2 = 0; i2 < providerArray.length; ++i2) {
            if (!(providerArray[i2] instanceof IAIKPkcs11)) continue;
            return ((IAIKPkcs11)providerArray[i2]).getTokenManager();
        }
        return null;
    }
}

