/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider;

import iaik.asn1.ASN1Object;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.Name;
import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.TokenInfo;
import iaik.pkcs.pkcs11.objects.BooleanAttribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Certificate;
import iaik.pkcs.pkcs11.objects.CharArrayAttribute;
import iaik.pkcs.pkcs11.objects.DHPrivateKey;
import iaik.pkcs.pkcs11.objects.DHPublicKey;
import iaik.pkcs.pkcs11.objects.DSAPrivateKey;
import iaik.pkcs.pkcs11.objects.DSAPublicKey;
import iaik.pkcs.pkcs11.objects.ECDSAPrivateKey;
import iaik.pkcs.pkcs11.objects.ECDSAPublicKey;
import iaik.pkcs.pkcs11.objects.GenericTemplate;
import iaik.pkcs.pkcs11.objects.KEAPrivateKey;
import iaik.pkcs.pkcs11.objects.KEAPublicKey;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.RSAPrivateKey;
import iaik.pkcs.pkcs11.objects.RSAPublicKey;
import iaik.pkcs.pkcs11.objects.Storage;
import iaik.pkcs.pkcs11.objects.X509AttributeCertificate;
import iaik.pkcs.pkcs11.objects.X509PublicKeyCertificate;
import iaik.pkcs.pkcs11.provider.ComparableByteArray;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.IdentityMap;
import iaik.pkcs.pkcs11.provider.PKCS11EngineClass;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11Key;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PrivateKey;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PublicKey;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey;
import iaik.utils.RFC2253NameParserException;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.attr.AttributeCertificate;
import iaik.x509.extensions.AuthorityKeyIdentifier;
import iaik.x509.extensions.BasicConstraints;
import iaik.x509.extensions.KeyUsage;
import iaik.x509.extensions.SubjectKeyIdentifier;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;

public class TokenKeyStoreSpi
extends KeyStoreSpi
implements PKCS11EngineClass {
    public static final String KEY_STORE_TYPE = "TokenKeyStoreSpi";
    protected TokenManager tokenManager_;
    protected Session readSession_;
    protected Session writeSession_;
    protected HashSet aliases_;
    protected Hashtable keys_;
    protected Hashtable certificateChains_;
    protected Hashtable trustedCertificates_;
    protected Hashtable keyAliasToPkcs11ObjectTable_;
    protected Hashtable certificateChainAliasToPkcs11ObjectsTable_;
    protected Hashtable trustedCertificateAliasToPkcs11ObjectTable_;
    protected boolean isUpToDate_;
    protected boolean useUserSession_;
    protected TokenInfo infoOfRecentToken_;
    protected byte[] lastNewID_;
    protected String supportProviderName_;
    protected Mechanism[] usedMechanisms_;
    protected MechanismInfo[] usedMechanismInfos_;
    protected char[] userPIN_;
    private static Class a;
    private static Class b;
    private static Class c;
    private static Class d;
    private static Class e;
    private static Class f;
    private static Class g;
    private static Class h;
    private static Class i;
    private static Class j;
    private static Class k;
    private static Class l;

    private static final boolean a(TokenManager object) {
        boolean bl = false;
        try {
            object = ((TokenManager)object).getToken();
            if (object != null && (object = object.getTokenInfo()) != null && (object = object.getManufacturerID()) != null && ((String)object).toUpperCase(Locale.US).indexOf("UTIMACO") != -1) {
                bl = true;
            }
        }
        catch (Exception exception) {}
        return bl;
    }

    public TokenKeyStoreSpi() {
    }

    /*
     * WARNING - void declaration
     */
    public TokenKeyStoreSpi(TokenManager tokenManager) {
        void var1_1;
        if (tokenManager == null) {
            throw new NullPointerException("Argument \"tokenManager\" must not be null");
        }
        this.tokenManager_ = var1_1;
        this.initialize();
    }

    private static final void a(byte[] byArray) {
        int n = byArray.length - 1;
        while (n >= 0) {
            int n2 = n--;
            byArray[n2] = (byte)(byArray[n2] + 1);
            if (byArray[n2] == 0) continue;
        }
    }

    public synchronized Enumeration engineAliases() {
        Set set;
        this.ensureSupportProvider();
        try {
            this.ensureCurrentTables();
            set = (Set)this.aliases_.clone();
        }
        finally {
            this.releaseSessions();
        }
        return Collections.enumeration(set);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean engineContainsAlias(String alias) {
        void var1_1;
        this.ensureSupportProvider();
        try {
            this.ensureCurrentTables();
        }
        finally {
            this.releaseSessions();
        }
        return this.aliases_.contains(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void engineDeleteEntry(String alias) throws KeyStoreException {
        if (alias == null) {
            throw new NullPointerException("Argument \"alias\" must not be null.");
        }
        this.ensureSupportProvider();
        this.ensureCurrentTables();
        if (this.aliases_.contains(alias)) {
            try {
                this.ensureWriteSession();
                if (this.keyAliasToPkcs11ObjectTable_.containsKey(alias)) {
                    this.deleteKey(alias);
                }
                if (this.certificateChainAliasToPkcs11ObjectsTable_.containsKey(alias)) {
                    this.deleteChertificateChain(alias);
                }
                if (this.trustedCertificateAliasToPkcs11ObjectTable_.containsKey(alias)) {
                    this.deleteCertificate(alias);
                }
                this.aliases_.remove(alias);
            }
            catch (TokenException tokenException) {
                throw new KeyStoreException(tokenException.toString());
            }
            finally {
                this.releaseSessions();
            }
        } else {
            void var1_1;
            throw new KeyStoreException("No entry with alias \"" + (String)var1_1 + "\".");
        }
    }

    public synchronized java.security.cert.Certificate engineGetCertificate(String alias) {
        java.security.cert.Certificate certificate;
        if (alias == null) {
            throw new NullPointerException("Argument \"alias\" must not be null.");
        }
        this.ensureSupportProvider();
        try {
            this.ensureCurrentTables();
            java.security.cert.Certificate[] certificateArray = (java.security.cert.Certificate[])this.certificateChains_.get(alias);
            certificate = certificateArray != null && certificateArray.length > 0 ? certificateArray[0] : (java.security.cert.Certificate)this.trustedCertificates_.get(certificate);
        }
        finally {
            this.releaseSessions();
        }
        return certificate;
    }

    public synchronized String engineGetCertificateAlias(java.security.cert.Certificate certificate) {
        String string;
        block6: {
            if (certificate == null) {
                throw new NullPointerException("argument \"certificate\" must not be null");
            }
            this.ensureSupportProvider();
            string = null;
            try {
                java.lang.Object object;
                String string2;
                this.ensureCurrentTables();
                Enumeration enumeration = this.certificateChains_.keys();
                while (enumeration.hasMoreElements()) {
                    string2 = enumeration.nextElement().toString();
                    object = (java.security.cert.Certificate[])this.certificateChains_.get(string2);
                    if (object == null || ((java.security.cert.Certificate[])object).length <= 0 || !certificate.equals(object[0])) continue;
                    string = string2;
                    break;
                }
                if (string != null) break block6;
                enumeration = this.trustedCertificates_.keys();
                while (enumeration.hasMoreElements()) {
                    string2 = enumeration.nextElement().toString();
                    object = (java.security.cert.Certificate)this.trustedCertificates_.get(string2);
                    if (!certificate.equals(object)) continue;
                    string = string2;
                    break;
                }
            }
            finally {
                this.releaseSessions();
            }
        }
        return string;
    }

    public synchronized java.security.cert.Certificate[] engineGetCertificateChain(String alias) {
        java.security.cert.Certificate[] certificateArray;
        if (alias == null) {
            throw new NullPointerException("Argument \"alias\" must not be null.");
        }
        this.ensureSupportProvider();
        try {
            this.ensureCurrentTables();
            certificateArray = (java.security.cert.X509Certificate[])this.certificateChains_.get(certificateArray);
            if (certificateArray == null) {
                certificateArray = new java.security.cert.X509Certificate[]{};
            }
        }
        finally {
            this.releaseSessions();
        }
        return certificateArray;
    }

    public Date engineGetCreationDate(String alias) {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        Key key;
        block7: {
            this.ensureSupportProvider();
            try {
                this.ensureCurrentTables();
                key = (Key)this.keys_.get(alias);
                if (key != null) break block7;
                try {
                    if (this.tokenManager_.isTokenPresent()) {
                        void var1_1;
                        if (this.loginSession()) {
                            this.setUpToDate(false);
                        }
                        this.ensureCurrentTables();
                        key = (Key)this.keys_.get(var1_1);
                    }
                }
                catch (TokenException tokenException) {
                    throw new IAIKPkcs11Exception(tokenException.toString());
                }
            }
            finally {
                this.releaseSessions();
            }
        }
        return key;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean engineIsCertificateEntry(String alias) {
        void var1_1;
        this.ensureSupportProvider();
        try {
            this.ensureCurrentTables();
        }
        finally {
            this.releaseSessions();
        }
        return this.trustedCertificates_.containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean engineIsKeyEntry(String alias) {
        void var1_1;
        this.ensureSupportProvider();
        try {
            this.ensureCurrentTables();
        }
        finally {
            this.releaseSessions();
        }
        return this.keys_.containsKey(alias) || this.certificateChains_.containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void engineLoad(InputStream in, char[] password) throws IOException, UnsupportedOperationException {
        java.lang.Object object;
        if (in != null) {
            int n = IAIKPkcs11.getProviderInstanceNumber((String)(object = this.readProviderName((InputStream)object)));
            if (n <= 0) throw new IAIKPkcs11Exception("The IAIKPkcs11 provider with the given name does not exist: " + (String)object);
            object = IAIKPkcs11.getProviderInstance(n);
            this.tokenManager_ = ((IAIKPkcs11)object).getTokenManager();
        } else if (this.tokenManager_ == null) {
            object = IAIKPkcs11.getCurrentProviderInstance();
            if (object == null) throw new UnsupportedOperationException("Cannot initialize key store. Could not find a IAIKPkcs11 provider.");
            this.tokenManager_ = ((IAIKPkcs11)object).getTokenManager();
        }
        if (password != null) {
            try {
                void var2_3;
                this.tokenManager_.loginUser(password);
                this.userPIN_ = var2_3;
            }
            catch (TokenException tokenException) {
                throw new IAIKPkcs11Exception("Failed to login the user with the provided PIN: " + (java.lang.Object)((java.lang.Object)tokenException));
            }
        }
        this.initialize();
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void engineSetCertificateEntry(String alias, java.security.cert.Certificate certificate) throws KeyStoreException {
        if (alias == null) {
            throw new NullPointerException("Argument \"alias\" must not be null.");
        }
        if (certificate == null) {
            throw new NullPointerException("Argument \"certificate\" must not be null.");
        }
        this.ensureSupportProvider();
        try {
            void var2_4;
            void var1_1;
            Object object;
            this.ensureWriteSession();
            if (this.trustedCertificates_.containsKey(alias)) {
                object = (Object)this.trustedCertificateAliasToPkcs11ObjectTable_.get(alias);
                if (object != null) {
                    this.trustedCertificates_.remove(alias);
                    this.aliases_.remove(alias);
                    try {
                        this.writeSession_.destroyObject(object);
                    }
                    catch (TokenException tokenException) {
                        throw new KeyStoreException("Could not remove already existing certificate with this alias: " + tokenException.toString());
                    }
                } else {
                    this.trustedCertificateAliasToPkcs11ObjectTable_.remove(var1_1);
                }
            }
            object = this.createCertificate(certificate, null, var1_1.toCharArray());
            this.trustedCertificateAliasToPkcs11ObjectTable_.put(var1_1, object);
            this.trustedCertificates_.put(var1_1, var2_4);
            this.aliases_.add(var1_1);
            return;
        }
        catch (TokenException tokenException) {
            throw new KeyStoreException(tokenException.toString());
        }
        finally {
            this.releaseSessions();
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void engineSetKeyEntry(String alias, Key key, char[] password, java.security.cert.Certificate[] certificateChain) throws KeyStoreException {
        if (alias == null) {
            throw new NullPointerException("Argument \"alias\" must not be null.");
        }
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        this.ensureSupportProvider();
        try {
            iaik.pkcs.pkcs11.objects.Key key2;
            java.lang.Object object;
            java.lang.Object object2;
            java.lang.Object object3;
            java.lang.Object object4;
            X509Certificate x509Certificate;
            Object object5;
            this.ensureWriteSession();
            this.ensureCurrentTables();
            X509Certificate[] x509CertificateArray = Util.convertCertificateChain((java.security.cert.Certificate[])certificateChain);
            if (x509CertificateArray != null && x509CertificateArray.length > 0) {
                object5 = Util.arrangeCertificateChain((X509Certificate[])x509CertificateArray, (boolean)false);
                if (object5 != null && ((X509Certificate[])object5).length > 0) {
                    x509CertificateArray = object5;
                }
                x509Certificate = x509CertificateArray[0];
            } else {
                x509Certificate = null;
            }
            object5 = null;
            boolean bl = false;
            if (this.aliases_.contains(alias)) {
                if (this.keys_.containsKey(alias)) {
                    object5 = (Object)this.keyAliasToPkcs11ObjectTable_.get(alias);
                    bl = true;
                }
                if (this.certificateChains_.containsKey(alias)) {
                    this.deleteChertificateChain(alias);
                }
                if (this.trustedCertificates_.containsKey(alias)) {
                    this.deleteCertificate(alias);
                }
            }
            if (key instanceof IAIKPKCS11Key) {
                object4 = (IAIKPKCS11Key)key;
                object3 = object4.getTokenManager().getToken();
                if (object3.equals(object2 = this.tokenManager_.getToken())) {
                    object = object4.getKeyObject();
                    object4 = new GenericTemplate();
                    object3 = object.getLabel().getCharArrayValue();
                    object2 = alias.toCharArray();
                    if (object3 == null || !Arrays.equals((char[])object3, (char[])object2)) {
                        object3 = new CharArrayAttribute(iaik.pkcs.pkcs11.objects.Attribute.LABEL);
                        object3.setCharArrayValue((char[])object2);
                        object4.addAttribute((iaik.pkcs.pkcs11.objects.Attribute)object3);
                    }
                    byte[] byArray = object.getId().getByteArrayValue();
                    object3 = byArray;
                    if (byArray == null) {
                        object2 = new ByteArrayAttribute(iaik.pkcs.pkcs11.objects.Attribute.ID);
                        object3 = this.generateNewID(null);
                        object2.setByteArrayValue((byte[])object3);
                        object4.addAttribute((iaik.pkcs.pkcs11.objects.Attribute)object2);
                    } else {
                        object3 = null;
                    }
                    if (bl && object5 != null) {
                        if (object5.equals(object)) {
                            if (object.getToken().getBooleanValue().booleanValue()) {
                                if (object4.getSetAttributes().size() > 0) {
                                    this.writeSession_.setAttributeValues((Object)object, (Object)object4);
                                    if (object3 != null) {
                                        object.getId().setByteArrayValue((byte[])object3);
                                    }
                                }
                                key2 = object;
                            } else {
                                object2 = new BooleanAttribute(iaik.pkcs.pkcs11.objects.Attribute.TOKEN);
                                object2.setBooleanValue(Boolean.TRUE);
                                object4.addAttribute((iaik.pkcs.pkcs11.objects.Attribute)object2);
                                key2 = (iaik.pkcs.pkcs11.objects.Key)this.writeSession_.copyObject((Object)object, (Object)object4);
                                this.writeSession_.destroyObject(object5);
                            }
                            if (key2 instanceof iaik.pkcs.pkcs11.objects.PrivateKey && object3 != null && (object2 = (iaik.pkcs.pkcs11.objects.PublicKey)this.findCoreespondingKey(key2)) != null && object2.getId().getByteArrayValue() == null) {
                                object = new GenericTemplate();
                                object5 = new ByteArrayAttribute(iaik.pkcs.pkcs11.objects.Attribute.ID);
                                object5.setByteArrayValue((byte[])object3);
                                object.addAttribute((iaik.pkcs.pkcs11.objects.Attribute)object5);
                                this.writeSession_.setAttributeValues((Object)object2, (Object)object);
                            }
                        } else {
                            this.writeSession_.destroyObject(object5);
                            if (object.getToken().getBooleanValue().booleanValue()) {
                                if (object4.getSetAttributes().size() > 0) {
                                    this.writeSession_.setAttributeValues((Object)object, (Object)object4);
                                    if (object3 != null) {
                                        object.getId().setByteArrayValue((byte[])object3);
                                    }
                                }
                                key2 = object;
                            } else {
                                object2 = new BooleanAttribute(iaik.pkcs.pkcs11.objects.Attribute.TOKEN);
                                object2.setBooleanValue(Boolean.TRUE);
                                object4.addAttribute((iaik.pkcs.pkcs11.objects.Attribute)object2);
                                key2 = (iaik.pkcs.pkcs11.objects.Key)this.writeSession_.copyObject((Object)object, (Object)object4);
                            }
                        }
                    } else if (object.getToken().getBooleanValue().booleanValue()) {
                        if (object4.getSetAttributes().size() > 0) {
                            this.writeSession_.setAttributeValues((Object)object, (Object)object4);
                            if (object3 != null) {
                                object.getId().setByteArrayValue((byte[])object3);
                            }
                        }
                        key2 = object;
                    } else {
                        object2 = new BooleanAttribute(iaik.pkcs.pkcs11.objects.Attribute.TOKEN);
                        object2.setBooleanValue(Boolean.TRUE);
                        object4.addAttribute((iaik.pkcs.pkcs11.objects.Attribute)object2);
                        key2 = (iaik.pkcs.pkcs11.objects.Key)this.writeSession_.copyObject((Object)object, (Object)object4);
                    }
                } else {
                    if (bl && object5 != null) {
                        this.writeSession_.destroyObject(object5);
                    }
                    object = object4.getKeyObject();
                    object4 = this.createKeyCreationTemplate((iaik.pkcs.pkcs11.objects.Key)object);
                    object3 = this.generateNewID(null);
                    object4.getId().setByteArrayValue((byte[])object3);
                    object4.getLabel().setCharArrayValue(alias.toCharArray());
                    key2 = (iaik.pkcs.pkcs11.objects.Key)this.writeSession_.createObject((Object)object4);
                }
                if (key2 instanceof iaik.pkcs.pkcs11.objects.PrivateKey) {
                    object = IAIKPKCS11PrivateKey.create(this.tokenManager_, (iaik.pkcs.pkcs11.objects.PrivateKey)key2);
                } else if (key2 instanceof iaik.pkcs.pkcs11.objects.PublicKey) {
                    object = IAIKPKCS11PublicKey.create(this.tokenManager_, (iaik.pkcs.pkcs11.objects.PublicKey)key2);
                } else if (key2 instanceof iaik.pkcs.pkcs11.objects.SecretKey) {
                    object = IAIKPKCS11SecretKey.create(this.tokenManager_, (iaik.pkcs.pkcs11.objects.SecretKey)key2);
                } else {
                    throw new KeyStoreException("Unknown key type: " + key2.getClass().getName());
                }
                this.keyAliasToPkcs11ObjectTable_.put(alias, key2);
                this.keys_.put(alias, object);
                this.aliases_.add(alias);
            } else {
                if (bl && object5 != null) {
                    this.writeSession_.destroyObject(object5);
                }
                object4 = this.generateNewID(null);
                object3 = object.getAlgorithm();
                if (object instanceof PrivateKey) {
                    object2 = new iaik.pkcs.pkcs11.objects.PrivateKey();
                    object2.getToken().setBooleanValue(Boolean.TRUE);
                    object2.getId().setByteArrayValue((byte[])object4);
                    object2.getLabel().setCharArrayValue(alias.toCharArray());
                    object2.getPrivate().setBooleanValue(Boolean.TRUE);
                    object2.getSensitive().setBooleanValue(Boolean.TRUE);
                    object = this.createPrivateKeySpec((Key)object);
                    if (object instanceof DSAPrivateKeySpec && TokenKeyStoreSpi.a(this.tokenManager_)) {
                        object2.getSign().setBooleanValue(Boolean.TRUE);
                    } else {
                        object4 = this.getMechanismFeaturesSupport((String)object3);
                        this.setKeyAttributes((iaik.pkcs.pkcs11.objects.PrivateKey)object2, (java.security.cert.X509Certificate)x509Certificate, (MechanismInfo)object4);
                    }
                    object4 = (PKCS11KeySpec)new PKCS11KeySpec((KeySpec)object, (Object)object2).setUseUserRole(true);
                    object4.setTokenManager(this.tokenManager_);
                    object3 = KeyFactory.getInstance((String)object3, this.tokenManager_.getProvider().getName());
                    object = (IAIKPKCS11Key)((java.lang.Object)object3.generatePrivate((KeySpec)object4));
                } else if (object instanceof PublicKey) {
                    object2 = new iaik.pkcs.pkcs11.objects.PublicKey();
                    object2.getToken().setBooleanValue(Boolean.TRUE);
                    object2.getId().setByteArrayValue((byte[])object4);
                    object2.getLabel().setCharArrayValue(alias.toCharArray());
                    object = this.createPublicKeySpec((Key)object);
                    if (object instanceof DSAPublicKeySpec && TokenKeyStoreSpi.a(this.tokenManager_)) {
                        object2.getVerify().setBooleanValue(Boolean.TRUE);
                    } else {
                        object4 = this.getMechanismFeaturesSupport((String)object3);
                        this.setKeyAttributes((iaik.pkcs.pkcs11.objects.PublicKey)object2, (java.security.cert.X509Certificate)x509Certificate, (MechanismInfo)object4);
                    }
                    object4 = (PKCS11KeySpec)new PKCS11KeySpec((KeySpec)object, (Object)object2).setUseUserRole(true);
                    object4.setTokenManager(this.tokenManager_);
                    object3 = KeyFactory.getInstance((String)object3, this.tokenManager_.getProvider().getName());
                    object = (IAIKPKCS11Key)((java.lang.Object)object3.generatePublic((KeySpec)object4));
                } else if (object instanceof SecretKey) {
                    object2 = new iaik.pkcs.pkcs11.objects.SecretKey();
                    object2.getToken().setBooleanValue(Boolean.TRUE);
                    object2.getId().setByteArrayValue((byte[])object4);
                    object2.getLabel().setCharArrayValue(alias.toCharArray());
                    object2.getPrivate().setBooleanValue(Boolean.TRUE);
                    object2.getSensitive().setBooleanValue(Boolean.TRUE);
                    object = this.createSecretKeySpec((SecretKey)object);
                    object4 = (PKCS11KeySpec)new PKCS11KeySpec((KeySpec)object, (Object)object2).setUseUserRole(true);
                    object4.setTokenManager(this.tokenManager_);
                    object3 = SecretKeyFactory.getInstance((String)object3, this.tokenManager_.getProvider().getName());
                    object = (IAIKPKCS11Key)((java.lang.Object)object3.generateSecret((KeySpec)object4));
                } else {
                    throw new KeyStoreException("Unknown key type: " + object.getClass().getName());
                }
                key2 = ((IAIKPKCS11Key)object).getKeyObject();
                this.keyAliasToPkcs11ObjectTable_.put(alias, key2);
                this.keys_.put(alias, object);
                this.aliases_.add(alias);
            }
            if (x509CertificateArray != null && x509CertificateArray.length > 0) {
                void var1_1;
                Object[] objectArray = new Object[x509CertificateArray.length];
                object4 = objectArray;
                objectArray[0] = this.createCertificate((java.security.cert.Certificate)x509Certificate, key2.getId().getByteArrayValue(), alias.toCharArray());
                for (int i2 = 1; i2 < x509CertificateArray.length; ++i2) {
                    object4[i2] = this.createCertificate((java.security.cert.Certificate)x509CertificateArray[i2], null, alias.toCharArray());
                }
                this.certificateChainAliasToPkcs11ObjectsTable_.put(alias, object4);
                this.certificateChains_.put(var1_1, x509CertificateArray);
            }
            return;
        }
        catch (TokenException tokenException) {
            throw new KeyStoreException(tokenException.toString());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new KeyStoreException(generalSecurityException.toString());
        }
        finally {
            this.releaseSessions();
        }
    }

    public void engineSetKeyEntry(String alias, byte[] key, java.security.cert.Certificate[] certificateChain) throws KeyStoreException {
        throw new KeyStoreException("TokenKeyStoreSpi does not support storing encrypted keys");
    }

    public synchronized int engineSize() {
        this.ensureSupportProvider();
        try {
            this.ensureCurrentTables();
        }
        finally {
            this.releaseSessions();
        }
        return this.aliases_.size();
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void engineStore(OutputStream out, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        try {
            IAIKPkcs11 iAIKPkcs11;
            this.ensureWriteSession();
            this.tokenManager_.setUserPIN(this.writeSession_, this.userPIN_, (char[])iAIKPkcs11);
            if (out != null) {
                void var1_1;
                iAIKPkcs11 = this.tokenManager_.getProvider();
                this.writeProviderName(iAIKPkcs11.getName(), (OutputStream)var1_1);
            }
            return;
        }
        catch (TokenException tokenException) {
            throw new IOException("Error setting new user PIN: " + tokenException.toString());
        }
        finally {
            this.releaseSessions();
        }
    }

    public TokenManager getTokenManager() {
        return this.tokenManager_;
    }

    public boolean isSupportedBy(TokenManager tokenManager) {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized void deleteKey(String alias) throws TokenException {
        if (alias != null) {
            void var1_1;
            Object object = (Object)this.keyAliasToPkcs11ObjectTable_.get(alias);
            if (object != null) {
                this.keyAliasToPkcs11ObjectTable_.remove(alias);
                if (!this.keyAliasToPkcs11ObjectTable_.contains(object)) {
                    this.writeSession_.destroyObject(object);
                }
            }
            this.keys_.remove(var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized void deleteChertificateChain(String alias) throws TokenException {
        if (alias != null) {
            void var1_1;
            Object[] objectArray = (Object[])this.certificateChainAliasToPkcs11ObjectsTable_.get(alias);
            if (objectArray != null) {
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    char[] cArray;
                    if (objectArray[i2] == null || (cArray = ((Storage)objectArray[i2]).getLabel().getCharArrayValue()) == null || !alias.equals(new String(cArray))) continue;
                    this.writeSession_.destroyObject(objectArray[i2]);
                }
                this.certificateChainAliasToPkcs11ObjectsTable_.remove(alias);
            }
            this.certificateChains_.remove(var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized void deleteCertificate(String alias) throws TokenException {
        if (alias != null) {
            void var1_1;
            Object object = (Object)this.trustedCertificateAliasToPkcs11ObjectTable_.get(alias);
            if (object != null) {
                this.writeSession_.destroyObject(object);
                this.trustedCertificateAliasToPkcs11ObjectTable_.remove(alias);
            }
            this.trustedCertificates_.remove(var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized Object createCertificate(java.security.cert.Certificate certificate, byte[] id, char[] label) throws KeyStoreException {
        AttributeCertificate attributeCertificate;
        if (certificate == null) {
            throw new NullPointerException("Argument \"certificate\" must not be null.");
        }
        try {
            this.ensureWriteSession();
        }
        catch (TokenException tokenException) {
            throw new KeyStoreException(tokenException.toString());
        }
        try {
            X509AttributeCertificate x509AttributeCertificate;
            if (attributeCertificate instanceof java.security.cert.X509Certificate) {
                java.lang.Object object;
                java.lang.Object object2;
                attributeCertificate = attributeCertificate instanceof X509Certificate ? (X509Certificate)attributeCertificate : new X509Certificate(attributeCertificate.getEncoded());
                X509PublicKeyCertificate x509PublicKeyCertificate = new X509PublicKeyCertificate();
                byte[] byArray = DerCoder.encode((ASN1Object)new INTEGER(attributeCertificate.getSerialNumber()));
                Name name = (Name)attributeCertificate.getSubjectDN();
                Name name2 = (Name)attributeCertificate.getIssuerDN();
                if (label == null) {
                    object2 = name.getRDN(ObjectID.commonName);
                    object = name2.getRDN(ObjectID.commonName);
                    label = ((String)object2 + "'s " + (object != null ? (String)object + " " : "") + "Certificate").toCharArray();
                }
                x509PublicKeyCertificate.getToken().setBooleanValue(Boolean.TRUE);
                x509PublicKeyCertificate.getPrivate().setBooleanValue(Boolean.FALSE);
                x509PublicKeyCertificate.getLabel().setCharArrayValue(label);
                if (id != null) {
                    x509PublicKeyCertificate.getId().setByteArrayValue((byte[])x509AttributeCertificate);
                }
                object2 = name.getEncoded();
                x509PublicKeyCertificate.getSubject().setByteArrayValue((byte[])object2);
                object = name2.getEncoded();
                x509PublicKeyCertificate.getIssuer().setByteArrayValue((byte[])object);
                x509PublicKeyCertificate.getSerialNumber().setByteArrayValue(byArray);
                x509PublicKeyCertificate.getValue().setByteArrayValue(attributeCertificate.getEncoded());
                attributeCertificate = x509PublicKeyCertificate;
            } else if (attributeCertificate instanceof AttributeCertificate) {
                void var3_6;
                java.lang.Object object;
                attributeCertificate = attributeCertificate;
                x509AttributeCertificate = new X509AttributeCertificate();
                byte[] byArray = attributeCertificate.getSerialNumber().toByteArray();
                if (label == null) {
                    label = "Attribute Certificate".toCharArray();
                }
                byte[] byArray2 = DerCoder.encode((ASN1Object)attributeCertificate.getHolder().toASN1Object());
                byte[] byArray3 = DerCoder.encode((ASN1Object)attributeCertificate.getIssuer().toASN1Object());
                SEQUENCE sEQUENCE = new SEQUENCE();
                Enumeration enumeration = attributeCertificate.getAttributes();
                while (enumeration.hasMoreElements()) {
                    object = (Attribute)enumeration.nextElement();
                    sEQUENCE.addComponent((ASN1Object)object.getType());
                }
                object = DerCoder.encode((ASN1Object)sEQUENCE);
                x509AttributeCertificate.getToken().setBooleanValue(Boolean.TRUE);
                x509AttributeCertificate.getPrivate().setBooleanValue(Boolean.FALSE);
                x509AttributeCertificate.getLabel().setCharArrayValue((char[])var3_6);
                x509AttributeCertificate.getOwner().setByteArrayValue(byArray2);
                x509AttributeCertificate.getAcIssuer().setByteArrayValue(byArray3);
                x509AttributeCertificate.getSerialNumber().setByteArrayValue(byArray);
                x509AttributeCertificate.getAttrTypes().setByteArrayValue(object);
                x509AttributeCertificate.getValue().setByteArrayValue(attributeCertificate.getEncoded());
                attributeCertificate = x509AttributeCertificate;
            } else {
                throw new KeyStoreException("Unsupported certificate type: " + attributeCertificate.getClass().getName());
            }
            attributeCertificate = this.writeSession_.createObject((Object)attributeCertificate);
        }
        catch (TokenException tokenException) {
            throw new KeyStoreException(tokenException.toString());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new KeyStoreException(generalSecurityException.toString());
        }
        return attributeCertificate;
    }

    protected synchronized iaik.pkcs.pkcs11.objects.Key findCoreespondingKey(iaik.pkcs.pkcs11.objects.Key key) throws TokenException {
        DHPrivateKey dHPrivateKey;
        java.lang.Object object;
        if (key instanceof iaik.pkcs.pkcs11.objects.PrivateKey) {
            if (key instanceof RSAPrivateKey) {
                object = new RSAPublicKey();
                object.getModulus().setByteArrayValue(((RSAPrivateKey)key).getModulus().getByteArrayValue());
                dHPrivateKey = object;
            } else if (dHPrivateKey instanceof DSAPrivateKey) {
                object = new DSAPublicKey();
                object.getBase().setByteArrayValue(((DSAPrivateKey)dHPrivateKey).getBase().getByteArrayValue());
                object.getPrime().setByteArrayValue(((DSAPrivateKey)dHPrivateKey).getPrime().getByteArrayValue());
                object.getSubprime().setByteArrayValue(((DSAPrivateKey)dHPrivateKey).getSubprime().getByteArrayValue());
                dHPrivateKey = object;
            } else if (dHPrivateKey instanceof ECDSAPrivateKey) {
                object = new ECDSAPublicKey();
                object.getEcdsaParams().setByteArrayValue(((ECDSAPrivateKey)dHPrivateKey).getEcdsaParams().getByteArrayValue());
                dHPrivateKey = object;
            } else if (dHPrivateKey instanceof DHPrivateKey) {
                object = new DHPublicKey();
                object.getBase().setByteArrayValue(((DHPrivateKey)dHPrivateKey).getBase().getByteArrayValue());
                object.getPrime().setByteArrayValue(dHPrivateKey.getPrime().getByteArrayValue());
                dHPrivateKey = object;
            } else {
                dHPrivateKey = null;
            }
        } else if (dHPrivateKey instanceof iaik.pkcs.pkcs11.objects.PublicKey) {
            if (dHPrivateKey instanceof RSAPublicKey) {
                object = new RSAPrivateKey();
                object.getModulus().setByteArrayValue(((RSAPublicKey)dHPrivateKey).getModulus().getByteArrayValue());
                dHPrivateKey = object;
            } else if (dHPrivateKey instanceof DSAPublicKey) {
                object = new DSAPrivateKey();
                object.getBase().setByteArrayValue(((DSAPublicKey)dHPrivateKey).getBase().getByteArrayValue());
                object.getPrime().setByteArrayValue(((DSAPublicKey)dHPrivateKey).getPrime().getByteArrayValue());
                object.getSubprime().setByteArrayValue(((DSAPublicKey)dHPrivateKey).getSubprime().getByteArrayValue());
                dHPrivateKey = object;
            } else if (dHPrivateKey instanceof ECDSAPublicKey) {
                object = new ECDSAPrivateKey();
                object.getEcdsaParams().setByteArrayValue(((ECDSAPublicKey)dHPrivateKey).getEcdsaParams().getByteArrayValue());
                dHPrivateKey = object;
            } else if (dHPrivateKey instanceof DHPublicKey) {
                object = new DHPrivateKey();
                object.getBase().setByteArrayValue(((DHPublicKey)dHPrivateKey).getBase().getByteArrayValue());
                object.getPrime().setByteArrayValue(((DHPublicKey)dHPrivateKey).getPrime().getByteArrayValue());
                dHPrivateKey = object;
            } else if (dHPrivateKey instanceof KEAPublicKey) {
                object = new KEAPrivateKey();
                object.getBase().setByteArrayValue(((KEAPublicKey)dHPrivateKey).getBase().getByteArrayValue());
                object.getPrime().setByteArrayValue(((KEAPublicKey)dHPrivateKey).getPrime().getByteArrayValue());
                object.getSubprime().setByteArrayValue(((KEAPublicKey)dHPrivateKey).getSubprime().getByteArrayValue());
                dHPrivateKey = object;
            } else {
                dHPrivateKey = null;
            }
        } else {
            dHPrivateKey = null;
        }
        if (dHPrivateKey != null) {
            this.ensureReadSession();
            this.readSession_.findObjectsInit(dHPrivateKey);
            dHPrivateKey = this.readSession_.findObjects(1);
            object = ((DHPrivateKey)dHPrivateKey).length > 0 ? (iaik.pkcs.pkcs11.objects.Key)dHPrivateKey[0] : null;
            this.readSession_.findObjectsFinal();
        } else {
            object = null;
        }
        return object;
    }

    protected MechanismInfo getMechanismFeaturesSupport(String algorithmName) throws TokenException {
        String string;
        Token token = this.tokenManager_.getToken();
        if (token != null) {
            HashSet<Mechanism> hashSet = new HashSet<Mechanism>(Arrays.asList(token.getMechanismList()));
            if (algorithmName.equalsIgnoreCase("RSA")) {
                string = new MechanismInfo();
                if (hashSet.contains(Mechanism.get((long)1L))) {
                    string = string.or(token.getMechanismInfo(Mechanism.get((long)1L)));
                }
                if (hashSet.contains(Mechanism.get((long)4L))) {
                    string = string.or(token.getMechanismInfo(Mechanism.get((long)4L)));
                }
                if (hashSet.contains(Mechanism.get((long)5L))) {
                    string = string.or(token.getMechanismInfo(Mechanism.get((long)5L)));
                }
                if (hashSet.contains(Mechanism.get((long)6L))) {
                    string = string.or(token.getMechanismInfo(Mechanism.get((long)6L)));
                }
                if (hashSet.contains(Mechanism.get((long)7L))) {
                    string = string.or(token.getMechanismInfo(Mechanism.get((long)7L)));
                }
                if (hashSet.contains(Mechanism.get((long)8L))) {
                    string = string.or(token.getMechanismInfo(Mechanism.get((long)8L)));
                }
                if (hashSet.contains(Mechanism.get((long)3L))) {
                    string = string.or(token.getMechanismInfo(Mechanism.get((long)3L)));
                }
                if (hashSet.contains(Mechanism.get((long)2L))) {
                    string = string.or(token.getMechanismInfo(Mechanism.get((long)2L)));
                }
                if (hashSet.contains(Mechanism.get((long)9L))) {
                    string = string.or(token.getMechanismInfo(Mechanism.get((long)9L)));
                }
            } else if (string.equalsIgnoreCase("DSA")) {
                string = new MechanismInfo();
                if (hashSet.contains(Mechanism.get((long)17L))) {
                    string = string.or(token.getMechanismInfo(Mechanism.get((long)17L)));
                }
                if (hashSet.contains(Mechanism.get((long)18L))) {
                    string = string.or(token.getMechanismInfo(Mechanism.get((long)18L)));
                }
            } else if (string.equalsIgnoreCase("DH")) {
                string = new MechanismInfo();
                if (hashSet.contains(Mechanism.get((long)33L))) {
                    string = string.or(token.getMechanismInfo(Mechanism.get((long)33L)));
                }
            } else if (string.equalsIgnoreCase("ECDSA") || string.equalsIgnoreCase("EC")) {
                string = new MechanismInfo();
                if (hashSet.contains(Mechanism.get((long)4161L))) {
                    string = string.or(token.getMechanismInfo(Mechanism.get((long)4161L)));
                }
                if (hashSet.contains(Mechanism.get((long)4162L))) {
                    string = string.or(token.getMechanismInfo(Mechanism.get((long)4162L)));
                }
                if (hashSet.contains(Mechanism.get((long)4177L))) {
                    string = string.or(token.getMechanismInfo(Mechanism.get((long)4177L)));
                }
                if (hashSet.contains(Mechanism.get((long)4176L))) {
                    string = string.or(token.getMechanismInfo(Mechanism.get((long)4176L)));
                }
                if (hashSet.contains(Mechanism.get((long)4178L))) {
                    string = string.or(token.getMechanismInfo(Mechanism.get((long)4178L)));
                }
            } else if (string.equalsIgnoreCase("KEA")) {
                string = new MechanismInfo();
                if (hashSet.contains(Mechanism.get((long)4113L))) {
                    string = string.or(token.getMechanismInfo(Mechanism.get((long)4113L)));
                }
            } else {
                string = null;
            }
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    protected void setKeyAttributes(iaik.pkcs.pkcs11.objects.PrivateKey keyTemplate, java.security.cert.X509Certificate certificate, MechanismInfo supportedFeatures) throws X509ExtensionException, CertificateException {
        void var1_1;
        java.security.cert.Certificate certificate2;
        if (keyTemplate == null) {
            throw new NullPointerException("Argument \"keyTemplate\" must not be null.");
        }
        if (certificate != null) {
            certificate2 = certificate instanceof X509Certificate ? (X509Certificate)certificate : new X509Certificate(certificate2.getEncoded());
            certificate2 = (KeyUsage)certificate2.getExtension(KeyUsage.oid);
        } else {
            certificate2 = null;
        }
        if (certificate2 != null) {
            int n = certificate2.get();
            if (supportedFeatures != null) {
                keyTemplate.getDecrypt().setBooleanValue(new Boolean(((n & 8) != 0 || (n & 4) != 0) && supportedFeatures.isDecrypt()));
                keyTemplate.getSign().setBooleanValue(new Boolean(((n & 1) != 0 || (n & 0x20) != 0 || (n & 0x40) != 0 || (n & 2) != 0) && supportedFeatures.isSign()));
                keyTemplate.getSignRecover().setBooleanValue(new Boolean(((n & 1) != 0 || (n & 0x20) != 0 || (n & 0x40) != 0 || (n & 2) != 0) && supportedFeatures.isSignRecover()));
                keyTemplate.getDerive().setBooleanValue(new Boolean((n & 0x10) != 0 && supportedFeatures.isDerive()));
                keyTemplate.getUnwrap().setBooleanValue(new Boolean((n & 4) != 0 && supportedFeatures.isUnwrap()));
                return;
            }
            keyTemplate.getDecrypt().setBooleanValue(new Boolean((n & 8) != 0 || (n & 4) != 0));
            keyTemplate.getSign().setBooleanValue(new Boolean((n & 1) != 0 || (n & 0x20) != 0 || (n & 0x40) != 0 || (n & 2) != 0));
            keyTemplate.getSignRecover().setBooleanValue(new Boolean((n & 1) != 0 || (n & 0x20) != 0 || (n & 0x40) != 0 || (n & 2) != 0));
            keyTemplate.getDerive().setBooleanValue(new Boolean((n & 0x10) != 0));
            keyTemplate.getUnwrap().setBooleanValue(new Boolean((n & 4) != 0));
            return;
        }
        if (supportedFeatures != null) {
            void var3_4;
            keyTemplate.getSign().setBooleanValue(new Boolean(supportedFeatures.isSign()));
            keyTemplate.getSignRecover().setBooleanValue(new Boolean(supportedFeatures.isSignRecover()));
            keyTemplate.getDecrypt().setBooleanValue(new Boolean(supportedFeatures.isDecrypt()));
            keyTemplate.getDerive().setBooleanValue(new Boolean(supportedFeatures.isDerive()));
            keyTemplate.getUnwrap().setBooleanValue(new Boolean(var3_4.isUnwrap()));
            return;
        }
        keyTemplate.getSign().setBooleanValue(Boolean.TRUE);
        keyTemplate.getSignRecover().setBooleanValue(Boolean.TRUE);
        keyTemplate.getDecrypt().setBooleanValue(Boolean.TRUE);
        keyTemplate.getDerive().setBooleanValue(Boolean.TRUE);
        var1_1.getUnwrap().setBooleanValue(Boolean.TRUE);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    protected void setKeyAttributes(iaik.pkcs.pkcs11.objects.PublicKey keyTemplate, java.security.cert.X509Certificate certificate, MechanismInfo supportedFeatures) throws X509ExtensionException, CertificateException {
        void var1_1;
        java.security.cert.Certificate certificate2;
        if (keyTemplate == null) {
            throw new NullPointerException("Argument \"keyTemplate\" must not be null.");
        }
        if (certificate != null) {
            certificate2 = certificate instanceof X509Certificate ? (X509Certificate)certificate : new X509Certificate(certificate2.getEncoded());
            certificate2 = (KeyUsage)certificate2.getExtension(KeyUsage.oid);
        } else {
            certificate2 = null;
        }
        if (certificate2 != null) {
            int n = certificate2.get();
            if (supportedFeatures != null) {
                keyTemplate.getEncrypt().setBooleanValue(new Boolean((n & 8) != 0 && supportedFeatures.isEncrypt()));
                keyTemplate.getVerify().setBooleanValue(new Boolean(((n & 1) != 0 || (n & 0x20) != 0 || (n & 0x40) != 0 || (n & 2) != 0) && supportedFeatures.isVerify()));
                keyTemplate.getVerifyRecover().setBooleanValue(new Boolean(((n & 1) != 0 || (n & 0x20) != 0 || (n & 0x40) != 0 || (n & 2) != 0) && supportedFeatures.isVerifyRecover()));
                keyTemplate.getDerive().setBooleanValue(new Boolean((n & 0x10) != 0 && supportedFeatures.isDerive()));
                keyTemplate.getWrap().setBooleanValue(new Boolean((n & 4) != 0 && supportedFeatures.isWrap()));
                return;
            }
            keyTemplate.getEncrypt().setBooleanValue(new Boolean((n & 8) != 0));
            keyTemplate.getVerify().setBooleanValue(new Boolean((n & 1) != 0 || (n & 0x20) != 0 || (n & 0x40) != 0 || (n & 2) != 0));
            keyTemplate.getVerifyRecover().setBooleanValue(new Boolean((n & 1) != 0 || (n & 0x20) != 0 || (n & 0x40) != 0 || (n & 2) != 0));
            keyTemplate.getDerive().setBooleanValue(new Boolean((n & 0x10) != 0));
            keyTemplate.getWrap().setBooleanValue(new Boolean((n & 4) != 0));
            return;
        }
        if (supportedFeatures != null) {
            void var3_4;
            keyTemplate.getVerify().setBooleanValue(new Boolean(supportedFeatures.isVerify()));
            keyTemplate.getVerifyRecover().setBooleanValue(new Boolean(supportedFeatures.isVerifyRecover()));
            keyTemplate.getEncrypt().setBooleanValue(new Boolean(supportedFeatures.isEncrypt()));
            keyTemplate.getDerive().setBooleanValue(new Boolean(supportedFeatures.isDerive()));
            keyTemplate.getWrap().setBooleanValue(new Boolean(var3_4.isWrap()));
            return;
        }
        keyTemplate.getVerify().setBooleanValue(Boolean.TRUE);
        keyTemplate.getVerifyRecover().setBooleanValue(Boolean.TRUE);
        keyTemplate.getEncrypt().setBooleanValue(Boolean.TRUE);
        keyTemplate.getDerive().setBooleanValue(Boolean.TRUE);
        var1_1.getWrap().setBooleanValue(Boolean.TRUE);
    }

    /*
     * WARNING - void declaration
     */
    protected KeySpec createPrivateKeySpec(Key key) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException, KeyStoreException {
        void var1_1;
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        java.lang.Object object = key.getAlgorithm();
        if (((String)object).equalsIgnoreCase("RSA")) {
            object = key instanceof RSAPrivateCrtKey ? (a == null ? (a = TokenKeyStoreSpi.a("java.security.spec.RSAPrivateCrtKeySpec")) : a) : (b == null ? (b = TokenKeyStoreSpi.a("java.security.spec.RSAPrivateKeySpec")) : b);
        } else if (((String)object).equalsIgnoreCase("DSA")) {
            object = c == null ? (c = TokenKeyStoreSpi.a("java.security.spec.DSAPrivateKeySpec")) : c;
        } else if (((String)object).equalsIgnoreCase("ECDSA") || ((String)object).equalsIgnoreCase("EC")) {
            object = d == null ? (d = TokenKeyStoreSpi.a("java.security.spec.PKCS8EncodedKeySpec")) : d;
        } else if (((String)object).equalsIgnoreCase("DH")) {
            object = e == null ? (e = TokenKeyStoreSpi.a("javax.crypto.spec.DHPrivateKeySpec")) : e;
        } else {
            throw new KeyStoreException("No means to convert key of algorithm: " + (String)object);
        }
        return this.createKeySpec((Key)var1_1, (Class)object);
    }

    /*
     * WARNING - void declaration
     */
    protected KeySpec createPublicKeySpec(Key key) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException, KeyStoreException {
        void var1_1;
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        java.lang.Object object = key.getAlgorithm();
        if (((String)object).equalsIgnoreCase("RSA")) {
            object = f == null ? (f = TokenKeyStoreSpi.a("java.security.spec.RSAPublicKeySpec")) : f;
        } else if (((String)object).equalsIgnoreCase("DSA")) {
            object = g == null ? (g = TokenKeyStoreSpi.a("java.security.spec.DSAPublicKeySpec")) : g;
        } else if (((String)object).equalsIgnoreCase("ECDSA") || ((String)object).equalsIgnoreCase("EC")) {
            object = h == null ? (h = TokenKeyStoreSpi.a("java.security.spec.X509EncodedKeySpec")) : h;
        } else if (((String)object).equalsIgnoreCase("DH")) {
            object = i == null ? (i = TokenKeyStoreSpi.a("javax.crypto.spec.DHPublicKeySpec")) : i;
        } else {
            throw new KeyStoreException("No means to convert key of algorithm: " + (String)object);
        }
        return this.createKeySpec((Key)var1_1, (Class)object);
    }

    /*
     * WARNING - void declaration
     */
    protected KeySpec createKeySpec(Key key, Class keySpecClass) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException, KeyStoreException {
        void var2_2;
        java.lang.Object t;
        KeyFactory keyFactory;
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        if (keySpecClass == null) {
            throw new NullPointerException("Argument \"keySpecClass\" must not be null.");
        }
        try {
            keyFactory = this.supportProviderName_ != null ? KeyFactory.getInstance(key.getAlgorithm(), this.supportProviderName_) : KeyFactory.getInstance(key.getAlgorithm());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            keyFactory = KeyFactory.getInstance(key.getAlgorithm());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            keyFactory = KeyFactory.getInstance(key.getAlgorithm());
        }
        t = keyFactory.getKeySpec((Key)t, var2_2);
        return t;
    }

    protected KeySpec createSecretKeySpec(SecretKey key) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException, KeyStoreException {
        KeySpec keySpec;
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        java.lang.Object object = key.getAlgorithm();
        Class clazz = ((String)object).equalsIgnoreCase("DESede") ? (j == null ? (j = TokenKeyStoreSpi.a("javax.crypto.spec.DESedeKeySpec")) : j) : (((String)object).equalsIgnoreCase("DES") ? (k == null ? (k = TokenKeyStoreSpi.a("javax.crypto.spec.DESKeySpec")) : k) : (l == null ? (l = TokenKeyStoreSpi.a("javax.crypto.spec.SecretKeySpec")) : l));
        object = this.supportProviderName_ != null ? SecretKeyFactory.getInstance((String)object, this.supportProviderName_) : SecretKeyFactory.getInstance((String)object);
        keySpec = ((SecretKeyFactory)object).getKeySpec((SecretKey)((java.lang.Object)keySpec), clazz);
        return keySpec;
    }

    protected iaik.pkcs.pkcs11.objects.Key createKeyCreationTemplate(iaik.pkcs.pkcs11.objects.Key baseKey) {
        iaik.pkcs.pkcs11.objects.Key key;
        if (baseKey == null) {
            throw new NullPointerException("Argument \"baseKey\" must not be null.");
        }
        key = (iaik.pkcs.pkcs11.objects.Key)key.clone();
        key.getKeyGenMechanism().setPresent(false);
        key.getLocal().setPresent(false);
        if (key instanceof iaik.pkcs.pkcs11.objects.PrivateKey) {
            iaik.pkcs.pkcs11.objects.PrivateKey privateKey = (iaik.pkcs.pkcs11.objects.PrivateKey)key;
            privateKey.getAuthPinFlags().setPresent(false);
            privateKey.getAlwaysSensitive().setPresent(false);
            privateKey.getNeverExtractable().setPresent(false);
            if (key instanceof DHPrivateKey) {
                privateKey = (DHPrivateKey)key;
                privateKey.getValueBits().setPresent(false);
            }
        } else if (key instanceof iaik.pkcs.pkcs11.objects.PublicKey) {
            if (key instanceof RSAPublicKey) {
                RSAPublicKey rSAPublicKey = (RSAPublicKey)key;
                rSAPublicKey.getModulusBits().setPresent(false);
            }
        } else if (key instanceof iaik.pkcs.pkcs11.objects.SecretKey) {
            iaik.pkcs.pkcs11.objects.SecretKey secretKey = (iaik.pkcs.pkcs11.objects.SecretKey)key;
            secretKey.getAlwaysSensitive().setPresent(false);
            secretKey.getNeverExtractable().setPresent(false);
            secretKey = (iaik.pkcs.pkcs11.objects.Attribute)secretKey.getAttributeTable().get(iaik.pkcs.pkcs11.objects.Attribute.VALUE_LEN);
            if (secretKey != null) {
                secretKey.setPresent(false);
            }
        }
        return key;
    }

    protected synchronized byte[] generateNewID(byte[] suggestedID) throws TokenException {
        byte[] byArray;
        if (suggestedID == null || suggestedID.length <= 0) {
            byArray = this.lastNewID_ == null ? new byte[20] : this.lastNewID_;
        }
        GenericTemplate genericTemplate = new GenericTemplate();
        ByteArrayAttribute byteArrayAttribute = new ByteArrayAttribute(iaik.pkcs.pkcs11.objects.Attribute.ID);
        byteArrayAttribute.setByteArrayValue(byArray);
        genericTemplate.addAttribute((iaik.pkcs.pkcs11.objects.Attribute)byteArrayAttribute);
        boolean bl = false;
        while (!bl) {
            TokenKeyStoreSpi.a(byArray);
            this.writeSession_.findObjectsInit((Object)genericTemplate);
            Object[] objectArray = this.writeSession_.findObjects(1);
            this.writeSession_.findObjectsFinal();
            bl = objectArray.length == 0;
        }
        this.lastNewID_ = byArray;
        return this.lastNewID_;
    }

    protected synchronized void ensureCurrentTables() throws IAIKPkcs11Exception {
        this.a();
    }

    final synchronized void a() throws IAIKPkcs11Exception {
        try {
            block4: {
                block3: {
                    block2: {
                        if (!this.tokenManager_.isTokenPresent()) break block2;
                        if (this.isUpToDate()) break block3;
                        break block4;
                    }
                    this.clearTables();
                    this.infoOfRecentToken_ = null;
                }
                return;
            }
            this.clearTables();
            this.ensureReadSession();
            this.updateTables();
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    protected synchronized void ensureReadSession() throws TokenException, IAIKPkcs11Exception {
        if (this.readSession_ == null) {
            this.openReadSession();
        }
        if (this.useUserSession_) {
            this.loginSession();
        }
    }

    protected synchronized void ensureWriteSession() throws TokenException, IAIKPkcs11Exception {
        if (this.writeSession_ == null) {
            this.openWriteSession();
        }
        this.loginSession();
    }

    protected synchronized void releaseSessions() {
        if (this.readSession_ != null) {
            if (this.readSession_ != this.writeSession_) {
                this.tokenManager_.disposeSession(this.readSession_);
            }
            this.readSession_ = null;
        }
        if (this.writeSession_ != null) {
            this.tokenManager_.disposeSession(this.writeSession_);
            this.writeSession_ = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized String createUniqueAlias(Object pkcs11Object, Set usedAliases) {
        String string;
        java.lang.Object object;
        if (pkcs11Object == null) {
            throw new NullPointerException("Argument \"pkcs11Object\" must not be null.");
        }
        if (usedAliases == null) {
            throw new NullPointerException("Argument \"usedAliases\" must not be null.");
        }
        if (pkcs11Object instanceof Storage) {
            object = (Storage)pkcs11Object;
            if ((object = object.getLabel()) != null) {
                char[] cArray = object.getCharArrayValue();
                object = cArray;
                string = cArray != null ? new String((char[])object) : String.valueOf(pkcs11Object.getObjectHandle());
            } else {
                string = Object.getObjectClassName((Long)pkcs11Object.getObjectClass().getLongValue());
            }
        } else {
            string = Object.getObjectClassName((Long)pkcs11Object.getObjectClass().getLongValue());
        }
        if (usedAliases.contains(string)) {
            void var1_1;
            object = new StringBuffer(string.length() + 16);
            ((StringBuffer)object).append(string);
            ((StringBuffer)object).append('(');
            ((StringBuffer)object).append(var1_1.getObjectHandle());
            ((StringBuffer)object).append(')');
            string = ((StringBuffer)object).toString();
        }
        object = string;
        while (usedAliases.contains(object)) {
            object = new StringBuffer(string.length() + 4);
            ((StringBuffer)object).append(string);
            ((StringBuffer)object).append('[');
            ((StringBuffer)object).append(2);
            ((StringBuffer)object).append(']');
            object = ((StringBuffer)object).toString();
        }
        return string;
    }

    private synchronized List b() throws TokenException {
        ArrayList<Object> arrayList;
        block9: {
            arrayList = new ArrayList<Object>(2);
            this.readSession_.findObjectsInit(null);
            try {
                while (true) {
                    try {
                        block6: while (true) {
                            Object[] objectArray;
                            if ((objectArray = this.readSession_.findObjects(1)).length == 0) {
                                break block9;
                            }
                            int n = 0;
                            while (true) {
                                if (n >= objectArray.length) continue block6;
                                arrayList.add(objectArray[n]);
                                ++n;
                            }
                            break;
                        }
                    }
                    catch (TokenException tokenException) {
                        if (null != tokenException.getEncapsulatedException()) continue;
                        throw tokenException;
                    }
                    break;
                }
            }
            finally {
                this.readSession_.findObjectsFinal();
            }
        }
        return arrayList;
    }

    protected boolean contains(List arrays, byte[] other) {
        for (int i2 = 0; i2 < arrays.size(); ++i2) {
            if (!Arrays.equals((byte[])arrays.get(i2), other)) continue;
            return true;
        }
        return false;
    }

    protected synchronized void findKeysAndCertificateTables() throws TokenException, KeyStoreException {
        java.lang.Object object;
        java.lang.Object object2;
        java.lang.Object object3;
        java.lang.Object object4;
        java.lang.Object object5;
        java.lang.Object object6;
        Object object7;
        java.lang.Object object8;
        Hashtable<java.lang.Object, java.lang.Object> hashtable;
        AttributeCertificate attributeCertificate;
        java.lang.Object object9;
        Serializable serializable;
        java.lang.Object object10 = this.b();
        X509Certificate[] x509CertificateArray = new ArrayList();
        IdentityMap identityMap = new IdentityMap(8);
        IdentityMap identityMap2 = new IdentityMap(8);
        java.lang.Object object11 = new HashMap<Serializable, java.lang.Object>(8);
        Iterator iterator = object10.iterator();
        while (iterator.hasNext()) {
            serializable = (Object)iterator.next();
            if (serializable instanceof Certificate) {
                if (serializable instanceof X509PublicKeyCertificate) {
                    serializable = (X509PublicKeyCertificate)serializable;
                    byte[] byArray = serializable.getValue().getByteArrayValue();
                    object9 = byArray;
                    if (byArray == null) continue;
                    try {
                        attributeCertificate = new X509Certificate((InputStream)new ByteArrayInputStream((byte[])object9));
                        identityMap2.a(attributeCertificate, serializable);
                        serializable = ((Name)attributeCertificate.getSubjectDN()).getRFC2253String();
                        hashtable = object11.get(serializable);
                        if (hashtable == null) {
                            object11.put(serializable, attributeCertificate);
                            continue;
                        }
                        if (hashtable instanceof X509Certificate) {
                            object8 = new Vector<Hashtable<java.lang.Object, java.lang.Object>>(2);
                            ((Vector)object8).addElement(hashtable);
                            ((Vector)object8).addElement(attributeCertificate);
                            object11.put(serializable, object8);
                            continue;
                        }
                        object8 = (Vector)((java.lang.Object)hashtable);
                        ((Vector)object8).addElement(attributeCertificate);
                    }
                    catch (IOException iOException) {
                        IAIKPkcs11.errorStream_.println("Could not create Certificate object: " + iOException);
                        iOException.printStackTrace(IAIKPkcs11.errorStream_);
                    }
                    catch (CertificateException certificateException) {
                        IAIKPkcs11.errorStream_.println("Could not create Certificate object: " + certificateException);
                        certificateException.printStackTrace(IAIKPkcs11.errorStream_);
                    }
                    catch (RFC2253NameParserException rFC2253NameParserException) {
                        IAIKPkcs11.errorStream_.println("Could not create Certificate object: " + (java.lang.Object)((java.lang.Object)rFC2253NameParserException));
                        rFC2253NameParserException.printStackTrace(IAIKPkcs11.errorStream_);
                    }
                    continue;
                }
                if (!(serializable instanceof X509AttributeCertificate)) continue;
                serializable = (X509AttributeCertificate)serializable;
                object9 = serializable.getValue().getByteArrayValue();
                try {
                    attributeCertificate = new AttributeCertificate(object9);
                    identityMap2.a(attributeCertificate, serializable);
                }
                catch (CertificateException certificateException) {
                    IAIKPkcs11.errorStream_.println("Could not create AttributeCertificate object: " + certificateException);
                    certificateException.printStackTrace(IAIKPkcs11.errorStream_);
                }
                continue;
            }
            if (!(serializable instanceof iaik.pkcs.pkcs11.objects.PrivateKey)) continue;
            x509CertificateArray.add(((iaik.pkcs.pkcs11.objects.PrivateKey)serializable).getId().getByteArrayValue());
        }
        serializable = identityMap2.b();
        serializable = serializable.iterator();
        while (serializable.hasNext()) {
            object9 = serializable.next();
            identityMap.a(object9, identityMap2.a(object9));
        }
        object9 = new Hashtable(identityMap2.a());
        attributeCertificate = new Hashtable(identityMap2.a());
        serializable = new Vector(identityMap2.a());
        ((Vector)serializable).addAll(identityMap2.b());
        hashtable = new Hashtable();
        object8 = ((Vector)serializable).iterator();
        int n = 0;
        while (object8.hasNext()) {
            serializable = (java.security.cert.Certificate)object8.next();
            if (serializable == null || (object7 = (Object)identityMap2.a(serializable)) == null || !(serializable instanceof X509Certificate)) continue;
            object6 = (X509Certificate)serializable;
            object5 = (X509PublicKeyCertificate)object7;
            object4 = object5.getId().getByteArrayValue();
            if (object4 == null || !this.contains((List)x509CertificateArray, (byte[])object4)) continue;
            object3 = new ComparableByteArray((byte[])object4);
            object2 = new Integer(n++);
            Vector vector = (Vector)hashtable.get(object3);
            object = vector;
            if (vector != null) {
                object.add(object2);
            } else {
                object = new Vector<iaik.pkcs.pkcs11.objects.PrivateKey>(1);
                object.add(object2);
            }
            hashtable.put(object3, object);
            object6 = this.createCertificateChain((X509Certificate)object6, (Map)object11, object5.getLabel().getCharArrayValue(), identityMap);
            object = new Object[((X509Certificate[])object6).length];
            for (int i2 = 0; i2 < ((java.lang.Object)object6).length; ++i2) {
                object[i2] = (Object)identityMap2.a(object6[i2]);
            }
            ((Hashtable)object9).put(object2, object);
            attributeCertificate.put(object2, object6);
        }
        serializable = new LinkedList();
        object7 = new LinkedList();
        Iterator iterator2 = object10.iterator();
        while (iterator2.hasNext()) {
            object6 = (Object)iterator2.next();
            if (!(object6 instanceof iaik.pkcs.pkcs11.objects.Key)) continue;
            object5 = (iaik.pkcs.pkcs11.objects.Key)object6;
            object4 = null;
            if (object5 instanceof iaik.pkcs.pkcs11.objects.PrivateKey) {
                object2 = (iaik.pkcs.pkcs11.objects.PrivateKey)object5;
                object3 = IAIKPKCS11PrivateKey.create(this.tokenManager_, object2);
                object = object2.getId().getByteArrayValue();
                if (object != null && (object = (Vector)hashtable.remove(object6 = new ComparableByteArray((byte[])object))) != null) {
                    object4 = new Vector(1);
                    Iterator iterator3 = object.iterator();
                    while (iterator3.hasNext()) {
                        object10 = (Integer)iterator3.next();
                        x509CertificateArray = (X509Certificate[])attributeCertificate.remove(object10);
                        if (x509CertificateArray == null || x509CertificateArray.length <= 0) continue;
                        object10 = (Object[])((Hashtable)object9).remove(object10);
                        object11 = this.createUniqueAlias(object10[0], this.aliases_);
                        object4.add(object11);
                        this.aliases_.add(object11);
                        this.certificateChains_.put(object11, x509CertificateArray);
                        if (object10 != null) {
                            this.certificateChainAliasToPkcs11ObjectsTable_.put(object11, object10);
                        }
                        if (x509CertificateArray.length <= 0) continue;
                        identityMap2.b(x509CertificateArray[0]);
                        identityMap.b(x509CertificateArray[0]);
                    }
                }
                if (object3 == null) continue;
                if (object4 == null) {
                    object4 = new Vector(1);
                    object6 = this.createUniqueAlias((Object)object5, this.aliases_);
                    object4.add(object6);
                    this.aliases_.add(object6);
                }
                object6 = object4.iterator();
                while (object6.hasNext()) {
                    object = (String)object6.next();
                    this.keyAliasToPkcs11ObjectTable_.put(object, object5);
                    this.keys_.put(object, object3);
                }
                continue;
            }
            if (object5 instanceof iaik.pkcs.pkcs11.objects.PublicKey) {
                serializable.add(object5);
                continue;
            }
            if (object5 instanceof iaik.pkcs.pkcs11.objects.SecretKey) {
                object7.add(object5);
                continue;
            }
            throw new KeyStoreException("Unknown key type: " + object5.getClass().getName());
        }
        object6 = serializable.iterator();
        while (object6.hasNext()) {
            object5 = (iaik.pkcs.pkcs11.objects.PublicKey)object6.next();
            object4 = IAIKPKCS11PublicKey.create(this.tokenManager_, (iaik.pkcs.pkcs11.objects.PublicKey)object5);
            object3 = this.createUniqueAlias((Object)object5, this.aliases_);
            this.keyAliasToPkcs11ObjectTable_.put(object3, object5);
            this.keys_.put(object3, object4);
            this.aliases_.add(object3);
        }
        object5 = object7.iterator();
        while (object5.hasNext()) {
            object4 = (iaik.pkcs.pkcs11.objects.SecretKey)object5.next();
            object3 = IAIKPKCS11SecretKey.create(this.tokenManager_, (iaik.pkcs.pkcs11.objects.SecretKey)object4);
            object2 = this.createUniqueAlias((Object)object4, this.aliases_);
            this.keyAliasToPkcs11ObjectTable_.put(object2, object4);
            this.keys_.put(object2, object3);
            this.aliases_.add(object2);
        }
        serializable = new Vector(identityMap.a());
        ((Vector)serializable).addAll(identityMap.b());
        object8 = ((Vector)serializable).iterator();
        while (object8.hasNext()) {
            java.security.cert.Certificate certificate = (java.security.cert.Certificate)object8.next();
            object4 = certificate;
            if (certificate == null) continue;
            object3 = (Object)identityMap.a(object4);
            if (object3 != null) {
                object2 = this.createUniqueAlias((Object)object3, this.aliases_);
                this.trustedCertificateAliasToPkcs11ObjectTable_.put(object2, object3);
                this.trustedCertificates_.put(object2, object4);
                this.aliases_.add(object2);
            }
            identityMap.b(object4);
        }
    }

    protected synchronized void initialize() {
        this.aliases_ = new HashSet();
        this.keys_ = new Hashtable();
        this.certificateChains_ = new Hashtable();
        this.trustedCertificates_ = new Hashtable();
        this.keyAliasToPkcs11ObjectTable_ = new Hashtable();
        this.certificateChainAliasToPkcs11ObjectsTable_ = new Hashtable();
        this.trustedCertificateAliasToPkcs11ObjectTable_ = new Hashtable();
        this.useUserSession_ = !this.tokenManager_.getProvider().isLoginKeystoreOnDemand();
        this.setUpToDate(false);
        this.tokenManager_.addKeyStoreReference(this);
    }

    protected boolean isEndUserCertificate(X509Certificate certificate) throws CertificateException {
        BasicConstraints basicConstraints;
        try {
            basicConstraints = (BasicConstraints)certificate.getExtension(BasicConstraints.oid);
        }
        catch (X509ExtensionInitException x509ExtensionInitException) {
            throw new CertificateException(x509ExtensionInitException.toString());
        }
        return basicConstraints == null || !basicConstraints.ca();
    }

    protected synchronized X509Certificate[] createCertificateChain(X509Certificate userCertificate, Map subjectToCertificatesMap, char[] label, IdentityMap trustedCertificates) {
        if (userCertificate == null) {
            throw new NullPointerException("Argument \"userCertificate\" must not be null.");
        }
        if (subjectToCertificatesMap == null) {
            throw new NullPointerException("Argument \"subjectToCertificatesMap\" must not be null.");
        }
        Vector<X509Certificate> vector = new Vector<X509Certificate>(4);
        vector.add(userCertificate);
        java.lang.Object object = null;
        int n = 100;
        try {
            java.lang.Object object2;
            java.lang.Object object3;
            java.lang.Object object4;
            java.lang.Object object5;
            X509Certificate x509Certificate;
            java.lang.Object object6 = (Name)x509Certificate.getIssuerDN();
            object6 = object6.getRFC2253String();
            object6 = subjectToCertificatesMap.get(object6);
            if (object6 == null) {
                object = null;
            } else if (object6 instanceof Vector) {
                object6 = (Vector)object6;
                object5 = object6.iterator();
                while (object5.hasNext()) {
                    object4 = (X509Certificate)object5.next();
                    object3 = (X509PublicKeyCertificate)trustedCertificates.a(object4);
                    if (object3 == null || !Arrays.equals(label, object2 = object3.getLabel().getCharArrayValue())) continue;
                    object = object4;
                    trustedCertificates.b(object4);
                    break;
                }
                if (object == null) {
                    object = (X509Certificate)object6.firstElement();
                }
            } else {
                object = (X509Certificate)object6;
                if ((object6 = (X509PublicKeyCertificate)trustedCertificates.a(object)) != null && Arrays.equals(label, (char[])(object5 = (java.lang.Object)object6.getLabel().getCharArrayValue()))) {
                    trustedCertificates.b(object);
                }
            }
            while (object != null && !x509Certificate.equals(object) && n-- > 0) {
                object6 = (AuthorityKeyIdentifier)x509Certificate.getExtension(AuthorityKeyIdentifier.oid);
                object5 = (SubjectKeyIdentifier)object.getExtension(SubjectKeyIdentifier.oid);
                if (object6 == null || object5 == null || Arrays.equals(object6.getKeyIdentifier(), object5.get())) {
                    vector.add((X509Certificate)object);
                    x509Certificate = object;
                    object6 = (Name)x509Certificate.getIssuerDN();
                    object6 = object6.getRFC2253String();
                    object = null;
                    object6 = subjectToCertificatesMap.get(object6);
                    if (object6 == null) {
                        object = null;
                        continue;
                    }
                    if (object6 instanceof Vector) {
                        object4 = (Vector)object6;
                        object3 = ((Vector)object4).iterator();
                        while (object3.hasNext()) {
                            object2 = (X509Certificate)object3.next();
                            object6 = (X509PublicKeyCertificate)trustedCertificates.a(object2);
                            if (object6 == null || !Arrays.equals(label, (char[])(object6 = (java.lang.Object)object6.getLabel().getCharArrayValue()))) continue;
                            object = object2;
                            trustedCertificates.b(object2);
                            break;
                        }
                        if (object != null) continue;
                        object = (X509Certificate)((Vector)object4).firstElement();
                        continue;
                    }
                    object = (X509Certificate)object6;
                    object4 = (X509PublicKeyCertificate)trustedCertificates.a(object);
                    if (object4 == null || !Arrays.equals(label, (char[])(object3 = (java.lang.Object)object4.getLabel().getCharArrayValue()))) continue;
                    trustedCertificates.b(object);
                    continue;
                }
                break;
            }
        }
        catch (RFC2253NameParserException rFC2253NameParserException) {
            RFC2253NameParserException rFC2253NameParserException2 = rFC2253NameParserException;
            rFC2253NameParserException.printStackTrace(IAIKPkcs11.errorStream_);
        }
        catch (X509ExtensionException x509ExtensionException) {
            X509ExtensionException x509ExtensionException2 = x509ExtensionException;
            x509ExtensionException.printStackTrace(IAIKPkcs11.errorStream_);
        }
        Vector<X509Certificate> vector2 = vector;
        return vector2.toArray(new X509Certificate[vector2.size()]);
    }

    protected synchronized boolean getReadProtectedKeyOnDemand() {
        return !this.useUserSession_;
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized void setReadProtectedKeyOnDemand(boolean onDemand) {
        if (onDemand == this.useUserSession_) {
            void var1_1;
            this.useUserSession_ = var1_1 == false;
            this.setUpToDate(false);
        }
    }

    protected synchronized void openReadSession() {
        try {
            this.readSession_ = this.writeSession_ != null ? this.writeSession_ : this.tokenManager_.getSession(false);
            return;
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    protected synchronized void openWriteSession() {
        try {
            this.writeSession_ = this.tokenManager_.getSession(true);
            return;
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    protected String readProviderName(InputStream in) throws IOException {
        int n;
        void var1_1;
        char[] cArray = new char[64];
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)var1_1, "UTF-8");
        CharArrayWriter charArrayWriter = new CharArrayWriter(64);
        while ((n = inputStreamReader.read(cArray, 0, 64)) >= 0) {
            charArrayWriter.write(cArray, 0, n);
        }
        charArrayWriter.flush();
        return new String(charArrayWriter.toCharArray());
    }

    /*
     * WARNING - void declaration
     */
    protected void writeProviderName(String providerName, OutputStream out) throws IOException {
        void var1_1;
        out.write(var1_1.getBytes("UTF-8"));
    }

    protected synchronized boolean loginSession() {
        boolean bl;
        try {
            if (this.readSession_ == null) {
                this.openReadSession();
            }
            bl = this.tokenManager_.makeAuthorizedSession(this.readSession_, null);
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
        return bl;
    }

    protected synchronized void logoutSession() {
        try {
            this.tokenManager_.logout();
            return;
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    protected synchronized void clearTables() {
        this.aliases_.clear();
        this.keys_.clear();
        this.certificateChains_.clear();
        this.trustedCertificates_.clear();
        this.keyAliasToPkcs11ObjectTable_.clear();
        this.certificateChainAliasToPkcs11ObjectsTable_.clear();
        this.trustedCertificateAliasToPkcs11ObjectTable_.clear();
    }

    protected void ensureSupportProvider() {
        this.supportProviderName_ = this.tokenManager_.getProvider().getKeystoreSupportProvider();
    }

    protected synchronized void updateTables() {
        try {
            this.infoOfRecentToken_ = this.tokenManager_.getToken().getTokenInfo();
            this.findKeysAndCertificateTables();
            this.setUpToDate(true);
            return;
        }
        catch (KeyStoreException keyStoreException) {
            KeyStoreException keyStoreException2 = keyStoreException;
            keyStoreException.printStackTrace(IAIKPkcs11.errorStream_);
            return;
        }
        catch (TokenException tokenException) {
            TokenException tokenException2 = tokenException;
            tokenException.printStackTrace(IAIKPkcs11.errorStream_);
            return;
        }
    }

    protected synchronized boolean isUpToDate() throws TokenException {
        if (this.isUpToDate_) {
            if (this.tokenManager_.isTokenPresent()) {
                TokenInfo tokenInfo = this.tokenManager_.getToken().getTokenInfo();
                if (!(this.infoOfRecentToken_ != null && this.infoOfRecentToken_.getLabel().equals(tokenInfo.getLabel()) && this.infoOfRecentToken_.getManufacturerID().equals(tokenInfo.getManufacturerID()) && this.infoOfRecentToken_.getModel().equals(tokenInfo.getModel()) && this.infoOfRecentToken_.getSerialNumber().equals(tokenInfo.getSerialNumber()) && this.infoOfRecentToken_.getFreePrivateMemory() == tokenInfo.getFreePrivateMemory() && this.infoOfRecentToken_.getFreePublicMemory() == tokenInfo.getFreePublicMemory())) {
                    this.isUpToDate_ = false;
                }
            } else if (this.infoOfRecentToken_ != null) {
                this.isUpToDate_ = false;
            }
        }
        return this.isUpToDate_;
    }

    /*
     * WARNING - void declaration
     */
    protected void setUpToDate(boolean isUpToDate) {
        void var1_1;
        this.isUpToDate_ = var1_1;
    }

    protected synchronized boolean tokenChanged() throws TokenException {
        boolean bl;
        if (this.tokenManager_.isTokenPresent()) {
            TokenInfo tokenInfo = this.tokenManager_.getToken().getTokenInfo();
            bl = !(this.infoOfRecentToken_ != null && this.infoOfRecentToken_.getLabel().equals(tokenInfo.getLabel()) && this.infoOfRecentToken_.getManufacturerID().equals(tokenInfo.getManufacturerID()) && this.infoOfRecentToken_.getModel().equals(tokenInfo.getModel()) && this.infoOfRecentToken_.getSerialNumber().equals(tokenInfo.getSerialNumber()));
        } else {
            bl = this.infoOfRecentToken_ != null;
        }
        return bl;
    }

    protected void finalize() throws Throwable {
        if (this.tokenManager_ != null) {
            this.tokenManager_.disposeSession(this.readSession_);
            if (this.readSession_ != this.writeSession_) {
                this.tokenManager_.disposeSession(this.writeSession_);
            }
        }
        super.finalize();
    }

    private static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

