/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider;

import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.provider.DefaultDelegateProvider;
import iaik.pkcs.pkcs11.provider.DefaultKeyHandler;
import iaik.pkcs.pkcs11.provider.DefaultLoginManager;
import iaik.pkcs.pkcs11.provider.DelegateProvider;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.KeyHandler;
import iaik.pkcs.pkcs11.provider.LoginManager;
import iaik.pkcs.pkcs11.provider.PKCS11EngineClass;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.provider.b;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.crypto.Cipher;

public class IAIKPkcs11
extends Provider {
    private static final double a;
    public static final String PROVIDER_BASE_NAME = "IAIK PKCS#11";
    public static final double PROVIDER_VERSION;
    public static final String PROVIDER_INFO_BASE = "IAIK JCE Provider for PKCS#11 operating with ";
    public static PrintStream debugStream_;
    public static PrintStream errorStream_;
    protected static Properties globalProperties_;
    protected static Properties defaultInstanceProperties_;
    protected static int instanceCounter_;
    protected static Map providerInstances_;
    protected static DelegateProvider globalDelegateProvider_;
    protected static KeyHandler keyHandler_;
    protected Properties defaultProperties_;
    protected Properties properties_;
    protected String initializationParameters_;
    protected TokenManager tokenManager_;
    protected LoginManager loginManager_;
    protected double version_;
    protected String info_;
    protected Hashtable engineObjectsCache_;
    protected DelegateProvider delegateProvider_;
    protected char[] userPIN_;
    private final Thread b;
    private static Class c;

    protected static void checkAccessPermission(String accessTarget) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            String string;
            securityManager.checkSecurityAccess(string);
        }
    }

    public static boolean isIAIKPkcs11Provider(Provider provider) {
        return provider instanceof IAIKPkcs11;
    }

    protected static Properties getDefaultInstanceProperties() {
        Serializable serializable;
        block7: {
            if (globalProperties_ != null) {
                serializable = new StringBuffer(17 + 2);
                ((StringBuffer)serializable).append("providerInstance.");
                ((StringBuffer)serializable).append(instanceCounter_ + 1);
                String string = globalProperties_.getProperty(((StringBuffer)serializable).toString());
                if (string != null) {
                    try {
                        serializable = (c == null ? (c = IAIKPkcs11.c("iaik.pkcs.pkcs11.provider.IAIKPkcs11")) : c).getClassLoader().getResource(string);
                        if (serializable != null) {
                            InputStream inputStream = ((URL)serializable).openStream();
                            serializable = new Properties(defaultInstanceProperties_);
                            ((Properties)serializable).load(inputStream);
                        } else {
                            errorStream_.print("Could not load IAIK PKCS#11 provider properties from \"");
                            errorStream_.print(string);
                            errorStream_.println("\". Using defaults.");
                            serializable = defaultInstanceProperties_;
                        }
                        break block7;
                    }
                    catch (IOException iOException) {
                        serializable = iOException;
                        iOException.printStackTrace(errorStream_);
                        errorStream_.print("Could not load IAIK PKCS#11 provider properties from \"");
                        errorStream_.print(string);
                        errorStream_.println("\". Using defaults.");
                    }
                }
                serializable = defaultInstanceProperties_;
            } else {
                serializable = defaultInstanceProperties_;
            }
        }
        return serializable;
    }

    public static IAIKPkcs11 getNewProviderInstance() {
        return new IAIKPkcs11();
    }

    public static IAIKPkcs11 getNewProviderInstance(Properties properties) {
        Properties properties2;
        return new IAIKPkcs11(properties2);
    }

    public static synchronized void discardProviderInstance(IAIKPkcs11 provider) {
        providerInstances_.remove(new Integer(IAIKPkcs11.getProviderInstanceNumber(provider.getName())));
        try {
            provider.tokenManager_.finalize();
            provider.disableCleanerThread();
        }
        catch (Throwable throwable) {
            Security.removeProvider(provider.getName());
            return;
        }
        catch (Throwable throwable) {
            IAIKPkcs11 iAIKPkcs11;
            Security.removeProvider(iAIKPkcs11.getName());
            throw throwable;
        }
        Security.removeProvider(provider.getName());
        return;
    }

    public static synchronized IAIKPkcs11 getProviderInstance(int instanceNumber) {
        int n;
        return (IAIKPkcs11)providerInstances_.get(n);
    }

    public static synchronized IAIKPkcs11 getCurrentProviderInstance() {
        if (providerInstances_.values().size() == 0) {
            return null;
        }
        return (IAIKPkcs11)providerInstances_.values().toArray()[0];
    }

    public static synchronized int getProviderInstanceNumber(String providerName) {
        int n;
        String string;
        if (providerName.startsWith(PROVIDER_BASE_NAME)) {
            string = providerName.substring(12 + 1);
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        return n;
    }

    public static synchronized int getProviderInstanceCount() {
        return providerInstances_.size();
    }

    /*
     * WARNING - void declaration
     */
    public static void insertProviderAtForJDK14(Provider provider, int position) {
        Provider provider2;
        void var1_1;
        if (provider == null) {
            throw new NullPointerException("Argument \"provider\" must not be null.");
        }
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>(provider.size());
        hashtable.putAll(provider);
        provider.clear();
        provider.put("cipher.null", "iaik.pkcs.pkcs11.provider.NullCipher");
        Security.insertProviderAt(provider, (int)var1_1);
        try {
            Cipher.getInstance("null", provider.getName());
        }
        catch (Exception exception) {}
        provider.remove("cipher.null");
        provider2.putAll((Map<?, ?>)hashtable);
    }

    public static boolean isEnableSoftwareDelegation() {
        String string = globalProperties_.getProperty("enableSoftwareDelegation", "true");
        return Boolean.valueOf(string);
    }

    public static void setEnableSoftwareDelegation(boolean enableSoftwareDelegation) {
        boolean bl;
        globalProperties_.setProperty("enableSoftwareDelegation", String.valueOf(bl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DelegateProvider getGlobalDelegateProvider() {
        if (globalDelegateProvider_ == null) {
            Class clazz = c == null ? (c = IAIKPkcs11.c("iaik.pkcs.pkcs11.provider.IAIKPkcs11")) : c;
            synchronized (clazz) {
                if (globalDelegateProvider_ == null) {
                    Class<?> clazz2 = globalProperties_.getProperty("globalDelegateProvider", "iaik.pkcs.pkcs11.provider.DefaultDelegateProvider");
                    try {
                        clazz2 = Class.forName((String)((Object)clazz2));
                        globalDelegateProvider_ = (DelegateProvider)clazz2.newInstance();
                    }
                    catch (Exception exception) {
                        clazz2 = exception;
                        exception.printStackTrace(errorStream_);
                        globalDelegateProvider_ = new DefaultDelegateProvider();
                    }
                }
            }
        }
        return globalDelegateProvider_;
    }

    public static void setGlobalDelegateProvider(DelegateProvider globalDelegateProvider) {
        globalDelegateProvider_ = globalDelegateProvider;
    }

    public static Properties getGlobalProperties() {
        return globalProperties_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyHandler getGlobalKeyHandler() {
        if (keyHandler_ == null) {
            Class clazz = c == null ? (c = IAIKPkcs11.c("iaik.pkcs.pkcs11.provider.IAIKPkcs11")) : c;
            synchronized (clazz) {
                if (keyHandler_ == null) {
                    Class<?> clazz2 = globalProperties_.getProperty("globalKeyHandler", "iaik.pkcs.pkcs11.provider.DefaultKeyHandler");
                    try {
                        clazz2 = Class.forName((String)((Object)clazz2));
                        keyHandler_ = (DefaultKeyHandler)clazz2.newInstance();
                    }
                    catch (Exception exception) {
                        clazz2 = exception;
                        exception.printStackTrace(errorStream_);
                        keyHandler_ = new DefaultKeyHandler();
                    }
                }
            }
            keyHandler_.addProperties(IAIKPkcs11.getCurrentProviderInstance().getProperties());
        }
        return keyHandler_;
    }

    public static void setGlobalKeyHandler(KeyHandler keyHandler) {
        keyHandler_ = keyHandler;
    }

    public static Module getModule() {
        return IAIKPkcs11.getModule(null);
    }

    public static Module getModule(Properties configuration) throws IAIKPkcs11Exception {
        Properties properties = new Properties(IAIKPkcs11.getDefaultInstanceProperties());
        if (configuration != null) {
            Properties properties2;
            properties.putAll((Map<?, ?>)properties2);
        }
        try {
            return TokenManager.a(properties);
        }
        catch (IOException iOException) {
            throw new IAIKPkcs11Exception(iOException.toString());
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAIKPkcs11() throws IAIKPkcs11Exception {
        super("IAIK PKCS#11:" + (instanceCounter_ + 1), PROVIDER_VERSION, PROVIDER_INFO_BASE);
        Class clazz = c == null ? (c = IAIKPkcs11.c("iaik.pkcs.pkcs11.provider.IAIKPkcs11")) : c;
        synchronized (clazz) {
            this.properties_ = IAIKPkcs11.getDefaultInstanceProperties();
            this.a();
            providerInstances_.put(new Integer(instanceCounter_ + 1), this);
            ++instanceCounter_;
            try {
                this.initialize();
            }
            catch (IAIKPkcs11Exception iAIKPkcs11Exception) {
                providerInstances_.remove(new Integer(IAIKPkcs11.getProviderInstanceNumber(this.getName())));
                --instanceCounter_;
                throw iAIKPkcs11Exception;
            }
            catch (RuntimeException runtimeException) {
                providerInstances_.remove(new Integer(IAIKPkcs11.getProviderInstanceNumber(this.getName())));
                --instanceCounter_;
                throw runtimeException;
            }
            this.b = new a(this);
            Runtime.getRuntime().addShutdownHook(this.b);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public IAIKPkcs11(Properties configuration) throws IAIKPkcs11Exception {
        super("IAIK PKCS#11:" + (instanceCounter_ + 1), PROVIDER_VERSION, PROVIDER_INFO_BASE);
        Class clazz = c == null ? (c = IAIKPkcs11.c("iaik.pkcs.pkcs11.provider.IAIKPkcs11")) : c;
        synchronized (clazz) {
            void var1_1;
            this.properties_ = new Properties(IAIKPkcs11.getDefaultInstanceProperties());
            this.properties_.putAll((Map<?, ?>)var1_1);
            this.a();
            providerInstances_.put(new Integer(instanceCounter_ + 1), this);
            ++instanceCounter_;
            try {
                this.initialize();
            }
            catch (IAIKPkcs11Exception iAIKPkcs11Exception) {
                providerInstances_.remove(new Integer(IAIKPkcs11.getProviderInstanceNumber(this.getName())));
                --instanceCounter_;
                throw iAIKPkcs11Exception;
            }
            catch (RuntimeException runtimeException) {
                providerInstances_.remove(new Integer(IAIKPkcs11.getProviderInstanceNumber(this.getName())));
                --instanceCounter_;
                throw runtimeException;
            }
            this.b = new a(this);
            Runtime.getRuntime().addShutdownHook(this.b);
            return;
        }
    }

    private void a() {
        this.a("PKCS11_NATIVE_MODULE");
        this.a("USER_PIN");
        this.a("PKCS11_WRAPPER_NATIVE_DEBUG");
    }

    private void a(String string) {
        String string2 = this.properties_.getProperty(string, null);
        if ((string2 = System.getProperty(string, string2)) != null) {
            this.properties_.setProperty(string, string2);
        }
    }

    public synchronized DelegateProvider getDelegateProvider() {
        if (this.delegateProvider_ == null) {
            Object object = this.properties_.getProperty("DELEGATE_PROVIDER");
            if (object == null) {
                object = globalProperties_.getProperty("DELEGATE_PROVIDER", "iaik.pkcs.pkcs11.provider.DefaultDelegateProvider");
            }
            try {
                object = Class.forName((String)object);
                this.delegateProvider_ = (DelegateProvider)((Class)object).newInstance();
            }
            catch (Exception exception) {
                object = exception;
                exception.printStackTrace(errorStream_);
                this.delegateProvider_ = new DefaultDelegateProvider();
            }
        }
        return this.delegateProvider_;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setDelegateProvider(DelegateProvider delegateProvider) {
        void var1_1;
        this.delegateProvider_ = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setModuleInitializationParameters(String initializationParameters) {
        void var1_1;
        this.initializationParameters_ = var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getModuleInitializationParameters() {
        if (this.initializationParameters_ == null) {
            IAIKPkcs11 iAIKPkcs11 = this;
            synchronized (iAIKPkcs11) {
                if (this.initializationParameters_ == null) {
                    this.initializationParameters_ = this.properties_.getProperty("MODULE_INITIALIZATION_PARAMETERS", null);
                }
            }
        }
        return this.initializationParameters_;
    }

    public synchronized LoginManager getLoginManager() {
        if (this.loginManager_ == null) {
            Object object = this.properties_.getProperty("LOGIN_MANAGER", "iaik.pkcs.pkcs11.provider.DefaultLoginManager");
            try {
                object = Class.forName((String)object);
                this.loginManager_ = (LoginManager)((Class)object).newInstance();
            }
            catch (Exception exception) {
                object = exception;
                exception.printStackTrace(errorStream_);
                this.loginManager_ = new DefaultLoginManager();
            }
            this.loginManager_.addProperties(this.properties_);
        }
        return this.loginManager_;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setLoginManager(LoginManager loginManager) {
        void var1_1;
        this.loginManager_ = var1_1;
    }

    public synchronized char[] getUserPIN() {
        String string;
        if (this.userPIN_ == null && (string = this.properties_.getProperty("USER_PIN", null)) != null) {
            this.userPIN_ = string.toCharArray();
        }
        return this.userPIN_;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setUserPIN(char[] userPIN) {
        void var1_1;
        this.userPIN_ = var1_1;
    }

    public Properties getProperties() {
        return this.properties_;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized String getProperty(String key) {
        void var1_1;
        String string = super.getProperty(key);
        if (string != null && this.isCheckMechanismSupported() && this.isEngineClassKey((String)var1_1) && !this.b(string)) {
            string = null;
        }
        return string;
    }

    private synchronized boolean b(String string) {
        PKCS11EngineClass pKCS11EngineClass = (PKCS11EngineClass)this.engineObjectsCache_.get(string);
        if (pKCS11EngineClass == null) {
            try {
                pKCS11EngineClass = (PKCS11EngineClass)Class.forName(string).newInstance();
                this.engineObjectsCache_.put(string, pKCS11EngineClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IAIKPkcs11Exception("Error instantiating engine class: " + classNotFoundException.toString());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IAIKPkcs11Exception("Error instantiating engine class: " + illegalAccessException.toString());
            }
            catch (InstantiationException instantiationException) {
                throw new IAIKPkcs11Exception("Error instantiating engine class: " + instantiationException.toString());
            }
        }
        return pKCS11EngineClass.isSupportedBy(this.tokenManager_);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized String getProperty(String key, String defaultValue) {
        void var2_2;
        void var1_1;
        return super.getProperty((String)var1_1, (String)var2_2);
    }

    public String getKeystoreSupportProvider() {
        return this.properties_.getProperty("KEY_STORE_SUPPORT_PROVIDER");
    }

    /*
     * WARNING - void declaration
     */
    public void setKeystoreSupportProvider(String providerName) {
        void var1_1;
        this.properties_.setProperty("KEY_STORE_SUPPORT_PROVIDER", (String)var1_1);
    }

    public boolean isLoginKeystoreOnDemand() {
        String string = this.properties_.getProperty("LOGIN_KEYSTORE_SESSION_ON_DEMAND", "false");
        return Boolean.valueOf(string);
    }

    /*
     * WARNING - void declaration
     */
    public void setLoginKeystoreOnDemand(boolean loginOnDemand) {
        void var1_1;
        this.properties_.setProperty("LOGIN_KEYSTORE_SESSION_ON_DEMAND", String.valueOf((boolean)var1_1));
    }

    public boolean isCheckMechanismSupported() {
        String string = this.properties_.getProperty("CHECK_MECHANISM_SUPPORTED", "false");
        return Boolean.valueOf(string);
    }

    /*
     * WARNING - void declaration
     */
    public void setCheckMechanismSupported(boolean checkMechanismSupported) {
        void var1_1;
        this.properties_.setProperty("CHECK_MECHANISM_SUPPORTED", String.valueOf((boolean)var1_1));
    }

    public boolean isMultiThreadInit() {
        String string = this.properties_.getProperty("MULTI_THREAD_INIT", "true");
        return Boolean.valueOf(string);
    }

    /*
     * WARNING - void declaration
     */
    public void setMultiThreadInit(boolean multiThread) {
        void var1_1;
        this.properties_.setProperty("MULTI_THREAD_INIT", String.valueOf((boolean)var1_1));
    }

    public String getModuleAlreadyInitialized() {
        return this.properties_.getProperty("MODULE_ALREADY_INITIALIZED", "ignore");
    }

    /*
     * WARNING - void declaration
     */
    public void setModuleAlreadyInitialized(String value) {
        void var1_1;
        this.properties_.setProperty("MODULE_ALREADY_INITIALIZED", (String)var1_1);
    }

    public synchronized int getSessionPoolMaxSize() {
        String string = this.properties_.getProperty("SESSION_POOL_MAX_SIZE", "100");
        int n = Integer.parseInt(string);
        n = Math.max(n, 1);
        return n;
    }

    public boolean isCheckSessionIntegrity() {
        String string = this.properties_.getProperty("CHECK_SESSION_INTEGRITY", "true");
        return string.equalsIgnoreCase("true");
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setSessionPoolMaxSize(int sessionPoolMaxSize) {
        void var1_1;
        sessionPoolMaxSize = Math.max(sessionPoolMaxSize, 1);
        this.properties_.setProperty("SESSION_POOL_MAX_SIZE", String.valueOf((int)var1_1));
    }

    public TokenManager getTokenManager() {
        return this.tokenManager_;
    }

    public double getVersion() {
        return this.version_;
    }

    public synchronized String getInfo() {
        return this.info_;
    }

    public String toString() {
        String string = this.getName();
        StringBuffer stringBuffer = new StringBuffer(string.length() + 16);
        stringBuffer.append(string);
        stringBuffer.append(", version: ");
        stringBuffer.append(this.version_);
        stringBuffer.append(", info: ");
        stringBuffer.append(this.info_);
        return stringBuffer.toString();
    }

    protected synchronized void addAlgorithms() {
        block6: {
            try {
                Serializable serializable;
                Enumeration<?> enumeration = this.properties_.getProperty("ALGORITHM_PROPERTIES", "iaik/pkcs/pkcs11/provider/IAIKPkcs11Algorithm.properties");
                enumeration = (c == null ? (c = IAIKPkcs11.c("iaik.pkcs.pkcs11.provider.IAIKPkcs11")) : c).getClassLoader().getResource((String)((Object)enumeration));
                if (enumeration != null) {
                    enumeration = ((URL)((Object)enumeration)).openStream();
                } else {
                    serializable = (c == null ? (c = IAIKPkcs11.c("iaik.pkcs.pkcs11.provider.IAIKPkcs11")) : c).getClassLoader().getResource("iaik/pkcs/pkcs11/provider/default/IAIKPkcs11Algorithm.properties");
                    enumeration = ((URL)serializable).openStream();
                }
                if (this.isCheckMechanismSupported() && !this.tokenManager_.isRemovable()) {
                    serializable = new Properties();
                    ((Properties)serializable).load((InputStream)((Object)enumeration));
                    enumeration = ((Properties)serializable).propertyNames();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        String string2 = ((Properties)serializable).getProperty(string);
                        if (this.isEngineClassKey(string) && !this.b(string2)) continue;
                        this.put(string, string2);
                    }
                    break block6;
                }
                this.load((InputStream)((Object)enumeration));
                return;
            }
            catch (IOException iOException) {
                throw new IAIKPkcs11Exception(iOException.toString());
            }
        }
    }

    public synchronized void initialize() throws IAIKPkcs11Exception {
        if (this.tokenManager_ != null) {
            this.tokenManager_.clearSessionPool(false);
        }
        try {
            this.tokenManager_ = new TokenManager(this);
        }
        catch (IOException iOException) {
            throw new IAIKPkcs11Exception(iOException.toString());
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
        this.engineObjectsCache_ = new Hashtable();
        this.addAlgorithms();
        this.setVersion();
        this.setInfo();
    }

    public void disableCleanerThread() {
        Runtime.getRuntime().removeShutdownHook(this.b);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isEngineClassKey(String key) {
        void var1_1;
        boolean bl = key != null ? (key = key.toLowerCase()).startsWith("signature.") || key.startsWith("cipher.") || key.startsWith("keygenerator.") || key.startsWith("keypairgenerator.") || key.startsWith("messagedigest.") || key.startsWith("mac.") || key.startsWith("keyagreement.") || key.startsWith("keystore.") || key.startsWith("keyfactory.") || key.startsWith("secretkeyfactory.") || var1_1.startsWith("securerandom.") : false;
        return bl;
    }

    protected void setVersion() {
        this.version_ = PROVIDER_VERSION;
    }

    protected synchronized void setInfo() {
        String string;
        String string2;
        try {
            string2 = this.tokenManager_.getModule().getInfo().getLibraryDescription();
        }
        catch (TokenException tokenException) {
            string2 = this.tokenManager_.getModulePath();
        }
        try {
            string = this.tokenManager_.getSlot().getSlotInfo().getSlotDescription();
        }
        catch (TokenException tokenException) {
            string = Long.toString(this.tokenManager_.getSlot().getSlotID());
        }
        StringBuffer stringBuffer = new StringBuffer(45 + string2.length() + string.length() + 20);
        stringBuffer.append(PROVIDER_INFO_BASE);
        stringBuffer.append("slot \"");
        stringBuffer.append(string.trim());
        stringBuffer.append("\" of module \"");
        stringBuffer.append(string2.trim());
        stringBuffer.append('\"');
        stringBuffer.append(" from PKCS#11 library \"");
        stringBuffer.append(this.tokenManager_.getModulePath());
        stringBuffer.append('\"');
        this.info_ = stringBuffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean equals(Object other) {
        void var1_1;
        return this == var1_1;
    }

    public synchronized int hashCode() {
        return System.identityHashCode(this);
    }

    private static Class c(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    static {
        try {
            IAIKPkcs11.a = var0 = Double.parseDouble("@VersionNumber@");
        }
        catch (NumberFormatException v0) {
            IAIKPkcs11.a = 1.94;
        }
        catch (Throwable var1_5) {
            IAIKPkcs11.a = 1.94;
            throw var1_5;
        }
        IAIKPkcs11.PROVIDER_VERSION = IAIKPkcs11.a;
        IAIKPkcs11.debugStream_ = System.out;
        IAIKPkcs11.errorStream_ = System.err;
        IAIKPkcs11.providerInstances_ = new HashMap<K, V>();
        try {
            var0_1 /* !! */  = (IAIKPkcs11.c == null ? (IAIKPkcs11.c = IAIKPkcs11.c("iaik.pkcs.pkcs11.provider.IAIKPkcs11")) : IAIKPkcs11.c).getClassLoader().getResource("iaik/pkcs/pkcs11/provider/default/IAIKPkcs11Global.properties");
            var1_6 = var0_1 /* !! */ .openStream();
            var0_1 /* !! */  = new Properties();
            var0_1 /* !! */ .load((InputStream)var1_6);
            var1_6.close();
            var1_6 = (IAIKPkcs11.c == null ? (IAIKPkcs11.c = IAIKPkcs11.c("iaik.pkcs.pkcs11.provider.IAIKPkcs11")) : IAIKPkcs11.c).getClassLoader().getResource("iaik/pkcs/pkcs11/provider/IAIKPkcs11Global.properties");
            if (var1_6 != null) {
                var1_6 = var1_6.openStream();
                var0_1 /* !! */  = new Properties((Properties)var0_1 /* !! */ );
                var0_1 /* !! */ .load((InputStream)var1_6);
                var1_6.close();
                IAIKPkcs11.globalProperties_ = var0_1 /* !! */ ;
            } else {
                IAIKPkcs11.globalProperties_ = var0_1 /* !! */ ;
            }
        }
        catch (IOException var0_2) {
            IAIKPkcs11.errorStream_.println("Could not load IAIK PKCS#11 global configuration properties.");
            var0_2.printStackTrace(IAIKPkcs11.errorStream_);
            IAIKPkcs11.globalProperties_ = null;
        }
        try {
            var0_1 /* !! */  = (IAIKPkcs11.c == null ? (IAIKPkcs11.c = IAIKPkcs11.c("iaik.pkcs.pkcs11.provider.IAIKPkcs11")) : IAIKPkcs11.c).getClassLoader().getResource("iaik/pkcs/pkcs11/provider/default/IAIKPkcs11.properties");
            var1_6 = var0_1 /* !! */ .openStream();
            var0_1 /* !! */  = new Properties();
            var0_1 /* !! */ .load((InputStream)var1_6);
            var1_6 = (IAIKPkcs11.c == null ? (IAIKPkcs11.c = IAIKPkcs11.c("iaik.pkcs.pkcs11.provider.IAIKPkcs11")) : IAIKPkcs11.c).getClassLoader().getResource("iaik/pkcs/pkcs11/provider/IAIKPkcs11.properties");
            if (var1_6 == null) ** GOTO lbl-1000
            v1 = var1_6;
            if (!v1.equals(v1)) {
                var1_6 = var1_6.openStream();
                var0_1 /* !! */  = new Properties((Properties)var0_1 /* !! */ );
                var0_1 /* !! */ .load((InputStream)var1_6);
                var1_6.close();
                IAIKPkcs11.defaultInstanceProperties_ = var0_1 /* !! */ ;
            } else lbl-1000:
            // 2 sources

            {
                IAIKPkcs11.defaultInstanceProperties_ = var0_1 /* !! */ ;
            }
        }
        catch (IOException var0_3) {
            IAIKPkcs11.errorStream_.println("Could not load IAIK PKCS#11 default configuration properties.");
            var0_3.printStackTrace(IAIKPkcs11.errorStream_);
            IAIKPkcs11.defaultInstanceProperties_ = null;
        }
        try {
            new b();
        }
        catch (Throwable v2) {
            var0_1 /* !! */  = v2;
            v2.printStackTrace(IAIKPkcs11.errorStream_);
            IAIKPkcs11.errorStream_.println("Class iaik.pkcs.pkcs11.provider.Reminder not found! going to exit.");
            System.exit(1);
        }
        try {
            Security.getProviders();
        }
        catch (Throwable var0_4) {
            IAIKPkcs11.errorStream_.println("Could not list all providers to ensure that all statically configured providers are set up.");
            var0_4.printStackTrace(IAIKPkcs11.errorStream_);
        }
    }

    private final class a
    extends Thread {
        private final IAIKPkcs11 a;

        public a(IAIKPkcs11 iAIKPkcs11) {
            this.a = iAIKPkcs11;
        }

        public final void run() {
            this.a.getTokenManager().closeSessions();
        }
    }
}

