/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider;

import iaik.apps.util.passphrase.NewPassphrasePrompt;
import iaik.apps.util.passphrase.PassphrasePrompt;
import iaik.apps.util.passphrase.Util;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.SessionInfo;
import iaik.pkcs.pkcs11.State;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.TokenInfo;
import iaik.pkcs.pkcs11.provider.Constants;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11AuthenticationCanceledException;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11AuthenticationException;
import iaik.pkcs.pkcs11.provider.LoginManager;
import iaik.pkcs.pkcs11.provider.SessionContainer;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Properties;

public class DefaultLoginManager
extends LoginManager {
    protected static final String DEFAULT_CONFIGURATION_PROPERTIES = "iaik/pkcs/pkcs11/provider/default/DefaultLoginManager.properties";
    protected static final String CONFIGURATION_PROPERTIES = "iaik/pkcs/pkcs11/provider/DefaultLoginManager.properties";
    protected static final String DEFAULT_PROMPT_DIALOG = "DEFAULT_PROMPT_DIALOG";
    protected static final String DEFAULT_CHANGE_DIALOG = "DEFAULT_CHANGE_DIALOG";
    protected static final String DEFAULT_NEW_PROMPT_MESSAGE_PREFIX = "DEFAULT_NEW_PROMPT_MESSAGE_PREFIX";
    protected static final String DEFAULT_PROMPT_MESSAGE_PREFIX = "DEFAULT_PROMPT_MESSAGE_PREFIX";
    protected static final String WRONG_PIN_WARNING = "WRONG_PIN_WARNING";
    protected static final String PIN_FINAL_TRY_WARNING = "PIN_FINAL_TRY_WARNING";
    protected static final String KEY_WORD_TRIALS_LEFT = "$(TRIALS_LEFT)";
    protected static final String KEY_WORD_TOKEN_LABEL = "$(TOKEN_LABEL)";
    protected static final String NUMBER_OF_USER_LOGIN_RETRIES = "NUMBER_OF_USER_LOGIN_RETRIES";
    protected static final String INVALID_NEW_PIN_WARNING = "INVALID_NEW_PIN_WARNING";
    protected static final String NEW_PIN_LENGTH_WARNING = "NEW_PIN_LENGTH_WARNING";
    protected static final String USE_PROTECTED_AUTHENTICATION_PATH = "USE_PROTECTED_AUTHENTICATION_PATH";
    protected static final String FORCE_PROTECTED_AUTHENTICATION_PATH = "FORCE_PROTECTED_AUTHENTICATION_PATH";
    protected static String LINE_SEPARATOR = Constants.LINE_SEPARATOR;
    protected static Properties defaultConfiguration_;
    protected PassphrasePrompt passphrasePrompt_;
    protected NewPassphrasePrompt passphraseChangePrompt_;
    private static Class a;
    private static Class b;

    public DefaultLoginManager() {
        this(null);
        this.properties_ = new Properties(defaultConfiguration_);
    }

    /*
     * WARNING - void declaration
     */
    public DefaultLoginManager(Properties configuration) {
        void var1_1;
        this.properties_ = new Properties(defaultConfiguration_);
        this.addProperties((Properties)var1_1);
    }

    public PassphrasePrompt getPassphrasePrompt() {
        if (this.passphrasePrompt_ == null) {
            Serializable serializable = this.properties_.getProperty(DEFAULT_PROMPT_DIALOG, "iaik.apps.util.passphrase.PassphraseDialog");
            try {
                serializable = Class.forName((String)((Object)serializable));
                this.passphrasePrompt_ = (PassphrasePrompt)((Class)serializable).newInstance();
            }
            catch (Exception exception) {
                serializable = exception;
                exception.printStackTrace(IAIKPkcs11.errorStream_);
                serializable = "iaik.apps.util.passphrase.PassphraseConsoleDialog";
                try {
                    serializable = Class.forName((String)((Object)serializable));
                    this.passphrasePrompt_ = (PassphrasePrompt)((Class)serializable).newInstance();
                }
                catch (Exception exception2) {
                    serializable = exception2;
                    exception2.printStackTrace(IAIKPkcs11.errorStream_);
                }
            }
        }
        return this.passphrasePrompt_;
    }

    /*
     * WARNING - void declaration
     */
    public void setPassphrasePrompt(PassphrasePrompt passphrasePrompt) {
        void var1_1;
        this.passphrasePrompt_ = var1_1;
    }

    public NewPassphrasePrompt getPassphraseChangePrompt() {
        if (this.passphraseChangePrompt_ == null) {
            Serializable serializable = this.properties_.getProperty(DEFAULT_CHANGE_DIALOG, "iaik.apps.util.passphrase.NewPassphraseDialog");
            try {
                serializable = Class.forName((String)((Object)serializable));
                this.passphraseChangePrompt_ = (NewPassphrasePrompt)((Class)serializable).newInstance();
            }
            catch (Exception exception) {
                serializable = exception;
                exception.printStackTrace(IAIKPkcs11.errorStream_);
                serializable = "iaik.apps.util.passphrase.NewPassphraseConsoleDialog";
                try {
                    serializable = Class.forName((String)((Object)serializable));
                    this.passphraseChangePrompt_ = (NewPassphrasePrompt)((Class)serializable).newInstance();
                }
                catch (Exception exception2) {
                    serializable = exception2;
                    exception2.printStackTrace(IAIKPkcs11.errorStream_);
                }
            }
        }
        return this.passphraseChangePrompt_;
    }

    /*
     * WARNING - void declaration
     */
    public void setPassphraseChangePrompt(NewPassphrasePrompt passphraseChangePrompt) {
        void var1_1;
        this.passphraseChangePrompt_ = var1_1;
    }

    public int getNumberOfLoginRetries() {
        String string = this.properties_.getProperty(NUMBER_OF_USER_LOGIN_RETRIES, "3");
        int n = Integer.parseInt(string);
        n = Math.max(n, 1);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public void setNumberOfLoginRetries(int numberOfLoginRetries) {
        void var1_1;
        numberOfLoginRetries = Math.max(numberOfLoginRetries, 1);
        this.properties_.setProperty(NUMBER_OF_USER_LOGIN_RETRIES, String.valueOf((int)var1_1));
    }

    public boolean isUseProtectedAuthenticationPath() {
        String string = this.properties_.getProperty(USE_PROTECTED_AUTHENTICATION_PATH, "true");
        return Boolean.valueOf(string);
    }

    /*
     * WARNING - void declaration
     */
    public void setUseProtectedAuthenticationPath(boolean useProtectedAuthenticationPath) {
        void var1_1;
        this.properties_.setProperty(USE_PROTECTED_AUTHENTICATION_PATH, String.valueOf((boolean)var1_1));
    }

    public boolean isForceProtectedAuthenticationPath() {
        String string = this.properties_.getProperty(FORCE_PROTECTED_AUTHENTICATION_PATH, "false");
        return Boolean.valueOf(string);
    }

    /*
     * WARNING - void declaration
     */
    public void setForceProtectedAuthenticationPath(boolean forceProtectedAuthenticationPath) {
        void var1_1;
        this.properties_.setProperty(FORCE_PROTECTED_AUTHENTICATION_PATH, String.valueOf((boolean)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void loginUser(TokenManager tokenManager, Session session, char[] userPIN) throws IAIKPkcs11AuthenticationCanceledException, IAIKPkcs11AuthenticationException, TokenException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.login((TokenManager)var1_1, (Session)var2_2, false, (char[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void loginSO(TokenManager tokenManager, Session session, char[] userPIN) throws TokenException, IAIKPkcs11AuthenticationCanceledException, IAIKPkcs11AuthenticationException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.login((TokenManager)var1_1, (Session)var2_2, true, (char[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void login(TokenManager tokenManager, Session session, boolean useSORole, char[] userPIN) throws TokenException, IAIKPkcs11AuthenticationCanceledException, IAIKPkcs11AuthenticationException {
        if (tokenManager == null) {
            throw new NullPointerException("Argument \"tokenManager\" must not be null");
        }
        SessionContainer sessionContainer = new SessionContainer(tokenManager, session);
        session = sessionContainer.getSession();
        try {
            void var2_3;
            SessionInfo sessionInfo = session.getSessionInfo();
            sessionInfo = sessionInfo.getState();
            PKCS11Exception pKCS11Exception = null;
            if (useSORole || !sessionInfo.equals((Object)State.RO_USER_FUNCTIONS) && !sessionInfo.equals((Object)State.RW_USER_FUNCTIONS) || !useSORole || !sessionInfo.equals((Object)State.RW_SO_FUNCTIONS)) {
                Object object;
                if (!sessionInfo.equals((Object)State.RW_PUBLIC_SESSION) && !sessionInfo.equals((Object)State.RO_PUBLIC_SESSION)) {
                    session.logout();
                }
                int n = this.getNumberOfLoginRetries();
                TokenInfo tokenInfo = session.getToken().getTokenInfo();
                if (this.useNullPINs((TokenManager)object, session)) {
                    while (n-- > 0) {
                        try {
                            session.login(!useSORole, null);
                            break;
                        }
                        catch (PKCS11Exception pKCS11Exception2) {
                            object = pKCS11Exception2;
                            if (pKCS11Exception2.getErrorCode() == 160L) continue;
                            throw new IAIKPkcs11AuthenticationException("Failed to login: " + object.toString());
                        }
                    }
                } else {
                    if (userPIN != null) {
                        try {
                            session.login(!useSORole, userPIN);
                        }
                        catch (PKCS11Exception pKCS11Exception3) {
                            object = pKCS11Exception3;
                            if (pKCS11Exception3.getErrorCode() == 160L) {
                                throw new IAIKPkcs11AuthenticationException("PIN Incorrect. Failed to login: " + object.toString());
                            }
                            throw object;
                        }
                    }
                    object = this.getPassphrasePrompt();
                    if (object == null) {
                        throw new IAIKPkcs11AuthenticationException("Configured passphrase prompt (LoginManager properties) can't be created.");
                    }
                    object.setCancelAllowed(true);
                    String string = this.properties_.getProperty(DEFAULT_PROMPT_MESSAGE_PREFIX, "Plaese enter " + (true == useSORole ? "SO" : "User") + "-PIN for this token") + LINE_SEPARATOR + LINE_SEPARATOR;
                    string = this.replaceKeyWord(string, "$(ROLE)", useSORole ? "SO" : "User");
                    Object object2 = Util.fixString(tokenInfo.getLabel());
                    string = this.replaceKeyWord(string, KEY_WORD_TOKEN_LABEL, (String)object2);
                    object.setMessage(string);
                    object.setProtectedResourceInfo(tokenInfo);
                    while (n-- > 0) {
                        Object object3;
                        tokenInfo = session.getToken().getTokenInfo();
                        if (tokenInfo.isUserPinLocked() && !useSORole || tokenInfo.isSoPinLocked() && useSORole) {
                            throw new IAIKPkcs11AuthenticationException("Cannot login, the PIN is locked.");
                        }
                        if (tokenInfo.isUserPinFinalTry() && !useSORole || tokenInfo.isSoPinFinalTry() && useSORole) {
                            object3 = this.properties_.getProperty(PIN_FINAL_TRY_WARNING, "Warning! The token reported that this will be the final try before the PIN gets blocked.") + LINE_SEPARATOR + string;
                            object2 = Util.fixString(tokenInfo.getLabel());
                            object3 = this.replaceKeyWord((String)object3, KEY_WORD_TOKEN_LABEL, (String)object2);
                            object.setMessage(object3);
                        }
                        if ((object3 = object.promptPassphrase()) == null) {
                            throw new IAIKPkcs11AuthenticationCanceledException("PIN entry cancelled.");
                        }
                        try {
                            session.login(!useSORole, object3);
                            break;
                        }
                        catch (PKCS11Exception pKCS11Exception4) {
                            object2 = pKCS11Exception4;
                            pKCS11Exception = pKCS11Exception4;
                            if (object2.getErrorCode() == 160L) {
                                object2 = this.properties_.getProperty(WRONG_PIN_WARNING, "Wrong PIN! You have $(TRIALS_LEFT) trials left.");
                                object2 = this.replaceKeyWord((String)object2, KEY_WORD_TRIALS_LEFT, String.valueOf(n));
                                object3 = object2 + LINE_SEPARATOR + string;
                                object2 = Util.fixString(tokenInfo.getLabel());
                                object3 = this.replaceKeyWord((String)object3, KEY_WORD_TOKEN_LABEL, (String)object2);
                                object.setMessage(object3);
                                continue;
                            }
                            throw object2;
                        }
                    }
                }
            }
            Object object = var2_3.getSessionInfo();
            if (!((object = object.getState()).equals((Object)State.RO_USER_FUNCTIONS) || object.equals((Object)State.RW_USER_FUNCTIONS) || object.equals((Object)State.RW_SO_FUNCTIONS))) {
                object = pKCS11Exception != null ? "Failed to login: " + pKCS11Exception.toString() : "Failed to login.";
                throw new IAIKPkcs11AuthenticationException((String)object);
            }
            return;
        }
        finally {
            sessionContainer.disposeSessionIfDummy();
        }
    }

    public void setUserPIN(TokenManager tokenManager, Session session, char[] oldPIN, char[] newPIN) throws TokenException, IAIKPkcs11AuthenticationCanceledException, IAIKPkcs11AuthenticationException {
        SessionContainer sessionContainer = new SessionContainer(tokenManager, session);
        session = sessionContainer.getSession();
        try {
            Object object;
            Object object2 = session.getSessionInfo();
            object2 = object2.getState();
            if (object2.equals((Object)State.RW_SO_FUNCTIONS)) {
                session.logout();
            }
            int n = this.getNumberOfLoginRetries();
            TokenInfo tokenInfo = session.getToken().getTokenInfo();
            if (this.useNullPINs((TokenManager)object, session)) {
                while (n-- > 0) {
                    try {
                        object2 = session.getSessionInfo();
                        object2 = object2.getState();
                        if (!object2.equals((Object)State.RO_USER_FUNCTIONS) && !object2.equals((Object)State.RW_USER_FUNCTIONS)) {
                            session.login(true, null);
                        }
                        session.setPIN(null, null);
                        break;
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        object = pKCS11Exception;
                        long l2 = pKCS11Exception.getErrorCode();
                        if (l2 == 160L || l2 == 161L || l2 == 162L) continue;
                        throw new IAIKPkcs11AuthenticationException(object.toString());
                    }
                }
            } else {
                if (oldPIN != null && newPIN != null) {
                    try {
                        object2 = session.getSessionInfo();
                        object2 = object2.getState();
                        if (!object2.equals((Object)State.RO_USER_FUNCTIONS) && !object2.equals((Object)State.RW_USER_FUNCTIONS)) {
                            session.login(true, oldPIN);
                        }
                        session.setPIN(oldPIN, newPIN);
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        object = pKCS11Exception;
                        if (pKCS11Exception.getErrorCode() == 160L) {
                            throw new IAIKPkcs11AuthenticationException("Old PIN Incorrect. Failed to login the user: " + object.toString());
                        }
                        throw object;
                    }
                }
                if (oldPIN != null) {
                    object = this.getPassphraseChangePrompt();
                    if (object == null) {
                        throw new IAIKPkcs11AuthenticationException("Configured passphrase prompt (LoginManager properties) can't be created.");
                    }
                    object.setOldPassphraseRequired(false);
                    try {
                        object2 = session.getSessionInfo();
                        object2 = object2.getState();
                        if (!object2.equals((Object)State.RO_USER_FUNCTIONS) && !object2.equals((Object)State.RW_USER_FUNCTIONS)) {
                            session.login(true, oldPIN);
                        }
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        PKCS11Exception pKCS11Exception2 = pKCS11Exception;
                        long l3 = pKCS11Exception.getErrorCode();
                        if (l3 == 160L) {
                            throw new IAIKPkcs11AuthenticationException("The provided user PIN is invalid.");
                        }
                        throw pKCS11Exception2;
                    }
                    String string = this.properties_.getProperty(DEFAULT_NEW_PROMPT_MESSAGE_PREFIX, "Please enter new User-PIN for this token") + LINE_SEPARATOR + LINE_SEPARATOR;
                    String string2 = Util.fixString(tokenInfo.getLabel());
                    string = this.replaceKeyWord(string, KEY_WORD_TOKEN_LABEL, string2);
                    object.setMessage(string);
                    object.setProtectedResourceInfo(tokenInfo);
                    while (n-- > 0) {
                        Object object3;
                        tokenInfo = session.getToken().getTokenInfo();
                        if (tokenInfo.isUserPinLocked()) {
                            throw new IAIKPkcs11AuthenticationException("Cannot set user PIN, the user PIN is locked.");
                        }
                        if (tokenInfo.isUserPinFinalTry()) {
                            object3 = this.properties_.getProperty(PIN_FINAL_TRY_WARNING, "Warning! The token reported that this will be the final try before the PIN gets blocked.") + LINE_SEPARATOR + string;
                            string2 = Util.fixString(tokenInfo.getLabel());
                            object3 = this.replaceKeyWord((String)object3, KEY_WORD_TOKEN_LABEL, string2);
                            object.setMessage(object3);
                        }
                        if ((object3 = object.promptNewPassphrase()) == null) {
                            throw new IAIKPkcs11AuthenticationCanceledException("User canceled new PIN entry.");
                        }
                        try {
                            session.setPIN(oldPIN, object3[1]);
                            break;
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            String string3;
                            PKCS11Exception pKCS11Exception3 = pKCS11Exception;
                            long l4 = pKCS11Exception.getErrorCode();
                            if (l4 == 161L) {
                                string3 = this.properties_.getProperty(INVALID_NEW_PIN_WARNING, "The entered new PIN is invalid.");
                                object2 = string3 + LINE_SEPARATOR + string;
                                string2 = Util.fixString(tokenInfo.getLabel());
                                object2 = this.replaceKeyWord((String)object2, KEY_WORD_TOKEN_LABEL, string2);
                                object.setMessage(object2);
                                continue;
                            }
                            if (l4 == 162L) {
                                string3 = this.properties_.getProperty(NEW_PIN_LENGTH_WARNING, "The length of the new PIN is invalid.");
                                object2 = string3 + LINE_SEPARATOR + string;
                                string2 = Util.fixString(tokenInfo.getLabel());
                                object2 = this.replaceKeyWord((String)object2, KEY_WORD_TOKEN_LABEL, string2);
                                object.setMessage(object2);
                                continue;
                            }
                            throw pKCS11Exception3;
                        }
                    }
                } else if (newPIN != null) {
                    object = this.getPassphrasePrompt();
                    if (object == null) {
                        throw new IAIKPkcs11AuthenticationException("Configured passphrase prompt (LoginManager properties) can't be created.");
                    }
                    String string = this.properties_.getProperty(DEFAULT_PROMPT_MESSAGE_PREFIX, "Plaese enter User-PIN for this token") + LINE_SEPARATOR + LINE_SEPARATOR;
                    String string4 = Util.fixString(tokenInfo.getLabel());
                    string = this.replaceKeyWord(string, KEY_WORD_TOKEN_LABEL, string4);
                    object.setMessage(string);
                    object.setProtectedResourceInfo(tokenInfo);
                    while (n-- > 0) {
                        Object object4;
                        tokenInfo = session.getToken().getTokenInfo();
                        if (tokenInfo.isUserPinLocked()) {
                            throw new IAIKPkcs11AuthenticationException("Cannot login user, the user PIN is locked.");
                        }
                        if (tokenInfo.isUserPinFinalTry()) {
                            object4 = this.properties_.getProperty(PIN_FINAL_TRY_WARNING, "Warning! The token reported that this will be the final try before the PIN gets blocked.") + LINE_SEPARATOR + string;
                            string4 = Util.fixString(tokenInfo.getLabel());
                            object4 = this.replaceKeyWord((String)object4, KEY_WORD_TOKEN_LABEL, string4);
                            object.setMessage(object4);
                        }
                        if ((object4 = object.promptPassphrase()) == null) {
                            throw new IAIKPkcs11AuthenticationCanceledException("User canceled PIN entry.");
                        }
                        try {
                            object2 = session.getSessionInfo();
                            object2 = object2.getState();
                            if (!object2.equals((Object)State.RO_USER_FUNCTIONS) && !object2.equals((Object)State.RW_USER_FUNCTIONS)) {
                                session.login(true, object4);
                            }
                            session.setPIN(object4, newPIN);
                            break;
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            PKCS11Exception pKCS11Exception4 = pKCS11Exception;
                            long l5 = pKCS11Exception.getErrorCode();
                            if (l5 == 160L) {
                                String string5 = this.properties_.getProperty(WRONG_PIN_WARNING, "Wrong PIN! You have $(TRIALS_LEFT) trials left.");
                                string5 = this.replaceKeyWord(string5, KEY_WORD_TRIALS_LEFT, String.valueOf(n));
                                object2 = string5 + LINE_SEPARATOR + string;
                                string4 = Util.fixString(tokenInfo.getLabel());
                                object2 = this.replaceKeyWord((String)object2, KEY_WORD_TOKEN_LABEL, string4);
                                object.setMessage(object2);
                                continue;
                            }
                            throw pKCS11Exception4;
                        }
                    }
                } else {
                    object = this.getPassphraseChangePrompt();
                    object.setOldPassphraseRequired(true);
                    String string = this.properties_.getProperty(DEFAULT_NEW_PROMPT_MESSAGE_PREFIX, "Please enter new User-PIN for this token") + LINE_SEPARATOR + LINE_SEPARATOR;
                    String string6 = Util.fixString(tokenInfo.getLabel());
                    string = this.replaceKeyWord(string, KEY_WORD_TOKEN_LABEL, string6);
                    object.setMessage(string);
                    object.setProtectedResourceInfo(tokenInfo);
                    PKCS11Exception pKCS11Exception = null;
                    while (n-- > 0) {
                        Object object5;
                        tokenInfo = session.getToken().getTokenInfo();
                        if (tokenInfo.isUserPinLocked()) {
                            throw new IAIKPkcs11AuthenticationException("Cannot set user PIN, the user PIN is locked.");
                        }
                        if (tokenInfo.isUserPinFinalTry()) {
                            object5 = this.properties_.getProperty(PIN_FINAL_TRY_WARNING, "Warning! The token reported that this will be the final try before the PIN gets blocked.") + LINE_SEPARATOR + string;
                            string6 = Util.fixString(tokenInfo.getLabel());
                            object5 = this.replaceKeyWord((String)object5, KEY_WORD_TOKEN_LABEL, string6);
                            object.setMessage(object5);
                        }
                        if ((object5 = object.promptNewPassphrase()) == null) {
                            throw new IAIKPkcs11AuthenticationCanceledException("User canceled new PIN entry.");
                        }
                        try {
                            object2 = session.getSessionInfo();
                            object2 = object2.getState();
                            if (!object2.equals((Object)State.RO_USER_FUNCTIONS) && !object2.equals((Object)State.RW_USER_FUNCTIONS)) {
                                session.login(true, object5[0]);
                                pKCS11Exception = null;
                            }
                            session.setPIN(object5[0], object5[1]);
                            break;
                        }
                        catch (PKCS11Exception pKCS11Exception5) {
                            String string7;
                            PKCS11Exception pKCS11Exception6 = pKCS11Exception5;
                            long l6 = pKCS11Exception5.getErrorCode();
                            if (l6 == 160L) {
                                pKCS11Exception = pKCS11Exception6;
                                if (oldPIN != null) break;
                                object2 = this.properties_.getProperty(WRONG_PIN_WARNING, "Wrong PIN! You have $(TRIALS_LEFT) trials left.");
                                object2 = this.replaceKeyWord((String)object2, KEY_WORD_TRIALS_LEFT, String.valueOf(n));
                                string7 = (String)object2 + LINE_SEPARATOR + string;
                                string6 = Util.fixString(tokenInfo.getLabel());
                                string7 = this.replaceKeyWord(string7, KEY_WORD_TOKEN_LABEL, string6);
                                object.setMessage(string7);
                                continue;
                            }
                            if (l6 == 161L) {
                                object2 = this.properties_.getProperty(INVALID_NEW_PIN_WARNING, "The entered new PIN is invalid.");
                                string7 = (String)object2 + LINE_SEPARATOR + string;
                                string6 = Util.fixString(tokenInfo.getLabel());
                                string7 = this.replaceKeyWord(string7, KEY_WORD_TOKEN_LABEL, string6);
                                object.setMessage(string7);
                                continue;
                            }
                            if (l6 == 162L) {
                                object2 = this.properties_.getProperty(NEW_PIN_LENGTH_WARNING, "The length of the new PIN is invalid.");
                                string7 = (String)object2 + LINE_SEPARATOR + string;
                                string6 = Util.fixString(tokenInfo.getLabel());
                                string7 = this.replaceKeyWord(string7, KEY_WORD_TOKEN_LABEL, string6);
                                object.setMessage(string7);
                                continue;
                            }
                            throw pKCS11Exception6;
                        }
                    }
                    if (pKCS11Exception != null) {
                        throw new IAIKPkcs11AuthenticationException("The provided user PIN is invalid.");
                    }
                }
            }
            return;
        }
        finally {
            sessionContainer.disposeSessionIfDummy();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logout(TokenManager tokenManager, Session session) throws TokenException {
        SessionContainer sessionContainer;
        sessionContainer = new SessionContainer((TokenManager)((Object)sessionContainer), session);
        session = sessionContainer.getSession();
        try {
            void var2_2;
            var2_2.logout();
            return;
        }
        finally {
            sessionContainer.disposeSessionIfDummy();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected boolean useNullPINs(TokenManager tokenManager, Session session) throws TokenException {
        void var1_1;
        if (tokenManager == null) {
            throw new NullPointerException("Argument \"tokenManager\" must not be null");
        }
        return this.isForceProtectedAuthenticationPath() || this.isUseProtectedAuthenticationPath() && var1_1.getToken().getTokenInfo().isProtectedAuthenticationPath();
    }

    protected String replaceKeyWord(String message, String keyWord, String keyWordValue) {
        String string = message;
        int n = 0;
        while ((n = string.indexOf(keyWord, n)) >= 0) {
            string = string.substring(0, n) + keyWordValue + string.substring(n + keyWord.length());
        }
        return string;
    }

    private static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            Object object = (a == null ? (a = DefaultLoginManager.a("iaik.pkcs.pkcs11.provider.DefaultLoginManager")) : a).getClassLoader().getResource(DEFAULT_CONFIGURATION_PROPERTIES);
            object = ((URL)object).openStream();
            Properties properties = new Properties();
            properties.load((InputStream)object);
            object = (b == null ? (b = DefaultLoginManager.a("iaik.pkcs.pkcs11.provider.IAIKPkcs11")) : b).getClassLoader().getResource(CONFIGURATION_PROPERTIES);
            if (object != null) {
                object = ((URL)object).openStream();
                properties = new Properties(properties);
                properties.load((InputStream)object);
                ((InputStream)object).close();
                defaultConfiguration_ = properties;
            } else {
                defaultConfiguration_ = properties;
            }
        }
        catch (IOException iOException) {
            IAIKPkcs11.errorStream_.println("Could not load DefaultLoginManager configuration properties.");
            iOException.printStackTrace(IAIKPkcs11.errorStream_);
            defaultConfiguration_ = null;
        }
    }
}

