/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider;

import iaik.asn1.ASN1Object;
import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.AESSecretKey;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.BooleanAttribute;
import iaik.pkcs.pkcs11.objects.CAST128SecretKey;
import iaik.pkcs.pkcs11.objects.CAST3SecretKey;
import iaik.pkcs.pkcs11.objects.CASTSecretKey;
import iaik.pkcs.pkcs11.objects.DES2SecretKey;
import iaik.pkcs.pkcs11.objects.DES3SecretKey;
import iaik.pkcs.pkcs11.objects.DESSecretKey;
import iaik.pkcs.pkcs11.objects.DHPrivateKey;
import iaik.pkcs.pkcs11.objects.DHPublicKey;
import iaik.pkcs.pkcs11.objects.DSAPrivateKey;
import iaik.pkcs.pkcs11.objects.DSAPublicKey;
import iaik.pkcs.pkcs11.objects.ECDSAPrivateKey;
import iaik.pkcs.pkcs11.objects.ECDSAPublicKey;
import iaik.pkcs.pkcs11.objects.GenericSecretKey;
import iaik.pkcs.pkcs11.objects.GenericTemplate;
import iaik.pkcs.pkcs11.objects.IDEASecretKey;
import iaik.pkcs.pkcs11.objects.KEAPrivateKey;
import iaik.pkcs.pkcs11.objects.KEAPublicKey;
import iaik.pkcs.pkcs11.objects.KeyPair;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.RC2SecretKey;
import iaik.pkcs.pkcs11.objects.RC4SecretKey;
import iaik.pkcs.pkcs11.objects.RC5SecretKey;
import iaik.pkcs.pkcs11.objects.RSAPrivateKey;
import iaik.pkcs.pkcs11.objects.RSAPublicKey;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.objects.X942DHPrivateKey;
import iaik.pkcs.pkcs11.objects.X942DHPublicKey;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.KeyHandler;
import iaik.pkcs.pkcs11.provider.a;
import iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11Key;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PrivateKey;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PublicKey;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DHParameterSpec;

public class DefaultKeyHandler
extends KeyHandler {
    private static final byte[] a = new byte[]{-16, 96, -49, -94, 63, 101, -102, 18, 62, -106, 112, 61, 83, 105, -74, 97, 18, 6, -76, -25, 34, -125, -122, -105, 23, -55, -3, 123, 63, -98, 46, 84, -114, -5, 24, 50, -12, 12, 83, -36, 8, -86, -2, -107, -103, -3, -81, 76, 57, 21, 101, 43, 2, 19, -111, -127, -58, 35, -107, 70, -73, -90, -39, -43};
    private static final byte[] b = new byte[]{15, 64, 8, 104, -4, 110, -4, 18, 96, -7, 67, 83, -22, -53, 73, -29, 20, 1, 4, 58, 24, 18, -112, -79, 15, 46, -105, -128, -18, 116, -116, -102, 0, 33, -4, 89, 95, 93, 13, -16, 5, -104, 31, -36, -85, -24, -65, -120, 116, 23, -64, 108, 31, 91, -90, -104, -114, -10, -73, -109, 100, -73, -115, 5};
    private static final byte[] c = new byte[]{-21, -72, 13, 18, 0, 59, 110, -65, 46, 18, 112, 82, -74, 105, -27, 109, 115, 70, 42, 21, -32, 92, 109, 46, -2, 60, 103, 22, -48, -8, -19, 78, 53, -64, -62, 37, -26, -37, 116, -16, 95, -78, -30, -61, 10, 75, -126, -15, -86, -49, 9, -7, 2, -89, 6, 87, -72, 72, 47, -48, 100, -86, -72, -9, -6, -118, -111, -117, -89, 9, -49, -33, 46, -52, -92, 29, -84, -104, -31, 16, -38, 125, 12, 40, -25, 0, -67, 73, 126, 1, -101, 22, -57, 113, 59, -13};
    private static final byte[] d = new byte[]{55, 97, -4, 22, -70, 100, -6, 34, -90, 57, -102, 36, -75, -35, 100, -40, 20, 57, 0, 14, 52, -4, -39, -119, 22, 51, -58, 10, -73, -104, -102, 121, 21, -91, 65, -33, -37, 27, 45, 35, 93, 74, -104, -121, 26, 83, -88, 116, 23, -93, -70, -116, -82, 95, 26, 10, 112, -71, 23, -10, -96, 21, -62, 101, -40, -113, -55, -88, -34, 3, 79, 83, -44, 97, -103, -66, -104, 97, -66, -68, 0, 102, 31, -41, -57, 89, -43, 99, -127, 108, 6, -124, -93, 81, 31, -64};
    private static final byte[] e = new byte[]{-86, -62, 47, 83, 18, -118, 18, 67, -88, 34, 84, -59, 33, 121, -48, -69, 25, -17, 103, -118, 50, -45, 87, 67, 33, 75, -114, -126, 18, -74, 76, -88, 89, -121, -41, 30, 101, 112, 34, -43, 66, 17, -55, 56, -16, -75, 40, 95, -101, -53, 11, 91, -110, 72, -109, 52, 72, -58, 118, -116, -43, 3, 98, 105, -52, 12, -11, -15, 11, -111, -104, 79, 105, -76, -118, -40, 47, -102, 117, -97, -75, 103, -9, -89, -9, 79, 10, 96, -38, -83, -115, -60, 40, 93, 26, 54, 81, 54, 58, -59, 127, -69, 99, -46, -26, -59, -81, -21, -15, 112, 51, -55, -64, -88, -8, 31, -80, -92, -15, -8, 103, 78, -112, 105, 123, -13, -25, 103};
    private static final byte[] f = new byte[]{102, 80, -68, -58, -75, -14, -72, -127, -71, -65, 88, -122, 20, 64, -43, 35, -111, 32, 111, 73, 109, -24, -50, 11, 6, -128, -113, -96, 61, -49, 96, -127, -36, 63, -96, -87, 91, -98, -94, -65, -18, 68, -52, -9, -101, -102, -118, -108, 106, 27, -43, 54, -48, 41, 112, -128, 54, -59, -47, -14, -56, -86, -118, 48, 100, 77, 2, 19, -123, -111, -103, 77, -90, -52, 59, -112, -123, -117, -33, 115, 66, -97, -42, -102, -28, -104, 25, 103, -39, 10, 77, 110, -34, 28, -54, 110, 2, 117, 22, -116, -107, 69, -86, -84, 111, -90, -77, 20, 39, -23, 97, -65, -92, -79, 80, 9, -28, -119, 20, -2, -48, -96, -90, -119, -50, 106, 47, -111};
    private static final byte[] g = new byte[]{-37, 102, 2, -42, -109, 117, -21, 67, -115, 11, -49, 126, 113, -103, 22, 95, -21, 40, 103, 76, 21, -53, -95, -112, 76, -89, -127, 120, -1, 9, 44, 121, -46, 115, -85, -102, -8, 13, 126, -42, 88, -26, 61, 44, 98, -42, 27, 13, 65, 58, -99, 49, 55, -72, -52, -33, -94, -9, 59, -74, -46, -105, -87, -76, 62, -38, -125, 16, -105, -85, 124, 98, -57, -56, 123, -14, -24, 50, -94, 57, 24, -37, -118, 6, -17, -87, 87, 59, -121, 99, 68, -32, 51, 58, 52, 11, -3, 43, 27, 31, 38, 127, 3, 119, 120, -52, 107, 100, 83, 27, 30, 122, -43, 10, -18, 37, -2, -110, 16, 85, 60, 101, -42, 85, 112, -44, 89, -81, 62, 15, -67, -15, -114, -84, 113, 90, -95, 110, 82, -103, 5, 93, -24, 27, -123, -93, 5, 77, 78, 29, 122, 62, -16, 120, -18, -30, -69, 104, -54, 23, 1, 37, 6, 127, 51, -23, -46, 82, 115, 32, -111, -63, -112, 122, 98, -58, 65, -6, 96, 71, 65, -52, 53, 60, -74, 28, -6, 33, 96, 82, -44, 18, -123, 12, 104, -29, 27, 116, -8, -24, 96, 79, -56, -39, -71, 7, -29, -102, -23, 96, -92, 23, 25, -124, -57, -17, -105, 103, -100, 122, -85, 118, -83, 4, 55, 121, -88, -38, -126, -6, 42, 117, -7, 126, -57, -54, -1, -116, 78, 114, 108, -67, 36, 65, 85, -90, 3, -91, -16, 52, -66, 123, 20, -111, 99, 71};
    private static final byte[] h = new byte[]{-117, 86, 122, -83, -22, 101, -41, -52, 21, 62, -122, -80, -111, 60, -113, -91, -109, 46, -113, -99, -62, -99, 15, -120, -2, 37, -86, 12, 93, -116, -63, 5, 115, 35, -28, 100, 113, -93, -14, 71, -65, -93, 119, -26, -62, 86, -43, 26, 55, -33, 57, 93, 66, -67, -75, -54, -77, 34, 24, -62, -36, 5, -120, 41, 108, -22, 75, -95, -38, -61, 85, 86, -122, 122, 120, -71, -36, -82, 85, 14, -107, -46, -35, -43, -29, 23, -95, 59, -80, 33, 36, 37, 80, 44, 56, 31, -53, -6, -113, -31, -75, -84, 63, 26, 106, 11, -48, 60, 10, -117, -61, 16, -103, -30, 44, -19, -110, 71, 127, -106, -1, 56, -82, -54, 28, 84, 65, 99, -34, 97, 118, 125, 36, 59, 51, 99, -78, -1, 20, 21, 77, -80, 54, -91, -99, 76, -110, -19, 120, 82, -115, 41, 54, 103, -21, 38, 94, 96, 89, -45, -78, 119, 73, -61, -10, 73, 56, 13, 97, -104, -107, -98, 15, 107, 117, 45, 46, 51, 54, -34, -29, 9, -84, 32, 86, -9, -61, -99, 125, 45, -94, -123, 78, -84, 34, -38, -89, 84, -80, -18, 81, -36, -66, -122, -107, -98, -44, -30, 52, 103, -83, 107, -116, -3, -42, 50, 78, 126, -125, -44, 72, -3, 39, -40, 37, -37, 76, -43, 0, 46, 103, 10, -8, 45, -46, -60, -44, 53, 52, -111, 113, -30, -6, 76, -9, 1, -64, 3, 47, -66, 89, -42, -30, -85, 0, -21};
    private static final byte[] i = new byte[]{126, 19, 102, -15, -94, -46, 109, -107, -39, -27, -116, 104, -127, 117, -11, -86, 102, -38, -9, 42, 61, -40, 20, 89, 99, -16, 46, -39, -69, -110, 87, -122, -113, -73, -39, -124, -63, 86, 122, 72, 43, -119, 84, 87, -88, 38, -111, 19, 36, 78, -56, -101, 9, -126, 71, -61, 38, 118, 109, -3, 8, -126, -50, 65};
    private static final byte[] j = new byte[]{-67, 46, 57, -115, 64, -123, -71, -120, 116, 123, -101, -7, 22, 89, -121, 106, 42, -72, -19, -48, -114, 97, 29, 112, -88, -19, -46, 72, -115, 7, -35, 7, 63, 105, 10, 9, -31, -13, -61, -95, -5, -33, -83, -49, -97, 67, -118, 103, -6, 78, 4, -112, 13, -4, 75, 1, -50, -66, 115, 66, -24, 4, 61, -21};
    private static final byte[] k = new byte[]{13, -114, -61, 92, -65, -63, 114, -32, -128, 39, -76, 45, -110, 32, -1, 78, -107, -54, 47, 75, -19, -22, -28, 31, 85, 18, 62, 41, 99, 0, 79, 83, -19, -27, -88, 24, -41, -17};
    private static final byte[] l = new byte[]{-119, -61, -126, -41, 13, 34, 26, 27, 42, 102, 81, 41, -74, 53, 11, -23, 99, 91, -10, -65, 22, 106, -26, -35, -102, 46, -37, -7, 9, 6, -6, 68, -19, -60, 120, -106, 85, -41, 98, -34, -38, 94, -61, 101, -128, -3, -59, -36, -74, 6, -21, -86, -124, 22, 20, -111, -87, -59, 82, 45, 46, 95, -7, -72, -48, 110, -71, 93, 114, 32, 2, -9, -86, 22, 12, 98, -87, -102, -18, 3, 107, -34, 103, -46, 69, -119, -35, 110, -115, 17, -29, -88, 90, 83, 107, 83};
    private static final byte[] m = new byte[]{-24, -70, 122, -95, -76, 114, 87, 26, -66, -77, -63, 104, 110, -70, 84, 75, -43, 70, -118, -40, 41, 96, 107, 13, -117, -86, 24, 1, 113, 25, 46, -8, 111, 18, 68, -12, -5, 83, -2, -23, 19, -90, -39, -81, -125, 94, -119, -91, 28, -116, 39, 59, 55, 50, -124, 110, -112, 10, -89, -69, -116, 71, 47, -76, -111, -80, 101, -58, -25, 54, 46, 36, -71, 8, 20, -41, 22, 9, -18, -84, 102, -11, 20, -82, 73, 63, 5, -71, 102, -114, -51, -44, 15, 123, 79, -69};
    private static final byte[] n = new byte[]{14, -102, -25, 93, -42, 68, 39, -17, -27, 34, -88, 46, 115, -62, -28, 62, 3, 60, 83, -32, -69, -50, -98, -54, -115, -8, 88, 55, -58, -117, 17, 49, -42, 76, -97, -25, -93, 49};
    private static final byte[] o = new byte[]{124, -108, 123, 56, -47, 64, 17, -18, -58, -106, -40, 14, -115, 114, 44, -76, 58, 108, -82, 53, 109, 32, 106, 58, -29, 67, 45, 98, 55, -28, -125, -43, -93, 127, -108, -125, 103, 86, 108, 28, -38, -82, -80, -9, -100, -120, 111, 38, -59, 10, 116, 69, 107, 64, -52, 59, 97, 90, 90, -120, 59, 44, -124, 31, 71, 27, 5, -25, 115, 66, 49, -108, -2, 77, 59, 118, -76, 58, 5, 88, -97, -117, 60, -15, 77, -33, -110, -114, 17, 34, -107, 28, -32, 121, 109, 37, -81, -67, 94, -106, 75, -86, -43, -45, -64, -85, 33, -45, 97, -90, -39, 33, 62, 115, -120, 9, 8, -11, 82, -68, -88, -115, 29, -36, -9, 35, -72, 90};
    private static final byte[] p = new byte[]{-27, -21, -122, 101, 122, -77, 95, 11, -58, 29, -16, -114, -2, -5, -12, -15, -126, 77, 94, -21, -74, 72, 59, 78, -96, 67, -48, 31, -34, -53, -114, -4, -121, -83, 82, 16, -126, 79, 84, 30, -107, -51, 33, 54, -65, -51, 84, 105, -3, -126, -9, 116, 117, -124, -96, 20, 113, 100, -105, -102, 4, 103, -53, 48, 10, -73, -51, 6, 127, 121, 9, -117, -111, -36, -111, -42, -104, 29, -41, 23, -13, -58, -45, 7, 73, -70, 82, 60, 116, -127, -125, 29, -116, -26, 51, -29, 8, 59, -92, 39, -102, -30, -27, 17, 46, 66, 38, -49, -97, 19, -19, -100, -17, -78, -79, 3, 38, -100, 32, -40, -79, 77, 108, 28, -40, -46, -51, -13};
    private static final byte[] q = new byte[]{10, 70, -69, -105, -95, 52, 74, 90, -86, -41, 34, 86, 86, 10, -100, 121, -95, -73, 30, -77, -61, 60, 102, 102, -100, -17, 27, -125, 11, -69, -85, 100, -41, 36, 63, -90, 119, -105};
    private static final byte[] r = new byte[]{-123, -75, 87, 86, -77, 98, 126, -69, 26, -9, 74, 98, -13, -54, 85, -36, -49, 108, -95, 41, 113, 8, 113, 65, 111, -4, 34, 113, -15, -27, 38, -1, 78, 26, 122, 56, 96, -123, -91, 103, 43, 104, -63, 81, -82, 92, 80, -87, -16, 60, -37, -38, 88, -117, 37, -94, -86, 99, 115, 57, -44, -38, -121, 64, -102, -84, -8, -59, 51, -56, -68, 89, 35, -52, -91, 100, 71, -18, 122, -89, 17, 108, -26, 117, -3, 76, 10, 67, -29, -44, 120, -59, -74, -85, -8, 17, -7, 9, 16, 88, 117, 96, -76, 40, 35, 34, 73, -86, 35, -122, -47, 83, 72, -81, 5, -77, -66, 32, -36, -12, 39, -90, 69, 32, -52, -104, -105, 17, 76, 24, -37, -99, -77, 11, 100, 90, -77, -123, -94, 100, -120, 4, -26, 126, 122, -70, -32, 122, -98, -91, -99, -123, 126, 14, -126, -47, 4, -86, -64, -82, -57, -40, 112, 87, 100, 50, 96, -110, 87, -106, 54, -94, 39, 120, 31, -109, -19, 126, 48, 71, 96, -65, -66, -94, 101, 35, -124, -113, -106, -78, -101, -86, 7, 109, -3, 73, -103, -13, -85, -112, 75, -17, -33, 99, -75, -71, 51, -34, -96, -2, 114, -95, -46, -67, -120, 51, 22, -112, 32, -105, -88, -108, -54, 10, -69, -4, 82, 25, 6, 65, -35, -70, -80, 78, -123, 122, -26, -5, -86, 69, -13, -24, -45, -101, 77, 84, 64, 108, -121, -101, -38, 104, 54, -69, -115, -19};
    private static final byte[] s = new byte[]{-74, 94, 41, -30, -68, 12, 71, -86, -72, 84, -79, -117, 18, 49, 66, -86, 10, -54, -50, -116, 53, 95, -121, 56, 97, 1, -95, -24, 66, -91, 90, 23, 5, -82, -40, -117, -127, 34, -90, -24, 44, 25, -44, -113, 49, -65, 111, 36, -9, 100, -12, -97, -98, -97, -3, -36, 45, 24, -75, -95, -27, 102, 115, -53, -79, 112, 78, 121, -19, -27, 91, -100, -18, 18, 32, 122, -42, 66, 24, -38, 42, 114, 39, 94, -86, -121, 23, 102, 107, -41, 52, -74, -16, 89, 66, -63, 27, -66, -87, 108, -51, 97, -114, 21, -96, -92, -7, 93, 125, 42, 126, 10, 59, 9, 21, 99, 78, -114, 61, 86, 68, 66, 69, -18, -33, 78, 58, 27, -116, 93, -82, 122, 104, 60, -57, -1, 50, 125, 109, 106, -68, 47, 42, 60, -29, 98, 118, -68, 8, 47, -46, 100, -79, -70, 80, -61, -23, -12, 59, 120, -94, 55, -40, -55, -10, 22, 73, -39, -28, 88, -52, -95, 37, -70, 24, 63, -39, 21, -3, 35, 74, 22, 99, -21, -117, -34, 100, 44, 107, -62, 87, -126, 83, -2, 21, 32, 28, 87, 19, 86, 27, 49, -77, 42, -35, 9, 118, 29, -77, -67, 78, -33, -118, -45, -48, -101, -64, -114, -122, 85, 125, 49, 73, -112, -119, -47, 83, 83, -11, -39, 56, -37, -84, -78, 59, 42, -17, 124, -71, -55, -51, 63, 48, 41, 17, -55, -69, 68, 78, 87, -97, -128, 74, -25, -93, -39};
    private static final byte[] t = new byte[]{13, -15, -3, -92, -83, 42, -36, -79, 37, 116, 36, 59, -29, -2, -78, -95, 32, -66, -78, -123, 72, -39, 87, 98, 19, 35, 118, -35, 62, 124, -14, -97, 49, -19, 100, 17, 99, -85};
    private static final byte[] u = new byte[]{-63, 108, -70, -45, 77, 71, 94, -59, 57, 102, -107, -42, -108, -68, -117, -60, 126, 89, -114, 35, -75, -87, -41, -59, -50, -56, 45, 101, -74, -126, 125, 68, -23, 83, 120, 72, 71, 48, -64, -65, -15, -12, -53, 86, -12, 124, 110, 81, 5, 75, -24, -110, 0, -13, 13, 67, -36, 79, -17, -106, 36, -44, 102, 91};
    private static final byte[] v = new byte[]{-73, -72, 16, -75, -116, 9, 52, -10, 66, -121, -113, 54, 11, -106, -41, -52, 38, -75, 62, 77};
    private static final byte[] w = new byte[]{76, 83, -57, 38, -67, -65, -69, -90, 84, -99, 126, 115, 25, 57, -58, -55, 58, -122, -102, 39, -59, -37, 23, -70, 60, -84, 88, -99, 123, 62, 0, 63, -89, 53, -14, -112, -49, -48, 122, 62, -15, 15, 53, 21, 95, 26, 46, -9, 3, 53, -81, 123, 106, 82, 17, -95, 16, 53, 24, -5, -92, 78, -105, 24};
    private static final byte[] x = new byte[]{-28, -3, -67, -20, 39, 58, -72, -122, 46, 39, 109, 95, -18, 103, 72, -78, 63, -52, 114, 101, -1, -58, 0, -51, 1, -32, 51, 104, -86, -75, 72, 114, -86, 108, -104, -12, -41, -106, -69, 125, -112, -52, -77, 106, 69, -11, 90, 5, -69, -96, 109, -35, -43, 61, 27, 65, 25, 96, -38, 9, 111, -84, 7, 95, 40, 51, -65, -113, 23, 59, -22, -106, -54, 83, 2, 106, 67, -79, 124, -100, 0, -3, 81, -74, -98, -92, 4, -64, -42, 9, 107, -86, 101, 75, -35, 43};
    private static final byte[] y = new byte[]{-125, -36, -107, -78, 5, 106, 105, -92, -29, -120, 23, 114, -77, 4, 106, 119, 2, 26, 125, 105};
    private static final byte[] z = new byte[]{98, -7, 116, 90, 6, -5, 15, -93, -87, 78, -74, -26, -40, -3, 78, -56, 28, -32, 75, 26, 102, -12, -62, -25, -32, -4, 43, 116, 81, 37, 41, -45, 56, 22, -62, -90, -65, -112, 58, 23, -24, 64, 102, 66, -22, 76, -14, -98, 127, -42, -47, 46, 22, 115, 79, 6, 83, 91, -5, -47, -90, 28, 54, -15, 40, -70, -12, 122, 30, 98, 13, -6, -36, -11, 108, 118, -28, -116, 71, -100, -62, 12, 43, -5, -77, 111, -86, -116, 54, -125, 78, -106, -56, 68, 32, -48};
    private static final byte[] A = new byte[]{-126, 125, -44, -100, -94, 5, 105, -124, -23, -125, 113, -79, 52, 13, 93, 113, -125, -110, -123, -78, 90, -54, -93, -126, -41, -84, 56, 110, -108, 64, -124, 63, 10, 70, 122, -88, 117, -88, -63, -54, 59, 112, -70, 106, -105, 7, 18, -10, -79, -103, -19, 62, -20, 83, 19, -13, -108, 10, 103, -69, -42, -97, 56, 114, 41, 97, -85, 2, 61, 23, -95, 51, 60, 82, 35, 93, -97, -73, -47, 14, -107, -29, -91, 94, -7, -80, 79, -57, -55, 32, -59, 114, -38, 122, -61, -43, 15, 36, 13, -69, -114, 84, -38, -98, -69, 112, 33, 17, -59, 53, -126, -27, 53, -123, 46, -97, 89, 57, 121, -77, 50, 80, -56, -122, -125, -106, 25, 23};
    private static final byte[] B = new byte[]{-6, 80, 121, -38, -6, 63, 58, -79, -24, 10, 109, -11, -67, 22, -14, 36, -40, -8, -41, 27};
    private static final byte[] C = new byte[]{79, -67, -11, 46, 51, 4, -16, 81, -63, 124, -91, 92, -109, -127, -75, -63, 125, 76, 32, 80, 118, -123, 52, 80, -49, -39, -4, 114, -78, -31, -78, -79, 111, -96, 16, 72, -72, -1, 23, -25, -87, 10, -31, -32, 24, 5, 62, 52, -39, -43, 97, -33, 113, 76, -56, -36, -110, -79, 81, -75, -33, 102, 89, 112, 107, 94, 87, -61, 25, -94, -42, 88, 59, 125, 50, -46, -23, -31, -15, 102, 62, -86, -84, 70, 13, -51, 78, 103, 112, 54, -9, -7, -66, 11, 46, 22, -96, 93, 105, 93, 91, -127, 19, -87, 3, -53, 56, 99, 86, 26, -67, 54, 74, 93, 108, 21, 102, 23, -6, 16, -93, 32, -103, -31, -46, 52, 119, 19};
    private static final byte[] D = new byte[]{1, 0, 1};
    private boolean E;
    private Map F = Collections.synchronizedMap(new WeakHashMap(32));
    private static Class G;
    private static Class H;
    private static Class I;
    private static Class J;
    private static Class K;
    private static Class L;
    private static Class M;
    private static Class N;
    private static Class O;
    private static Class P;
    private static Class Q;
    private static Class R;

    public DefaultKeyHandler() {
        this.propertiesChanged();
    }

    protected void propertiesChanged() {
        String string = this.properties_.getProperty("AUTO_CONVERSION", "false");
        if (string != null) {
            this.E = Boolean.valueOf(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Key handleCipherKey(String algorithm, int operationMode, Key key) throws InvalidKeyException {
        void var3_3;
        if (this.E && !(key instanceof IAIKPKCS11Key)) {
            void var2_2;
            IAIKPkcs11 iAIKPkcs11 = IAIKPkcs11.getCurrentProviderInstance();
            if (iAIKPkcs11 == null) {
                return key;
            }
            return this.a(iAIKPkcs11, key, (int)var2_2);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Key handleMacKey(String algorithm, Key key) throws InvalidKeyException {
        void var2_2;
        if (this.E && !(key instanceof IAIKPKCS11Key)) {
            IAIKPkcs11 iAIKPkcs11 = IAIKPkcs11.getCurrentProviderInstance();
            if (iAIKPkcs11 == null) {
                return key;
            }
            return this.a(iAIKPkcs11, key);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public PrivateKey handleSignatureKey(String algorithm, PrivateKey key) throws InvalidKeyException {
        void var2_2;
        if (this.E && !(key instanceof IAIKPKCS11Key)) {
            IAIKPkcs11 iAIKPkcs11 = IAIKPkcs11.getCurrentProviderInstance();
            if (iAIKPkcs11 == null) {
                return key;
            }
            return this.a(iAIKPkcs11, key);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public PublicKey handleVerificationKey(String algorithm, PublicKey key) throws InvalidKeyException {
        void var2_2;
        if (this.E && !(key instanceof IAIKPKCS11Key)) {
            IAIKPkcs11 iAIKPkcs11 = IAIKPkcs11.getCurrentProviderInstance();
            if (iAIKPkcs11 == null) {
                return key;
            }
            return this.a(iAIKPkcs11, key);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Key handleKeyAgreementKey(String algorithm, Key key, AlgorithmParameterSpec params) throws InvalidKeyException {
        void var2_2;
        if (this.E && !(key instanceof IAIKPKCS11Key)) {
            IAIKPkcs11 iAIKPkcs11 = IAIKPkcs11.getCurrentProviderInstance();
            if (iAIKPkcs11 == null) {
                return key;
            }
            return this.b(iAIKPkcs11, key);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Key handleKeyAgreementPhaseKey(String algorithm, Key key) throws InvalidKeyException {
        void var2_2;
        if (this.E && !(key instanceof IAIKPKCS11Key)) {
            IAIKPkcs11 iAIKPkcs11 = IAIKPkcs11.getCurrentProviderInstance();
            if (iAIKPkcs11 == null) {
                return key;
            }
            return this.c(iAIKPkcs11, key);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public KeySpec handleKeyFactoryGeneratePublic(String algorithm, KeySpec keySpec) throws InvalidKeySpecException {
        void var2_2;
        if (this.E && !(keySpec instanceof PKCS11KeySpec)) {
            java.lang.Object object = IAIKPkcs11.getCurrentProviderInstance();
            if (object == null) {
                return keySpec;
            }
            object = keySpec;
            keySpec = new BooleanAttribute(Attribute.TOKEN);
            keySpec.setBooleanValue(Boolean.FALSE);
            GenericTemplate genericTemplate = new GenericTemplate();
            genericTemplate.addAttribute((Attribute)keySpec);
            return (PKCS11KeySpec)new PKCS11KeySpec((KeySpec)object, (Object)genericTemplate).setUseUserRole(false);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public KeySpec handleKeyFactoryGeneratePrivate(String algorithm, KeySpec keySpec) throws InvalidKeySpecException {
        void var2_2;
        if (this.E && !(keySpec instanceof PKCS11KeySpec)) {
            java.lang.Object object = IAIKPkcs11.getCurrentProviderInstance();
            if (object == null) {
                return keySpec;
            }
            object = this;
            GenericTemplate genericTemplate = new GenericTemplate();
            super.a(genericTemplate);
            return (PKCS11KeySpec)new PKCS11KeySpec(keySpec, (Object)genericTemplate).setUseUserRole(false);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Key handleKeyFactoryTranslateKey(String algorithm, Key key) throws InvalidKeyException {
        void var2_2;
        if (this.E && !(key instanceof IAIKPKCS11Key)) {
            IAIKPkcs11 iAIKPkcs11 = IAIKPkcs11.getCurrentProviderInstance();
            if (iAIKPkcs11 == null) {
                return key;
            }
            return this.d(iAIKPkcs11, key);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public KeySpec handleSecretKeyFactoryGenerateSecret(String algorithm, KeySpec keySpec) throws InvalidKeySpecException {
        void var2_2;
        if (this.E && !(keySpec instanceof PKCS11KeySpec)) {
            java.lang.Object object = IAIKPkcs11.getCurrentProviderInstance();
            if (object == null) {
                return keySpec;
            }
            object = this;
            GenericTemplate genericTemplate = new GenericTemplate();
            super.a(genericTemplate);
            return (PKCS11KeySpec)new PKCS11KeySpec(keySpec, (Object)genericTemplate).setUseUserRole(false);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public javax.crypto.SecretKey handleSecretKeyFactoryTranslateKey(String algorithm, javax.crypto.SecretKey key) throws InvalidKeyException {
        void var2_2;
        if (this.E && !(key instanceof IAIKPKCS11Key)) {
            IAIKPkcs11 iAIKPkcs11 = IAIKPkcs11.getCurrentProviderInstance();
            if (iAIKPkcs11 == null) {
                return key;
            }
            return this.a(iAIKPkcs11, key);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public KeyPair getKeyPairGeneratorTemplate(String algorithm222, int keySize422) throws InvalidParameterException {
        int keySize422;
        void var1_1;
        KeyPair keyPair;
        if (algorithm222.equalsIgnoreCase("RSA") || algorithm222.equalsIgnoreCase("RSA/X9.31")) {
            int algorithm222 = keySize422;
            if (algorithm222 != -1 && algorithm222 < 0) {
                throw new InvalidParameterException("Invalid key size: " + algorithm222);
            }
            keySize422 = algorithm222 == -1 ? 1024 : algorithm222;
            RSAPrivateKey rSAPrivateKey = new RSAPrivateKey();
            RSAPublicKey algorithm222 = new RSAPublicKey();
            algorithm222.getModulusBits().setLongValue(new Long(keySize422));
            algorithm222.getPublicExponent().setByteArrayValue(D);
            keyPair = new KeyPair((iaik.pkcs.pkcs11.objects.PublicKey)algorithm222, (iaik.pkcs.pkcs11.objects.PrivateKey)rSAPrivateKey);
        } else if (var1_1.equalsIgnoreCase("DH")) {
            int n = keySize422;
            DHPrivateKey keySize422 = new DHPrivateKey();
            keySize422.getDerive().setBooleanValue(Boolean.TRUE);
            DHPublicKey dHPublicKey = new DHPublicKey();
            if (n == -1) {
                n = 1024;
            }
            switch (n) {
                case 512: {
                    dHPublicKey.getPrime().setByteArrayValue(a);
                    dHPublicKey.getBase().setByteArrayValue(b);
                    break;
                }
                case 768: {
                    dHPublicKey.getPrime().setByteArrayValue(c);
                    dHPublicKey.getBase().setByteArrayValue(d);
                    break;
                }
                case 1024: {
                    dHPublicKey.getPrime().setByteArrayValue(e);
                    dHPublicKey.getBase().setByteArrayValue(f);
                    break;
                }
                case 2048: {
                    dHPublicKey.getPrime().setByteArrayValue(g);
                    dHPublicKey.getBase().setByteArrayValue(h);
                    break;
                }
                default: {
                    throw new InvalidParameterException("Unsupported key size: " + n);
                }
            }
            keyPair = new KeyPair((iaik.pkcs.pkcs11.objects.PublicKey)dHPublicKey, (iaik.pkcs.pkcs11.objects.PrivateKey)keySize422);
        } else if (var1_1.equalsIgnoreCase("DH/X9.42")) {
            int n = keySize422;
            X942DHPrivateKey keySize422 = new X942DHPrivateKey();
            keySize422.getDerive().setBooleanValue(Boolean.TRUE);
            X942DHPublicKey x942DHPublicKey = new X942DHPublicKey();
            if (n == -1) {
                n = 1024;
            }
            switch (n) {
                case 512: {
                    x942DHPublicKey.getPrime().setByteArrayValue(j);
                    x942DHPublicKey.getSubprime().setByteArrayValue(k);
                    x942DHPublicKey.getBase().setByteArrayValue(i);
                    break;
                }
                case 768: {
                    x942DHPublicKey.getPrime().setByteArrayValue(m);
                    x942DHPublicKey.getSubprime().setByteArrayValue(DefaultKeyHandler.n);
                    x942DHPublicKey.getBase().setByteArrayValue(l);
                    break;
                }
                case 1024: {
                    x942DHPublicKey.getPrime().setByteArrayValue(p);
                    x942DHPublicKey.getSubprime().setByteArrayValue(q);
                    x942DHPublicKey.getBase().setByteArrayValue(o);
                    break;
                }
                case 2048: {
                    x942DHPublicKey.getPrime().setByteArrayValue(s);
                    x942DHPublicKey.getSubprime().setByteArrayValue(t);
                    x942DHPublicKey.getBase().setByteArrayValue(r);
                    break;
                }
                default: {
                    throw new InvalidParameterException("Unsupported key size: " + n);
                }
            }
            keyPair = new KeyPair((iaik.pkcs.pkcs11.objects.PublicKey)x942DHPublicKey, (iaik.pkcs.pkcs11.objects.PrivateKey)keySize422);
        } else if (var1_1.equalsIgnoreCase("DSA")) {
            int n = keySize422;
            DSAPrivateKey keySize422 = new DSAPrivateKey();
            keySize422.getSign().setBooleanValue(Boolean.TRUE);
            DSAPublicKey dSAPublicKey = new DSAPublicKey();
            if (n == -1) {
                n = 1024;
            }
            switch (n) {
                case 512: {
                    dSAPublicKey.getPrime().setByteArrayValue(u);
                    dSAPublicKey.getSubprime().setByteArrayValue(v);
                    dSAPublicKey.getBase().setByteArrayValue(w);
                    break;
                }
                case 768: {
                    dSAPublicKey.getPrime().setByteArrayValue(x);
                    dSAPublicKey.getSubprime().setByteArrayValue(y);
                    dSAPublicKey.getBase().setByteArrayValue(z);
                    break;
                }
                case 1024: {
                    dSAPublicKey.getPrime().setByteArrayValue(A);
                    dSAPublicKey.getSubprime().setByteArrayValue(B);
                    dSAPublicKey.getBase().setByteArrayValue(C);
                    break;
                }
                default: {
                    throw new InvalidParameterException("Unsupported key size: " + n);
                }
            }
            dSAPublicKey.getVerify().setBooleanValue(Boolean.TRUE);
            keyPair = new KeyPair((iaik.pkcs.pkcs11.objects.PublicKey)dSAPublicKey, (iaik.pkcs.pkcs11.objects.PrivateKey)keySize422);
        } else if (var1_1.equalsIgnoreCase("ECDSA") || var1_1.equalsIgnoreCase("EC")) {
            int n = keySize422;
            ECDSAPrivateKey keySize422 = new ECDSAPrivateKey();
            keySize422.getSign().setBooleanValue(Boolean.TRUE);
            ECDSAPublicKey eCDSAPublicKey = new ECDSAPublicKey();
            if (n == -1) {
                n = 192;
            }
            switch (n) {
                case 163: {
                    keyPair = new ObjectID("1.2.840.10045.3.0.1");
                    break;
                }
                case 176: {
                    keyPair = new ObjectID("1.2.840.10045.3.0.4");
                    break;
                }
                case 191: {
                    keyPair = new ObjectID("1.2.840.10045.3.0.5");
                    break;
                }
                case 192: {
                    keyPair = new ObjectID("1.2.840.10045.3.1.1");
                    break;
                }
                case 208: {
                    keyPair = new ObjectID("1.2.840.10045.3.0.10");
                    break;
                }
                case 224: {
                    keyPair = new ObjectID("1.3.132.0.33");
                    break;
                }
                case 239: {
                    keyPair = new ObjectID("1.2.840.10045.3.1.4");
                    break;
                }
                case 256: {
                    keyPair = new ObjectID("1.2.840.10045.3.1.7");
                    break;
                }
                case 384: {
                    keyPair = new ObjectID("1.3.132.0.34");
                    break;
                }
                case 521: {
                    keyPair = new ObjectID("1.3.132.0.35");
                    break;
                }
                default: {
                    throw new InvalidParameterException("Unsupported key size: " + n);
                }
            }
            eCDSAPublicKey.getEcdsaParams().setByteArrayValue(DerCoder.encode((ASN1Object)keyPair));
            eCDSAPublicKey.getVerify().setBooleanValue(Boolean.TRUE);
            keyPair = new KeyPair((iaik.pkcs.pkcs11.objects.PublicKey)eCDSAPublicKey, (iaik.pkcs.pkcs11.objects.PrivateKey)keySize422);
        } else if (var1_1.equalsIgnoreCase("KEA")) {
            void var2_9;
            int n = var2_9;
            KEAPrivateKey kEAPrivateKey = new KEAPrivateKey();
            kEAPrivateKey.getDerive().setBooleanValue(Boolean.TRUE);
            KEAPublicKey kEAPublicKey = new KEAPublicKey();
            if (n == -1) {
                n = 1024;
            }
            switch (n) {
                case 512: {
                    kEAPublicKey.getPrime().setByteArrayValue(u);
                    kEAPublicKey.getSubprime().setByteArrayValue(v);
                    kEAPublicKey.getBase().setByteArrayValue(w);
                    break;
                }
                case 768: {
                    kEAPublicKey.getPrime().setByteArrayValue(x);
                    kEAPublicKey.getSubprime().setByteArrayValue(y);
                    kEAPublicKey.getBase().setByteArrayValue(z);
                    break;
                }
                case 1024: {
                    kEAPublicKey.getPrime().setByteArrayValue(A);
                    kEAPublicKey.getSubprime().setByteArrayValue(B);
                    kEAPublicKey.getBase().setByteArrayValue(C);
                    break;
                }
                default: {
                    throw new InvalidParameterException("Unsupported key size: " + n);
                }
            }
            keyPair = new KeyPair((iaik.pkcs.pkcs11.objects.PublicKey)kEAPublicKey, (iaik.pkcs.pkcs11.objects.PrivateKey)kEAPrivateKey);
        } else {
            throw new IAIKPkcs11Exception("Unknown algorithm: " + (String)var1_1);
        }
        DefaultKeyHandler.a(keyPair, true);
        return keyPair;
    }

    public KeyPair getKeyPairGeneratorTemplate(String algorithm, AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        java.lang.Object object;
        if (((String)algorithm).equalsIgnoreCase("RSA") || ((String)algorithm).equalsIgnoreCase("RSA/X9.31")) {
            throw new InvalidAlgorithmParameterException("This implementation does not support key-pair generation parameters.");
        }
        if (((String)algorithm).equalsIgnoreCase("DH")) {
            algorithm = params;
            if (!(algorithm instanceof DHParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Unsupported algorithm parameters: " + algorithm);
            }
            algorithm = (DHParameterSpec)algorithm;
            params = new DHPrivateKey();
            params.getDerive().setBooleanValue(Boolean.TRUE);
            params.getValueBits().setLongValue(new Long(((DHParameterSpec)algorithm).getL()));
            DHPublicKey dHPublicKey = new DHPublicKey();
            byte[] byArray = Util.unsignedBigIntergerToByteArray((BigInteger)((DHParameterSpec)algorithm).getP());
            byte[] byArray2 = Util.unsignedBigIntergerToByteArray((BigInteger)((DHParameterSpec)algorithm).getG());
            dHPublicKey.getPrime().setByteArrayValue(byArray);
            dHPublicKey.getBase().setByteArrayValue(byArray2);
            object = new KeyPair((iaik.pkcs.pkcs11.objects.PublicKey)dHPublicKey, (iaik.pkcs.pkcs11.objects.PrivateKey)params);
        } else if (((String)object).equalsIgnoreCase("DH/X9.42")) {
            object = params;
            if (!(object instanceof DSAParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Unsupported algorithm parameters: " + object);
            }
            object = (DSAParameterSpec)object;
            params = new DHPrivateKey();
            params.getDerive().setBooleanValue(Boolean.TRUE);
            X942DHPublicKey x942DHPublicKey = new X942DHPublicKey();
            byte[] byArray = Util.unsignedBigIntergerToByteArray((BigInteger)((DSAParameterSpec)object).getP());
            byte[] byArray3 = Util.unsignedBigIntergerToByteArray((BigInteger)((DSAParameterSpec)object).getQ());
            object = Util.unsignedBigIntergerToByteArray((BigInteger)((DSAParameterSpec)object).getG());
            x942DHPublicKey.getPrime().setByteArrayValue(byArray);
            x942DHPublicKey.getSubprime().setByteArrayValue(byArray3);
            x942DHPublicKey.getBase().setByteArrayValue((byte[])object);
            object = new KeyPair((iaik.pkcs.pkcs11.objects.PublicKey)x942DHPublicKey, (iaik.pkcs.pkcs11.objects.PrivateKey)params);
        } else if (((String)object).equalsIgnoreCase("DSA")) {
            object = params;
            if (!(object instanceof DSAParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Unsupported algorithm parameters: " + object);
            }
            object = (DSAParameterSpec)object;
            params = new DSAPrivateKey();
            params.getSign().setBooleanValue(Boolean.TRUE);
            DSAPublicKey dSAPublicKey = new DSAPublicKey();
            byte[] byArray = Util.unsignedBigIntergerToByteArray((BigInteger)((DSAParameterSpec)object).getP());
            byte[] byArray4 = Util.unsignedBigIntergerToByteArray((BigInteger)((DSAParameterSpec)object).getQ());
            object = Util.unsignedBigIntergerToByteArray((BigInteger)((DSAParameterSpec)object).getG());
            dSAPublicKey.getPrime().setByteArrayValue(byArray);
            dSAPublicKey.getSubprime().setByteArrayValue(byArray4);
            dSAPublicKey.getBase().setByteArrayValue((byte[])object);
            object = new KeyPair((iaik.pkcs.pkcs11.objects.PublicKey)dSAPublicKey, (iaik.pkcs.pkcs11.objects.PrivateKey)params);
        } else {
            if (((String)object).equalsIgnoreCase("ECDSA") || ((String)object).equalsIgnoreCase("EC")) {
                throw new InvalidAlgorithmParameterException("This implementation does not support key-pair generation parameters.");
            }
            if (((String)object).equalsIgnoreCase("KEA")) {
                KEAPrivateKey kEAPrivateKey;
                object = kEAPrivateKey;
                if (!(object instanceof DSAParameterSpec)) {
                    throw new InvalidAlgorithmParameterException("Unsupported algorithm parameters: " + object);
                }
                object = (DSAParameterSpec)object;
                kEAPrivateKey = new KEAPrivateKey();
                kEAPrivateKey.getDerive().setBooleanValue(Boolean.TRUE);
                KEAPublicKey kEAPublicKey = new KEAPublicKey();
                byte[] byArray = Util.unsignedBigIntergerToByteArray((BigInteger)((DSAParameterSpec)object).getP());
                byte[] byArray5 = Util.unsignedBigIntergerToByteArray((BigInteger)((DSAParameterSpec)object).getQ());
                object = Util.unsignedBigIntergerToByteArray((BigInteger)((DSAParameterSpec)object).getG());
                kEAPublicKey.getPrime().setByteArrayValue(byArray);
                kEAPublicKey.getSubprime().setByteArrayValue(byArray5);
                kEAPublicKey.getBase().setByteArrayValue((byte[])object);
                object = new KeyPair((iaik.pkcs.pkcs11.objects.PublicKey)kEAPublicKey, (iaik.pkcs.pkcs11.objects.PrivateKey)kEAPrivateKey);
            } else {
                throw new IAIKPkcs11Exception("Unknown algorithm: " + (String)object);
            }
        }
        DefaultKeyHandler.a((KeyPair)object, true);
        return object;
    }

    public SecretKey getKeyGeneratorTemplate(String algorithm, int keySize) throws InvalidParameterException {
        int n;
        AESSecretKey aESSecretKey;
        if (algorithm.equalsIgnoreCase("AES")) {
            if (keySize != -1 && keySize != 128 && keySize != 192 && keySize != 256) {
                throw new InvalidParameterException("Invalid key size: " + keySize);
            }
            aESSecretKey = new AESSecretKey();
            n = keySize == -1 ? 16 : (keySize + 7) / 8;
            aESSecretKey.getValueLen().setLongValue(new Long(n));
        } else if (aESSecretKey.equalsIgnoreCase("CAST128")) {
            if (n != -1 && (n < 8 || n > 128 || n % 8 != 0)) {
                throw new InvalidParameterException("Invalid key size: " + n);
            }
            aESSecretKey = new CAST128SecretKey();
            n = n == -1 ? 16 : (n + 7) / 8;
            aESSecretKey.getValueLen().setLongValue(new Long(n));
        } else if (aESSecretKey.equalsIgnoreCase("CAST3")) {
            if (n != -1 && (n < 8 || n > 64 || n % 8 != 0)) {
                throw new InvalidParameterException("Invalid key size: " + n);
            }
            aESSecretKey = new CAST3SecretKey();
            n = n == -1 ? 8 : (n + 7) / 8;
            aESSecretKey.getValueLen().setLongValue(new Long(n));
        } else if (aESSecretKey.equalsIgnoreCase("CAST")) {
            if (n != -1 && (n < 8 || n > 64 || n % 8 != 0)) {
                throw new InvalidParameterException("Invalid key size: " + n);
            }
            aESSecretKey = new CASTSecretKey();
            n = n == -1 ? 8 : (n + 7) / 8;
            aESSecretKey.getValueLen().setLongValue(new Long(n));
        } else if (aESSecretKey.equalsIgnoreCase("DES2")) {
            if (n != -1 && n != 112 && n != 128) {
                throw new InvalidParameterException("Invalid key size: " + n);
            }
            aESSecretKey = new DES2SecretKey();
        } else if (aESSecretKey.equalsIgnoreCase("DESede")) {
            if (n != -1 && n != 168 && n != 192) {
                throw new InvalidParameterException("Invalid key size: " + n);
            }
            aESSecretKey = new DES3SecretKey();
        } else if (aESSecretKey.equalsIgnoreCase("DES")) {
            if (n != -1 && n != 56 && n != 64) {
                throw new InvalidParameterException("Invalid key size: " + n);
            }
            aESSecretKey = new DESSecretKey();
        } else if (aESSecretKey.equalsIgnoreCase("GenericSecret")) {
            if (n != -1 && (n < 8 || n % 8 != 0)) {
                throw new InvalidParameterException("Invalid key size: " + n);
            }
            aESSecretKey = new GenericSecretKey();
            n = n == -1 ? 16 : (n + 7) / 8;
            aESSecretKey.getValueLen().setLongValue(new Long(n));
        } else if (aESSecretKey.equalsIgnoreCase("IDEA")) {
            if (n != -1 && n != 128) {
                throw new InvalidParameterException("Invalid key size: " + n);
            }
            aESSecretKey = new IDEASecretKey();
        } else if (aESSecretKey.equalsIgnoreCase("RC2")) {
            if (n != -1 && (n < 8 || n > 1024 || n % 8 != 0)) {
                throw new InvalidParameterException("Invalid key size: " + n);
            }
            aESSecretKey = new RC2SecretKey();
            n = n == -1 ? 16 : (n + 7) / 8;
            aESSecretKey.getValueLen().setLongValue(new Long(n));
        } else if (aESSecretKey.equalsIgnoreCase("RC4")) {
            if (n != -1 && (n < 8 || n > 2048 || n % 8 != 0)) {
                throw new InvalidParameterException("Invalid key size: " + n);
            }
            aESSecretKey = new RC4SecretKey();
            n = n == -1 ? 16 : (n + 7) / 8;
            aESSecretKey.getValueLen().setLongValue(new Long(n));
        } else if (aESSecretKey.equalsIgnoreCase("RC5")) {
            if (n != -1 && (n < 0 || n > 2040 || n % 8 != 0)) {
                throw new InvalidParameterException("Invalid key size: " + n);
            }
            aESSecretKey = new RC5SecretKey();
            n = n == -1 ? 16 : (n + 7) / 8;
            aESSecretKey.getValueLen().setLongValue(new Long(n));
        } else {
            throw new IAIKPkcs11Exception("Unknown algorithm: " + (String)aESSecretKey);
        }
        aESSecretKey.getToken().setBooleanValue(Boolean.FALSE);
        aESSecretKey.getPrivate().setBooleanValue(Boolean.TRUE);
        aESSecretKey.getSensitive().setBooleanValue(Boolean.TRUE);
        return aESSecretKey;
    }

    public SecretKey getKeyGeneratorTemplate(String algorithm, AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("params must be null or instance of PKCS11KeyGenerationSpec");
    }

    /*
     * WARNING - void declaration
     */
    public void setAutoConversion(boolean on) {
        void var1_1;
        this.E = on;
        this.properties_.put("AUTO_CONVERSION", true == var1_1 ? "true" : "false");
    }

    public boolean isAutoConversion() {
        return this.E;
    }

    private IAIKPKCS11Key a(IAIKPkcs11 iAIKPkcs11, Key key, int n) throws InvalidKeyException {
        IAIKPKCS11Key iAIKPKCS11Key = (IAIKPKCS11Key)this.F.get(new a(key));
        if (iAIKPKCS11Key != null) {
            return iAIKPKCS11Key;
        }
        try {
            iAIKPKCS11Key = null;
            if (n == 1) {
                iAIKPKCS11Key = new BooleanAttribute(Attribute.ENCRYPT);
                iAIKPKCS11Key.setBooleanValue(Boolean.TRUE);
            } else if (n == 2) {
                iAIKPKCS11Key = new BooleanAttribute(Attribute.DECRYPT);
                iAIKPKCS11Key.setBooleanValue(Boolean.TRUE);
            } else if (n == 3) {
                iAIKPKCS11Key = new BooleanAttribute(Attribute.WRAP);
                iAIKPKCS11Key.setBooleanValue(Boolean.TRUE);
            } else if (n == 4) {
                iAIKPKCS11Key = new BooleanAttribute(Attribute.UNWRAP);
                iAIKPKCS11Key.setBooleanValue(Boolean.TRUE);
            }
            if (iAIKPKCS11Key == null) {
                throw new InvalidKeySpecException("operationMode has to be Cipher.ENCRYPT_MODE, Cipher.DECRYPT_MODE, Cipher.WRAP_MODE, or Cipher.UNWRAP_MODE");
            }
            GenericTemplate genericTemplate = new GenericTemplate();
            genericTemplate.addAttribute((Attribute)iAIKPKCS11Key);
            if (key instanceof PublicKey) {
                DefaultKeyHandler.b(genericTemplate);
                return this.a(iAIKPkcs11, (PublicKey)key, genericTemplate, key.getAlgorithm());
            }
            this.a(genericTemplate);
            if (key instanceof javax.crypto.SecretKey) {
                return this.a(iAIKPkcs11, (javax.crypto.SecretKey)key, genericTemplate, key.getAlgorithm());
            }
            if (key instanceof PrivateKey) {
                return this.a(iAIKPkcs11, (PrivateKey)key, genericTemplate, key.getAlgorithm());
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IAIKPkcs11Exception("error converting key to PKCS#11 key: " + generalSecurityException);
        }
        throw new InvalidKeyException("incompatible key class: " + key.getClass());
    }

    private IAIKPKCS11SecretKey a(IAIKPkcs11 iAIKPkcs11, Key key) throws InvalidKeyException {
        IAIKPKCS11SecretKey iAIKPKCS11SecretKey = (IAIKPKCS11SecretKey)this.F.get(new a(key));
        if (iAIKPKCS11SecretKey != null) {
            return iAIKPKCS11SecretKey;
        }
        try {
            iAIKPKCS11SecretKey = new BooleanAttribute(Attribute.SIGN);
            iAIKPKCS11SecretKey.setBooleanValue(Boolean.TRUE);
            GenericTemplate genericTemplate = new GenericTemplate();
            genericTemplate.addAttribute((Attribute)iAIKPKCS11SecretKey);
            this.a(genericTemplate);
            if (key instanceof javax.crypto.SecretKey) {
                return this.a(iAIKPkcs11, (javax.crypto.SecretKey)key, genericTemplate, "Generic");
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IAIKPkcs11Exception("error converting key to PKCS#11 key: " + generalSecurityException);
        }
        throw new InvalidKeyException("incompatible key class: " + key.getClass());
    }

    private IAIKPKCS11PrivateKey a(IAIKPkcs11 iAIKPkcs11, PrivateKey privateKey) throws InvalidKeyException {
        IAIKPKCS11PrivateKey iAIKPKCS11PrivateKey = (IAIKPKCS11PrivateKey)this.F.get(new a(privateKey));
        if (iAIKPKCS11PrivateKey != null) {
            return iAIKPKCS11PrivateKey;
        }
        try {
            iAIKPKCS11PrivateKey = new BooleanAttribute(Attribute.SIGN);
            iAIKPKCS11PrivateKey.setBooleanValue(Boolean.TRUE);
            GenericTemplate genericTemplate = new GenericTemplate();
            genericTemplate.addAttribute((Attribute)iAIKPKCS11PrivateKey);
            this.a(genericTemplate);
            return this.a(iAIKPkcs11, privateKey, genericTemplate, privateKey.getAlgorithm());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidKeyException("error converting key to PKCS#11 key: " + generalSecurityException);
        }
    }

    private IAIKPKCS11PublicKey a(IAIKPkcs11 iAIKPkcs11, PublicKey publicKey) throws InvalidKeyException {
        IAIKPKCS11PublicKey iAIKPKCS11PublicKey = (IAIKPKCS11PublicKey)this.F.get(new a(publicKey));
        if (iAIKPKCS11PublicKey != null) {
            return iAIKPKCS11PublicKey;
        }
        try {
            iAIKPKCS11PublicKey = new BooleanAttribute(Attribute.VERIFY);
            iAIKPKCS11PublicKey.setBooleanValue(Boolean.TRUE);
            BooleanAttribute booleanAttribute = new BooleanAttribute(Attribute.TOKEN);
            booleanAttribute.setBooleanValue(Boolean.FALSE);
            GenericTemplate genericTemplate = new GenericTemplate();
            genericTemplate.addAttribute((Attribute)iAIKPKCS11PublicKey);
            genericTemplate.addAttribute((Attribute)booleanAttribute);
            return this.a(iAIKPkcs11, publicKey, genericTemplate, publicKey.getAlgorithm());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidKeyException("error converting key to PKCS#11 key: " + generalSecurityException);
        }
    }

    private IAIKPKCS11PrivateKey b(IAIKPkcs11 iAIKPkcs11, Key key) throws InvalidKeyException {
        if (!(key instanceof PrivateKey)) {
            throw new InvalidKeyException("Invalid key. Key must be a java.security.PrivateKey.");
        }
        IAIKPKCS11PrivateKey iAIKPKCS11PrivateKey = (IAIKPKCS11PrivateKey)this.F.get(new a(key));
        if (iAIKPKCS11PrivateKey != null) {
            return iAIKPKCS11PrivateKey;
        }
        try {
            iAIKPKCS11PrivateKey = new BooleanAttribute(Attribute.DERIVE);
            iAIKPKCS11PrivateKey.setBooleanValue(Boolean.TRUE);
            GenericTemplate genericTemplate = new GenericTemplate();
            genericTemplate.addAttribute((Attribute)iAIKPKCS11PrivateKey);
            this.a(genericTemplate);
            return this.a(iAIKPkcs11, (PrivateKey)key, genericTemplate, key.getAlgorithm());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidKeyException("error converting key to PKCS#11 key: " + generalSecurityException);
        }
    }

    private IAIKPKCS11PublicKey c(IAIKPkcs11 iAIKPkcs11, Key key) throws InvalidKeyException {
        if (!(key instanceof PublicKey)) {
            throw new InvalidKeyException("Invalid key. Key must be a java.security.PublicKey");
        }
        IAIKPKCS11PublicKey iAIKPKCS11PublicKey = (IAIKPKCS11PublicKey)this.F.get(new a(key));
        if (iAIKPKCS11PublicKey != null) {
            return iAIKPKCS11PublicKey;
        }
        try {
            iAIKPKCS11PublicKey = new BooleanAttribute(Attribute.DERIVE);
            iAIKPKCS11PublicKey.setBooleanValue(Boolean.TRUE);
            BooleanAttribute booleanAttribute = new BooleanAttribute(Attribute.TOKEN);
            booleanAttribute.setBooleanValue(Boolean.FALSE);
            GenericTemplate genericTemplate = new GenericTemplate();
            genericTemplate.addAttribute((Attribute)iAIKPKCS11PublicKey);
            genericTemplate.addAttribute((Attribute)booleanAttribute);
            return this.a(iAIKPkcs11, (PublicKey)key, genericTemplate, key.getAlgorithm());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidKeyException("error converting key to PKCS#11 key: " + generalSecurityException);
        }
    }

    private IAIKPKCS11Key d(IAIKPkcs11 iAIKPkcs11, Key key) throws InvalidKeyException {
        IAIKPKCS11Key iAIKPKCS11Key = (IAIKPKCS11Key)this.F.get(new a(key));
        if (iAIKPKCS11Key != null) {
            return iAIKPKCS11Key;
        }
        try {
            iAIKPKCS11Key = new GenericTemplate();
            if (key instanceof PrivateKey) {
                this.a((GenericTemplate)iAIKPKCS11Key);
                return this.a(iAIKPkcs11, (PrivateKey)key, (GenericTemplate)iAIKPKCS11Key, key.getAlgorithm());
            }
            if (key instanceof PublicKey) {
                BooleanAttribute booleanAttribute = new BooleanAttribute(Attribute.TOKEN);
                booleanAttribute.setBooleanValue(Boolean.FALSE);
                iAIKPKCS11Key.addAttribute((Attribute)booleanAttribute);
                return this.a(iAIKPkcs11, (PublicKey)key, (GenericTemplate)iAIKPKCS11Key, key.getAlgorithm());
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IAIKPkcs11Exception("error converting key to PKCS#11 key: " + generalSecurityException);
        }
        throw new InvalidKeyException("incompatible key class: " + key.getClass());
    }

    private IAIKPKCS11SecretKey a(IAIKPkcs11 iAIKPkcs11, javax.crypto.SecretKey secretKey) throws InvalidKeyException {
        IAIKPKCS11SecretKey iAIKPKCS11SecretKey = (IAIKPKCS11SecretKey)this.F.get(new a(secretKey));
        if (iAIKPKCS11SecretKey != null) {
            return iAIKPKCS11SecretKey;
        }
        try {
            iAIKPKCS11SecretKey = new GenericTemplate();
            this.a((GenericTemplate)iAIKPKCS11SecretKey);
            return this.a(iAIKPkcs11, secretKey, (GenericTemplate)iAIKPKCS11SecretKey, secretKey.getAlgorithm());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IAIKPkcs11Exception("error converting key to PKCS#11 key: " + generalSecurityException);
        }
    }

    private IAIKPKCS11SecretKey a(IAIKPkcs11 object, javax.crypto.SecretKey secretKey, GenericTemplate object2, String string) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        java.lang.Object object3 = SecretKeyFactory.getInstance(secretKey.getAlgorithm(), ((Provider)object).getName());
        Class clazz = DefaultKeyHandler.a(string);
        object3 = ((SecretKeyFactory)object3).getKeySpec(secretKey, clazz);
        object = SecretKeyFactory.getInstance(string, ((Provider)object).getName());
        object2 = (PKCS11KeySpec)new PKCS11KeySpec((KeySpec)object3, (Object)object2).setUseUserRole(false);
        object = (IAIKPKCS11SecretKey)((SecretKeyFactory)object).generateSecret((KeySpec)object2);
        this.F.put(new a(secretKey), object);
        return object;
    }

    private static Class a(String object) {
        object = ((String)object).equalsIgnoreCase("DES") ? (H == null ? (H = DefaultKeyHandler.b("javax.crypto.spec.DESKeySpec")) : H) : (((String)object).equalsIgnoreCase("DESede") ? (I == null ? (I = DefaultKeyHandler.b("javax.crypto.spec.DESedeKeySpec")) : I) : (J == null ? (J = DefaultKeyHandler.b("javax.crypto.spec.SecretKeySpec")) : J));
        return object;
    }

    private IAIKPKCS11PublicKey a(IAIKPkcs11 object, PublicKey publicKey, GenericTemplate object2, String object3) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(publicKey.getAlgorithm(), ((Provider)object).getName());
        object3 = ((String)object3).equalsIgnoreCase("RSA") ? (K == null ? (K = DefaultKeyHandler.b("java.security.spec.RSAPublicKeySpec")) : K) : (((String)object3).equalsIgnoreCase("DSA") ? (L == null ? (L = DefaultKeyHandler.b("java.security.spec.DSAPublicKeySpec")) : L) : (((String)object3).equalsIgnoreCase("DH") ? (M == null ? (M = DefaultKeyHandler.b("javax.crypto.spec.DHPublicKeySpec")) : M) : (N == null ? (N = DefaultKeyHandler.b("java.security.spec.X509EncodedKeySpec")) : N)));
        object3 = keyFactory.getKeySpec(publicKey, object3);
        object = KeyFactory.getInstance(publicKey.getAlgorithm(), ((Provider)object).getName());
        object2 = (PKCS11KeySpec)new PKCS11KeySpec((KeySpec)object3, (Object)object2).setUseUserRole(false);
        object = (IAIKPKCS11PublicKey)((KeyFactory)object).generatePublic((KeySpec)object2);
        this.F.put(new a(publicKey), object);
        return object;
    }

    private IAIKPKCS11PrivateKey a(IAIKPkcs11 object, PrivateKey privateKey, GenericTemplate object2, String object3) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(privateKey.getAlgorithm(), ((Provider)object).getName());
        object3 = ((String)object3).equalsIgnoreCase("RSA") ? (O == null ? (O = DefaultKeyHandler.b("java.security.spec.RSAPrivateCrtKeySpec")) : O) : (((String)object3).equalsIgnoreCase("DSA") ? (P == null ? (P = DefaultKeyHandler.b("java.security.spec.DSAPrivateKeySpec")) : P) : (((String)object3).equalsIgnoreCase("DH") ? (Q == null ? (Q = DefaultKeyHandler.b("javax.crypto.spec.DHPrivateKeySpec")) : Q) : (R == null ? (R = DefaultKeyHandler.b("java.security.spec.PKCS8EncodedKeySpec")) : R)));
        object3 = keyFactory.getKeySpec(privateKey, object3);
        object = KeyFactory.getInstance(privateKey.getAlgorithm(), ((Provider)object).getName());
        object2 = (PKCS11KeySpec)new PKCS11KeySpec((KeySpec)object3, (Object)object2).setUseUserRole(false);
        object = (IAIKPKCS11PrivateKey)((KeyFactory)object).generatePrivate((KeySpec)object2);
        this.F.put(new a(privateKey), object);
        return object;
    }

    private void a(GenericTemplate genericTemplate) {
        DefaultKeyHandler.b(genericTemplate);
        BooleanAttribute booleanAttribute = new BooleanAttribute(Attribute.PRIVATE);
        booleanAttribute.setBooleanValue(Boolean.TRUE);
        genericTemplate.addAttribute((Attribute)booleanAttribute);
        booleanAttribute = new BooleanAttribute(Attribute.SENSITIVE);
        booleanAttribute.setBooleanValue(Boolean.TRUE);
        genericTemplate.addAttribute((Attribute)booleanAttribute);
    }

    private static void b(GenericTemplate genericTemplate) {
        BooleanAttribute booleanAttribute = new BooleanAttribute(Attribute.TOKEN);
        booleanAttribute.setBooleanValue(Boolean.FALSE);
        genericTemplate.addAttribute((Attribute)booleanAttribute);
    }

    private static void a(KeyPair keyPair, boolean bl) {
        keyPair = keyPair.getPrivateKey();
        keyPair.getToken().setBooleanValue(Boolean.TRUE);
        keyPair.getPrivate().setBooleanValue(Boolean.TRUE);
        keyPair.getSensitive().setBooleanValue(Boolean.TRUE);
    }

    private static Class b(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            java.lang.Object object = (G == null ? (G = DefaultKeyHandler.b("iaik.pkcs.pkcs11.provider.IAIKPkcs11")) : G).getClassLoader().getResource("iaik/pkcs/pkcs11/provider/default/DefaultKeyHandler.properties");
            object = ((URL)object).openStream();
            Properties properties = new Properties();
            properties.load((InputStream)object);
            object = (G == null ? (G = DefaultKeyHandler.b("iaik.pkcs.pkcs11.provider.IAIKPkcs11")) : G).getClassLoader().getResource("iaik/pkcs/pkcs11/provider/DefaultKeyHandler.properties");
            if (object != null) {
                object = ((URL)object).openStream();
                properties = new Properties(properties);
                properties.load((InputStream)object);
                ((InputStream)object).close();
                defaultProperties_ = properties;
            } else {
                defaultProperties_ = properties;
            }
        }
        catch (IOException iOException) {
            IAIKPkcs11.errorStream_.println("Could not load DefaultKeyHandler configuration properties.");
            iOException.printStackTrace(IAIKPkcs11.errorStream_);
        }
    }
}

