/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.qualified;

import iaik.asn1.ObjectID;
import iaik.asn1.structures.PolicyInformation;
import iaik.utils.InternalErrorException;
import iaik.x509.V3Extension;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.extensions.CertificatePolicies;
import iaik.x509.extensions.qualified.BiometricInfo;
import iaik.x509.extensions.qualified.QCStatements;
import iaik.x509.extensions.qualified.structures.QCStatement;
import iaik.x509.qualified.QualifiedCertificateException;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Vector;

public class QualifiedCertificate
extends X509Certificate {
    static Vector a = new Vector();
    static Vector b = new Vector();
    private transient QCStatement[] c;
    private transient PolicyInformation[] d;

    public static void registerQualifiedPolicyIDs(ObjectID[] objectIDArray) {
        a.removeAllElements();
        for (int i2 = 0; i2 < objectIDArray.length; ++i2) {
            a.addElement(objectIDArray[i2]);
        }
    }

    public static boolean registerQualifiedPolicyID(ObjectID objectID) {
        Enumeration enumeration = a.elements();
        while (enumeration.hasMoreElements()) {
            if (!objectID.equals(enumeration.nextElement())) continue;
            return false;
        }
        a.addElement(objectID);
        return true;
    }

    public static ObjectID[] getRegisteredQualifiedPolicyIDs() {
        Object[] objectArray = new ObjectID[a.size()];
        a.copyInto(objectArray);
        return objectArray;
    }

    public static boolean removeRegisteredQualifiedPolicyID(ObjectID objectID) {
        return a.removeElement(objectID);
    }

    public static void clearRegisteredQualifiedPolicyIDs() {
        a.removeAllElements();
    }

    public static boolean isQualifiedPolicyID(ObjectID objectID) {
        Enumeration enumeration = a.elements();
        while (enumeration.hasMoreElements()) {
            if (!objectID.equals(enumeration.nextElement())) continue;
            return true;
        }
        return false;
    }

    public static PolicyInformation[] containsQualifiedPolicyInformations(CertificatePolicies certificatePolicies) {
        int n2;
        Object[] objectArray = null;
        Vector<PolicyInformation> vector = new Vector<PolicyInformation>();
        PolicyInformation[] policyInformationArray = certificatePolicies.getPolicyInformation();
        for (n2 = 0; n2 < policyInformationArray.length; ++n2) {
            PolicyInformation policyInformation = policyInformationArray[n2];
            if (!QualifiedCertificate.isQualifiedPolicyID(policyInformation.getPolicyIdentifier())) continue;
            vector.addElement(policyInformation);
        }
        n2 = vector.size();
        if (n2 > 0) {
            objectArray = new PolicyInformation[n2];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public static void registerQualifiedQCStatementIDs(ObjectID[] objectIDArray) {
        b.removeAllElements();
        for (int i2 = 0; i2 < objectIDArray.length; ++i2) {
            b.addElement(objectIDArray[i2]);
        }
    }

    public static boolean registerQualifiedQCStatementID(ObjectID objectID) {
        Enumeration enumeration = b.elements();
        while (enumeration.hasMoreElements()) {
            if (!objectID.equals(enumeration.nextElement())) continue;
            return false;
        }
        b.addElement(objectID);
        return true;
    }

    public static ObjectID[] getRegisteredQualifiedQCStatementIDs() {
        Object[] objectArray = new ObjectID[b.size()];
        b.copyInto(objectArray);
        return objectArray;
    }

    public static boolean removeRegisteredQualifiedQCStatementID(ObjectID objectID) {
        return b.removeElement(objectID);
    }

    public static void clearRegisteredQualifiedQCStatementIDs() {
        b.removeAllElements();
    }

    public static boolean isQualifiedQCStatementID(ObjectID objectID) {
        Enumeration enumeration = b.elements();
        while (enumeration.hasMoreElements()) {
            if (!objectID.equals(enumeration.nextElement())) continue;
            return true;
        }
        return false;
    }

    public static QCStatement[] containsQualifiedQCStatements(QCStatements qCStatements) {
        int n2;
        Object[] objectArray = null;
        Vector<QCStatement> vector = new Vector<QCStatement>();
        QCStatement[] qCStatementArray = qCStatements.getQCStatements();
        for (n2 = 0; n2 < qCStatementArray.length; ++n2) {
            QCStatement qCStatement = qCStatementArray[n2];
            if (!QualifiedCertificate.isQualifiedQCStatementID(qCStatement.getStatementID())) continue;
            vector.addElement(qCStatement);
        }
        n2 = vector.size();
        if (n2 > 0) {
            objectArray = new QCStatement[n2];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public static QualifiedCertificate isQualifedCertificate(X509Certificate x509Certificate) throws QualifiedCertificateException {
        try {
            return new QualifiedCertificate(x509Certificate.getEncoded());
        }
        catch (CertificateException certificateException) {
            throw new InternalErrorException("Error in reading certificate: " + certificateException.getMessage(), certificateException);
        }
    }

    public QualifiedCertificate() {
    }

    public QualifiedCertificate(InputStream inputStream) throws IOException, CertificateException, QualifiedCertificateException {
        super(inputStream);
        if (!this.a()) {
            throw new QualifiedCertificateException("Initialization failed! No qualified cert!");
        }
    }

    public QualifiedCertificate(byte[] byArray) throws CertificateException, QualifiedCertificateException {
        super(byArray);
        if (!this.a()) {
            throw new QualifiedCertificateException("Initialization failed! No qualified cert!");
        }
    }

    private boolean a() {
        V3Extension v3Extension;
        try {
            v3Extension = this.getQCStatements();
            if (v3Extension != null) {
                this.c = QualifiedCertificate.containsQualifiedQCStatements(v3Extension);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            v3Extension = (CertificatePolicies)this.getExtension(CertificatePolicies.oid);
            if (v3Extension != null) {
                this.d = QualifiedCertificate.containsQualifiedPolicyInformations((CertificatePolicies)v3Extension);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.d != null || this.c != null;
    }

    public void setBiometricInfo(BiometricInfo biometricInfo) throws X509ExtensionException {
        this.addExtension(biometricInfo);
    }

    public void setQCStatements(QCStatements qCStatements) throws X509ExtensionException {
        this.addExtension(qCStatements);
        this.c = QualifiedCertificate.containsQualifiedQCStatements(qCStatements);
    }

    public void setCertificatePolicies(CertificatePolicies certificatePolicies) throws X509ExtensionException {
        this.addExtension(certificatePolicies);
        this.d = QualifiedCertificate.containsQualifiedPolicyInformations(certificatePolicies);
    }

    public void addExtension(V3Extension v3Extension) throws X509ExtensionException {
        super.addExtension(v3Extension);
        if (v3Extension.getObjectID().equals(CertificatePolicies.oid)) {
            this.d = QualifiedCertificate.containsQualifiedPolicyInformations((CertificatePolicies)v3Extension);
        } else if (v3Extension.getObjectID().equals(QCStatements.oid)) {
            this.c = QualifiedCertificate.containsQualifiedQCStatements((QCStatements)v3Extension);
        }
    }

    public BiometricInfo getBiometricInfo() throws X509ExtensionInitException {
        return (BiometricInfo)this.getExtension(BiometricInfo.oid);
    }

    public QCStatements getQCStatements() throws X509ExtensionInitException {
        return (QCStatements)this.getExtension(QCStatements.oid);
    }

    public CertificatePolicies getCertificatePolicies() throws X509ExtensionInitException {
        return (CertificatePolicies)this.getExtension(CertificatePolicies.oid);
    }

    public boolean removeExtension(ObjectID objectID) {
        boolean bl = super.removeExtension(objectID);
        if (bl) {
            if (objectID.equals(CertificatePolicies.oid)) {
                this.d = null;
            } else if (objectID.equals(QCStatements.oid)) {
                this.c = null;
            }
        }
        return bl;
    }

    public void removeAllExtensions() {
        super.removeAllExtensions();
        this.d = null;
        this.c = null;
    }

    public QCStatement[] getQualifiedQCStatements() {
        return this.c;
    }

    public PolicyInformation[] getQualifiedPolicyInformations() {
        return this.d;
    }
}

