/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.ocsp.net;

import iaik.asn1.CodingException;
import iaik.utils.ASN1InputStream;
import iaik.utils.Util;
import iaik.x509.ocsp.OCSPRequest;
import iaik.x509.ocsp.OCSPResponse;
import iaik.x509.ocsp.UnknownResponseException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Locale;

public class HttpOCSPRequest {
    private URL b;
    private OCSPResponse c;
    private String d;
    HttpURLConnection a;

    public HttpOCSPRequest(URL uRL) {
        this.b = uRL;
    }

    public int postRequest(OCSPRequest oCSPRequest) throws IOException, UnknownResponseException {
        byte[] byArray = null;
        try {
            byArray = oCSPRequest.getEncoded();
        }
        catch (CodingException codingException) {
            throw new IOException("Request encoding error: " + codingException.getMessage());
        }
        return this.a(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int a(byte[] byArray) throws IOException, UnknownResponseException {
        this.d = null;
        this.c = null;
        this.a = this.openConnection(this.b);
        this.a.setRequestProperty("Content-Type", "application/ocsp-request");
        this.a.setRequestProperty("Accept", "application/ocsp-response");
        this.a.setRequestProperty("Content-Length", String.valueOf(byArray.length));
        this.a.setDoOutput(true);
        InputStream inputStream = null;
        OutputStream outputStream = this.a.getOutputStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        try {
            bufferedOutputStream.write(byArray);
            bufferedOutputStream.flush();
            int n2 = this.a.getResponseCode();
            this.d = this.a.getResponseMessage();
            if (n2 / 100 == 2) {
                String string = this.a.getContentType();
                if (string != null && !string.toLowerCase(Locale.US).startsWith("application/ocsp-response")) {
                    throw new IOException("Got response with invalid content type: " + string);
                }
                inputStream = this.a.getInputStream();
                this.c = new OCSPResponse(new ASN1InputStream(new BufferedInputStream(inputStream)));
            }
            int n3 = n2;
            return n3;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
            try {
                bufferedOutputStream.close();
            }
            catch (IOException iOException) {}
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected HttpURLConnection openConnection(URL uRL) throws IOException {
        return (HttpURLConnection)uRL.openConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendGETRequest(OCSPRequest oCSPRequest) throws IOException, UnknownResponseException {
        String string;
        this.d = null;
        this.c = null;
        byte[] byArray = null;
        try {
            byArray = oCSPRequest.getEncoded();
        }
        catch (CodingException codingException) {
            throw new IOException("Request encoding error: " + codingException.getMessage());
        }
        int n2 = 0;
        boolean bl = true;
        if (byArray.length < 250 && (string = this.b.toExternalForm() + "/" + URLEncoder.encode(Util.toBase64String(byArray))).getBytes().length < 255) {
            bl = false;
            this.b = new URL(string);
            this.a = this.openConnection(this.b);
            this.a.setRequestProperty("Accept", "application/ocsp-response");
            n2 = this.a.getResponseCode();
            this.d = this.a.getResponseMessage();
            InputStream inputStream = null;
            try {
                if (n2 / 100 == 2) {
                    String string2 = this.a.getContentType();
                    if (!"application/ocsp-response".equalsIgnoreCase(string2)) {
                        throw new IOException("Got response with invalid content type: " + string2);
                    }
                    inputStream = this.a.getInputStream();
                    this.c = new OCSPResponse(new ASN1InputStream(new BufferedInputStream(inputStream)));
                }
                int n3 = n2;
                return n3;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (bl) {
            n2 = this.a(byArray);
        }
        return n2;
    }

    public OCSPResponse getOCSPResponse() {
        return this.c;
    }

    public String getResponseMessage() {
        return this.d;
    }

    public String getHeaderField(String string) {
        return this.a == null ? null : this.a.getHeaderField(string);
    }

    public String getHeaderFieldKey(int n2) {
        return this.a == null ? null : this.a.getHeaderFieldKey(n2);
    }

    public String getHeaderField(int n2) {
        return this.a == null ? null : this.a.getHeaderField(n2);
    }
}

