/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.ocsp;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.ChoiceOfTime;
import iaik.asn1.structures.GeneralName;
import iaik.utils.Util;
import iaik.x509.V3Extension;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.ocsp.CertStatus;
import iaik.x509.ocsp.CertificateResponse;
import iaik.x509.ocsp.OCSPException;
import iaik.x509.ocsp.OCSPExtensions;
import iaik.x509.ocsp.ReqCert;
import iaik.x509.ocsp.extensions.ArchiveCutoff;
import iaik.x509.ocsp.extensions.CrlID;
import java.util.Date;
import java.util.Enumeration;

public class SingleResponse
implements CertificateResponse {
    ReqCert a;
    CertStatus b;
    ChoiceOfTime c;
    ChoiceOfTime d;
    OCSPExtensions e;

    public SingleResponse() {
    }

    public SingleResponse(ReqCert reqCert, CertStatus certStatus, Date date) {
        if (reqCert == null) {
            throw new IllegalArgumentException("Cannot create SingleResponse. Missing ReqCert!");
        }
        this.a = reqCert;
        if (certStatus == null) {
            throw new IllegalArgumentException("Cannot create SingleResponse. Missing CertStatus!");
        }
        this.b = certStatus;
        if (date == null) {
            throw new IllegalArgumentException("Cannot create SingleResponse. Missing thisUpdate date!");
        }
        this.c = new ChoiceOfTime(date, ASN.GeneralizedTime, false);
    }

    public SingleResponse(ASN1Object aSN1Object) throws CodingException, X509ExtensionException {
        this.decode(aSN1Object);
    }

    public void setNextUpdate(Date date) {
        this.d = new ChoiceOfTime(date, ASN.GeneralizedTime, false);
    }

    public ReqCert getReqCert() {
        return this.a;
    }

    public CertStatus getCertStatus() {
        return this.b;
    }

    public boolean isResponseFor(X509Certificate x509Certificate, X509Certificate x509Certificate2, GeneralName generalName) throws OCSPException {
        return this.a.isReqCertFor(x509Certificate, x509Certificate2, generalName);
    }

    public boolean isResponseFor(ReqCert reqCert) {
        return this.a.equals(reqCert);
    }

    public Date getThisUpdate() {
        return this.c == null ? null : this.c.getDate();
    }

    public Date getNextUpdate() {
        return this.d == null ? null : this.d.getDate();
    }

    public void addExtension(V3Extension v3Extension) throws X509ExtensionException {
        if (this.e == null) {
            this.e = new OCSPExtensions();
        }
        this.e.addExtension(v3Extension);
    }

    public boolean removeExtension(ObjectID objectID) {
        return this.e == null ? false : this.e.removeExtension(objectID);
    }

    public void removeAllExtensions() {
        if (this.e != null) {
            this.e.removeAllExtensions();
        }
        this.e = null;
    }

    public Enumeration listExtensions() {
        return this.e == null ? null : this.e.listExtensions();
    }

    public boolean hasExtensions() {
        return this.e == null ? false : this.e.hasExtensions();
    }

    public boolean hasUnsupportedCriticalExtension() {
        return this.e == null ? false : this.e.hasUnsupportedCriticalExtension();
    }

    public int countExtensions() {
        return this.e == null ? 0 : this.e.countExtensions();
    }

    public V3Extension getExtension(ObjectID objectID) throws X509ExtensionInitException {
        return this.e == null ? null : this.e.getExtension(objectID);
    }

    public void setArchiveCutoff(Date date) throws X509ExtensionException {
        this.addExtension(new ArchiveCutoff(date));
    }

    public Date getArchiveCutoff() throws X509ExtensionInitException {
        ArchiveCutoff archiveCutoff = (ArchiveCutoff)this.getExtension(ArchiveCutoff.oid);
        return archiveCutoff == null ? null : archiveCutoff.getCutoffTime();
    }

    public void setCrlID(CrlID crlID) throws X509ExtensionException {
        this.addExtension(crlID);
    }

    public CrlID getCrlID() throws X509ExtensionInitException {
        return (CrlID)this.getExtension(CrlID.oid);
    }

    public ASN1Object toASN1Object() throws CodingException {
        try {
            SEQUENCE sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(this.a.toASN1Object());
            sEQUENCE.addComponent(this.b.toASN1Object());
            sEQUENCE.addComponent(this.c.toASN1Object());
            if (this.d != null) {
                sEQUENCE.addComponent(new CON_SPEC(0, this.d.toASN1Object()));
            }
            if (this.e != null) {
                sEQUENCE.addComponent(new CON_SPEC(1, this.e.toASN1Object()));
            }
            return sEQUENCE;
        }
        catch (Exception exception) {
            throw new CodingException(exception.getMessage());
        }
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.a = new ReqCert(aSN1Object.getComponentAt(0));
        if (this.a == null) {
            throw new CodingException("Cannot create SingleResponse. Missing reqCert!");
        }
        this.b = new CertStatus(aSN1Object.getComponentAt(1));
        if (this.b == null) {
            throw new CodingException("Cannot create SingleResponse. Missing CertStatus!");
        }
        this.c = new ChoiceOfTime(aSN1Object.getComponentAt(2));
        CON_SPEC cON_SPEC = null;
        for (int i2 = 3; i2 < aSN1Object.countComponents(); ++i2) {
            cON_SPEC = (CON_SPEC)aSN1Object.getComponentAt(i2);
            int n2 = cON_SPEC.getAsnType().getTag();
            if (n2 == 0) {
                this.d = new ChoiceOfTime((ASN1Object)cON_SPEC.getValue());
                continue;
            }
            if (n2 == 1) {
                try {
                    this.e = new OCSPExtensions((ASN1Object)cON_SPEC.getValue());
                    continue;
                }
                catch (X509ExtensionException x509ExtensionException) {
                    throw new CodingException(x509ExtensionException.getMessage());
                }
            }
            throw new CodingException("Invalid context specific tag in SingleResponse encoding: " + n2);
        }
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("reqCert: {\n");
        Util.printIndented(this.a.toString(), true, "  ", stringBuffer);
        stringBuffer.append("\n}");
        stringBuffer.append("\ncertStatus: {\n");
        Util.printIndented(this.b.toString(), true, "  ", stringBuffer);
        stringBuffer.append("\n}");
        stringBuffer.append("\nthisUpdate: " + this.c);
        if (this.d != null) {
            stringBuffer.append("\nnextUpdate: " + this.d);
        }
        if (this.e != null) {
            if (bl) {
                stringBuffer.append("\nextensions:\n");
                Util.printIndented(this.e.toString(), true, "  ", stringBuffer);
                stringBuffer.append("\n}");
            } else {
                stringBuffer.append("\nExtensions: " + this.e.countExtensions());
            }
        }
        return stringBuffer.toString();
    }
}

