/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.ocsp;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.GeneralName;
import iaik.utils.Util;
import iaik.x509.V3Extension;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.ocsp.OCSPException;
import iaik.x509.ocsp.OCSPExtensions;
import iaik.x509.ocsp.Request;
import iaik.x509.ocsp.extensions.AcceptableResponses;
import iaik.x509.ocsp.extensions.Nonce;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Enumeration;

public class OCSPRequest {
    private ASN1 c = new ASN1();
    private int d = 1;
    private GeneralName e;
    private Request[] f;
    private OCSPExtensions g;
    private AlgorithmID h;
    private byte[] i;
    private X509Certificate[] j;
    private boolean k = true;
    static Class a;
    static Class b;

    public OCSPRequest() {
    }

    public OCSPRequest(InputStream inputStream) throws IOException {
        this();
        this.decode(inputStream);
    }

    public OCSPRequest(byte[] byArray) throws CodingException {
        this();
        this.decode(byArray);
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.c = new ASN1(aSN1Object);
        try {
            this.a();
        }
        catch (Exception exception) {
            throw new CodingException(exception.toString());
        }
    }

    public void decode(byte[] byArray) throws CodingException {
        try {
            this.c = new ASN1(byArray);
            this.a();
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new CodingException(x509ExtensionException.getMessage());
        }
    }

    public void decode(InputStream inputStream) throws IOException {
        try {
            this.c = new ASN1(inputStream);
            this.a();
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new IOException(x509ExtensionException.getMessage());
        }
        catch (CodingException codingException) {
            throw new IOException(codingException.getMessage());
        }
    }

    private void a() throws CodingException, X509ExtensionException {
        int n2 = 0;
        ASN1Object aSN1Object = this.c.getComponentAt(0);
        ASN1Object aSN1Object2 = aSN1Object.getComponentAt(0);
        if (aSN1Object2.isA(ASN.CON_SPEC) && aSN1Object2.getAsnType().getTag() == 0) {
            BigInteger bigInteger = (BigInteger)((ASN1Object)aSN1Object2.getValue()).getValue();
            this.d = bigInteger.intValue() + 1;
            ++n2;
        }
        if ((aSN1Object2 = aSN1Object.getComponentAt(0 + n2)).isA(ASN.CON_SPEC) && aSN1Object2.getAsnType().getTag() == 1) {
            this.e = new GeneralName((ASN1Object)aSN1Object2.getValue());
            ++n2;
        }
        aSN1Object2 = aSN1Object.getComponentAt(0 + n2);
        this.f = (Request[])ASN.parseSequenceOf(aSN1Object2, a == null ? (a = OCSPRequest.class$("iaik.x509.ocsp.Request")) : a);
        int n3 = 1 + n2;
        if (n3 < aSN1Object.countComponents()) {
            aSN1Object2 = aSN1Object.getComponentAt(n3);
            this.g = new OCSPExtensions((ASN1Object)aSN1Object2.getValue());
        }
        if (this.c.countComponents() == 2) {
            ASN1Object aSN1Object3 = (ASN1Object)this.c.getComponentAt(1).getValue();
            this.h = new AlgorithmID(aSN1Object3.getComponentAt(0));
            if (this.h == null) {
                throw new CodingException("Request is signed, but signature algorithm is missing!");
            }
            BIT_STRING bIT_STRING = (BIT_STRING)aSN1Object3.getComponentAt(1);
            this.i = (byte[])bIT_STRING.getValue();
            if (this.i == null) {
                throw new CodingException("Request is signed, but signature value is missing!");
            }
            if (aSN1Object3.countComponents() == 3) {
                this.j = (X509Certificate[])ASN.parseSequenceOf((ASN1Object)aSN1Object3.getComponentAt(2).getValue(), b == null ? (b = OCSPRequest.class$("iaik.x509.X509Certificate")) : b);
            }
            this.k = false;
        }
        this.c.clearASN1Object();
    }

    private ASN1Object b() throws OCSPException {
        if (this.f == null || this.f.length == 0) {
            throw new OCSPException("No single requests set!");
        }
        try {
            SEQUENCE sEQUENCE = new SEQUENCE();
            if (this.d > 1) {
                sEQUENCE.addComponent(new CON_SPEC(0, new INTEGER(this.d - 1)));
            }
            if (this.e != null) {
                sEQUENCE.addComponent(new CON_SPEC(1, this.e.toASN1Object()));
            }
            sEQUENCE.addComponent(ASN.createSequenceOf(this.f));
            if (this.g != null && this.g.countExtensions() > 0) {
                sEQUENCE.addComponent(new CON_SPEC(2, this.g.toASN1Object()));
            }
            return sEQUENCE;
        }
        catch (Exception exception) {
            throw new OCSPException(exception.getMessage());
        }
    }

    public void sign(AlgorithmID algorithmID, PrivateKey privateKey) throws OCSPException, InvalidKeyException, NoSuchAlgorithmException {
        try {
            this.a(algorithmID, privateKey, null, null, null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            // empty catch block
        }
    }

    public void sign(AlgorithmID algorithmID, PrivateKey privateKey, String string) throws OCSPException, InvalidKeyException, NoSuchAlgorithmException {
        try {
            this.a(algorithmID, privateKey, null, string, null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            // empty catch block
        }
    }

    public void sign(AlgorithmID algorithmID, PrivateKey privateKey, AlgorithmParameterSpec algorithmParameterSpec, String string) throws OCSPException, InvalidKeyException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        this.a(algorithmID, privateKey, algorithmParameterSpec, string, null);
    }

    public void sign(AlgorithmID algorithmID, PrivateKey privateKey, Provider provider) throws OCSPException, InvalidKeyException, NoSuchAlgorithmException {
        try {
            this.a(algorithmID, privateKey, null, null, provider);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            // empty catch block
        }
    }

    public void sign(AlgorithmID algorithmID, PrivateKey privateKey, AlgorithmParameterSpec algorithmParameterSpec, Provider provider) throws OCSPException, InvalidKeyException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        this.a(algorithmID, privateKey, algorithmParameterSpec, null, provider);
    }

    private void a(AlgorithmID algorithmID, PrivateKey privateKey, AlgorithmParameterSpec algorithmParameterSpec, String string, Provider provider) throws OCSPException, InvalidKeyException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        Object object;
        Signature signature;
        if (algorithmID == null) {
            throw new OCSPException("Cannot sign request! No signature algorithm specified!");
        }
        this.h = algorithmID;
        Signature signature2 = signature = provider != null ? this.h.getSignatureInstance(provider) : this.h.getSignatureInstance(string);
        if (algorithmParameterSpec != null) {
            signature.setParameter(algorithmParameterSpec);
        }
        signature.initSign(privateKey);
        try {
            if (!AlgorithmID.getDoNotIncludeParameters(this.h) && !this.h.hasParameters() && (object = Util.getSignatureParameters(signature)) != null) {
                this.h.setAlgorithmParameters((AlgorithmParameters)object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = this.b();
        try {
            signature.update(DerCoder.encode((ASN1Object)object));
            this.i = signature.sign();
            BIT_STRING bIT_STRING = new BIT_STRING(this.i);
            SEQUENCE sEQUENCE = new SEQUENCE();
            SEQUENCE sEQUENCE2 = new SEQUENCE();
            sEQUENCE2.addComponent(this.h.toASN1Object());
            sEQUENCE2.addComponent(bIT_STRING);
            if (this.j != null && this.j.length > 0) {
                sEQUENCE2.addComponent(new CON_SPEC(0, ASN.createSequenceOf(this.j)));
            }
            sEQUENCE.addComponent((ASN1Object)object);
            sEQUENCE.addComponent(new CON_SPEC(0, sEQUENCE2));
            this.c = new ASN1(sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new OCSPException(codingException.getMessage());
        }
        catch (SignatureException signatureException) {
            throw new OCSPException(signatureException.getMessage());
        }
        this.k = false;
    }

    public void setSignature(AlgorithmID algorithmID, byte[] byArray) throws OCSPException {
        if (algorithmID == null) {
            throw new OCSPException("Cannot sign request! No signature algorithm specified!");
        }
        if (byArray == null || byArray.length == 0) {
            throw new OCSPException("Cannot set empty signature value!");
        }
        this.h = algorithmID;
        this.i = byArray;
        ASN1Object aSN1Object = this.b();
        try {
            BIT_STRING bIT_STRING = new BIT_STRING(this.i);
            SEQUENCE sEQUENCE = new SEQUENCE();
            SEQUENCE sEQUENCE2 = new SEQUENCE();
            sEQUENCE2.addComponent(this.h.toASN1Object());
            sEQUENCE2.addComponent(bIT_STRING);
            if (this.j != null && this.j.length > 0) {
                sEQUENCE2.addComponent(new CON_SPEC(0, ASN.createSequenceOf(this.j)));
            }
            sEQUENCE.addComponent(aSN1Object);
            sEQUENCE.addComponent(new CON_SPEC(0, sEQUENCE2));
            this.c = new ASN1(sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new OCSPException(codingException.getMessage());
        }
        this.k = false;
    }

    public byte[] getEncoded() throws CodingException {
        if (this.k && this.i != null) {
            throw new RuntimeException("Cannot encode this request. First it has to be resigned.");
        }
        if (this.i == null && this.c.toByteArray() == null) {
            try {
                this.c();
            }
            catch (OCSPException oCSPException) {
                throw new CodingException(oCSPException.getMessage());
            }
        }
        return this.c.toByteArray();
    }

    public int getVersion() {
        return this.d;
    }

    public GeneralName getRequestorName() {
        return this.e;
    }

    public Request[] getRequestList() {
        return this.f;
    }

    public int countRequests() {
        return this.f.length;
    }

    public byte[] getTBSRequest() throws CodingException {
        try {
            if (this.c != null && this.c.toByteArray() != null) {
                return this.c.getFirstObject();
            }
            return DerCoder.encode(this.b());
        }
        catch (OCSPException oCSPException) {
            throw new CodingException(oCSPException.toString());
        }
    }

    public byte[] getSignature() {
        return this.i;
    }

    public boolean containsSignature() {
        return this.i != null;
    }

    public AlgorithmID getSignatureAlgorithm() {
        return this.h;
    }

    public void verify(PublicKey publicKey) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        this.a(publicKey, null, null);
    }

    public void verify(PublicKey publicKey, String string) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        this.a(publicKey, string, null);
    }

    public void verify(PublicKey publicKey, Provider provider) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        this.a(publicKey, null, provider);
    }

    private void a(PublicKey publicKey, String string, Provider provider) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        byte[] byArray;
        if (this.k) {
            throw new RuntimeException("Cannot verify this request. First it has to be signed.");
        }
        if (this.h == null) {
            throw new NoSuchAlgorithmException("Cannot verify request! No signature algorithm set.");
        }
        Signature signature = provider != null ? this.h.getSignatureInstance(provider) : this.h.getSignatureInstance(string);
        try {
            byArray = this.c.getFirstObject();
        }
        catch (CodingException codingException) {
            throw new SignatureException(codingException.toString());
        }
        signature.initVerify(publicKey);
        signature.update(byArray);
        if (!signature.verify(this.i)) {
            throw new SignatureException("Signature verification error!");
        }
    }

    public X509Certificate verify() throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, OCSPException {
        X509Certificate[] x509CertificateArray = null;
        if (this.j == null || this.j.length <= 0) {
            throw new OCSPException("Cannot verify request. No certificates included.");
        }
        x509CertificateArray = Util.arrangeCertificateChain(this.j, false);
        if (x509CertificateArray != null && x509CertificateArray.length > 0) {
            this.verify(x509CertificateArray[0].getPublicKey());
            return x509CertificateArray[0];
        }
        throw new OCSPException("Cannot verify request. Cannot build chain from included certs.");
    }

    public boolean containsCertificates() {
        return this.j != null && this.j.length > 0;
    }

    public ASN1Object toASN1Object() throws CodingException {
        if (this.k && this.i != null) {
            throw new RuntimeException("Cannot give an ASN.1 representation of this request. First it has to be resigned.");
        }
        if (this.i == null && this.c.toByteArray() == null) {
            try {
                this.c();
            }
            catch (OCSPException oCSPException) {
                throw new CodingException(oCSPException.getMessage());
            }
        }
        return this.c.toASN1Object();
    }

    private void c() throws OCSPException {
        try {
            this.b();
            SEQUENCE sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(this.b());
            this.c = new ASN1(sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new OCSPException(codingException.getMessage());
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        if (this.k && this.i != null) {
            throw new RuntimeException("Cannot encode this response. First it has to be signed.");
        }
        try {
            outputStream.write(this.getEncoded());
        }
        catch (CodingException codingException) {
            throw new IOException(codingException.getMessage());
        }
    }

    public void setRequestorName(GeneralName generalName) {
        this.e = generalName;
        this.k = true;
    }

    public void setNonce(byte[] byArray) throws X509ExtensionException {
        this.addExtension(new Nonce(byArray));
    }

    public byte[] getNonce() throws X509ExtensionInitException {
        Nonce nonce = (Nonce)this.getExtension(Nonce.oid);
        return nonce == null ? null : nonce.getValue();
    }

    public void setAcceptableResponseTypes(ObjectID[] objectIDArray) throws X509ExtensionException {
        this.addExtension(new AcceptableResponses(objectIDArray));
    }

    public ObjectID[] getAccepatableResponseTypes() throws X509ExtensionInitException {
        AcceptableResponses acceptableResponses = (AcceptableResponses)this.getExtension(AcceptableResponses.oid);
        return acceptableResponses == null ? null : acceptableResponses.getAcceptableResponseTypes();
    }

    public void setRequestList(Request[] requestArray) {
        this.f = requestArray;
        this.k = true;
        if (requestArray != null) {
            for (int i2 = 0; i2 < requestArray.length; ++i2) {
                if (requestArray[i2].getReqCert().getType() == 0) continue;
                this.d = 2;
                break;
            }
        }
    }

    public void setCertificates(X509Certificate[] x509CertificateArray) {
        this.j = x509CertificateArray;
        this.k = true;
    }

    public X509Certificate[] getCertifcates() {
        return this.j;
    }

    public void addExtension(V3Extension v3Extension) throws X509ExtensionException {
        if (this.g == null) {
            this.g = new OCSPExtensions();
        }
        this.g.addExtension(v3Extension);
        this.k = true;
    }

    public boolean removeExtension(ObjectID objectID) {
        boolean bl = false;
        boolean bl2 = bl = this.g == null ? false : this.g.removeExtension(objectID);
        if (bl) {
            this.k = true;
        }
        return bl;
    }

    public void removeAllExtensions() {
        if (this.g != null) {
            this.g.removeAllExtensions();
            this.k = true;
        }
        this.g = null;
    }

    public Enumeration listExtensions() {
        return this.g == null ? null : this.g.listExtensions();
    }

    public boolean hasExtensions() {
        return this.g == null ? false : this.g.hasExtensions();
    }

    public boolean hasUnsupportedCriticalExtension() {
        return this.g == null ? false : this.g.hasUnsupportedCriticalExtension();
    }

    public int countExtensions() {
        return this.g == null ? 0 : this.g.countExtensions();
    }

    public V3Extension getExtension(ObjectID objectID) throws X509ExtensionInitException {
        return this.g == null ? null : this.g.getExtension(objectID);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.d + "\n");
        if (this.e != null) {
            stringBuffer.append("requestorName: " + this.e + "\n");
        }
        if (bl) {
            for (int i2 = 0; i2 < this.f.length; ++i2) {
                stringBuffer.append("request " + i2 + ": {\n");
                Util.printIndented(this.f[i2].toString(true), true, "  ", stringBuffer);
                stringBuffer.append("\n}");
            }
        } else {
            stringBuffer.append("requests: " + this.f.length);
        }
        if (this.g != null) {
            stringBuffer.append("\n");
            if (bl) {
                stringBuffer.append(this.g);
                stringBuffer.setLength(stringBuffer.length() - 1);
            } else {
                stringBuffer.append("Extensions: " + this.g.countExtensions());
            }
        }
        if (this.h != null) {
            stringBuffer.append("\nSignature algorithm: " + this.h);
        }
        if (this.j != null) {
            stringBuffer.append("\ncertificates: " + this.j.length);
        }
        return stringBuffer.toString();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Util.toString(null, -1, 1);
    }
}

